/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;

public class LabelTemplateImportPlugin
extends AbstractFormPlugin
implements LblStrategyConstants {
    private static final String BTN_TEMPLATE = "btndowntpl";
    private static final String ACTION_ID_EXPORT = "exportUrl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_TEMPLATE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String eventKey = ((Control)evt.getSource()).getKey();
        if (BTN_TEMPLATE.equals(eventKey)) {
            this.showFilterForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)ACTION_ID_EXPORT, (String)actionId)) {
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo")) {
                String taskInfoStr = (String)result.get("taskinfo");
                TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
                this.handleTaskInfo(taskInfo);
            }
        } else if (HRStringUtils.equals((String)"importFilter", (String)actionId) && returnData != null) {
            Map qFilterMap = (Map)closedCallBackEvent.getReturnData();
            QFilter qFilter = (QFilter)qFilterMap.get("importFilter");
            this.showDownTemForm(qFilter);
        }
    }

    private void handleTaskInfo(TaskInfo taskInfo) {
        if (taskInfo.isTaskEnd()) {
            Map taskInfoMap = (Map)JSONObject.parseObject((String)taskInfo.getData(), Map.class);
            if (Objects.isNull(taskInfoMap)) {
                return;
            }
            String exportUrl = (String)taskInfoMap.get(ACTION_ID_EXPORT);
            if (HRStringUtils.isNotEmpty((String)exportUrl)) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)exportUrl);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efa\u5bfc\u51faURL\u5931\u8d25\uff01", (String)"HRMultiEntityExportPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    private void showFilterForm() {
        Long lblObjId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("labelobject"));
        DynamicObject lblObjConfig = LabelObjectServiceHelper.getLblObjConfig((Long)lblObjId);
        DynamicObjectCollection entry = lblObjConfig.getDynamicObjectCollection("manualentryentity");
        boolean hasSearch = entry.stream().anyMatch(row -> row.getBoolean("manualsearchfield"));
        if (hasSearch) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_downtemplate");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importFilter"));
            this.getView().showForm(showParameter);
        } else {
            this.showDownTemForm(null);
        }
    }

    private void showDownTemForm(QFilter qFilter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_labelexportperm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("label", this.getView().getFormShowParameter().getCustomParam("label"));
        showParameter.setCustomParam("labelobject", this.getView().getFormShowParameter().getCustomParam("labelobject"));
        showParameter.getCustomParams().put("entityname", ResManager.loadKDString((String)"\u6253\u6807\u6570\u636e\u6a21\u677f", (String)"PermRoleInitTemplatePlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        showParameter.getCustomParams().put("taskClassName", "kd.hr.hrcs.formplugin.web.label.task.LabelTemplateExportTask");
        if (qFilter != null) {
            showParameter.setCustomParam("importFilter", (Object)qFilter.toSerializedString());
        }
        showParameter.setCustomParam("labelObjFilter", this.getView().getFormShowParameter().getCustomParam("labelObjFilter"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_ID_EXPORT));
        this.getView().showForm(showParameter);
    }
}

