/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;
import kd.hr.hrcs.formplugin.web.label.info.LabelDimensionInfo;
import kd.hr.hrcs.formplugin.web.label.info.LabelEntityInfo;

@ExcludeFromJacocoGeneratedReport
public class LblObjConfigEditPlugin
extends HRCoreBaseBillEdit {
    private static final String KEY_ENTITY_CONDITION = "conditionentryentity";
    private static final String KEY_ENTITY_MANUAL = "manualentryentity";
    private static final String KEY_ENTITY_DISPLAY = "displayentryentity";
    private static final String KEY_LABEL_OBJECT = "labelobjectid";
    private static final String KEY_ENTITY_IS_DEFAULT = "isdefault";
    private static final String IS_DEFAULT_TRUE = "1";
    private static final String ENTITY_NAME_LABEL_FIELD = "hrcs_lblobjectfield";
    private static final String RULE_FIELD_NUMBER = "rulefieldnumber";
    private static final String MANUAL_FIELD_NUMBER = "manualfieldnumber";
    private static final String DISPLAY_FIELD_NUMBER = "displayfieldnumber";
    private static final String DISPLAY_FIELD_NAME = "displayfieldname";
    private static final String RULE_LABEL = "rule";
    private static final String MANUAL_LABEL = "manual";
    private static final String DISPLAY_LABEL = "display";
    private static final String MAIN_ENTITY_ALIAS = "mainentitynumber";
    private static final String LABEL_ENTITY_INFO = "labelentityinfos";
    private static final String HRMP_HRCS_FORMPLUGIN = "hrmp-hrcs-formplugin";
    private static final String AP_MANUAL_LABEL = "manuallabel";
    private static final boolean TRUE = Boolean.TRUE;

    private void openLabelDimensionF7(String type) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)ENTITY_NAME_LABEL_FIELD, (boolean)true, (int)0, (boolean)true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"LblObjConfigEditPlugin_7", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
        showParameter.setFormId("bos_treelistf7");
        showParameter.setBillFormId("hrcs_lbldelineatdim");
        showParameter.setCustomParam(LABEL_ENTITY_INFO, (Object)this.getPageCache().get(LABEL_ENTITY_INFO));
        showParameter.setCustomParam("type", (Object)type);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
        List<Long> selectedIds = this.getSelectedDimIds(type);
        if (!CollectionUtils.isEmpty(selectedIds)) {
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setFilter(new QFilter("id", "not in", selectedIds));
            showParameter.setListFilterParameter(filterParameter);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operationType = formOperate.getType();
        String key = formOperate.getOperateKey();
        if ("save".equals(operationType)) {
            Long labelObjectId;
            DynamicObject[] manualLabelDys;
            ValueMapItem mainEntityInfo = (ValueMapItem)SerializationUtils.fromJsonString((String)this.getPageCache().get(MAIN_ENTITY_ALIAS), ValueMapItem.class);
            DynamicObjectCollection conditionRows = this.getEntityRows(KEY_ENTITY_CONDITION);
            if (conditionRows == null || conditionRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219\u6253\u6807\u8303\u56f4\u5708\u5b9a\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"LblObjConfigEditPlugin_1", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(TRUE);
                return;
            }
            boolean noneManualEntity = false;
            boolean manualLabel = this.getModel().getDataEntity().getBoolean(AP_MANUAL_LABEL);
            if (manualLabel) {
                DynamicObjectCollection manualRows = this.getEntityRows(KEY_ENTITY_MANUAL);
                if (manualRows == null || manualRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u624b\u52a8\u6253\u6807\u8303\u56f4\u5708\u5b9a\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"LblObjConfigEditPlugin_11", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(TRUE);
                    return;
                }
                noneManualEntity = manualRows.stream().noneMatch(dy -> mainEntityInfo.getValue().equals(dy.getString("manualentitynumberalias")));
            }
            DynamicObjectCollection displayRows = this.getEntityRows(KEY_ENTITY_DISPLAY);
            boolean nonDisplayEntity = displayRows.stream().noneMatch(dy -> mainEntityInfo.getValue().equals(dy.getString("displayentitynumberalias")));
            if (noneManualEntity && nonDisplayEntity) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5728\u624b\u52a8\u6253\u6807\u8303\u56f4\u5708\u5b9a\u5b57\u6bb5\u3001\u547d\u4e2d\u7ed3\u679c\u67e5\u770b\u9875\u663e\u793a\u914d\u7f6e\u4e2d\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u201c%s\u201d\u4e3b\u4e1a\u52a1\u5bf9\u8c61\u7684\u5b57\u6bb5\u3002", (String)"LblObjConfigEditPlugin_8", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), mainEntityInfo.getName().getLocaleValue()));
                args.setCancel(TRUE);
            } else if (nonDisplayEntity) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5728\u547d\u4e2d\u7ed3\u679c\u67e5\u770b\u9875\u663e\u793a\u914d\u7f6e\u4e2d\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\"%s\"\u4e3b\u5b9e\u4f53\u7684\u5b57\u6bb5\u3002", (String)"LblObjConfigEditPlugin_9", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), mainEntityInfo.getName().getLocaleValue()));
                args.setCancel(TRUE);
            } else if (noneManualEntity) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5728\u624b\u52a8\u6253\u6807\u8303\u56f4\u5708\u5b9a\u5b57\u6bb5\u4e2d\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u201c%s\u201d\u4e3b\u4e1a\u52a1\u5bf9\u8c61\u7684\u5b57\u6bb5\u3002", (String)"LblObjConfigEditPlugin_10", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), mainEntityInfo.getName().getLocaleValue()));
                args.setCancel(TRUE);
            }
            if (!manualLabel && null != (manualLabelDys = LblStrategyServiceHelper.getManualLabelPolicy((Long)(labelObjectId = Long.valueOf(this.getModel().getDataEntity().getDynamicObject(KEY_LABEL_OBJECT).getLong("id"))))) && manualLabelDys.length > 0) {
                List numbers = Arrays.stream(manualLabelDys).map(dy -> dy.getString("number")).collect(Collectors.toList());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6253\u6807\u5bf9\u8c61\u4e0a\u5df2\u5b58\u5728\u624b\u52a8\u6253\u6807\u7b56\u7565\u201c%s\u201d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u52fe\u9009\u201c\u624b\u52a8\u6253\u6807\u201d\u3002", (String)"LblObjConfigEditPlugin_13", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201d", numbers)));
                args.setCancel(TRUE);
            }
        } else if ("addruledim".equals(key)) {
            this.openLabelDimensionF7(RULE_LABEL);
        } else if ("addmanualdim".equals(key)) {
            this.openLabelDimensionF7(MANUAL_LABEL);
        } else if ("adddisplay".equals(key)) {
            this.openLabelDimensionF7(DISPLAY_LABEL);
        }
    }

    private List<Long> getSelectedDimIds(String type) {
        String entityName;
        ArrayList<Long> selectIds = new ArrayList<Long>();
        String string = RULE_LABEL.equals(type) ? KEY_ENTITY_CONDITION : (entityName = MANUAL_LABEL.equals(type) ? KEY_ENTITY_MANUAL : KEY_ENTITY_DISPLAY);
        String idField = RULE_LABEL.equals(type) ? "ruleid" : (MANUAL_LABEL.equals(type) ? "manualid" : "displayid");
        DynamicObjectCollection displayRows = this.getEntityRows(entityName);
        for (DynamicObject row : displayRows) {
            if (row == null) continue;
            selectIds.add(row.getLong(idField));
        }
        return selectIds;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (RULE_LABEL.equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.setFieldEntry(selectedRows, KEY_ENTITY_CONDITION);
        } else if (MANUAL_LABEL.equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.setFieldEntry(selectedRows, KEY_ENTITY_MANUAL);
        } else if (DISPLAY_LABEL.equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.setFieldEntry(selectedRows, KEY_ENTITY_DISPLAY);
        }
    }

    private Map<String, LabelDimensionInfo> getIdMap() {
        HashMap<String, LabelDimensionInfo> idMap = new HashMap<String, LabelDimensionInfo>(16);
        String labelEntityInfoStr = this.getPageCache().get(LABEL_ENTITY_INFO);
        List labelEntityInfos = SerializationUtils.fromJsonStringToList((String)labelEntityInfoStr, LabelEntityInfo.class);
        for (LabelEntityInfo labelEntityInfo : labelEntityInfos) {
            for (LabelDimensionInfo labelDimensionInfo : labelEntityInfo.getDimensions()) {
                idMap.put(String.valueOf(labelDimensionInfo.getId()), labelDimensionInfo);
            }
        }
        return idMap;
    }

    private boolean checkDelete(DynamicObjectCollection selectedCollection) {
        Long labelObjectId = this.getModel().getDataEntity().getDynamicObject(KEY_LABEL_OBJECT).getLong("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_lblstrategyfilter");
        Map<String, String> numberNameMap = selectedCollection.stream().collect(Collectors.toMap(dy -> dy.getString("ruleentitynumberalias") + "." + dy.getString(RULE_FIELD_NUMBER), dy -> dy.getString("rulefieldname")));
        QFilter[] qFilters = new QFilter[]{new QFilter("fieldkey", "in", numberNameMap.keySet()), new QFilter("lblstrategy.labelobject", "=", (Object)labelObjectId), new QFilter("hasfilter", "=", (Object)false)};
        DynamicObject[] dys = helper.query("lblstrategy.number,fieldkey", qFilters);
        if (null != dys && 0 != dys.length) {
            HashMap tipMap = new HashMap(16);
            for (DynamicObject dy2 : dys) {
                String key = dy2.getString("fieldkey");
                String value = dy2.getString("lblstrategy.number");
                if (!tipMap.containsKey(key)) {
                    ArrayList<String> values = new ArrayList<String>(10);
                    values.add(value);
                    tipMap.put(key, values);
                    continue;
                }
                ((List)tipMap.get(key)).add(value);
            }
            ArrayList<String> tipList = new ArrayList<String>(tipMap.size());
            for (Map.Entry entry : tipMap.entrySet()) {
                String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5220\u9664\u5931\u8d25\uff0c\u5df2\u5728\u6253\u6807\u7b56\u7565%2$s\u4e2d\u8bbe\u7f6e\u4e86\u6b64\u7ef4\u5ea6\u7684\u6253\u6807\u8303\u56f4\u3002", (String)"LblObjConfigEditPlugin_5", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), numberNameMap.get(entry.getKey()), "\"" + String.join((CharSequence)"\",\"", (Iterable)entry.getValue()) + "\"");
                tipList.add(tip);
            }
            if (tipList.size() == 1) {
                this.getView().showTipNotification((String)tipList.get(0));
            } else {
                int total = selectedCollection.size();
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5220\u9664\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"LblObjConfigEditPlugin_6", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), total, total - tipList.size(), tipList.size());
                this.getView().showConfirm(msg, String.join((CharSequence)"\r\n", tipList), MessageBoxOptions.OKCancel, ConfirmTypes.Save, null, null);
            }
            return false;
        }
        return true;
    }

    private void setFieldEntry(ListSelectedRowCollection selectedRows, String entryName) {
        if (null == selectedRows) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int idx = this.getModel().getEntryEntity(entryName).size();
        Map<String, LabelDimensionInfo> idMap = this.getIdMap();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            if (KEY_ENTITY_CONDITION.equals(entryName)) {
                model.batchCreateNewEntryRow(entryName, selectedRows.size());
                this.createRule(model, idx, selectedRows, idMap);
            } else if (KEY_ENTITY_MANUAL.equals(entryName)) {
                model.batchCreateNewEntryRow(entryName, selectedRows.size());
                this.createManual(model, idx, selectedRows, idMap);
            } else {
                model.batchCreateNewEntryRow(entryName, selectedRows.size());
                this.createDisplay(model, idx, selectedRows, idMap);
            }
        }
        model.endInit();
        this.getView().updateView(entryName);
    }

    private void createRule(AbstractFormDataModel model, int startIdx, ListSelectedRowCollection selectedRows, Map<String, LabelDimensionInfo> idMap) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            int idx = startIdx + i;
            ListSelectedRow row = selectedRows.get(i);
            LabelDimensionInfo labelDimensionInfo = idMap.get(row.getPrimaryKeyValue().toString());
            model.setValue("ruleid", row.getPrimaryKeyValue(), idx);
            model.setValue(RULE_FIELD_NUMBER, (Object)labelDimensionInfo.getNumber(), idx);
            model.setValue("rulefieldname", (Object)labelDimensionInfo.getName(), idx);
            model.setValue("ruleentityname", (Object)labelDimensionInfo.getEntityName(), idx);
            model.setValue("ruleentitynumber", (Object)labelDimensionInfo.getEntityNumber(), idx);
            model.setValue("ruleentitynumberalias", (Object)labelDimensionInfo.getEntityNumberAlias(), idx);
        }
    }

    private void createManual(AbstractFormDataModel model, int startIdx, ListSelectedRowCollection selectedRows, Map<String, LabelDimensionInfo> idMap) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            int idx = startIdx + i;
            ListSelectedRow row = selectedRows.get(i);
            LabelDimensionInfo labelDimensionInfo = idMap.get(row.getPrimaryKeyValue().toString());
            model.setValue("manualid", row.getPrimaryKeyValue(), idx);
            model.setValue(MANUAL_FIELD_NUMBER, (Object)labelDimensionInfo.getNumber(), idx);
            model.setValue("manualfieldname", (Object)labelDimensionInfo.getName(), idx);
            model.setValue("manualentityname", (Object)labelDimensionInfo.getEntityName(), idx);
            model.setValue("manualentitynumber", (Object)labelDimensionInfo.getEntityNumber(), idx);
            model.setValue("manualentitynumberalias", (Object)labelDimensionInfo.getEntityNumberAlias(), idx);
        }
    }

    private void createDisplay(AbstractFormDataModel model, int startIdx, ListSelectedRowCollection selectedRows, Map<String, LabelDimensionInfo> idMap) {
        this.setDefaultColumnReadOnly();
        for (int i = 0; i < selectedRows.size(); ++i) {
            int idx = startIdx + i;
            ListSelectedRow row = selectedRows.get(i);
            LabelDimensionInfo labelDimensionInfo = idMap.get(row.getPrimaryKeyValue().toString());
            model.setValue("displayid", row.getPrimaryKeyValue(), idx);
            model.setValue(DISPLAY_FIELD_NUMBER, (Object)labelDimensionInfo.getNumber(), idx);
            model.setValue(DISPLAY_FIELD_NAME, (Object)labelDimensionInfo.getName(), idx);
            model.setValue("displayentityname", (Object)labelDimensionInfo.getEntityName(), idx);
            model.setValue("displayentitynumber", (Object)labelDimensionInfo.getEntityNumber(), idx);
            model.setValue("displayentitynumberalias", (Object)labelDimensionInfo.getEntityNumberAlias(), idx);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entityKey = e.getEntryProp().getName();
        DynamicObjectCollection selectedCollection = this.getSelectedDynamicObjectCollection(entityKey);
        if (KEY_ENTITY_DISPLAY.equals(entityKey) && this.getModel().getDataEntity().getBoolean(AP_MANUAL_LABEL)) {
            List fields = selectedCollection.stream().filter(dy -> IS_DEFAULT_TRUE.equals(dy.get(KEY_ENTITY_IS_DEFAULT))).map(dy -> dy.getString(DISPLAY_FIELD_NAME)).collect(Collectors.toList());
            if (fields.size() > 0) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5c55\u793a\u5b57\u6bb5\u201c%s\u201d\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"LblObjConfigEditPlugin_2", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[]{String.join((CharSequence)"\"\u3001\"", fields)}));
            }
        } else if (KEY_ENTITY_CONDITION.equals(entityKey) && !this.checkDelete(selectedCollection)) {
            e.setCancel(true);
        }
    }

    private DynamicObjectCollection getSelectedDynamicObjectCollection(String entryEntity) {
        DynamicObjectCollection coll = new DynamicObjectCollection();
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntity);
        DynamicObjectCollection displayRows = this.getEntityRows(entryEntity);
        for (int row : grid.getSelectRows()) {
            coll.add(displayRows.get(row));
        }
        return coll;
    }

    public void afterCreateNewData(EventObject e) {
        Object objectId = this.getView().getFormShowParameter().getCustomParam("labelObjectId");
        if (objectId != null) {
            Long labelObjectId = (Long)objectId;
            DynamicObject lblObjConfig = LabelObjectServiceHelper.getLblObjConfig((Long)labelObjectId);
            DynamicObject[] lblObjects = LabelObjectServiceHelper.getLabelObjectsByFilter((QFilter)new QFilter("id", "=", (Object)labelObjectId));
            if (lblObjConfig == null && lblObjects != null && lblObjects.length > 0) {
                this.getModel().setValue("id", (Object)labelObjectId);
                this.getModel().setValue("number", lblObjects[0].get("number"));
                this.getModel().setValue("name", lblObjects[0].get("name"));
                this.getModel().setValue(KEY_LABEL_OBJECT, (Object)labelObjectId);
                this.addDisplayRows();
                this.setDefaultColumnReadOnly();
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.setDefaultColumnReadOnly();
        this.getView().setVisible(Boolean.valueOf(this.getModel().getDataEntity().getBoolean(AP_MANUAL_LABEL)), new String[]{"advconap"});
    }

    private void setDefaultColumnReadOnly() {
        DynamicObjectCollection displayRows = this.getEntityRows(KEY_ENTITY_DISPLAY);
        if (displayRows != null) {
            for (int idx = 0; idx < displayRows.getRowCount(); ++idx) {
                if (!IS_DEFAULT_TRUE.equals(((DynamicObject)displayRows.get(idx)).get(KEY_ENTITY_IS_DEFAULT))) continue;
                this.getView().setEnable(Boolean.valueOf(false), idx, new String[]{DISPLAY_FIELD_NUMBER});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        if (AP_MANUAL_LABEL.equals(changeKey)) {
            if (((Boolean)newValue).booleanValue()) {
                this.getModel().insertEntryRow(KEY_ENTITY_DISPLAY, 2);
                this.getModel().setValue(DISPLAY_FIELD_NUMBER, (Object)"LabelPerson", 2);
                this.getModel().setValue(DISPLAY_FIELD_NAME, (Object)ResManager.loadKDString((String)"\u6253\u6807\u4eba", (String)"LblObjConfigEditPlugin_12", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), 2);
                this.getModel().setValue(KEY_ENTITY_IS_DEFAULT, (Object)IS_DEFAULT_TRUE, 2);
                this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{DISPLAY_FIELD_NUMBER});
            } else {
                DynamicObjectCollection displayRows = this.getEntityRows(KEY_ENTITY_DISPLAY);
                List seq = displayRows.stream().filter(dy -> "LabelPerson".equals(dy.getString(DISPLAY_FIELD_NUMBER))).map(dy -> dy.getInt("seq")).collect(Collectors.toList());
                int[] indexes = new int[seq.size()];
                for (int i = 0; i < seq.size(); ++i) {
                    indexes[i] = (Integer)seq.get(i) - 1;
                }
                this.getModel().deleteEntryRows(KEY_ENTITY_DISPLAY, indexes);
                EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTITY_DISPLAY);
                grid.setStopSelectRow(false);
                this.getModel().setEntryCurrentRowIndex(KEY_ENTITY_DISPLAY, 0);
                grid.selectRows(-1);
            }
            this.getView().setVisible((Boolean)newValue, new String[]{"advconap"});
        }
    }

    private void addDisplayRows() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_NAME_LABEL_FIELD);
        DynamicObject[] lblFields = serviceHelper.query("id,fieldname,fieldalias", new QFilter[]{new QFilter(KEY_LABEL_OBJECT, "=", (Object)0)}, "id asc");
        if (lblFields == null || lblFields.length == 0) {
            return;
        }
        DynamicObjectCollection displayRows = this.getEntityRows(KEY_ENTITY_DISPLAY);
        for (DynamicObject lblField : lblFields) {
            if (!this.getModel().getDataEntity().getBoolean(AP_MANUAL_LABEL) && 3L == lblField.getLong("id")) break;
            DynamicObject defaultFieldRow = displayRows.addNew();
            defaultFieldRow.getDataEntityState().setBizChanged(true);
            defaultFieldRow.getDataEntityState().setBizChangeFlags(new long[]{1L});
            defaultFieldRow.set(DISPLAY_FIELD_NUMBER, (Object)lblField.getString("fieldalias"));
            defaultFieldRow.set(DISPLAY_FIELD_NAME, (Object)lblField.getLocaleString("fieldname"));
            defaultFieldRow.set(KEY_ENTITY_IS_DEFAULT, (Object)IS_DEFAULT_TRUE);
            defaultFieldRow.set("dispcolumnid", (Object)lblField.getLong("id"));
        }
    }

    private DynamicObjectCollection getEntityRows(String entityKey) {
        return this.getModel().getEntryEntity(entityKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long objectId = (Long)this.getView().getFormShowParameter().getCustomParam("labelObjectId");
        if (objectId != null) {
            String filedAlias;
            String entityAlias;
            LabelService labelService = new LabelService();
            List joinEntityCommonBoList = labelService.getJoinEntityCommonBoList(objectId);
            ArrayList<FieldTreeNode> fieldTreeNodeList = new ArrayList<FieldTreeNode>(10);
            FieldDefineService service = new FieldDefineService();
            String mainEntityAlias = null;
            for (JoinEntityCommonBo joinEntityCommonBo : joinEntityCommonBoList) {
                FieldTreeNode entityFiledBo = service.getEntityFiledBo(joinEntityCommonBo.getEntityNumber(), joinEntityCommonBo.getEntityAlias(), "main".equals(joinEntityCommonBo.getType()), null);
                service.replaceTitle(joinEntityCommonBo, entityFiledBo);
                if ("main".equals(joinEntityCommonBo.getType())) {
                    mainEntityAlias = joinEntityCommonBo.getEntityAlias();
                    ValueMapItem item = new ValueMapItem();
                    item.setValue(entityFiledBo.getNumber());
                    item.setName(entityFiledBo.getName());
                    this.getPageCache().put(MAIN_ENTITY_ALIAS, SerializationUtils.toJsonString((Object)item));
                }
                fieldTreeNodeList.add(entityFiledBo);
            }
            List<LabelEntityInfo> labelEntityInfos = this.getLabelEntityInfo(fieldTreeNodeList);
            DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity(KEY_ENTITY_CONDITION);
            DynamicObjectCollection manualEntry = this.getModel().getEntryEntity(KEY_ENTITY_MANUAL);
            DynamicObjectCollection displayEntry = this.getModel().getEntryEntity(KEY_ENTITY_DISPLAY);
            Map<String, String> entityNameMap = this.getEntityNameMap(fieldTreeNodeList);
            for (DynamicObject dynamicObject : conditionEntry) {
                entityAlias = dynamicObject.getString("ruleentitynumberalias");
                filedAlias = HRStringUtils.equals((String)entityAlias, (String)mainEntityAlias) ? dynamicObject.getString(RULE_FIELD_NUMBER) : entityAlias + "." + dynamicObject.getString(RULE_FIELD_NUMBER);
                dynamicObject.set("ruleentityname", (Object)entityNameMap.get(filedAlias));
            }
            for (DynamicObject dynamicObject : manualEntry) {
                entityAlias = dynamicObject.getString("manualentitynumberalias");
                filedAlias = HRStringUtils.equals((String)entityAlias, (String)mainEntityAlias) ? dynamicObject.getString(MANUAL_FIELD_NUMBER) : entityAlias + "." + dynamicObject.getString(MANUAL_FIELD_NUMBER);
                dynamicObject.set("manualentityname", (Object)entityNameMap.get(filedAlias));
            }
            for (DynamicObject dynamicObject : displayEntry) {
                entityAlias = dynamicObject.getString("displayentitynumberalias");
                filedAlias = HRStringUtils.equals((String)entityAlias, (String)mainEntityAlias) ? dynamicObject.getString(DISPLAY_FIELD_NUMBER) : entityAlias + "." + dynamicObject.getString(DISPLAY_FIELD_NUMBER);
                dynamicObject.set("displayentityname", (Object)entityNameMap.get(filedAlias));
            }
            this.getView().updateView(KEY_ENTITY_CONDITION);
            this.getView().updateView(KEY_ENTITY_MANUAL);
            this.getView().updateView(KEY_ENTITY_DISPLAY);
            this.getModel().setDataChanged(false);
            this.getPageCache().put(LABEL_ENTITY_INFO, SerializationUtils.toJsonString(labelEntityInfos));
        }
    }

    private List<LabelEntityInfo> getLabelEntityInfo(List<FieldTreeNode> fieldTreeNodeList) {
        ArrayList<LabelEntityInfo> labelEntityInfos = new ArrayList<LabelEntityInfo>(fieldTreeNodeList.size());
        for (FieldTreeNode fieldTreeNode : fieldTreeNodeList) {
            LabelEntityInfo labelEntityInfo = new LabelEntityInfo();
            labelEntityInfo.setEntityName(fieldTreeNode.getTitle());
            labelEntityInfo.setEntityNumber(fieldTreeNode.getNumber());
            if (!CollectionUtils.isEmpty((Collection)fieldTreeNode.getChildren())) {
                ArrayList<LabelDimensionInfo> dimensions = new ArrayList<LabelDimensionInfo>(fieldTreeNode.getChildren().size());
                for (FieldTreeNode node : fieldTreeNode.getChildren()) {
                    this.genLabelDimensionInfo(node, dimensions);
                }
                labelEntityInfo.setDimensions(dimensions);
            }
            labelEntityInfos.add(labelEntityInfo);
        }
        return labelEntityInfos;
    }

    private String getEntityAlias(String fieldAlias, String entityNumber) {
        return fieldAlias.contains("\u03b4") ? fieldAlias.substring(0, fieldAlias.indexOf(46)) : entityNumber;
    }

    private void genLabelDimensionInfo(FieldTreeNode fieldTreeNode, List<LabelDimensionInfo> dimensions) {
        if (fieldTreeNode.getSubEntry().booleanValue()) {
            return;
        }
        if (fieldTreeNode.getField().booleanValue() && !fieldTreeNode.getLabelIgnore().booleanValue()) {
            LabelDimensionInfo labelDimensionInfo = new LabelDimensionInfo();
            labelDimensionInfo.setId(Long.valueOf(fieldTreeNode.getKey().hashCode()));
            labelDimensionInfo.setName(fieldTreeNode.getName());
            labelDimensionInfo.setNumber(fieldTreeNode.getFieldPath().replace(fieldTreeNode.getEntityNumber() + ".", ""));
            labelDimensionInfo.setEntityName(new LocaleString(fieldTreeNode.getEntityName()));
            labelDimensionInfo.setEntityNumber(fieldTreeNode.getEntityNumber());
            labelDimensionInfo.setEntityNumberAlias(this.getEntityAlias(fieldTreeNode.getFieldAlias(), fieldTreeNode.getEntityNumber()));
            labelDimensionInfo.setControlProp(fieldTreeNode.getControlProp());
            dimensions.add(labelDimensionInfo);
        }
        if (!CollectionUtils.isEmpty((Collection)fieldTreeNode.getChildren())) {
            for (FieldTreeNode node : fieldTreeNode.getChildren()) {
                this.genLabelDimensionInfo(node, dimensions);
            }
        }
    }

    private Map<String, String> getEntityNameMap(List<FieldTreeNode> fieldTreeNodeList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)fieldTreeNodeList.size());
        for (FieldTreeNode fieldTreeNode : fieldTreeNodeList) {
            this.addName(map, fieldTreeNode);
        }
        return map;
    }

    private void addName(Map<String, String> map, FieldTreeNode fieldTreeNode) {
        List children;
        if (fieldTreeNode.getField().booleanValue()) {
            map.put(fieldTreeNode.getFieldAlias(), fieldTreeNode.getEntityName());
        }
        if (!CollectionUtils.isEmpty((Collection)(children = fieldTreeNode.getChildren()))) {
            for (FieldTreeNode child : children) {
                this.addName(map, child);
            }
        }
    }
}

