/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.managestrategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.HrBuDutyStrategyServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.formplugin.web.utils.ManageStrategyServiceHelper;

public class ManageStrategyEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_SAVE = "save";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String KEY_MODIFY = "modify";
    private static final String HRMP_HRCS_FORMPLUGIN = "hrmp-hrcs-formplugin";
    private static final Log LOG = LogFactory.getLog(ManageStrategyEditPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit entryDefStrategyEdit = (BasedataEdit)this.getView().getControl("entrydefstrategy");
        entryDefStrategyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit hrbuEdit = (OrgEdit)this.getView().getControl("entryhrbu");
        hrbuEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inheritedOrgEdit = (BasedataEdit)this.getView().getControl("inheritedorg");
        inheritedOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryInheritedOrgEdit = (BasedataEdit)this.getView().getControl("entryinheritedorg");
        entryInheritedOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{KEY_MODIFY});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operKey = formOperate.getOperateKey()) {
            case "save": {
                this.doBeforeSave(args);
                break;
            }
            case "modify": {
                this.changeViewStatus(args);
                break;
            }
        }
    }

    protected void changeViewStatus(BeforeDoOperationEventArgs e) {
        String status = (String)this.getModel().getValue("status");
        String enable = (String)this.getModel().getValue("enable");
        if (StringUtils.equals((CharSequence)"C", (CharSequence)status) && StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.setFieldsEnableByDefStrategy();
            this.initEntryEnable();
        } else {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"inheritedorg"});
        }
        this.getView().updateView();
    }

    private void doBeforeSave(BeforeDoOperationEventArgs args) {
        boolean dirty = this.getModel().getDataChanged();
        if (!dirty) {
            String message = ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53d8\u66f4\uff0c\u65e0\u9700\u4fdd\u5b58\u3002", (String)"ManageStrategyEditPlugin_1", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            this.getView().sendFormAction(this.getView());
            args.setCancel(true);
            return;
        }
        if (!this.checkIsDataChange().booleanValue()) {
            String message = ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53d8\u66f4\uff0c\u65e0\u9700\u4fdd\u5b58\u3002", (String)"ManageStrategyEditPlugin_1", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            this.getView().sendFormAction(this.getView());
            args.setCancel(true);
        }
    }

    private Boolean checkIsDataChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long orgteamId = dataEntity.getLong("orgteam.id");
        HRBaseServiceHelper strategyHelper = new HRBaseServiceHelper(this.getStrategyPageName());
        QFilter orgteamIdQFilter = new QFilter("orgteam", "=", (Object)orgteamId);
        DynamicObject strategyDy = strategyHelper.loadDynamicObject(orgteamIdQFilter);
        long oldDefstrategytypeId = strategyDy.getLong("defstrategytype.id");
        long oldnheritedorgId = strategyDy.getLong("inheritedorg.id");
        long currentDefstrategytypeId = dataEntity.getLong("defstrategytype.id");
        long currentInheritedorgId = dataEntity.getLong("inheritedorg.id");
        if (oldDefstrategytypeId != currentDefstrategytypeId || oldnheritedorgId != currentInheritedorgId) {
            return true;
        }
        DynamicObjectCollection currentEntryentityColl = this.getModel().getEntryEntity("entryentity");
        HRBaseServiceHelper strategyEntryHelper = new HRBaseServiceHelper(this.getStrategyEntryPageName());
        DynamicObject[] strategyEntryDys = strategyEntryHelper.query("bussinessfield,strategy,inheritedorg,hrbu", new QFilter[]{orgteamIdQFilter});
        Map<Long, DynamicObject> strategyEntryMap = this.strategyEntryConvertToMap(strategyEntryDys);
        for (DynamicObject currentEntry : currentEntryentityColl) {
            Long currentBusinessFieldId = currentEntry.getLong("bussinessfield.id");
            long curStrategyId = currentEntry.getLong("entrydefstrategy.id");
            long curInheritedorgId = currentEntry.getLong("entryinheritedorg.id");
            long curHrbuId = currentEntry.getLong("entryhrbu.id");
            DynamicObject oldEntry = strategyEntryMap.get(currentBusinessFieldId);
            long oldStrategyId = oldEntry.getLong("strategy.id");
            long oldInheritedorgId = oldEntry.getLong("inheritedorg.id");
            long oldHrbuId = oldEntry.getLong("hrbu.id");
            if (curStrategyId == oldStrategyId && curInheritedorgId == oldInheritedorgId && curHrbuId == oldHrbuId) continue;
            return true;
        }
        return false;
    }

    private Map<Long, DynamicObject> strategyEntryConvertToMap(DynamicObject[] strategyEntryDys) {
        HashMap strategyEntryMap = Maps.newHashMapWithExpectedSize((int)strategyEntryDys.length);
        for (DynamicObject entry : strategyEntryDys) {
            Long businessfieldId = entry.getLong("bussinessfield.id");
            strategyEntryMap.put(businessfieldId, entry);
        }
        return strategyEntryMap;
    }

    public String getStrategyPageName() {
        return null;
    }

    public String getStrategyEntryPageName() {
        return null;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String proeName;
        switch (proeName = args.getProperty().getName()) {
            case "defstrategytype": {
                this.doDefStrategyTypeChange(args);
                break;
            }
            case "inheritedorg": {
                this.doInheritedOrgChange(args);
                break;
            }
            case "entrydefstrategy": {
                this.doEntryStrategyChange(args);
                break;
            }
            case "entryinheritedorg": {
                this.doEntryInheritedOrgChange(args);
                break;
            }
            case "entryhrbu": {
                this.doEntryHrbuChange(args);
                break;
            }
        }
    }

    private void doEntryHrbuChange(PropertyChangedArgs e) {
        int entryCurrentRowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject org = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (!ObjectUtils.isEmpty((Object)org)) {
            this.getModel().setValue("entryhrbu", org.get("id"), entryCurrentRowIndex);
        }
        this.getModel().setValue("entryeffdt", (Object)new Date(System.currentTimeMillis()), entryCurrentRowIndex);
        this.getModel().setValue("effdt", (Object)new Date(System.currentTimeMillis()));
    }

    private void doEntryInheritedOrgChange(PropertyChangedArgs e) {
        String isFromHead;
        DynamicObject org = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int entryCurrentRowIndex = e.getChangeSet()[0].getRowIndex();
        String entryDefStrategy = this.getEntryDefStrategy(entryCurrentRowIndex);
        DynamicObject strategyEntry = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        Long bussinessFieldId = strategyEntry.getLong("bussinessfield.id");
        Long orgId = null;
        if (!ObjectUtils.isEmpty((Object)org)) {
            orgId = org.getLong("id");
        }
        if (HRStringUtils.equals((String)(isFromHead = this.getValueFromPageCache("entryinheritedorg" + entryCurrentRowIndex)), (String)VALUE_TRUE)) {
            this.putValueFromPageCache("entryinheritedorg" + entryCurrentRowIndex, VALUE_FALSE);
            Long entryinheritedorgId = strategyEntry.getLong("entryinheritedorg.id");
            if (entryinheritedorgId != null && orgId != null) {
                Long newEntrysourceorgId = orgId;
                newEntrysourceorgId = this.getNewEntrysourceorgId(strategyEntry, bussinessFieldId, orgId, newEntrysourceorgId);
                this.getModel().setValue("entrysourceorg", (Object)newEntrysourceorgId, entryCurrentRowIndex);
            }
            return;
        }
        boolean flag = this.handleEntryHrBuByInherChange(org, entryCurrentRowIndex, entryDefStrategy, strategyEntry, bussinessFieldId, orgId);
        if (flag) {
            this.putValueFromPageCache("entryinheritedorg" + bussinessFieldId + entryCurrentRowIndex, VALUE_FALSE);
        }
    }

    protected boolean handleEntryHrBuByInherChange(DynamicObject org, int entryCurrentRowIndex, String entryDefStrategy, DynamicObject strategyEntry, Long bussinessFieldId, Long orgId) {
        boolean flag = true;
        if (HRStringUtils.equals((String)entryDefStrategy, (String)"5") && org != null) {
            this.setConsistentOrg(entryCurrentRowIndex, strategyEntry, bussinessFieldId, orgId);
            flag = false;
        }
        return flag;
    }

    private void setConsistentOrg(int entryCurrentRowIndex, DynamicObject strategyEntry, Long bussinessFieldId, Long orgId) {
        Long entryinheritedorgId = strategyEntry.getLong("entryinheritedorg.id");
        if (entryinheritedorgId != null) {
            Long newEntrysourceorgId = orgId;
            newEntrysourceorgId = this.getNewEntrysourceorgId(strategyEntry, bussinessFieldId, orgId, newEntrysourceorgId);
            this.getModel().setValue("entrysourceorg", (Object)newEntrysourceorgId, entryCurrentRowIndex);
        }
        DynamicObject strategy = (DynamicObject)strategyEntry.get("entrydefstrategy");
        Map<String, Object> hrbuByStrategyType = this.getEntryHrbuByStrategyType(strategy, orgId);
        this.getModel().setValue("entryhrbu", hrbuByStrategyType.get("hrbu"), entryCurrentRowIndex);
        this.getModel().setValue("entryeffdt", (Object)new Date(System.currentTimeMillis()), entryCurrentRowIndex);
        this.getModel().setValue("effdt", (Object)new Date(System.currentTimeMillis()));
        this.putValueFromPageCache("entryinheritedorg" + bussinessFieldId + entryCurrentRowIndex, VALUE_TRUE);
    }

    private Long getNewEntrysourceorgId(DynamicObject strategyEntry, Long bussinessFieldId, Long orgId, Long newEntrysourceorgId) {
        HRBaseServiceHelper strategyEntryHelper = new HRBaseServiceHelper("hrcs_orgstrentry");
        boolean exists = strategyEntryHelper.isExists((Object)strategyEntry.getLong("id"));
        if (exists) {
            Object[] orgStrategyEntryByOrg = StrategyServiceHelper.getOrgStrategyEntryByOrgAndBussinessField((Object)orgId, (Object)bussinessFieldId);
            if (!ObjectUtils.isEmpty((Object[])orgStrategyEntryByOrg)) {
                newEntrysourceorgId = orgStrategyEntryByOrg[0].getLong("sourceorg.id");
            }
        } else {
            Object[] empStrategyEntryByOrg = StrategyServiceHelper.getEmpStrategyEntryByOrgAndBussinessField((Object)orgId, (Object)bussinessFieldId);
            if (!ObjectUtils.isEmpty((Object[])empStrategyEntryByOrg)) {
                newEntrysourceorgId = empStrategyEntryByOrg[0].getLong("sourceorg.id");
            }
        }
        return newEntrysourceorgId;
    }

    private void doEntryStrategyChange(PropertyChangedArgs args) {
        int entryCurrentRowIndex = args.getChangeSet()[0].getRowIndex();
        this.setEntryFieldsEnableByEntryStrategy(entryCurrentRowIndex);
        String defStrategy = this.getDefStrategy();
        String entryDefStrategy = this.getEntryDefStrategy(entryCurrentRowIndex);
        this.setStrategy(entryCurrentRowIndex, defStrategy, entryDefStrategy);
        String isFromHead = this.getValueFromPageCache("entrydefstrategy" + entryCurrentRowIndex);
        if (HRStringUtils.equals((String)isFromHead, (String)VALUE_TRUE)) {
            this.putValueFromPageCache("entrydefstrategy" + entryCurrentRowIndex, VALUE_FALSE);
            return;
        }
        DynamicObject oldDefStrategy = (DynamicObject)args.getChangeSet()[0].getOldValue();
        if (oldDefStrategy == null) {
            this.putValueFromPageCache("defstrategytype", null);
        } else {
            this.putValueFromPageCache("entrydefstrategy.strategytype" + entryCurrentRowIndex, oldDefStrategy.getString("strategytype"));
        }
        this.getModel().setValue("entryeffdt", (Object)new Date(System.currentTimeMillis()), entryCurrentRowIndex);
        this.getModel().setValue("effdt", (Object)new Date(System.currentTimeMillis()));
        DynamicObject strategyEntry = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject adminorg = (DynamicObject)this.getModel().getValue("orgteam");
        Long orgId = adminorg.getLong("id");
        this.handleStrategyEntry(entryCurrentRowIndex, entryDefStrategy, strategyEntry, orgId);
    }

    protected void handleStrategyEntry(int entryCurrentRowIndex, String entryDefStrategy, DynamicObject strategyEntry, Long orgId) {
        if (entryDefStrategy == null || HRStringUtils.equals((String)entryDefStrategy, (String)"5")) {
            this.getModel().setValue("entryinheritedorg", null, entryCurrentRowIndex);
            this.getModel().setValue("entryhrbu", null, entryCurrentRowIndex);
        } else if (HRStringUtils.equals((String)entryDefStrategy, (String)"3")) {
            this.setDefaultCurrentOrg(entryCurrentRowIndex, orgId);
        } else if (HRStringUtils.equals((String)entryDefStrategy, (String)"4")) {
            this.setDefaultCurrentBizUnit(entryCurrentRowIndex, orgId);
        } else {
            this.setForReflectionInterface(entryCurrentRowIndex, (DynamicObject)strategyEntry.get("entrydefstrategy"), orgId);
        }
    }

    private void setForReflectionInterface(int entryCurrentRowIndex, DynamicObject strategy, Long orgId) {
        Map<String, Object> hrbuByStrategyType = this.getEntryHrbuByStrategyType(strategy, orgId);
        if (hrbuByStrategyType == null) {
            return;
        }
        this.getModel().setValue("entryinheritedorg", hrbuByStrategyType.get("inheritedorg"), entryCurrentRowIndex);
        this.getModel().setValue("entryhrbu", hrbuByStrategyType.get("hrbu"), entryCurrentRowIndex);
        this.getModel().setValue("entrysourceorg", hrbuByStrategyType.get("sourceorg"), entryCurrentRowIndex);
    }

    private void setStrategy(int entryCurrentRowIndex, String defStrategy, String entryDefStrategy) {
        if (!HRStringUtils.equals((String)defStrategy, (String)entryDefStrategy)) {
            this.getModel().setValue("strategyentrytype", (Object)"1", entryCurrentRowIndex);
        } else {
            this.getModel().setValue("strategyentrytype", (Object)"0", entryCurrentRowIndex);
        }
    }

    private void setDefaultCurrentOrg(int entryCurrentRowIndex, Long orgId) {
        this.getModel().setValue("entryinheritedorg", (Object)orgId, entryCurrentRowIndex);
        this.getModel().setValue("entryhrbu", null, entryCurrentRowIndex);
        this.getModel().setValue("entrysourceorg", (Object)orgId, entryCurrentRowIndex);
    }

    private void setDefaultCurrentBizUnit(int entryCurrentRowIndex, Long orgId) {
        this.getModel().setValue("entryinheritedorg", (Object)orgId, entryCurrentRowIndex);
        this.getModel().setValue("entryhrbu", (Object)orgId, entryCurrentRowIndex);
        this.getModel().setValue("entrysourceorg", (Object)orgId, entryCurrentRowIndex);
    }

    private void doInheritedOrgChange(PropertyChangedArgs args) {
        DynamicObject org = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (org == null) {
            return;
        }
        String defStrategyType = this.getDefStrategy();
        if (HRStringUtils.equals((String)defStrategyType, (String)"5")) {
            Long orgId = org.getLong("id");
            DynamicObject defStrategy = (DynamicObject)this.getModel().getValue("defstrategytype");
            Map<Long, Map<String, Object>> hrbuByStrategyType = this.getHrbuByStrategyType(defStrategy, orgId, true);
            if (ObjectUtils.isEmpty(hrbuByStrategyType)) {
                return;
            }
            Map<String, Object> strategyMap = hrbuByStrategyType.get(orgId);
            this.getModel().setValue("effdt", (Object)new Date(System.currentTimeMillis()));
            DynamicObjectCollection strategyEntrys = this.getModel().getEntryEntity("entryentity");
            int rowCount = strategyEntrys.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String strategyEntryType = this.getEntryStrategyType(i);
                DynamicObject strategyEntry = (DynamicObject)strategyEntrys.get(i);
                if (!HRStringUtils.equals((String)strategyEntryType, (String)"0")) continue;
                Long bussinessFieldId = strategyEntry.getDynamicObject("bussinessfield").getLong("id");
                String isSetByCustom = this.getValueFromPageCache("entryinheritedorg" + bussinessFieldId + i);
                if (HRStringUtils.equals((String)isSetByCustom, (String)VALUE_TRUE)) continue;
                this.putValueFromPageCache("entryinheritedorg" + i, VALUE_TRUE);
                this.getModel().setValue("entryinheritedorg", (Object)orgId, i);
                this.getModel().setValue("entryhrbu", strategyMap.get(bussinessFieldId + "hrbu"), i);
            }
        }
    }

    private void doDefStrategyTypeChange(PropertyChangedArgs args) {
        this.setFieldsEnableByDefStrategy();
        DynamicObject defStrategy = (DynamicObject)this.getModel().getValue("defstrategytype");
        if (defStrategy == null) {
            this.getModel().setValue("inheritedorg", null);
            return;
        }
        Long newStrategyId = defStrategy.getLong("id");
        String strategyCacheId = this.getValueFromPageCache("defstrategytype");
        if (!HRStringUtils.equals((String)strategyCacheId, (String)newStrategyId.toString())) {
            DynamicObject oldDefStrategy = (DynamicObject)args.getChangeSet()[0].getOldValue();
            if (oldDefStrategy == null) {
                this.putValueFromPageCache("defstrategytype", null);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("strategy_confirm_change_defStrategyType", (IFormPlugin)this);
                HashMap map = Maps.newHashMap();
                map.put("flag", "1");
                callBackListener.setOperateOption((Map)map);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u7b56\u7565\u540e\uff0c\u5c06\u4f1a\u66f4\u65b0\u5217\u8868\u4e2d\u6240\u6709\u6570\u636e\u884c\u7684\u7b56\u7565\u6570\u636e\u3002\u786e\u5b9a\u8981\u8bbe\u7f6e\u5417\uff1f", (String)"ManageStrategyEditPlugin_14", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBackListener);
            } else {
                Long oldStrategyId = oldDefStrategy.getLong("id");
                this.putValueFromPageCache("defstrategytype", oldStrategyId.toString());
                this.putValueFromPageCache("defstrategytype.strategytype", oldDefStrategy.getString("strategytype"));
                this.showConfirm();
            }
        }
    }

    private void showConfirm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setFormId("hrcs_changeheaderselect");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "opearateConfirm"));
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("strategy_confirm_change_defStrategyType".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (this.getValueFromPageCache("defstrategytype") == null) {
                this.doConfirmCallBack(true);
                this.putValueFromPageCache("defstrategytype", null);
                this.getModel().setValue("effdt", (Object)new Date(System.currentTimeMillis()));
            } else {
                this.showConfirm();
            }
        } else {
            this.getModel().setValue("defstrategytype", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (returnData != null && "btnok".equals(returnData.get("operation"))) {
            boolean isFillAll = false;
            if (HRStringUtils.equals((String)((String)returnData.get("selectvalue")), (String)"1")) {
                isFillAll = true;
            }
            this.doConfirmCallBack(isFillAll);
            this.putValueFromPageCache("defstrategytype", null);
            this.getModel().setValue("effdt", (Object)new Date(System.currentTimeMillis()));
        } else {
            String defStrategy = this.getValueFromPageCache("defstrategytype");
            Long oldDefStrategyId = null;
            if (!HRStringUtils.isEmpty((String)defStrategy)) {
                oldDefStrategyId = Long.valueOf(defStrategy);
            }
            this.getModel().setValue("defstrategytype", (Object)oldDefStrategyId);
        }
    }

    protected void doConfirmCallBack(boolean isFillAll) {
        DynamicObject defStrategy = (DynamicObject)this.getModel().getValue("defstrategytype");
        String strategyType = this.getDefStrategy();
        IDataModel dataModel = this.getModel();
        Map<Long, Map<String, Object>> strategyMap = null;
        DynamicObject adminorg = (DynamicObject)this.getModel().getValue("orgteam");
        Long orgId = adminorg.getLong("id");
        switch (strategyType) {
            case "3": {
                dataModel.setValue("inheritedorg", (Object)adminorg.getLong("id"));
                break;
            }
            case "5": {
                dataModel.setValue("inheritedorg", null);
                break;
            }
            case "4": {
                dataModel.setValue("inheritedorg", (Object)adminorg.getLong("id"));
                break;
            }
            default: {
                strategyMap = this.getHrbuByStrategyType(defStrategy, orgId, true);
                Map<String, Object> defStrategyMap = strategyMap.get(orgId);
                dataModel.setValue("inheritedorg", defStrategyMap.get("inheritedorg"));
            }
        }
        DynamicObject defStrategyDy = (DynamicObject)dataModel.getValue("defstrategytype");
        DynamicObjectCollection strategyEntrys = dataModel.getEntryEntity("entryentity");
        Map<Long, DynamicObject> strategyBussinessMap = this.getStrategyByBussinessFieldAndStrategyType(strategyEntrys, defStrategyDy);
        int rowCount = strategyEntrys.getRowCount();
        for (int index = 0; index < rowCount; ++index) {
            this.handleEntryData(isFillAll, strategyType, dataModel, strategyMap, orgId, strategyEntrys, strategyBussinessMap, index);
        }
        if (HRStringUtils.equals((String)strategyType, (String)"3") && rowCount > 0) {
            EntryGrid strategyEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
            strategyEntryGrid.focusCell(0, "entryhrbu");
        }
    }

    private void handleEntryData(boolean isFillAll, String strategyType, IDataModel dataModel, Map<Long, Map<String, Object>> strategyMap, Long orgId, DynamicObjectCollection strategyEntrys, Map<Long, DynamicObject> strategyBussinessMap, int index) {
        String strategyTypeCache;
        DynamicObject strategyEntry = (DynamicObject)strategyEntrys.get(index);
        String strategyEntryType = strategyEntry.getString("entrydefstrategy.strategytype");
        if (!HRStringUtils.equals((String)strategyEntryType, (String)(strategyTypeCache = this.getValueFromPageCache("defstrategytype.strategytype"))) && !isFillAll) {
            return;
        }
        Long bussinessFieldId = strategyEntry.getDynamicObject("bussinessfield").getLong("id");
        this.putValueFromPageCache("entrydefstrategy" + index, VALUE_TRUE);
        dataModel.setValue("entrydefstrategy", (Object)strategyBussinessMap.get(bussinessFieldId), index);
        this.setEntryFieldsValueByDefStrategy(strategyType, bussinessFieldId, orgId, strategyMap, index);
        this.setEntryFieldsEnableByDefStrategy(strategyType, index);
        this.setEntryFieldsEnableByEntryStrategy(index);
    }

    protected Map<Long, DynamicObject> getStrategyByBussinessFieldAndStrategyType(DynamicObjectCollection strategyEntrys, DynamicObject defStrategyDy) {
        ArrayList<Long> bussinessFieldIds = new ArrayList<Long>();
        for (DynamicObject strategyEntry : strategyEntrys) {
            bussinessFieldIds.add(strategyEntry.getDynamicObject("bussinessfield").getLong("id"));
        }
        String stategyType = defStrategyDy.getString("strategytype");
        DynamicObject[] strategys = StrategyServiceHelper.getStrategyByBussinessFieldAndStrategyType(bussinessFieldIds, (String)stategyType);
        HashMap<Long, DynamicObject> strategyMap = new HashMap<Long, DynamicObject>(strategys.length);
        for (DynamicObject strategy : strategys) {
            Long bussinessFieldId = strategy.getDynamicObject("bussinessfield").getLong("id");
            strategyMap.put(bussinessFieldId, strategy);
        }
        return strategyMap;
    }

    private Map<String, Object> getEntryHrbuByStrategyType(DynamicObject defStrategy, Long orgId) {
        return this.getHrbuByStrategyType(defStrategy, orgId, false).get(orgId);
    }

    private Map<Long, Map<String, Object>> getHrbuByStrategyType(DynamicObject defStrategy, Long orgId, boolean isAllField) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        return StrategyServiceHelper.getHrbuByStrategyType((DynamicObject)defStrategy, orgIds, (String)this.getBusinessObject(), (boolean)isAllField);
    }

    private void setEntryFieldsValueByDefStrategy(String strategyType, Long bussinessFieldId, Long orgId, Map<Long, Map<String, Object>> strategyMap, int rowIndex) {
        IDataModel dataModel = this.getModel();
        this.putValueFromPageCache("entryinheritedorg" + rowIndex, VALUE_TRUE);
        dataModel.setValue("entryeffdt", (Object)new Date(System.currentTimeMillis()), rowIndex);
        switch (strategyType) {
            case "3": {
                dataModel.setValue("entryhrbu", null, rowIndex);
                dataModel.setValue("entryinheritedorg", (Object)orgId, rowIndex);
                dataModel.setValue("entrysourceorg", (Object)orgId, rowIndex);
                break;
            }
            case "5": {
                dataModel.setValue("entryhrbu", null, rowIndex);
                dataModel.setValue("entryinheritedorg", null, rowIndex);
                this.putValueFromPageCache("entryinheritedorg" + bussinessFieldId + rowIndex, VALUE_FALSE);
                break;
            }
            case "4": {
                dataModel.setValue("entryhrbu", (Object)orgId, rowIndex);
                dataModel.setValue("entryinheritedorg", (Object)orgId, rowIndex);
                dataModel.setValue("entrysourceorg", (Object)orgId, rowIndex);
                break;
            }
            default: {
                if (strategyMap == null) {
                    return;
                }
                Map<String, Object> strategyEntryMap = strategyMap.get(orgId);
                if (strategyEntryMap != null) {
                    dataModel.setValue("entryhrbu", strategyEntryMap.get(bussinessFieldId + "hrbu"), rowIndex);
                    dataModel.setValue("entryinheritedorg", strategyEntryMap.get(bussinessFieldId + "inheritedorg"), rowIndex);
                    dataModel.setValue("entrysourceorg", strategyEntryMap.get(bussinessFieldId + "sourceorg"), rowIndex);
                    break;
                }
                dataModel.setValue("entryhrbu", null, rowIndex);
                dataModel.setValue("entryinheritedorg", null, rowIndex);
            }
        }
    }

    private void setEntryFieldsEnableByDefStrategy(String defStrategy, int entryRowIndex) {
        this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryhrbu"});
        this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryinheritedorg"});
        if (HRStringUtils.equals((String)defStrategy, (String)"5")) {
            this.getView().setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{"entryinheritedorg"});
        } else if (HRStringUtils.equals((String)defStrategy, (String)"3")) {
            this.getView().setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{"entryhrbu"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "entrydefstrategy": {
                this.doBeforeEntryStrategySelect(evt);
                break;
            }
            case "entryhrbu": {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setMultiSelect(false);
                this.filterBuByBusinessType(evt);
                break;
            }
            case "inheritedorg": {
                this.doBeforeInheritedOrgSelect(evt, "inheritedorg");
                break;
            }
            case "entryinheritedorg": {
                this.doBeforeInheritedOrgSelect(evt, "entryinheritedorg");
                break;
            }
        }
    }

    protected void doBeforeInheritedOrgSelect(BeforeF7SelectEvent evt, String controlKey) {
        DynamicObject adminorg = (DynamicObject)this.getModel().getValue("orgteam");
        Long orgId = adminorg.getLong("id");
        QFilter qFilter = new QFilter("id", "!=", (Object)orgId);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void doBeforeEntryStrategySelect(BeforeF7SelectEvent evt) {
        QFilter entryStrategyFilter;
        QFilter qFilter = this.getStrategyCommonFilter();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject strategyEntry = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject bussinessField = (DynamicObject)strategyEntry.get("bussinessfield");
        Long bussinessFieldId = 0L;
        if (bussinessField != null) {
            bussinessFieldId = bussinessField.getLong("bussinesstype.id");
        }
        if ((entryStrategyFilter = this.getEntryDefStrategyFilter(bussinessFieldId)) != null) {
            qFilter.and(entryStrategyFilter);
        }
        List<String> strategyTypes = this.getValueListFromPageCache("strategytype", bussinessFieldId);
        LOG.info("doBeforeEntryStrategySelect() strategyTypes:{}", strategyTypes);
        if (strategyTypes != null && !strategyTypes.isEmpty()) {
            qFilter.and(new QFilter("strategytype", "in", strategyTypes));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    protected QFilter getEntryDefStrategyFilter(Long businessFieldId) {
        if (businessFieldId == 0L) {
            return null;
        }
        return new QFilter("bussinessfield.bussinesstype.id", "=", (Object)businessFieldId);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.sortEntryByBusniessField();
    }

    public void afterBindData(EventObject e) {
        BaseView view = (BaseView)e.getSource();
        OperationStatus opeStatus = view.getStatus();
        if (opeStatus.name().equals(OperationStatus.EDIT.name())) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        Collections.sort(entry, Comparator.comparingInt(o -> o.getInt("bussinessfield.index")));
        this.getView().updateView("entryentity");
        List<String> strategyTypes = this.getStrategyTypes();
        this.initDefStrategyFilter(strategyTypes);
        this.setFieldsEnableByDefStrategy();
        this.initEntryEnable();
        this.putValueFromPageCache("defstrategytype", null);
        if (ManageStrategyConstants.LONG_ORGTYPE_ADMINORG.equals(this.getOrgType())) {
            this.initAdminorgDisplayName();
        }
    }

    private void initAdminorgDisplayName() {
        DynamicObject adminorg = (DynamicObject)this.getModel().getValue("orgteam");
        DynamicObject orgType = (DynamicObject)adminorg.get("orgtype");
        Long orgTypeNumber = orgType.getLong("id");
        BasedataPropEdit companyName = (BasedataPropEdit)this.getView().getControl("companyname");
        BasedataPropEdit companyNumber = (BasedataPropEdit)this.getView().getControl("companynumber");
        String name = ResManager.loadKDString((String)"\u516c\u53f8\u540d\u79f0", (String)"ManageStrategyEditPlugin_8", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
        String number = ResManager.loadKDString((String)"\u516c\u53f8\u7f16\u7801", (String)"ManageStrategyEditPlugin_9", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
        if (ManageStrategyConstants.ID_ORGTYPE_GROUP.equals(orgTypeNumber)) {
            name = ResManager.loadKDString((String)"\u96c6\u56e2\u540d\u79f0", (String)"ManageStrategyEditPlugin_6", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
            number = ResManager.loadKDString((String)"\u96c6\u56e2\u7f16\u7801", (String)"ManageStrategyEditPlugin_7", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
        } else if (ManageStrategyConstants.ID_ORGTYPE_COMPANY.equals(orgTypeNumber)) {
            name = ResManager.loadKDString((String)"\u516c\u53f8\u540d\u79f0", (String)"ManageStrategyEditPlugin_8", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
            number = ResManager.loadKDString((String)"\u516c\u53f8\u7f16\u7801", (String)"ManageStrategyEditPlugin_9", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
        } else if (ManageStrategyConstants.ID_ORGTYPE_DEPARTMENT.equals(orgTypeNumber)) {
            name = ResManager.loadKDString((String)"\u90e8\u95e8\u540d\u79f0", (String)"ManageStrategyEditPlugin_10", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
            number = ResManager.loadKDString((String)"\u90e8\u95e8\u7f16\u7801", (String)"ManageStrategyEditPlugin_11", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
        } else if (ManageStrategyConstants.ID_ORGTYPE_REGION.equals(orgTypeNumber)) {
            name = ResManager.loadKDString((String)"\u533a\u57df\u540d\u79f0", (String)"ManageStrategyEditPlugin_12", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
            number = ResManager.loadKDString((String)"\u533a\u57df\u7f16\u7801", (String)"ManageStrategyEditPlugin_13", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]);
        }
        companyName.setCaption(new LocaleString(name));
        companyNumber.setCaption(new LocaleString(number));
    }

    private QFilter getStrategyCommonFilter() {
        QFilter qFilter = new QFilter("bussinessfield.bussinessobject.orgtype.id", "=", (Object)this.getOrgType());
        qFilter.and("bussinessfield.bussinessobject.objecttype", "=", (Object)this.getBusinessObject());
        qFilter.and("bussinessfield.bussinessobject.teamtype.id", "=", (Object)this.getTeamTypeNumber());
        return qFilter;
    }

    protected void initDefStrategyFilter(List<String> strategyTypes) {
        QFilter qFilter = this.getStrategyCommonFilter();
        qFilter.and("bussinessfield.isallfield", "=", (Object)Character.valueOf(Character.forDigit(1, 10)));
        if (strategyTypes != null) {
            qFilter.and(new QFilter("strategytype", "in", strategyTypes));
        }
        LOG.info("initDefStrategyFilter() filter:{}", (Object)qFilter);
        BasedataEdit defStrategy = (BasedataEdit)this.getView().getControl("defstrategytype");
        defStrategy.setQFilter(qFilter);
    }

    protected void initEntryEnable() {
        DynamicObjectCollection strategyEntrys = this.getModel().getEntryEntity("entryentity");
        int rowCount = strategyEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String strategyentrytype = this.getEntryStrategyType(i);
            if (HRStringUtils.equals((String)strategyentrytype, (String)"0")) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"bussinessfield"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entryeffdt"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entryhrbu"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entryinheritedorg"});
            }
            this.setEntryFieldsEnableByEntryStrategy(i);
        }
    }

    private void sortEntryByBusniessField() {
        DynamicObjectCollection entryColl = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        if (null != entryColl && entryColl.size() != 0) {
            entryColl.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject entryDy, DynamicObject nextEntryDy) {
                    Long entryDyId = entryDy.getLong("bussinessfield.bussinesstype.id");
                    Long nextEntryDyId = nextEntryDy.getLong("bussinessfield.bussinesstype.id");
                    return entryDyId.compareTo(nextEntryDyId);
                }
            });
            this.getModel().setValue("entryentity", (Object)entryColl);
        }
    }

    protected String getDefStrategy() {
        DynamicObject strategy = (DynamicObject)this.getModel().getDataEntity().get("defstrategytype");
        if (strategy == null) {
            return "";
        }
        return strategy.getString("strategytype");
    }

    protected String getEntryDefStrategy(int rowIndex) {
        DynamicObject strategyEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (strategyEntry == null) {
            return null;
        }
        DynamicObject strategy = strategyEntry.getDynamicObject("entrydefstrategy");
        if (strategy == null) {
            return null;
        }
        return strategy.getString("strategytype");
    }

    private String getEntryStrategyType(int rowIndex) {
        DynamicObject strategyEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (strategyEntry == null) {
            return null;
        }
        return strategyEntry.getString("strategyentrytype");
    }

    protected void setEntryFieldsEnableByEntryStrategy(int entryRowIndex) {
        String entryDefstrategy = this.getEntryDefStrategy(entryRowIndex);
        this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryhrbu"});
        this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryinheritedorg"});
        if (HRStringUtils.equals((String)entryDefstrategy, (String)"3")) {
            this.getView().setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{"entryhrbu"});
            this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryinheritedorg"});
        } else if (HRStringUtils.equals((String)entryDefstrategy, (String)"5")) {
            this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryhrbu"});
            this.getView().setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{"entryinheritedorg"});
        }
    }

    protected void setFieldsEnableByDefStrategy() {
        String strategyType = this.getDefStrategy();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"inheritedorg"});
        if (HRStringUtils.equals((String)strategyType, (String)"5")) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"inheritedorg"});
        }
    }

    protected List<String> getStrategyTypes() {
        return new ArrayList<String>();
    }

    protected Long getOrgType() {
        return ManageStrategyConstants.LONG_ORGTYPE_ADMINORG;
    }

    protected String getBusinessObject() {
        return "2";
    }

    protected Long getBusinessObjectId() {
        return ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_EMP;
    }

    protected Long getTeamTypeNumber() {
        return ManageStrategyConstants.VALUE_ADMINORG_NUMBER;
    }

    private void putValueListFromPageCache(String key, List<String> value) {
        DynamicObject orgTeam = (DynamicObject)this.getModel().getValue("orgteam");
        if (orgTeam != null) {
            String orgTeamIdStr = orgTeam.getString("id");
            this.putValueFromPageCache(key + orgTeamIdStr, SerializationUtils.toJsonString(value));
            LOG.info("putValueListFromPageCache() key:{},value:{}", (Object)(key + orgTeamIdStr), (Object)SerializationUtils.toJsonString(value));
        }
    }

    private List<String> getValueListFromPageCache(String key, Long businessTypeId) {
        DynamicObject orgTeam = (DynamicObject)this.getModel().getValue("orgteam");
        String orgTeamIdStr = orgTeam.getString("id");
        String value = this.getValueFromPageCache(key + businessTypeId + orgTeamIdStr);
        LOG.info("getValueListFromPageCache() key:{},value:{}", (Object)(key + orgTeamIdStr), (Object)value);
        List<Object> results = Lists.newArrayList();
        if (value != null) {
            results = (List)SerializationUtils.fromJsonString((String)value, List.class);
        } else if (ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_EMP.equals(this.getBusinessObjectId()) || ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG.equals(this.getBusinessObjectId())) {
            results = ManageStrategyServiceHelper.getStrategyTypes(orgTeam, this.getOrgType(), this.getBusinessObjectId(), businessTypeId);
            this.putValueListFromPageCache(key + businessTypeId, results);
        }
        return results;
    }

    private void putValueFromPageCache(String key, String value) {
        LOG.info("putValueFromPageCache() key:{},value:{}", (Object)key, (Object)value);
        String pageId = this.getView().getFormShowParameter().getPageId();
        if (pageId != null) {
            PageCache pageCache = new PageCache(pageId);
            DynamicObject orgTeam = (DynamicObject)this.getModel().getValue("orgteam");
            String orgTeamIdStr = orgTeam.getString("id");
            LOG.info("putValueFromPageCache() orgTeamIdStr:{}", (Object)orgTeamIdStr);
            pageCache.put(key + orgTeamIdStr, value);
        }
    }

    protected String getValueFromPageCache(String key) {
        String pageId = this.getView().getFormShowParameter().getPageId();
        PageCache pageCache = new PageCache(pageId);
        DynamicObject orgTeam = (DynamicObject)this.getModel().getValue("orgteam");
        String orgTeamIdStr = orgTeam.getString("id");
        LOG.info("getValueFromPageCache() key:{},value:{}", (Object)(key + orgTeamIdStr), (Object)pageCache.get(key + orgTeamIdStr));
        return pageCache.get(key + orgTeamIdStr);
    }

    protected void filterBuByBusinessType(BeforeF7SelectEvent evt) {
        int entryCurrentRowIndex;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex = evt.getRow());
        long businessTypeId = dynamicObject.getLong("bussinessfield.bussinesstype.id");
        Long controlFuncType = HrBuDutyStrategyServiceHelper.getHrBuCaDyByBusinessTypeId((long)businessTypeId);
        if (controlFuncType == null || controlFuncType == 0L) {
            return;
        }
        evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)"11");
        evt.getFormShowParameter().setCustomParam("orgViewSchemeNumber", (Object)String.valueOf(controlFuncType));
    }
}

