/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.managestrategy.projectteam;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.formplugin.web.managestrategy.ManageStrategyEditPlugin;
import kd.hr.hrcs.formplugin.web.utils.ManageStrategyServiceHelper;

public class ProjStrategyEditPlugin
extends ManageStrategyEditPlugin {
    @Override
    protected void doBeforeInheritedOrgSelect(BeforeF7SelectEvent evt, String controlKey) {
        evt.setCancel(true);
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"haos_adminorghr", (boolean)false);
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, controlKey));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    @Override
    protected void filterBuByBusinessType(BeforeF7SelectEvent evt) {
        super.filterBuByBusinessType(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        formShowParameter.setCustomParam("orgFuncId", formShowParameter.getCustomParam("orgViewSchemeNumber"));
    }

    @Override
    protected void handleStrategyEntry(int entryCurrentRowIndex, String entryDefStrategy, DynamicObject entryStrategy, Long orgId) {
        IDataModel dataModel = this.getModel();
        if (null == entryDefStrategy) {
            this.getModel().setValue("entryinheritedorg", null, entryCurrentRowIndex);
            this.getModel().setValue("entryhrbu", null, entryCurrentRowIndex);
            return;
        }
        switch (entryDefStrategy) {
            case "1": {
                dataModel.setValue("entryinheritedorg", entryStrategy.get("entryorgteam.parentorg.id"), entryCurrentRowIndex);
                dataModel.setValue("entryhrbu", (Object)ProjStrategyServiceHelper.getHrBuByInheritedorg((Long)entryStrategy.getLong("entryorgteam.parentorg.id"), (Long)entryStrategy.getLong("bussinessfield.bussinesstype.id"), (Long)0L, (String)this.getStrategyEntryPageName()), entryCurrentRowIndex);
                break;
            }
            case "2": {
                dataModel.setValue("entryinheritedorg", entryStrategy.get("entryorgteam.belongadminorg.id"), entryCurrentRowIndex);
                dataModel.setValue("entryhrbu", (Object)ProjStrategyServiceHelper.getHrBuByInheritedorg((Long)entryStrategy.getLong("entryorgteam.belongadminorg.id"), (Long)entryStrategy.getLong("bussinessfield.bussinesstype.id"), (Long)0L, (String)this.getStrategyEntryPageName()), entryCurrentRowIndex);
                break;
            }
            case "3": {
                dataModel.setValue("entryinheritedorg", (Object)entryStrategy.getLong("entryorgteam.id"), entryCurrentRowIndex);
                dataModel.setValue("entryhrbu", null, entryCurrentRowIndex);
                break;
            }
            case "4": {
                this.getView().setEnable(Boolean.valueOf(true), entryCurrentRowIndex, new String[]{"entryinheritedorg"});
                dataModel.setValue("entryinheritedorg", null, entryCurrentRowIndex);
                dataModel.setValue("entryhrbu", null, entryCurrentRowIndex);
                break;
            }
        }
    }

    @Override
    protected void setEntryFieldsEnableByEntryStrategy(int entryRowIndex) {
        String entryDefStrategy = super.getEntryDefStrategy(entryRowIndex);
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryhrbu", "entryinheritedorg"});
        if (HRStringUtils.equals((String)entryDefStrategy, (String)"3")) {
            view.setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{"entryhrbu"});
            view.setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryinheritedorg"});
        } else if (HRStringUtils.equals((String)entryDefStrategy, (String)"4")) {
            view.setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{"entryhrbu"});
            view.setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{"entryinheritedorg"});
        }
    }

    @Override
    protected boolean handleEntryHrBuByInherChange(DynamicObject org, int entryCurrentRowIndex, String entryDefStrategy, DynamicObject strategyEntry, Long bussinessFieldId, Long orgId) {
        boolean flag = true;
        if (HRStringUtils.equals((String)entryDefStrategy, (String)"4") && org != null) {
            this.getModel().setValue("entryhrbu", (Object)ProjStrategyServiceHelper.getHrBuByInheritedorg((Long)orgId, (Long)0L, (Long)bussinessFieldId, (String)this.getStrategyEntryPageName()), entryCurrentRowIndex);
            flag = false;
        }
        return flag;
    }

    @Override
    protected void changeViewStatus(BeforeDoOperationEventArgs eventArgs) {
        boolean flag;
        IDataModel model = this.getModel();
        String status = (String)model.getValue("status");
        String enable = (String)model.getValue("enable");
        boolean bl = flag = StringUtils.equals((CharSequence)"C", (CharSequence)status) && StringUtils.equals((CharSequence)"1", (CharSequence)enable);
        if (flag) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            if ("4".equals(model.getValue("defstrategytype"))) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"inheritedorg"});
            }
            this.initEntryEnable();
        } else {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        this.getView().updateView();
    }

    @Override
    protected void doConfirmCallBack(boolean isFillAll) {
        String strategyType;
        IDataModel dataModel = this.getModel();
        DynamicObject mainDataEntity = dataModel.getDataEntity();
        if (mainDataEntity == null) {
            return;
        }
        switch (strategyType = super.getDefStrategy()) {
            case "1": {
                dataModel.setValue("inheritedorg", mainDataEntity.get("orgteam.parentorg.id"));
                break;
            }
            case "2": {
                dataModel.setValue("inheritedorg", mainDataEntity.get("orgteam.belongadminorg.id"));
                break;
            }
            case "3": {
                dataModel.setValue("inheritedorg", (Object)mainDataEntity.getLong("orgteam.id"));
                break;
            }
            case "4": {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"inheritedorg"});
                dataModel.setValue("inheritedorg", null);
                break;
            }
        }
        this.disposeEntryentity(isFillAll, strategyType);
    }

    private void disposeEntryentity(boolean isFillAll, String strategyType) {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection strategyEntrys = dataModel.getEntryEntity("entryentity");
        Date modifyDate = new Date();
        Map entryStrategyTypeMap = ProjStrategyServiceHelper.getEntryStrategyTypeMap((Long)this.getBusinessObjectId(), (String)strategyType);
        String oldStrategyType = this.getValueFromPageCache("defstrategytype.strategytype");
        strategyEntrys.forEach(dy -> {
            if (isFillAll || oldStrategyType.equals(dy.getString("entrydefstrategy.strategytype"))) {
                dy.set("entrydefstrategy", entryStrategyTypeMap.get(dy.getLong("bussinessfield.id")));
                dy.set("entryinheritedorg", dataModel.getValue("inheritedorg"));
                Long hrBuByInheritedorg = ProjStrategyServiceHelper.getHrBuByInheritedorg((Long)dy.getLong("entryinheritedorg.id"), (Long)dy.getLong("bussinessfield.bussinesstype.id"), (Long)0L, (String)this.getStrategyEntryPageName());
                dy.set("entryhrbu", 0L == hrBuByInheritedorg ? null : new HRBaseServiceHelper("bos_org").loadSingle((Object)hrBuByInheritedorg));
                dy.set("entryeffdt", (Object)modifyDate);
            }
        });
        this.getView().updateView("entryentity");
        this.initEntryEnable();
    }

    @Override
    protected Map<Long, DynamicObject> getStrategyByBussinessFieldAndStrategyType(DynamicObjectCollection strategyEntrys, DynamicObject defStrategyDy) {
        String stategyType = defStrategyDy.getString("strategytype");
        HashMap strategyMap = Maps.newHashMapWithExpectedSize((int)strategyEntrys.size());
        strategyEntrys.stream().filter(entry -> stategyType.equals(entry.getString("entrydefstrategy.strategytype"))).forEach(entry -> strategyMap.put(entry.getLong("bussinessfield.id"), entry.getDynamicObject("entrydefstrategy")));
        return strategyMap;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (null == event.getReturnData()) {
            return;
        }
        if (actionId.equals("entryinheritedorg")) {
            int[] entryentities = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            this.getModel().setValue("entryinheritedorg", ((ListSelectedRowCollection)event.getReturnData()).getPrimaryKeyValues()[0], entryentities[0]);
        } else if (actionId.equals("inheritedorg")) {
            this.getModel().setValue("inheritedorg", ((ListSelectedRowCollection)event.getReturnData()).getPrimaryKeyValues()[0]);
            this.disposeEntryentity(false, super.getDefStrategy());
        } else {
            super.closedCallBack(event);
        }
    }

    @Override
    protected List<String> getStrategyTypes() {
        List<String> projStrategyTypes = ManageStrategyServiceHelper.getProjStrategyTypes();
        DynamicObject orgTeam = (DynamicObject)this.getModel().getValue("orgteam");
        QFilter qFilter = new QFilter("id", "=", (Object)orgTeam.getLong("parentorg.id"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ProjStrategyEditPlugin.getStrategyTypes()", (String)"haos_adminorgteam", (String)"otclassify.id", (QFilter[])new QFilter[]{qFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row.getLong(0).longValue() != ManageStrategyConstants.LONG_ORGTEAM_ADMINORG.longValue()) continue;
            projStrategyTypes.remove("1");
        }
        return projStrategyTypes;
    }
}

