/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.formplugin.web.msgcenter.filter.comparetype.MoreThan30DayCompareType;
import kd.hr.hrcs.formplugin.web.msgcenter.filter.comparetype.MoreThan7DayCompareType;

public class MsgCenterList
extends HRDataBaseList
implements ClickListener {
    private Map<Long, DynamicObject> processDataMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObjectCollection> consumerDataMap = new HashMap<Long, DynamicObjectCollection>(16);
    private static final String FIELD_SEND_TIME = "sendtime";
    private static final Set<String> SEND_TIME_FILTER_IDS = Sets.newHashSet((Object[])new String[]{"-999", "-998"});

    public void setFilter(SetFilterEvent event) {
        Map parameters = this.getView().getFormShowParameter().getCustomParams();
        for (Map.Entry entry : parameters.entrySet()) {
            if (!"number".equalsIgnoreCase((String)entry.getKey()) || entry.getValue() == null) continue;
            String[] numbers = entry.getValue().toString().split(",");
            QFilter intLogNumberFilter = new QFilter("number", "in", (Object)numbers);
            event.getQFilters().add(intLogNumberFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs providerArgs) {
        providerArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection collection = super.getData(start, limit);
                if (collection.isEmpty()) {
                    return collection;
                }
                ArrayList idList = Lists.newArrayListWithExpectedSize((int)collection.size());
                for (DynamicObject row : collection) {
                    idList.add(row.getLong("id"));
                }
                MsgCenterList.this.processDataMap = MsgCenterServiceHelper.getPubInfoByMsgId((List)idList);
                MsgCenterList.this.consumerDataMap = MsgCenterServiceHelper.getConsumerMap((List)idList);
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent packageDataEvt) {
        super.packageData(packageDataEvt);
        if (this.processDataMap == null) {
            return;
        }
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        long rowId = packageDataEvt.getRowData().getLong("id");
        DynamicObject dy = this.processDataMap.get(rowId);
        if (dy != null) {
            if (HRStringUtils.equals((String)fieldKey, (String)"actioncloud.name")) {
                packageDataEvt.setFormatValue(dy.get("actioncloud.name"));
            } else if (HRStringUtils.equals((String)fieldKey, (String)"actionapp.name")) {
                packageDataEvt.setFormatValue(dy.get("actionapp.name"));
            } else if (HRStringUtils.equals((String)fieldKey, (String)"msgrecstatus")) {
                DynamicObjectCollection consumerList = this.consumerDataMap.get(rowId);
                if (CollectionUtils.isEmpty((Collection)consumerList)) {
                    packageDataEvt.setFormatValue((Object)"");
                    return;
                }
                if (this.judgeRecstatus(consumerList)) {
                    packageDataEvt.setFormatValue((Object)"1");
                } else {
                    packageDataEvt.setFormatValue((Object)"2");
                }
            } else if (HRStringUtils.equals((String)fieldKey, (String)"consumerdostatus")) {
                DynamicObjectCollection consumerList = this.consumerDataMap.get(rowId);
                if (CollectionUtils.isEmpty((Collection)consumerList)) {
                    packageDataEvt.setFormatValue((Object)"");
                    return;
                }
                String consumerStatus = this.judgeConsumerStatus(consumerList);
                if (HRStringUtils.equals((String)"1", (String)consumerStatus)) {
                    packageDataEvt.setFormatValue((Object)"1");
                } else if (HRStringUtils.equals((String)"2", (String)consumerStatus)) {
                    packageDataEvt.setFormatValue((Object)"2");
                } else if (HRStringUtils.equals((String)"3", (String)consumerStatus)) {
                    packageDataEvt.setFormatValue((Object)"3");
                }
            }
        }
    }

    private String judgeConsumerStatus(DynamicObjectCollection consumerList) {
        boolean conflag = true;
        boolean exceflag = true;
        boolean emptyflag = false;
        for (DynamicObject dynamicObject : consumerList) {
            String handlestatus = dynamicObject.getString("handlestatus");
            String exceptionfeedback = dynamicObject.getString("exceptionfeedback");
            if (HRStringUtils.isEmpty((String)handlestatus)) {
                emptyflag = true;
                continue;
            }
            if (!HRStringUtils.equals((String)"2", (String)handlestatus) && !HRStringUtils.equals((String)"3", (String)handlestatus)) continue;
            conflag = false;
            if (!HRStringUtils.isEmpty((String)exceptionfeedback)) continue;
            exceflag = false;
        }
        if (conflag) {
            if (emptyflag) {
                return "0";
            }
            return "1";
        }
        if (exceflag) {
            return "3";
        }
        return "2";
    }

    private boolean judgeRecstatus(DynamicObjectCollection consumerList) {
        boolean flag = true;
        for (DynamicObject dynamicObject : consumerList) {
            String recstatus = dynamicObject.getString("recstatus");
            if (!HRStringUtils.isEmpty((String)recstatus) && HRStringUtils.equals((String)"A", (String)recstatus)) continue;
            flag = false;
        }
        return flag;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn sendTimeFilterColumn = args.getFilterColumn(FIELD_SEND_TIME);
        Map fieldCompareTypeMap = sendTimeFilterColumn.getContext().getFieldCompareTypeMap();
        fieldCompareTypeMap.put(FIELD_SEND_TIME, Lists.newArrayList((Object[])new CompareType[]{new MoreThan7DayCompareType(), new MoreThan30DayCompareType()}));
        sendTimeFilterColumn.initProperties();
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String listFieldKey = args.getListFieldKey();
        if (FIELD_SEND_TIME.equals(listFieldKey)) {
            List listColumnCompareTypes = args.getListColumnCompareTypes();
            args.setListColumnCompareTypes(listColumnCompareTypes.stream().filter(type -> !SEND_TIME_FILTER_IDS.contains(type.getId())).collect(Collectors.toList()));
        }
    }
}

