/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import org.joda.time.DateTime;

public class MsgPubPointLineChartCardPlugin
extends HRDataBaseEdit {
    private static final String DATE_FORMAT = "MM-dd";
    private static final ExecutorService NUM_COUNT_THREAD = ThreadPools.newCachedExecutorService((String)"MsgPubPointLineChart-NumCount-Thread", (int)7, (int)7);
    private static final String FIELD_SEND_TIME = "sendtime";
    private static final String FIELD_PUB_ER = "puber";
    private static final String PAGE_MY_MONITOR = "hrcs_msgmymonitor";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initPointLineChart();
    }

    private void initPointLineChart() {
        Control pointLineChart = this.getControl("pointlinechartap");
        if (pointLineChart instanceof PointLineChart) {
            PointLineChart pieChart = (PointLineChart)pointLineChart;
            DateTime nowTime = new DateTime();
            String[] xCategories = this.getXAxis(nowTime);
            Axis xAxis = pieChart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)"TransferReportPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), AxisType.category);
            xAxis.setCategorys(xCategories);
            Axis yAxis = pieChart.createYAxis(ResManager.loadKDString((String)"\u6761", (String)"TransferReportPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), AxisType.value);
            yAxis.setPropValue("minInterval", (Object)1);
            HashMap nameTextStyle = Maps.newHashMapWithExpectedSize((int)1);
            int[] padding = new int[]{0, 0, 0, -28};
            nameTextStyle.put("padding", padding);
            yAxis.setPropValue("nameTextStyle", (Object)nameTextStyle);
            LineSeries msgNumSeries = pieChart.createSeries(ResManager.loadKDString((String)"\u6d88\u606f\u6570\u636e\u91cf", (String)"TransferReportPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            Number[] msgNumYAxisValue = this.getYAxis(nowTime);
            msgNumSeries.setData(msgNumYAxisValue);
            pieChart.setShowLegend(false);
            pieChart.setShowTooltip(true);
            pieChart.setMargin(Position.top, "10%");
        }
    }

    private String[] getXAxis(DateTime nowTime) {
        int total = 7;
        String[] xAxis = new String[total];
        for (int index = 0; index < total; ++index) {
            int minusDay = total - index - 1;
            DateTime day = nowTime.minusDays(minusDay);
            xAxis[index] = minusDay == 0 ? ResManager.loadKDString((String)"\u4eca\u65e5", (String)"TransferReportPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]) : day.toString(DATE_FORMAT);
        }
        return xAxis;
    }

    private Integer[] getYAxis(DateTime nowTime) {
        int index;
        int total = 7;
        Integer[] yAxisValues = new Integer[total];
        HRBaseServiceHelper msgCenterHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        ArrayList results = Lists.newArrayListWithExpectedSize((int)total);
        for (index = 0; index < total; ++index) {
            int minusDay = total - index - 1;
            results.add(index, NUM_COUNT_THREAD.submit(() -> {
                DateTime day = nowTime.minusDays(minusDay);
                DateTime dayStart = day.withTimeAtStartOfDay();
                DateTime dayEnd = day.millisOfDay().withMaximumValue();
                ArrayList filters = Lists.newArrayListWithExpectedSize((int)3);
                QFilter dayStartFilter = new QFilter(FIELD_SEND_TIME, ">=", (Object)dayStart.toDate());
                QFilter dayEndFilter = new QFilter(FIELD_SEND_TIME, "<", (Object)dayEnd.toDate());
                filters.add(dayStartFilter);
                filters.add(dayEndFilter);
                String parentFormId = this.getView().getFormShowParameter().getParentFormId();
                if (PAGE_MY_MONITOR.equals(parentFormId)) {
                    filters.add(new QFilter(FIELD_PUB_ER, "=", (Object)RequestContext.get().getCurrUserId()));
                }
                return msgCenterHelper.count("hrcs_msgcenter", filters.toArray(new QFilter[0]));
            }));
        }
        for (index = 0; index < total; ++index) {
            try {
                yAxisValues[index] = (Integer)((Future)results.get(index)).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u6570\u636e\u83b7\u53d6\u5931\u8d25\u3002", (String)"TransferReportPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), index + 1));
                yAxisValues[index] = 0;
            }
        }
        return yAxisValues;
    }
}

