/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import org.apache.commons.lang3.StringUtils;

public class MultiGetMsgTestEdit
extends HRCoreBaseBillEdit {
    private static final String KEY_BUTTONAP_SENDMSG = "buttonapsendmsg";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_ENTRY_ENTITY_IMPORT = "advconbaritemapimport";
    private static final String ACTION_CODE_SENDMSG = "dosend";
    private static final String ACTION_CODE_IMPORT = "importdata";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ENTRY_ENTITY});
        this.addItemClickListeners(new String[]{KEY_ENTRY_ENTITY_IMPORT});
        Button buttonSendMsg = (Button)this.getView().getControl(KEY_BUTTONAP_SENDMSG);
        buttonSendMsg.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTONAP_SENDMSG)) {
            DynamicObjectCollection dynRows = this.getEntityRows(KEY_ENTRY_ENTITY);
            if (dynRows == null || dynRows.size() == 0) {
                this.getView().showErrorNotification("The message list is empty, please add message first.");
            }
            List<Map<String, Object>> messageList = this.getMessageList();
            List resultList = (List)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getMsgCenterListInfo", (Object[])new Object[]{messageList});
            JSONArray jsonObject = new JSONArray(resultList);
            this.getModel().setValue("resultmsg", (Object)jsonObject.toString());
            this.getView().updateView("resultmsg");
        }
    }

    private List<Map<String, Object>> getMessageList() {
        DynamicObjectCollection dynRows = this.getEntityRows(KEY_ENTRY_ENTITY);
        ArrayList<Map<String, Object>> messageList = new ArrayList<Map<String, Object>>(dynRows.size());
        for (int idx = 0; idx < dynRows.size(); ++idx) {
            HashMap actionInfo = Maps.newHashMap();
            DynamicObject dynamicObject = (DynamicObject)dynRows.get(idx);
            if (dynamicObject.get("entrynumber") != null && HRStringUtils.isNotEmpty((String)((String)dynamicObject.get("entrynumber")))) {
                actionInfo.put("msgNumber", dynamicObject.get("entrynumber"));
            } else {
                actionInfo.put("msgNumber", null);
            }
            if (dynamicObject.get("entryaction") != null) {
                actionInfo.put("actionId", dynamicObject.getDynamicObject("entryaction").get("id"));
            } else {
                actionInfo.put("actionId", null);
            }
            messageList.add(actionInfo);
        }
        return messageList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRowColl;
        super.closedCallBack(closedCallBackEvent);
        if (ACTION_CODE_IMPORT.equalsIgnoreCase(closedCallBackEvent.getActionId()) && (selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            Iterator iterator = selectRowColl.iterator();
            HashSet<Long> pkIds = new HashSet<Long>();
            while (iterator.hasNext()) {
                ListSelectedRow selectRow = (ListSelectedRow)iterator.next();
                pkIds.add((Long)selectRow.getPrimaryKeyValue());
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgcenter");
            String queryFields = "number,action.id";
            DynamicObject[] dynamicObjects = serviceHelper.query(queryFields, new QFilter[]{new QFilter("id", "in", pkIds)}, "id");
            int idx = this.getEntityRows(KEY_ENTRY_ENTITY).getRowCount();
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, dynamicObjects.length);
            for (DynamicObject dyn : dynamicObjects) {
                this.getModel().setValue("entrynumber", dyn.get("number"), idx);
                if (dyn.get("action") != null) {
                    this.getModel().setValue("entryaction", (Object)dyn.getDynamicObject("action"), idx++);
                    continue;
                }
                this.getModel().setValue("entryaction", null, idx++);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null != result && result.isSuccess()) {
            String key = ((AbstractOperate)args.getSource()).getOperateKey();
            if (ACTION_CODE_SENDMSG.equals(key)) {
                this.getView().showSuccessNotification("query succeed.");
            } else if (ACTION_CODE_IMPORT.equals(key)) {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hrcs_msgcenter", (boolean)true, (int)0, (boolean)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CODE_IMPORT));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private DynamicObjectCollection getEntityRows(String entityKey) {
        IFormView billView = this.getView();
        IDataModel billModel = billView.getModel();
        return billModel.getEntryEntity(entityKey);
    }
}

