/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MultiMsgProducerTestEdit
extends HRCoreBaseBillEdit {
    private static final String KEY_BUTTONAP_ADDMSG = "buttonapaddmsg";
    private static final String KEY_BUTTONAP_SENDMSG = "buttonapsendmsg";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String ACTION_CODE_ADDMSG = "addmultimsg";
    private static final String ACTION_CODE_SENDMSG = "dosend";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ENTRY_ENTITY});
        Button buttonAddMsg = (Button)this.getView().getControl(KEY_BUTTONAP_ADDMSG);
        buttonAddMsg.addClickListener((ClickListener)this);
        Button buttonSendMsg = (Button)this.getView().getControl(KEY_BUTTONAP_SENDMSG);
        buttonSendMsg.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTONAP_ADDMSG)) {
            this.addMultiMsgParams();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTONAP_SENDMSG)) {
            this.publishMultiAction();
        }
    }

    private void publishMultiAction() {
        DynamicObjectCollection dynRows = this.getEntityRows(KEY_ENTRY_ENTITY);
        if (dynRows == null || dynRows.size() == 0) {
            this.getView().showErrorNotification("The message list is empty, please add message first.");
            return;
        }
        List<Map<String, Object>> messageList = this.getMessageList();
        this.getModel().setValue("resultmsg", (Object)HRProducerServiceHelper.publishAction(messageList).toString());
        this.getView().updateView("resultmsg");
    }

    private List<Map<String, Object>> getMessageList() {
        DynamicObjectCollection dynRows = this.getEntityRows(KEY_ENTRY_ENTITY);
        ArrayList<Map<String, Object>> messageList = new ArrayList<Map<String, Object>>(dynRows.size());
        for (int idx = 0; idx < dynRows.size(); ++idx) {
            HashMap actionInfo = Maps.newHashMap();
            DynamicObject dynamicObject = (DynamicObject)dynRows.get(idx);
            if (dynamicObject.get("entrynumber") != null && HRStringUtils.isNotEmpty((String)((String)dynamicObject.get("entrynumber")))) {
                actionInfo.put("msgNumber", dynamicObject.get("entrynumber"));
            } else {
                actionInfo.put("msgNumber", null);
            }
            if (dynamicObject.get("entrymsgtitle") != null && HRStringUtils.isNotEmpty((String)((String)dynamicObject.get("entrymsgtitle")))) {
                actionInfo.put("msgTitle", dynamicObject.get("entrymsgtitle"));
            } else {
                actionInfo.put("msgTitle", null);
            }
            actionInfo.put("msgDesc", dynamicObject.get("entrymsgdesc"));
            if (dynamicObject.get("entryaction") != null) {
                actionInfo.put("actionId", dynamicObject.getDynamicObject("entryaction").get("id"));
            } else {
                actionInfo.put("actionId", null);
            }
            actionInfo.put("msgTag", dynamicObject.get("entrymsgtag"));
            if (dynamicObject.get("entrysender") != null) {
                actionInfo.put("senderId", dynamicObject.getDynamicObject("entrysender").get("id"));
            } else {
                actionInfo.put("senderId", null);
            }
            actionInfo.put("sendTime", dynamicObject.get("entrysendtime"));
            if (dynamicObject.get("entrymsgpublisher") != null) {
                actionInfo.put("msgPubNo", dynamicObject.getDynamicObject("entrymsgpublisher").get("msgpubno"));
            } else {
                actionInfo.put("msgPubNo", null);
            }
            actionInfo.put("params", dynamicObject.get("entryparams"));
            actionInfo.put("groupNumber", dynamicObject.get("entrygroupnum"));
            actionInfo.put("groupSeq", dynamicObject.get("entrygroupseq"));
            messageList.add(actionInfo);
        }
        return messageList;
    }

    private void addMultiMsgParams() {
        Integer repeatCount = 0;
        IDataModel model = this.getModel();
        if (ObjectUtils.isNotEmpty((Object)model.getValue("repeatcount"))) {
            repeatCount = (Integer)model.getValue("repeatcount");
        }
        int curPos = this.getEntityRows(KEY_ENTRY_ENTITY).getRowCount();
        model.beginInit();
        model.batchCreateNewEntryRow(KEY_ENTRY_ENTITY, repeatCount.intValue());
        for (int idx = 0; idx < repeatCount; ++idx) {
            this.addMsgParamsRow(curPos, idx);
        }
        model.endInit();
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void addMsgParamsRow(int curPos, int idx) {
        String cursor = "_" + idx;
        IDataModel model = this.getModel();
        String msgNumber = (String)model.getValue("number");
        String msgTitle = (String)model.getValue("msgTitle");
        this.getModel().setValue("entrynumber", (Object)(msgNumber + cursor), curPos + idx);
        this.getModel().setValue("entrymsgtitle", (Object)(msgTitle + cursor), curPos + idx);
        this.getModel().setValue("entryaction", model.getValue("action"), curPos + idx);
        this.getModel().setValue("entrymsgtag", model.getValue("msgTag"), curPos + idx);
        this.getModel().setValue("entrymsgpublisher", model.getValue("msgPublisher"), curPos + idx);
        this.getModel().setValue("entrysendtime", model.getValue("sendtime"), curPos + idx);
        this.getModel().setValue("entrysender", model.getValue("sender"), curPos + idx);
        this.getModel().setValue("entrymsgdesc", model.getValue("msgDesc"), curPos + idx);
        this.getModel().setValue("entrygroupseq", model.getValue("groupseq"), curPos + idx);
        this.getModel().setValue("entrygroupnum", model.getValue("groupnum"), curPos + idx);
        this.getModel().setValue("entryparams", model.getValue("params"), curPos + idx);
    }

    private DynamicObjectCollection getEntityRows(String entityKey) {
        IFormView billView = this.getView();
        IDataModel billModel = billView.getModel();
        return billModel.getEntryEntity(entityKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null != result && result.isSuccess() && ACTION_CODE_SENDMSG.equals(key = ((AbstractOperate)args.getSource()).getOperateKey())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606f\u6210\u529f", (String)"MsgProducerTestEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void publishAction() {
        try {
            IDataModel model = this.getModel();
            this.checkIsNull(model, "number", "msgtitle", "action", "msgpublisher", "sendtime", "sender");
            HashMap actionInfo = Maps.newHashMap();
            String msgNumber = (String)model.getValue("number");
            String msgTitle = (String)model.getValue("msgTitle");
            String msgDesc = (String)model.getValue("msgDesc");
            DynamicObject msgPublisher = (DynamicObject)model.getValue("msgPublisher");
            String msgPubNo = (String)msgPublisher.get("msgpubno");
            DynamicObject action = (DynamicObject)model.getValue("action");
            Date sendTime = (Date)model.getValue("sendtime");
            DynamicObject sender = (DynamicObject)model.getValue("sender");
            Long senderId = (Long)sender.getPkValue();
            Long actionId = (Long)action.getPkValue();
            String msgTag = (String)model.getValue("msgTag");
            String params = (String)model.getValue("params");
            actionInfo.put("msgNumber", msgNumber);
            actionInfo.put("msgTitle", msgTitle);
            actionInfo.put("msgDesc", msgDesc);
            actionInfo.put("actionId", actionId);
            actionInfo.put("msgTag", msgTag);
            actionInfo.put("senderId", senderId);
            actionInfo.put("sendTime", sendTime);
            actionInfo.put("msgPubNo", msgPubNo);
            actionInfo.put("params", params);
            actionInfo.put("groupNumber", (String)model.getValue("groupnum"));
            if (ObjectUtils.isNotEmpty((Object)model.getValue("groupseq"))) {
                actionInfo.put("groupSeq", (Integer)model.getValue("groupseq"));
            }
            HRProducerServiceHelper.publishAction((Map)actionInfo);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606f\u6210\u529f", (String)"MsgProducerTestEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void checkIsNull(IDataModel model, String ... keys) {
        for (String key : keys) {
            String localeValue = ((IDataEntityProperty)model.getDataEntityType().getAllFields().get(key)).getDisplayName().getLocaleValue();
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgProducerTestEdit_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), localeValue);
            Object data = model.getValue(key);
            if (Objects.isNull(data)) {
                throw new KDBizException(errorMsg);
            }
            if (!(data instanceof String) || !HRStringUtils.isEmpty((String)data.toString())) continue;
            throw new KDBizException(errorMsg);
        }
    }
}

