/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.multientity;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.mulentities.expr.QSPropExpr;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.EntityEsConfigService;
import kd.hr.hbp.common.enums.query.EnumQueryEntityDatasourceType;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.service.multientity.EntityReleaseInfoService;
import kd.hr.hrcs.bussiness.service.multientity.EsStrageBaseHelper;
import kd.hr.hrcs.bussiness.service.multientity.MetaEntityDesignService;
import kd.hr.hrcs.bussiness.service.multientity.impl.EsQueryEntityReleaseService;

public class EsQueryEntityInfoDetailPlugin
extends HRDynamicFormBasePlugin
implements CellClickListener {
    private static final String BUTTON_SAVE = "saveconfig";
    private static final String QUERY_ENTITY_ENTRY = "queryentityentry";
    private static final String QUERY_RELATION_ENTRY = "queryrelationenrtry";
    private static final String CHILD_ENTITY_ALIAS = "childentityalias";
    private static final String QUERYSOURCE_JOIN_RELATION_ID = "querysourcejoinrelationid";
    private static final String SELECT_FIELD_ALIAS = "selectfieldalias";
    private static final String MAIN_ENTITY_NAME = "mainentityname";
    private static final String QUERY_SELECT_FIELDS_ENTRY = "queryselectfieldsentry";
    private static final String COLUMN_ENTITY_ALIAS = "entityalias";
    private static final String MAIN_ENTITY_ALIAS = "mainentityalias";
    private static final String SELECT_FIELD_ENTITY_NAME = "selectfieldentityname";
    private static final String QUERY_SELECT_FIELDS_ENTRY_ID = "queryselectfieldsentryid";
    private static final String SELECT_FIELD_DISPLAY_NAME = "selectfielddisplayname";
    private static final String QUERY_RELATION_CONDITION_ENTRY = "queryrelaconditionentry";
    private static final String RELATION_CHILD_ENTITY_PROPDISNAME = "relachilddisplayname";
    private static final String RELATION_CONDITION_TYPE = "relaconditiontype";
    private static final String RELATION_PARENT_ENTITY_PROP = "relaparententityprop";
    private static final String COLUMN_ENTITY_NUMBER = "entitynumber";
    private static final String ENTITY_NAME = "entityname";
    private static final String PARENT_ENTITY_ALIAS = "parententityalias";
    private static final String ES_MULTI_ENTITY_CONFIG = "hrcs_esmultientity_config";
    private static final String RADIO_DATASOURCE_TYPE = "radiogroupscheme";

    public void cellClick(CellClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (QUERY_RELATION_ENTRY.equals(entryGrid.getEntryKey())) {
            this.setDatatoConditionEntry();
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        String id = MetaEntityDesignService.getEntityIdByEntityName((String)number);
        this.getModel().setValue("id", (Object)id);
        QueryEntity queryEntity = EsStrageBaseHelper.getQueryEntity((String)number);
        this.setMainEntity(queryEntity);
        this.setJoinEntity(queryEntity);
        this.setQuerySelectFields(queryEntity);
        this.setEntityReleaseInfo(number);
    }

    private void setMainEntity(QueryEntity queryEntity) {
        LocaleString queryEntityName = queryEntity.getName();
        String entityName = queryEntity.getEntityName();
        String entityAlias = queryEntity.getEntityAlias();
        this.getModel().setValue("name", (Object)queryEntityName);
        this.getModel().setValue("number", (Object)queryEntity.getKey());
        this.getModel().setValue(MAIN_ENTITY_NAME, (Object)entityName);
        this.getModel().setValue(MAIN_ENTITY_ALIAS, (Object)entityAlias);
        this.getModel().setValue("resultdatasourcetype", (Object)entityAlias);
    }

    private void setJoinEntity(QueryEntity queryEntity) {
        List joinEntities = queryEntity.getJoinEntitys();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(ENTITY_NAME, new Object[0]);
        vs.addField(COLUMN_ENTITY_NUMBER, new Object[0]);
        vs.addField(COLUMN_ENTITY_ALIAS, new Object[0]);
        TableValueSetter vsRel = new TableValueSetter(new String[0]);
        vsRel.addField(QUERYSOURCE_JOIN_RELATION_ID, new Object[0]);
        vsRel.addField(PARENT_ENTITY_ALIAS, new Object[0]);
        vsRel.addField(CHILD_ENTITY_ALIAS, new Object[0]);
        vsRel.addField("combinationtype", new Object[0]);
        for (Object joinEntity : joinEntities) {
            String joinAlias = joinEntity.getAlias();
            String joinEntityName = joinEntity.getEntityName();
            String joinName = joinEntity.getDisplayName();
            vs.addRow(new Object[]{joinName, joinEntityName, joinAlias});
        }
        List querySourceJoinRelaList = queryEntity.getJoinRelations();
        for (QuerySourceJoinRelation querySourceJoinRela : querySourceJoinRelaList) {
            vsRel.addRow(new Object[]{querySourceJoinRela.getId(), querySourceJoinRela.getEntityNumber(), querySourceJoinRela.getRelEntityNumber(), querySourceJoinRela.getJoinType()});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(QUERY_ENTITY_ENTRY, vs);
        model.batchCreateNewEntryRow(QUERY_RELATION_ENTRY, vsRel);
    }

    private void setEntityReleaseInfo(String queryEntityName) {
        DynamicObject dynamicObject = EntityReleaseInfoService.getEntityReleaseInfoByName((String)queryEntityName);
        DynamicObject dyEsConfig = EntityEsConfigService.getEntityReleaseInfoByName((String)queryEntityName);
        if (dynamicObject != null) {
            Object ksqlquerytype;
            String datasourcetype = (String)dynamicObject.get("datasourcetype");
            if (StringUtils.isEmpty((String)datasourcetype)) {
                this.getModel().setValue(RADIO_DATASOURCE_TYPE, (Object)EnumQueryEntityDatasourceType.ALGO.getType());
            } else {
                this.getModel().setValue(RADIO_DATASOURCE_TYPE, (Object)datasourcetype);
            }
            if (dyEsConfig != null) {
                this.getModel().setValue("esversion", dyEsConfig.get("version"));
                this.getModel().setValue("combostatus", dyEsConfig.get("status"));
            }
            if ((ksqlquerytype = dynamicObject.get("ksqlquerytype")) != null && StringUtils.isNotEmpty((String)ksqlquerytype.toString())) {
                this.getModel().setValue("radiogroupquerytype", dynamicObject.get("ksqlquerytype"));
            }
            this.getModel().setValue("checkboxuseunion", dynamicObject.get("ksqluseunion"));
            this.getModel().setValue("resultdatasourcetype", dynamicObject.get("datasourcetype"));
        } else {
            this.getModel().setValue("resultdatasourcetype", (Object)EnumQueryEntityDatasourceType.ALGO.getType());
        }
    }

    private void setQuerySelectFields(QueryEntity queryEntity) {
        List selectFields;
        String mainEntityNameLocale = null;
        MainEntityType bt = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        if (bt == null) {
            return;
        }
        LocaleString localeString = bt.getDisplayName();
        mainEntityNameLocale = localeString == null ? queryEntity.getEntityName() : localeString.getLocaleValue();
        if (StringUtils.isEmpty((String)mainEntityNameLocale)) {
            mainEntityNameLocale = queryEntity.getEntityName();
        }
        if ((selectFields = queryEntity.getSelectFields()).size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(SELECT_FIELD_ENTITY_NAME, new Object[0]);
            vs.addField(QUERY_SELECT_FIELDS_ENTRY_ID, new Object[0]);
            vs.addField(SELECT_FIELD_ALIAS, new Object[0]);
            vs.addField(SELECT_FIELD_DISPLAY_NAME, new Object[0]);
            int size = selectFields.size();
            for (int i = 0; i < size; ++i) {
                QuerySelectField selectField = (QuerySelectField)selectFields.get(i);
                String entityAlias = this.getEntityAliasByFieldName(selectField.getAlias(), mainEntityNameLocale);
                vs.addRow(new Object[]{this.getEntityNameByAlias(entityAlias, mainEntityNameLocale), selectField.getId(), selectField.getAlias(), selectField.getDisplayName()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_SELECT_FIELDS_ENTRY, vs);
        }
    }

    private void setDatatoConditionEntry() {
        String currentParentEntityAlias = this.getCurrentSelectedParentEntityAlias();
        String currentChildEntityAlias = this.getCurrentSelectedChildEntityAlias();
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        QueryEntity queryEntity = EsStrageBaseHelper.getQueryEntity((String)number);
        List querySourceJoinRelationList = queryEntity.getJoinRelations();
        for (QuerySourceJoinRelation querySourceJoinRelation : querySourceJoinRelationList) {
            String leftEntityName = querySourceJoinRelation.getEntityNumber();
            String rightEntityName = querySourceJoinRelation.getRelEntityNumber();
            if (!leftEntityName.equals(currentParentEntityAlias) || !rightEntityName.equals(currentChildEntityAlias)) continue;
            List qSConditionRowList = querySourceJoinRelation.getCondition();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(RELATION_PARENT_ENTITY_PROP, new Object[0]);
            vs.addField(RELATION_CONDITION_TYPE, new Object[0]);
            vs.addField(RELATION_CHILD_ENTITY_PROPDISNAME, new Object[0]);
            for (QSConditionRow qSConditionRow : qSConditionRowList) {
                QSPropExpr rightItem;
                QSPropExpr leftItem;
                QSExpr objRight = qSConditionRow.getRightItem();
                QSExpr objLeft = qSConditionRow.getLeftItem();
                if (objLeft == null || objRight == null) continue;
                String leftItemName = null;
                String rightItemName = null;
                if (objLeft instanceof QSPropExpr) {
                    leftItem = (QSPropExpr)objLeft;
                    leftItemName = leftItem.toString();
                } else {
                    if (!(objLeft instanceof QSIdentifierExpr)) continue;
                    leftItem = (QSIdentifierExpr)objLeft;
                    leftItemName = leftItem.getExpr();
                }
                if (objRight instanceof QSPropExpr) {
                    rightItem = (QSPropExpr)objRight;
                    rightItemName = rightItem.toString();
                } else {
                    if (!(objRight instanceof QSIdentifierExpr)) continue;
                    rightItem = (QSIdentifierExpr)objRight;
                    rightItemName = rightItem.getExpr();
                }
                if (StringUtils.isEmpty((String)rightItemName) || StringUtils.isEmpty((String)leftItemName)) continue;
                String compareOp = qSConditionRow.getCompareOp();
                String leftPropDisName = this.assembleRelPropDisplayName(leftItemName, currentParentEntityAlias, 2);
                String rightPropDisName = this.assembleRelPropDisplayName(rightItemName, currentChildEntityAlias, 1);
                vs.addRow(new Object[]{leftPropDisName, compareOp, rightPropDisName});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(QUERY_RELATION_CONDITION_ENTRY);
            model.batchCreateNewEntryRow(QUERY_RELATION_CONDITION_ENTRY, vs);
        }
    }

    private String assembleRelPropDisplayName(String propName, String entityAlias, int flag) {
        String entityNumber = this.getEntityNumberByAlias(entityAlias);
        String entityName = this.getEntityNameByAlias(entityAlias);
        if (entityName == null) {
            throw new KDException(BosErrorCode.systemError, new Object[0]);
        }
        String propDisplayName = propName;
        String[] propNames = StringUtils.split((String)propName, (boolean)true, (char[])new char[]{'.'});
        if (flag == 1 && propNames.length > 1 && (propNames[0].equals(entityAlias) || propNames[0].equals(entityNumber))) {
            String displayName = this.findPorpDisplayName(entityNumber, entityName, propName);
            propDisplayName = displayName + "(" + propName + ")";
        } else if (flag == 2) {
            String displayName = this.findPorpDisplayName(entityNumber, entityName, propName);
            displayName = displayName.substring(entityName.length() + 1);
            propDisplayName = displayName + "(" + propName + ")";
        }
        return propDisplayName;
    }

    private String getEntityNumberByAlias(String entityAlias) {
        String mainEntityAlias;
        String entityNumber = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityNumber = dynObj.getString(COLUMN_ENTITY_NUMBER);
                break;
            }
        }
        if (entityNumber == null && entityAlias != null && (mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) != null && entityAlias.equals(mainEntityAlias)) {
            entityNumber = (String)this.getModel().getValue(MAIN_ENTITY_NAME);
        }
        return entityNumber;
    }

    private String findPorpDisplayName(String entityNumber, String entityName, String propName) {
        String displayName = "";
        String[] propNames = StringUtils.split((String)propName, (boolean)true, (char[])new char[]{'.'});
        String fieldValue = null;
        String fieldBaseData = "";
        if (propNames.length == 0) {
            fieldValue = propName;
        } else if (propNames.length == 3) {
            fieldBaseData = propNames[propNames.length - 2];
            fieldValue = propNames[propNames.length - 1];
        } else if (propNames.length == 4) {
            fieldBaseData = propNames[propNames.length - 3];
            fieldValue = propNames[propNames.length - 2] + "." + propNames[propNames.length - 1];
        } else {
            fieldValue = propNames[propNames.length - 1];
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String baseName = "";
        for (IDataEntityProperty dtProp : properties) {
            if (dtProp.getName().equals(fieldBaseData)) {
                baseName = dtProp.getDisplayName() != null ? dtProp.getDisplayName().toString() : dtProp.getAlias();
                displayName = this.findPropertity(fieldValue, dtProp);
                break;
            }
            if (!dtProp.getName().equals(fieldValue)) continue;
            if (dtProp.getDisplayName() != null) {
                displayName = dtProp.getDisplayName().toString();
                continue;
            }
            displayName = dtProp.getAlias();
        }
        if (!StringUtils.isEmpty((String)baseName)) {
            displayName = baseName + "." + displayName;
        }
        displayName = entityName + "." + displayName;
        return displayName;
    }

    private String findPropertity(String fieldValue, IDataEntityProperty dtProp) {
        String displayName = "";
        MainEntityType bdType2 = null;
        DataEntityPropertyCollection properties = null;
        if (dtProp instanceof BasedataProp) {
            BasedataProp bdProp2 = (BasedataProp)dtProp;
            bdType2 = (MainEntityType)bdProp2.getComplexType();
            properties = bdType2.getProperties();
        } else if (dtProp instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)dtProp;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            properties = entryEntitytype.getProperties();
        }
        if (properties != null) {
            String[] fieldValueArray = fieldValue.split("\\.");
            String baseDataProp = fieldValueArray[0];
            for (IDataEntityProperty baseProp : properties) {
                if (fieldValueArray.length > 1 && baseProp instanceof BasedataProp && baseProp.getName().equals(baseDataProp)) {
                    String baseDataPropVal = fieldValueArray[1];
                    BasedataProp bdProp2 = (BasedataProp)baseProp;
                    bdType2 = (MainEntityType)bdProp2.getComplexType();
                    properties = bdType2.getProperties();
                    for (IDataEntityProperty endBaseProp : properties) {
                        if (!endBaseProp.getName().equals(baseDataPropVal)) continue;
                        displayName = bdProp2.getDisplayName() == null ? bdProp2.getAlias() : bdProp2.getDisplayName().toString();
                        String propDisplayName = endBaseProp.getDisplayName() == null ? endBaseProp.getAlias() : endBaseProp.getDisplayName().toString();
                        displayName = displayName + "." + propDisplayName;
                        return displayName;
                    }
                    continue;
                }
                if (!baseProp.getName().equals(fieldValue)) continue;
                if (baseProp.getDisplayName() != null) {
                    displayName = baseProp.getDisplayName().toString();
                    break;
                }
                displayName = baseProp.getAlias();
                break;
            }
        }
        return displayName;
    }

    private String getEntityNameByAlias(String entityAlias) {
        String mainEntityAlias;
        String entityName = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityName = dynObj.getString(ENTITY_NAME);
                break;
            }
        }
        if (entityName == null && entityAlias.equals(mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS))) {
            entityName = (String)this.getModel().getValue(MAIN_ENTITY_NAME);
        }
        return entityName;
    }

    private String getCurrentSelectedChildEntityAlias() {
        DynamicObject dynObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
        if (dynObject == null) {
            return "";
        }
        String childEntityAlias = dynObject.getString(CHILD_ENTITY_ALIAS);
        return childEntityAlias;
    }

    private DynamicObject getEntryCurrentSelectDynamicObject(String entryPropNumber) {
        DynamicObject dynObject = null;
        if (!StringUtils.isEmpty((String)entryPropNumber)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(entryPropNumber);
            int selectRowIndex = this.getModel().getEntryCurrentRowIndex(entryPropNumber);
            if (selectRowIndex >= 0 && dynColl.size() > 0) {
                dynObject = (DynamicObject)dynColl.get(selectRowIndex);
            }
        }
        return dynObject;
    }

    private String getCurrentSelectedParentEntityAlias() {
        DynamicObject dynObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
        if (dynObject == null) {
            return "";
        }
        String parentEntityAlias = dynObject.getString(PARENT_ENTITY_ALIAS);
        return parentEntityAlias;
    }

    private String getEntityAliasByFieldName(String fieldName, String mainEntityNameLocale) {
        String[] fieldNames = fieldName.split("\\.");
        String entityAlias = (String)this.getModel().getValue(MAIN_ENTITY_NAME);
        String mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_NAME);
        entityAlias = fieldNames.length > 1 ? fieldNames[0] : mainEntityAlias;
        if (this.getEntityNameByAlias(entityAlias, mainEntityNameLocale) == null) {
            entityAlias = mainEntityAlias;
        }
        return entityAlias;
    }

    private String getEntityNameByAlias(String entityAlias, String mainEntityNameLocale) {
        String entityName = entityAlias;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityName = dynObj.getString(ENTITY_NAME);
                return entityName;
            }
        }
        return mainEntityNameLocale;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", CHILD_ENTITY_ALIAS});
        this.addClickListeners(new String[]{"barcancel"});
        EntryGrid queryrelationenrtry = (EntryGrid)this.getControl(QUERY_RELATION_ENTRY);
        queryrelationenrtry.addCellClickListener((CellClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Donothing donothing;
        super.afterDoOperation(afterDoOperationEventArgs);
        Object obj = afterDoOperationEventArgs.getSource();
        if (obj instanceof Donothing && BUTTON_SAVE.equals((donothing = (Donothing)obj).getOperateKey())) {
            this.clickSave();
            return;
        }
    }

    private DynamicObject geReleaseInfoDynamicObject() {
        String queryEntityName = (String)this.getModel().getValue("number");
        String datasourceType = (String)this.getModel().getValue("resultdatasourcetype");
        DynamicObject dyReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)queryEntityName);
        if (dyReleaseInfo == null) {
            dyReleaseInfo = EntityReleaseInfoService.generateEmptyDynamicObject();
            dyReleaseInfo.set("queryentityname", (Object)queryEntityName);
            dyReleaseInfo.set("createtime", (Object)new Date());
        }
        dyReleaseInfo.set("datasourcetype", (Object)datasourceType);
        return dyReleaseInfo;
    }

    private void algoSave() {
        DynamicObject dyReleaseInfo = this.geReleaseInfoDynamicObject();
        Date modifytime = new Date();
        dyReleaseInfo.set("modifytime", (Object)modifytime);
        dyReleaseInfo.set("datasourcetype", (Object)EnumQueryEntityDatasourceType.ALGO.getType());
        EntityReleaseInfoService.saveOne((DynamicObject)dyReleaseInfo);
        this.getModel().setValue("resultdatasourcetype", (Object)EnumQueryEntityDatasourceType.ALGO.getType());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e3aALGO\u65b9\u6848\u6210\u529f\u3002", (String)"EsQueryEntityInfoDetailPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void ksqlSave() {
        DynamicObject dyReleaseInfo = this.geReleaseInfoDynamicObject();
        Date ksqlmodifytime = new Date();
        String ksqlQueryType = (String)this.getModel().getValue("radiogroupquerytype");
        dyReleaseInfo.set("ksqlquerytype", (Object)ksqlQueryType);
        Boolean useUnion = (Boolean)this.getModel().getValue("checkboxuseunion");
        dyReleaseInfo.set("ksqluseunion", (Object)useUnion);
        dyReleaseInfo.set("datasourcetype", (Object)EnumQueryEntityDatasourceType.KSQL.getType());
        dyReleaseInfo.set("modifytime", (Object)new Date());
        EntityReleaseInfoService.saveOne((DynamicObject)dyReleaseInfo);
        this.getModel().setValue("resultdatasourcetype", (Object)EnumQueryEntityDatasourceType.KSQL.getType());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e3aKSQL\u65b9\u6848\u6210\u529f\u3002", (String)"EsQueryEntityInfoDetailPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void esSave() {
        String strStatus = (String)this.getModel().getValue("combostatus");
        if (StringUtils.isNotEmpty((String)strStatus)) {
            String mainEntityName;
            String queryEntityName;
            EsQueryEntityReleaseService esQueryEntityRelease = EsQueryEntityReleaseService.getInstance();
            if (esQueryEntityRelease.isFullSync(queryEntityName = (String)this.getView().getFormShowParameter().getCustomParam("number"), mainEntityName = (String)this.getView().getFormShowParameter().getCustomParam(MAIN_ENTITY_NAME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u540c\u6b65ES\u6570\u636e\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"EsQueryEntityInfoDetailPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            this.showTipEsNoneVersion();
            return;
        }
        String queryEntityName = (String)this.getModel().getValue("number");
        this.getModel().setValue("resultdatasourcetype", (Object)EnumQueryEntityDatasourceType.ES.getType());
        DynamicObject dyReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)queryEntityName);
        Date modifyDate = new Date();
        if (dyReleaseInfo == null) {
            this.showTipEsNoneVersion();
            return;
        }
        dyReleaseInfo.set("modifytime", (Object)modifyDate);
        dyReleaseInfo.set("datasourcetype", (Object)EnumQueryEntityDatasourceType.ES.getType());
        EntityReleaseInfoService.saveOne((DynamicObject)dyReleaseInfo);
        this.setEntityReleaseInfo(queryEntityName);
        this.getModel().setValue("resultdatasourcetype", (Object)EnumQueryEntityDatasourceType.ES.getType());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e3aES\u65b9\u6848\u6210\u529f\u3002", (String)"EsQueryEntityInfoDetailPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void clickSave() {
        String datasourcetype = (String)this.getModel().getValue(RADIO_DATASOURCE_TYPE);
        if (StringUtils.isEmpty((String)datasourcetype)) {
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("save", (IFormPlugin)this);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u4fdd\u5b58\u67e5\u8be2\u65b9\u6848\u4e3a\u201c%s\u201d\u65b9\u6848\u5417\uff1f", (String)"EsQueryEntityInfoDetailPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), datasourcetype), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }

    private void save() {
        String datasourcetype = (String)this.getModel().getValue(RADIO_DATASOURCE_TYPE);
        if (datasourcetype.equals(EnumQueryEntityDatasourceType.ES.getType())) {
            this.esSave();
        } else if (datasourcetype.equals(EnumQueryEntityDatasourceType.KSQL.getType())) {
            this.ksqlSave();
        } else if (datasourcetype.equals(EnumQueryEntityDatasourceType.ALGO.getType())) {
            this.algoSave();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("save".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.save();
            }
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String controlKey = e.getProperty().getName();
        if (RADIO_DATASOURCE_TYPE.equals(controlKey) && changeData != null && changeData.length > 0) {
            for (int i = 0; i < changeData.length; ++i) {
                String status;
                String newValue = (String)changeData[i].getNewValue();
                if (!EnumQueryEntityDatasourceType.ES.getType().equals(newValue) || !StringUtils.isEmpty((String)(status = (String)this.getModel().getValue("combostatus")))) continue;
                this.showTipEsNoneVersion();
                return;
            }
        }
    }

    public void showTipEsNoneVersion() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"ES\u90e8\u7f72\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u540c\u6b65ES\u6570\u636e\u3002", (String)"EsQueryEntityInfoDetailPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }
}

