/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.multimpt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRMultiEntityImptUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;

public class MultiEntityImpTmplEdit
extends HRBaseDataCommonEdit
implements BeforeF7SelectListener {
    private static final String HRMP_HRCS_FORMPLUGIN = "hrmp-hrcs-formplugin";
    private static final String ALGO_KEY = "MultiEntityImpTmplEdit_query";
    private static final String FIELD_TEMPLATE_TYPE = "tmpltype";
    private static final String FIELD_MAIN_ENTITY_TMPL = "mainentitytmpl";
    private static final String FIELD_MAIN_ENTITY_UNIQUE = "mainentityuniqueval";
    private static final String FIELD_ASSOC_ENTITY_TMPL = "assocentitytmpl";
    private static final String FIELD_ASSOC_ENTITY_OBJ = "assocentitytmpl.bizobject";
    private static final String FIELD_APPLY_SCOPE = "applyscope";
    private static final String FIELD_APPLY_USERS = "users";
    private static final String FIELD_RELATION_LEFT_PROP = "relationleftprop";
    private static final String FIELD_RELATION_RIGHT_PROP = "relationrightprop";
    private static final String ENTITY_UNIQUE_VALUE = "entityuniqueval";
    private static final String ENTITY_UNIQUE_NAME = "entityuniquename";
    private static final String ENTRY_ENTITY = "assocentitytmplentry";
    private static final String RELATION_CONDITION = "relationcondition";
    private static final String FIELD_TEM_DESCRIPTION = "flexpanelap";
    private static final String FIELD_SELECT_FORM = "cts_queryfieldmodifyvalf7";
    private static final String UNIQUE_SELECT_FORM = "hrcs_multisheetfieldf7";
    private static final String FIELD_SEQ = "seq";
    private static final String IMPORT_TYEP = "IMPT";

    public void afterLoadData(EventObject eventObject) {
        this.resetMainEntityUQVal();
    }

    private void clearRightFieldValue(String oldObjNumber) {
        this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(row -> HRStringUtils.isNotEmpty((String)row.getString(FIELD_RELATION_RIGHT_PROP)) && row.getString(FIELD_RELATION_RIGHT_PROP).contains(oldObjNumber)).forEach(row -> row.set(FIELD_RELATION_RIGHT_PROP, (Object)""));
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        switch (propName) {
            case "mainentitytmpl": {
                this.resetMainEntityUQVal();
                DynamicObject oldMainValue = (DynamicObject)changeSet[0].getOldValue();
                if (!Objects.nonNull(oldMainValue)) break;
                this.clearRightFieldValue(oldMainValue.getString("bizobject.number"));
                break;
            }
            case "applyscope": {
                this.getView().setVisible(Boolean.valueOf("1".equals(this.getModel().getValue(FIELD_APPLY_SCOPE))), new String[]{FIELD_APPLY_USERS});
                break;
            }
            case "tmpltype": {
                this.initTemplateType();
                break;
            }
            case "assocentitytmpl": {
                int rowIndex = changeSet[0].getRowIndex();
                this.getModel().setValue(ENTITY_UNIQUE_VALUE, (Object)"", rowIndex);
                this.getModel().setValue(ENTITY_UNIQUE_NAME, (Object)"", rowIndex);
                this.getModel().setValue(FIELD_RELATION_LEFT_PROP, (Object)"", rowIndex);
                DynamicObject oldRelValue = (DynamicObject)changeSet[0].getOldValue();
                if (!Objects.nonNull(oldRelValue)) break;
                this.clearRightFieldValue(oldRelValue.getString("bizobject.number"));
                break;
            }
        }
    }

    private void initTemplateType() {
        boolean flag = IMPORT_TYEP.equals(this.getModel().getValue(FIELD_TEMPLATE_TYPE));
        ((TextEdit)this.getControl(FIELD_RELATION_LEFT_PROP)).setMustInput(!flag);
        ((TextEdit)this.getControl(FIELD_RELATION_RIGHT_PROP)).setMustInput(!flag);
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{FIELD_MAIN_ENTITY_UNIQUE, ENTITY_UNIQUE_NAME, FIELD_TEM_DESCRIPTION});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (!evt.getOperationKey().equals("save") && !evt.getOperationKey().equals("saveandnew")) {
            return;
        }
        if (this.checkSingleEntityTemplate()) {
            evt.setCancel(true);
            return;
        }
        boolean flag = IMPORT_TYEP.equals(this.getModel().getValue(FIELD_TEMPLATE_TYPE));
        if (Objects.nonNull(this.getModel().getValue(FIELD_MAIN_ENTITY_UNIQUE)) && this.getModel().getValue(FIELD_MAIN_ENTITY_UNIQUE).toString().length() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u552f\u4e00\u66ff\u6362\u503c\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236\u3002", (String)"MultiEntityImpTmplEdit_1", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (!flag && Objects.isNull(this.getModel().getValue(FIELD_MAIN_ENTITY_UNIQUE))) {
            this.getModel().setValue(FIELD_MAIN_ENTITY_UNIQUE, (Object)",id,");
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject dynamicObject : entryEntity) {
            if (!flag && (StringUtils.isBlank((CharSequence)dynamicObject.getString(FIELD_RELATION_LEFT_PROP)) || StringUtils.isBlank((CharSequence)dynamicObject.getString(FIELD_RELATION_RIGHT_PROP)))) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7b2c%s\u884c\u4e0e\u5176\u4ed6\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u3002", (String)"MultiEntityImpTmplEdit_4", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), dynamicObject.getInt(FIELD_SEQ)));
                evt.setCancel(true);
                break;
            }
            if (Objects.nonNull(dynamicObject.getString(ENTITY_UNIQUE_VALUE)) && dynamicObject.getString(ENTITY_UNIQUE_VALUE).length() > 50) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\uff0c\u552f\u4e00\u66ff\u6362\u503c\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236\u3002", (String)"MultiEntityImpTmplEdit_2", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), dynamicObject.getInt(FIELD_SEQ)));
                evt.setCancel(true);
                break;
            }
            if (flag || !StringUtils.isBlank((CharSequence)dynamicObject.getString(ENTITY_UNIQUE_VALUE)) && !",,".equals(dynamicObject.getString(ENTITY_UNIQUE_VALUE))) continue;
            dynamicObject.set(ENTITY_UNIQUE_VALUE, (Object)",id,");
            dynamicObject.set(ENTITY_UNIQUE_NAME, (Object)"id");
        }
    }

    private boolean checkSingleEntityTemplate() {
        DynamicObject mainEntity = (DynamicObject)this.getModel().getValue(FIELD_MAIN_ENTITY_TMPL);
        if (this.checkTemplate(mainEntity)) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u5355\u636e\u4f53\u6216\u8005\u591a\u5c42\u5355\u636e\u4f53\u7684\u5bfc\u5165\u5bfc\u51fa\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\uff1a%s\u3002", (String)"MultiEntityImpTmplEdit_5", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), mainEntity.getLocaleString("name").getLocaleValue()));
            return true;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject entryDynamicObject : entryEntity) {
            if (!Objects.nonNull(entryDynamicObject.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL)) || !this.checkTemplate(entryDynamicObject.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL))) continue;
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u5355\u636e\u4f53\u6216\u8005\u591a\u5c42\u5355\u636e\u4f53\u7684\u5bfc\u5165\u5bfc\u51fa\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\uff1a%s\u3002", (String)"MultiEntityImpTmplEdit_5", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), entryDynamicObject.getLocaleString("assocentitytmpl.name")));
            return true;
        }
        return false;
    }

    private boolean checkTemplate(DynamicObject mainEntity) {
        DataSet rows = HRDBUtil.queryDataSet((String)ALGO_KEY, (DBRoute)new DBRoute("sys"), (String)"select fentryid,fparententryid,fisimport from T_BAS_IMPORTTEMPLATEENTRY where fid = ? order by fseq", (Object[])new Object[]{mainEntity.getPkValue()});
        ArrayList treeList = Lists.newArrayListWithCapacity((int)16);
        HashSet entrySizeList = Sets.newHashSetWithExpectedSize((int)16);
        EntryEntityTreeBO rootNode = null;
        while (rows.hasNext()) {
            Row row = rows.next();
            if (row.getLong(1) == 0L) {
                rootNode = new EntryEntityTreeBO(row.getLong(0), row.getLong(1), row.getBoolean(2));
                rootNode.level = 0;
                continue;
            }
            treeList.add(new EntryEntityTreeBO(row.getLong(0), row.getLong(1), row.getBoolean(2)));
        }
        return this.getEntryEntityChildNode(treeList, rootNode, entrySizeList) || entrySizeList.size() > 2;
    }

    private boolean getEntryEntityChildNode(List<EntryEntityTreeBO> treeList, EntryEntityTreeBO fatherNode, Set<Long> entrySizeList) {
        if (fatherNode == null) {
            return false;
        }
        for (EntryEntityTreeBO entryEntityTreeBO : treeList) {
            if (entryEntityTreeBO.parentId.longValue() != fatherNode.id.longValue()) continue;
            entryEntityTreeBO.level = fatherNode.level + 1;
            if (entryEntityTreeBO.level > 2 && entryEntityTreeBO.isImport) {
                return true;
            }
            if (entryEntityTreeBO.level > 1 && entryEntityTreeBO.isImport) {
                entrySizeList.add(entryEntityTreeBO.parentId);
            }
            fatherNode.addChildren(entryEntityTreeBO);
            this.getEntryEntityChildNode(treeList, entryEntityTreeBO, entrySizeList);
        }
        return false;
    }

    private void resetMainEntityUQVal() {
        ComboEdit combo = (ComboEdit)this.getControl(FIELD_MAIN_ENTITY_UNIQUE);
        Object mainEntityTmplObj = this.getModel().getValue(FIELD_MAIN_ENTITY_TMPL);
        if (Objects.isNull(mainEntityTmplObj)) {
            combo.setComboItems(Collections.emptyList());
        } else {
            combo.setComboItems(Collections.emptyList());
            DynamicObject mainEntityTmplDyo = (DynamicObject)mainEntityTmplObj;
            String entityNumber = mainEntityTmplDyo.getString("bizobject.number");
            HashMap<String, Boolean> importField = this.getImportFieldHashMap(mainEntityTmplDyo);
            HRMultiEntityImptUtil.loadImportField4Combo((String)entityNumber, (ComboEdit)combo, importField);
        }
    }

    private HashMap<String, Boolean> getImportFieldHashMap(DynamicObject mainEntityTmplDyo) {
        HashMap importField = Maps.newHashMapWithExpectedSize((int)16);
        mainEntityTmplDyo.getDynamicObjectCollection("treeentryentity").stream().filter(dynamicObject -> dynamicObject.getBoolean("isimport")).forEach(dynamicObject -> importField.put(dynamicObject.getString("entitynumber"), dynamicObject.getBoolean("isimport")));
        return importField;
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit mainBaseData = (BasedataEdit)this.getView().getControl(FIELD_MAIN_ENTITY_TMPL);
        mainBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryBaseData = (BasedataEdit)this.getView().getControl(FIELD_ASSOC_ENTITY_TMPL);
        entryBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit entityUniqueNameText = (TextEdit)this.getView().getControl(ENTITY_UNIQUE_NAME);
        entityUniqueNameText.addClickListener((ClickListener)this);
        TextEdit relationLeftPropText = (TextEdit)this.getView().getControl(FIELD_RELATION_LEFT_PROP);
        relationLeftPropText.addClickListener((ClickListener)this);
        TextEdit relationRightPropText = (TextEdit)this.getView().getControl(FIELD_RELATION_RIGHT_PROP);
        relationRightPropText.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit source = (TextEdit)evt.getSource();
            String entryKey = source.getEntryKey();
            if (source.getView().getFormShowParameter().getStatus().name().equalsIgnoreCase("VIEW")) {
                return;
            }
            if (ENTRY_ENTITY.equals(entryKey)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                int rowNum = selectRows[0];
                String fieldKey = source.getKey();
                if (HRStringUtils.equals((String)ENTITY_UNIQUE_NAME, (String)fieldKey)) {
                    this.openSelectFieldF7(rowNum, source);
                } else if (HRStringUtils.equals((String)FIELD_RELATION_LEFT_PROP, (String)fieldKey)) {
                    DynamicObject dataEntity = source.getModel().getEntryRowEntity(ENTRY_ENTITY, rowNum);
                    if (Objects.isNull(dataEntity.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u5b9e\u4f53\u6a21\u677f\u3002", (String)"MultiEntityImpTmplEdit_0", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
                    } else {
                        DynamicObject dynamicObject = (DynamicObject)dataEntity.get(FIELD_ASSOC_ENTITY_OBJ);
                        String number = dynamicObject.getString("number");
                        String name = dynamicObject.getString("name");
                        this.showFieldForm(this.buildTreeNodesByEntityType(number, ""), number, name, "relationleftprop_" + rowNum);
                    }
                } else if (HRStringUtils.equals((String)FIELD_RELATION_RIGHT_PROP, (String)fieldKey)) {
                    if (Objects.isNull(this.getModel().getValue(FIELD_MAIN_ENTITY_TMPL))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5b9e\u4f53\u6a21\u677f\u3002", (String)"MultiEntityImpTmplEdit_6", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    this.showFieldForm(this.buildTreeNodes(rowNum), "", "", "relationrightprop_" + rowNum);
                }
            }
        }
    }

    private void openSelectFieldF7(int rowIndex, TextEdit textEditCol) {
        DynamicObject entity = (DynamicObject)this.getModel().getValue(FIELD_ASSOC_ENTITY_TMPL, rowIndex);
        if (null == entity) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u5b9e\u4f53\u6a21\u677f\u3002", (String)"MultiEntityImpTmplEdit_0", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString("bizobject.number");
        HashMap<String, Boolean> importField = this.getImportFieldHashMap(entity);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        List newItems = entityItems.stream().filter(item -> item instanceof Field && HRMultiEntityImptUtil.isValid((Field)((Field)item))).collect(Collectors.toList());
        TreeNode fieldTreeNode = new TreeNode("", entityType.getName(), entityType.getDisplayName().toString());
        fieldTreeNode.setIsOpened(true);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (!HRMultiEntityImptUtil.isPropertyImport(newItems, (IDataEntityProperty)prop) || !Objects.nonNull(importField.get(prop.getName())) || !importField.get(prop.getName()).booleanValue()) continue;
            fieldTreeNode.addChild(new TreeNode(entityType.getName(), prop.getName(), prop.getDisplayName().getLocaleValue()));
        }
        DynamicObject entryDy = textEditCol.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(UNIQUE_SELECT_FORM);
        String nodesJson = SerializationUtils.toJsonString((Object)fieldTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("rootNodeId", entityType.getName());
        showParameter.getCustomParams().put("selectfieldvalue", entryDy.getString(ENTITY_UNIQUE_VALUE));
        showParameter.getCustomParams().put("selectfieldname", entryDy.getString(ENTITY_UNIQUE_NAME));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "entityuniquename_" + rowIndex));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTITY_UNIQUE_VALUE});
        this.getView().setVisible(Boolean.valueOf("1".equals(this.getModel().getValue(FIELD_APPLY_SCOPE))), new String[]{FIELD_APPLY_USERS});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entryEntity.size() > 0) {
            entryEntity.forEach(entryDyn -> {
                entryDyn.set(RELATION_CONDITION, (Object)"=");
                DynamicObject entryBiz = entryDyn.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL);
                if (entryBiz == null) {
                    return;
                }
                StringBuilder uniqueFieldName = new StringBuilder();
                String uniqueFiledValue = entryDyn.getString(ENTITY_UNIQUE_VALUE);
                String entityNumber = entryBiz.getString("bizobject.number");
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                DataEntityPropertyCollection properties = entityType.getProperties();
                Arrays.stream(uniqueFiledValue.split(",")).filter(filter -> StringUtils.isNotBlank((CharSequence)filter) && properties.containsKey(filter)).forEach(field -> uniqueFieldName.append(((IDataEntityProperty)properties.get(field)).getDisplayName() == null ? ((IDataEntityProperty)properties.get(field)).getName() : ((IDataEntityProperty)properties.get(field)).getDisplayName().getLocaleValue()).append("\uff1b"));
                entryDyn.set(ENTITY_UNIQUE_NAME, (Object)uniqueFieldName.toString());
            });
            this.getModel().setDataChanged(false);
        }
        this.initTemplateType();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.contains(FIELD_RELATION_LEFT_PROP) || actionId.contains(FIELD_RELATION_RIGHT_PROP)) {
            String[] keys = actionId.split("_");
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int selectRowIndex = Integer.parseInt(keys[1]);
            DynamicObject dynObject = (DynamicObject)dynColl.get(selectRowIndex);
            dynObject.set(keys[0], closedCallBackEvent.getReturnData());
            this.getView().updateView(ENTRY_ENTITY);
        } else if (actionId.contains(ENTITY_UNIQUE_NAME)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int selectRowIndex = Integer.parseInt(actionId.split("_")[1]);
            DynamicObject dynObject = (DynamicObject)dynColl.get(selectRowIndex);
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                dynObject.set(ENTITY_UNIQUE_NAME, returnData.get("currNodeNames"));
                dynObject.set(ENTITY_UNIQUE_VALUE, returnData.get("currNodeIds"));
                this.getView().updateView(ENTRY_ENTITY);
            }
        } else if (actionId.contains(FIELD_ASSOC_ENTITY_TMPL)) {
            this.setCallbackAssocEntityTmplValue(closedCallBackEvent, actionId);
        }
    }

    private void setCallbackAssocEntityTmplValue(ClosedCallBackEvent closedCallBackEvent, String actionId) {
        String[] keys = actionId.split("_");
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            int selectRowIndex = Integer.parseInt(keys[1]);
            if (selectedRows.size() == 1) {
                this.getModel().setValue(FIELD_ASSOC_ENTITY_TMPL, selectedRows.get(0).getPrimaryKeyValue(), selectRowIndex);
            } else {
                Map<Object, String> pkIdNameMap = selectedRows.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getName));
                QFilter idFilter = new QFilter("id", "in", pkIdNameMap.keySet());
                Map<String, String> idMap = QueryServiceHelper.query((String)"bos_importtemplate", (String)"id,bizobject.id", (QFilter[])new QFilter[]{idFilter}).stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getString("bizobject.id")));
                HashMap bizObjectIdToTmpNameMap = Maps.newHashMapWithExpectedSize((int)pkIdNameMap.size());
                int loopIndex = selectRowIndex;
                for (Map.Entry<Object, String> entry : pkIdNameMap.entrySet()) {
                    String bizId = idMap.get(String.valueOf(entry.getKey()));
                    if (bizObjectIdToTmpNameMap.containsKey(bizId)) {
                        this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u4f53\u6a21\u677f[%1$s]\u9009\u62e9\u5931\u8d25\uff0c\u5df2\u7ecf\u9009\u62e9\u4e86\u6a21\u677f[%2$s]\u5173\u8054\u7684\u5b9e\u4f53\u76f8\u540c\u7684\u6a21\u677f\u6570\u636e[%3$s]", (String)"MultiEntityImpTmplEdit_7", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]), entry.getValue(), entry.getValue(), bizObjectIdToTmpNameMap.get(bizId)));
                        continue;
                    }
                    bizObjectIdToTmpNameMap.put(bizId, entry.getValue());
                    if (loopIndex != selectRowIndex) {
                        loopIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                    }
                    this.getModel().setValue(FIELD_ASSOC_ENTITY_TMPL, entry.getKey(), loopIndex);
                    if (loopIndex != selectRowIndex) continue;
                    ++loopIndex;
                }
            }
        }
    }

    private TreeNode buildTreeNodesByEntityType(String entityNumber, String parentId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode childNode = QueryEntityParseHelper.buildBillTreeNodes((QueryEntityTreeBuildParameter)parameter, (boolean)true, (String)"");
        childNode.setParentid(parentId);
        return childNode;
    }

    private TreeNode buildTreeNodes(int rowNumber) {
        DynamicObjectCollection assocentitytmplentry;
        TreeNode treeNode = new TreeNode("", "rootnode", ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u4f53", (String)"MultiEntityImpTmplEdit_3", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
        Object mainEntityTmplObj = this.getModel().getValue(FIELD_MAIN_ENTITY_TMPL);
        if (Objects.nonNull(mainEntityTmplObj)) {
            DynamicObject mainEntityTmplDyo = (DynamicObject)mainEntityTmplObj;
            String entityNumber = mainEntityTmplDyo.getString("bizobject.number");
            treeNode.addChild(this.buildTreeNodesByEntityType(entityNumber, "0"));
        }
        if ((assocentitytmplentry = this.getModel().getEntryEntity(ENTRY_ENTITY)).size() > 0) {
            assocentitytmplentry.remove(rowNumber);
            assocentitytmplentry.stream().filter(entityDynamicObject -> Objects.nonNull(entityDynamicObject.get(FIELD_ASSOC_ENTITY_OBJ))).forEach(entityDynamicObject -> treeNode.addChild(this.buildTreeNodesByEntityType(((DynamicObject)entityDynamicObject.get(FIELD_ASSOC_ENTITY_OBJ)).getString("number"), "0")));
        }
        return treeNode;
    }

    private void showFieldForm(TreeNode entityFieldTreeNode, String entityNumber, String entityAlias, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FIELD_SELECT_FORM);
        String nodesJson = SerializationUtils.toJsonString((Object)entityFieldTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entityalias", entityAlias);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("rowindex", 0);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_MAIN_ENTITY_TMPL)) {
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            if (entryEntity.size() > 0) {
                entryEntity.stream().filter(dynamicObject -> Objects.nonNull(dynamicObject.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL))).forEach(object -> idList.add(object.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL).getPkValue()));
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)idList));
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_ASSOC_ENTITY_TMPL)) {
            EntryGrid entryGrid;
            int[] selectRows;
            DynamicObject mainEntityTmplObj = (DynamicObject)this.getModel().getValue(FIELD_MAIN_ENTITY_TMPL);
            HashSet businessObjIds = Sets.newHashSetWithExpectedSize((int)16);
            if (Objects.nonNull(mainEntityTmplObj)) {
                businessObjIds.add(mainEntityTmplObj.get("bizobject.id"));
            }
            DynamicObjectCollection relTmpEntities = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject relTmp : relTmpEntities) {
                DynamicObject relTmpObj = relTmp.getDynamicObject(FIELD_ASSOC_ENTITY_TMPL);
                if (!Objects.nonNull(relTmpObj)) continue;
                businessObjIds.add(relTmpObj.get("bizobject.id"));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!businessObjIds.isEmpty()) {
                showParameter.getListFilterParameter().setFilter(new QFilter("bizobject.id", "not in", (Object)businessObjIds));
            }
            if ((selectRows = (entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows()) == null || selectRows.length == 0) {
                return;
            }
            int rowNum = selectRows[0];
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assocentitytmpl_" + rowNum));
        }
    }

    protected List<String> getUnCheckField() {
        ArrayList<String> uncheckFieldList = new ArrayList<String>();
        uncheckFieldList.add(RELATION_CONDITION);
        return uncheckFieldList;
    }

    private static class EntryEntityTreeBO {
        private Long id;
        private Long parentId;
        private boolean isImport;
        private int level;
        private List<EntryEntityTreeBO> children;

        public EntryEntityTreeBO(Long id, Long parentId, boolean isImport) {
            this.id = id;
            this.parentId = parentId;
            this.isImport = isImport;
        }

        public void addChildren(EntryEntityTreeBO child) {
            if (this.children == null) {
                this.children = new ArrayList<EntryEntityTreeBO>();
            }
            this.children.add(child);
        }
    }
}

