/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityCtrlImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(EntityCtrlImportPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        ArrayList<Long> entryIds = new ArrayList<Long>();
        billdatas.stream().forEach(it -> entryIds.addAll(it.getData().getJSONArray("entryentity").stream().filter(entryRow -> ((JSONObject)entryRow).getLong("id") != null).map(entryRow -> ((JSONObject)entryRow).getLong("id")).collect(Collectors.toList())));
        List<Long> existEntryIds = this.queryExistEntryIds(entryIds);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        String separator = ResManager.loadKDString((String)"\uff0c", (String)"EntityCtrlImportPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            JSONObject data = billData.getData();
            int startIndex = billData.getStartIndex();
            JSONArray coll = data.getJSONArray("entryentity");
            boolean collError = false;
            for (Object rowObj : coll) {
                JSONObject row = (JSONObject)rowObj;
                boolean errorFlag = false;
                ArrayList errorMsgList = Lists.newArrayListWithExpectedSize((int)10);
                errorMsgList.add(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a", (String)"EntityCtrlImportPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                if (HRStringUtils.isEmpty((String)row.getString("propkey"))) {
                    errorFlag = true;
                    errorMsgList.add(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"EntityCtrlImportPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                }
                if (ObjectUtils.isEmpty((Object)row.getJSONObject("dimension"))) {
                    errorFlag = true;
                    errorMsgList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"EntityCtrlImportPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                }
                if (HRStringUtils.isEmpty((String)row.getString("authrange"))) {
                    errorFlag = true;
                    errorMsgList.add(ResManager.loadKDString((String)"\u63a7\u6743\u8303\u56f4", (String)"EntityCtrlImportPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                }
                if (HRStringUtils.isEmpty((String)row.getString("ismust"))) {
                    errorFlag = true;
                    errorMsgList.add(ResManager.loadKDString((String)"\u662f\u5426\u5fc5\u9009", (String)"EntityCtrlImportPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                }
                if (errorFlag) {
                    logger.log(Integer.valueOf(startIndex), String.join((CharSequence)separator, errorMsgList));
                    logger.fail();
                    collError = true;
                }
                if (!existEntryIds.contains(row.getLong("id"))) {
                    row.remove((Object)"id");
                }
                ++startIndex;
            }
            if (!collError) continue;
            iterator.remove();
        }
    }

    private List<Long> queryExistEntryIds(List<Long> entryIds) {
        if (CollectionUtils.isEmpty(entryIds)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        String sql = "select fentryid from t_hrcs_entitydimentry where fentryid in(";
        String entryIdStr = entryIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
        List existEntryIds = (List)DB.query((DBRoute)DBRoute.of((String)"hmp"), (String)(sql + entryIdStr + ")"), (ResultSetHandler)new ResultSetHandler<Object>(){

            public List<Long> handle(ResultSet resultSet) throws Exception {
                ArrayList existEntryIds = Lists.newArrayListWithExpectedSize((int)10);
                while (resultSet.next()) {
                    existEntryIds.add(resultSet.getLong("fentryid"));
                }
                return existEntryIds;
            }
        });
        return existEntryIds;
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>(1);
        lockKeys.add("keyfields");
        return lockKeys;
    }

    public String getDefaultKeyFields() {
        return "entitytype";
    }

    public String getDefaultImportType() {
        return "overridenew";
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.valueOf(false), new String[]{"radiofield", "radiofield1"});
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage());
            }
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }
}

