/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import java.util.EventObject;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.formplugin.web.utils.HRPermChargeTreeSearchServiceHelper;
import kd.hr.hrcs.formplugin.web.utils.HRPermChargeTreeServiceHelper;

public class HRAppTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeQueryListener {
    private TreeView treeView;
    private HRPermChargeTreeServiceHelper treeHelper;

    public void initialize() {
        super.initialize();
        this.treeView = this.getTreeView();
        this.treeHelper = new HRPermChargeTreeServiceHelper(this.treeView);
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.treeHelper.reBuildWholeTree();
        this.getView().getPageCache().put("nodeId", "1010");
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.buildTreeBySearchText(searchText);
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() != null) {
            String nodeId = event.getNodeId().toString();
            this.treeHelper.handleExpandNodeClick(nodeId);
        }
    }

    private void buildTreeBySearchText(String searchText) {
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.treeHelper.reBuildWholeTree();
            this.getPageCache().put("lefttree_search_mode", "false");
        } else {
            HRPermChargeTreeSearchServiceHelper.reBuildTreeBySearchKey(this.treeView, searchText);
            this.getPageCache().put("lefttree_search_mode", "true");
        }
        this.getView().updateView("treeview");
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        this.getView().getPageCache().put("nodeId", nodeId);
    }
}

