/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.SetEntryBottom;
import kd.bos.form.operate.SetEntryTop;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.bussiness.util.QueryEntitiesUtil;
import kd.hr.hrcs.formplugin.web.utils.HRPermChargeTreeSearchServiceHelper;
import kd.hr.hrcs.formplugin.web.utils.HRPermChargeTreeServiceHelper;

public class PermChargeTreeListPlugin
extends HRDynamicFormBasePlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final String KEY_ENTRY_ENTITY = "bizentities";
    private static final String BAR_EXIT = "exit";
    private static final String BAR_SET_TOP = "btnsettop";
    private static final String BAR_SET_BOTTOM = "btnsetbottom";
    private static final String KEY_SEARCH_AP = "searchap";
    private static final String KEY_SEARCH_ENTITY = "searchentity";
    private static final String KEY_BIZ_ENTITY = "bizentity";
    private static final String KEY_APP_ID = "appid";
    private TreeView treeView;
    private HRPermChargeTreeServiceHelper treeHelper;
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entitytreecfg");

    public void initialize() {
        super.initialize();
        this.treeView = this.getTreeView();
        this.treeHelper = new HRPermChargeTreeServiceHelper(this.treeView);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar control = (Toolbar)this.getView().getControl("toolbarap");
        control.addItemClickListener((ItemClickListener)this);
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.treeHelper.reBuildWholeTree();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
        Set<String> entityIds = this.queryEntity();
        this.getPageCache().put("entityIds", SerializationUtils.toJsonString(entityIds));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals(BAR_SET_TOP)) {
            this.setTop();
        } else if (itemKey.equals(BAR_SET_BOTTOM)) {
            this.setBottom();
        } else if (itemKey.equals(BAR_EXIT)) {
            String entityNumbers = this.getPageCache().get("entityNumbers");
            DynamicObjectCollection entities = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
            String entityNumbersNow = entities.stream().map(dy -> dy.getString("bizentity.number")).collect(Collectors.toList()).toString();
            if (entityNumbers != null && !entityNumbers.equals(entityNumbersNow)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4fee\u6539\u672a\u4fdd\u5b58\uff0c\u786e\u5b9a\u8981\u9000\u51fa\u5417\uff1f", (String)"PermChargeTreeListPlugin_01", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitCallBack"));
            } else {
                this.getView().close();
            }
        } else if (itemKey.equals("save")) {
            String focusNodeId = this.getTreeView().getTreeState().getFocusNodeId();
            if (focusNodeId == null || focusNodeId.equals("1010") || !focusNodeId.split("_split_")[0].equals("2")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u8282\u70b9\u3002", (String)"PermChargeTreeListPlugin_03", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObjectCollection dys = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
            String app = focusNodeId.split("_split_")[1];
            DynamicObject[] cfgs = this.queryEntitiesFormCFG(app);
            for (DynamicObject dy2 : dys) {
                for (DynamicObject cfg : cfgs) {
                    if (dy2.getLong("id") != cfg.getLong("id")) continue;
                    cfg.set("index", (Object)dy2.getInt("seq"));
                    cfg.set("modifier", (Object)currUserId);
                }
            }
            this.serviceHelper.updateDatas(cfgs);
            this.getPageCache().remove("entityNumbers");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"PermChargeTreeListPlugin_02", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else if (itemKey.equals("refresh")) {
            String nodeId = this.getTreeView().getTreeState().getFocusNodeId();
            String nodeIdPrefix = nodeId.split("_split_")[0];
            if (HRStringUtils.equals((String)"2", (String)nodeIdPrefix)) {
                Object[] objs;
                String appId = nodeId.split("_split_")[1];
                DynamicObject[] entitiesFromCFG = this.queryEntitiesFormCFG(appId);
                QueryEntitiesUtil queryEntitiesUtil = new QueryEntitiesUtil();
                DynamicObject[] entitiesFromObj = queryEntitiesUtil.getAllowedEntities(appId);
                if (entitiesFromCFG.length == 0) {
                    ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(entitiesFromObj.length);
                    int index = 1;
                    for (DynamicObject dy3 : entitiesFromObj) {
                        DynamicObject tmp = this.serviceHelper.generateEmptyDynamicObject();
                        tmp.set(KEY_APP_ID, (Object)appId);
                        tmp.set("number", (Object)dy3.getString("number"));
                        tmp.set("index", (Object)index++);
                        dynamicObjects.add(tmp);
                    }
                    DynamicObject[] dys = new DynamicObject[dynamicObjects.size()];
                    dys = dynamicObjects.toArray(dys);
                    this.serviceHelper.save(dys);
                    this.createEntries(appId);
                    return;
                }
                Object[] cfgs = (String[])Arrays.stream(entitiesFromCFG).map(dy -> dy.getString("number")).sorted().toArray(String[]::new);
                boolean equals = Arrays.equals(cfgs, objs = (String[])Arrays.stream(entitiesFromObj).map(dy -> dy.getString("number")).sorted().toArray(String[]::new));
                if (!equals) {
                    Map permRelateConfig;
                    Set entitiesFromCFGSet = Arrays.stream(cfgs).collect(Collectors.toSet());
                    Set entitiesFromObjSet = Arrays.stream(objs).collect(Collectors.toSet());
                    HashSet entitiesFromCFGSetCopy = new HashSet(entitiesFromCFGSet);
                    HashSet<String> toDelRows = new HashSet<String>(16);
                    for (String number : entitiesFromCFGSetCopy) {
                        if (entitiesFromObjSet.contains(number)) continue;
                        entitiesFromCFGSet.remove(number);
                        toDelRows.add(number);
                    }
                    this.serviceHelper.deleteByFilter(new QFilter[]{new QFilter("number", "in", toDelRows)});
                    DynamicObject last = this.serviceHelper.queryOne("index", new QFilter[]{new QFilter(KEY_APP_ID, "=", (Object)appId)}, "index desc");
                    int index = last.getInt("index");
                    long currUserId = RequestContext.get().getCurrUserId();
                    String allPermConfigStr = this.getPageCache().get("allPermConfig");
                    if (HRStringUtils.isEmpty((String)allPermConfigStr)) {
                        permRelateConfig = PermRelateServiceHelper.queryAllPermRelateConfig();
                        this.getPageCache().put("allPermConfig", SerializationUtils.toJsonString((Object)permRelateConfig));
                    } else {
                        permRelateConfig = (Map)SerializationUtils.fromJsonString((String)allPermConfigStr, Map.class);
                    }
                    for (String number : entitiesFromObjSet) {
                        if (entitiesFromCFGSet.contains(number) || !PermRelateServiceHelper.hasAssignablePerm((String)number, (String)appId, (Set)Sets.newHashSet((Iterable)permRelateConfig.getOrDefault(appId, Sets.newHashSetWithExpectedSize((int)0))), new HashSet(0))) continue;
                        DynamicObject dy4 = this.serviceHelper.generateEmptyDynamicObject();
                        dy4.set("number", (Object)number);
                        dy4.set(KEY_APP_ID, (Object)appId);
                        dy4.set("index", (Object)index++);
                        dy4.set("creator", (Object)currUserId);
                        dy4.set("modifier", (Object)currUserId);
                        this.serviceHelper.saveOne(dy4);
                    }
                    this.createEntries(appId);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u8282\u70b9\u3002", (String)"PermChargeTreeListPlugin_03", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (HRStringUtils.equals((String)"exitCallBack", (String)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        String key = source.getKey();
        String searchText = evt.getText();
        if (HRStringUtils.equals((String)key, (String)KEY_SEARCH_AP)) {
            this.buildTreeBySearchText(searchText);
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String nodeId = (String)treeNodeEvent.getNodeId();
        String nodeIdPrefix = nodeId.split("_split_")[0];
        if (HRStringUtils.equals((String)"2", (String)nodeIdPrefix)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
            String appId = nodeId.split("_split_")[1];
            this.createEntries(appId);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
            this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() != null) {
            String nodeId = event.getNodeId().toString();
            this.treeHelper.handleExpandNodeClick(nodeId);
        }
    }

    private void buildTreeBySearchText(String searchText) {
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.treeHelper.reBuildWholeTree();
            this.getPageCache().put("lefttree_search_mode", "false");
        } else {
            HRPermChargeTreeSearchServiceHelper.reBuildTreeBySearchKey(this.treeView, searchText);
            this.getPageCache().put("lefttree_search_mode", "true");
        }
        this.getView().updateView("treeview");
    }

    private void createEntries(String appId) {
        Set entityIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("entityIds"), Set.class);
        DynamicObject[] entitiesFromCFG = this.queryEntitiesFormCFG(appId);
        List dys = Arrays.stream(entitiesFromCFG).collect(Collectors.toList());
        this.getModel().beginInit();
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        HashSet<String> numbers = new HashSet<String>(dys.size());
        ArrayList<String> entityNumbers = new ArrayList<String>(dys.size());
        int index = 0;
        for (DynamicObject dy : dys) {
            String number = dy.getString("number");
            if (numbers.contains(number) || !entityIds.contains(number)) continue;
            this.getModel().createNewEntryRow(KEY_ENTRY_ENTITY);
            this.getModel().setValue(KEY_BIZ_ENTITY, (Object)number, index);
            this.getModel().setValue("id", dy.get("id"), index++);
            numbers.add(number);
            entityNumbers.add(number);
        }
        this.getPageCache().put("entityNumbers", ((Object)entityNumbers).toString());
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private Set<String> queryEntity() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] formDesigns = serviceHelper.query("id,number", new QFilter[0]);
        return Arrays.stream(formDesigns).map(it -> it.getString("id")).collect(Collectors.toSet());
    }

    private DynamicObject[] queryEntitiesFormCFG(String appId) {
        QFilter qFilter = new QFilter(KEY_APP_ID, "=", (Object)appId);
        return this.serviceHelper.query("id,appid,number,index,modifier", new QFilter[]{qFilter}, "index asc");
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }

    private void setTop() {
        SetEntryTop setEntryTop = new SetEntryTop(KEY_ENTRY_ENTITY, this.getView());
        setEntryTop.invokeOperation();
    }

    private void setBottom() {
        SetEntryBottom setEntryBottom = new SetEntryBottom(KEY_ENTRY_ENTITY, this.getView());
        setEntryBottom.invokeOperation();
    }
}

