/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dimension.PermRtSyncService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.dimension.SyncEdit;

@ExcludeFromJacocoGeneratedReport
public class PermRelateSyncSelEdit
extends SyncEdit {
    private static final String PREKEY = "hrcs_syncrolesel";
    private int count = 0;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        Button cancel = (Button)this.getControl("btncancel");
        cancel.addItemClickListener((ItemClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectedRows = entry.getEntryState().getSelectedRows();
            if (selectedRows.length == 0) {
                String tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u6570\u636e\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"PermRelateSyncSelEdit_01", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(tip);
                return;
            }
            this.startJob(selectedRows, entry);
        }
    }

    protected void startJob(int[] selectedRows, EntryGrid entry) {
        JobInfo jobInfo = new JobInfo();
        Object roleInfo = this.getView().getFormShowParameter().getCustomParam("roleInfo");
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        LinkedHashMap resultRolePermMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)((String)roleInfo), Map.class);
        LinkedHashMap resultRolePermMapCp = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObject[] data = entry.getEntryData().getDataEntitys();
        if (selectedRows.length == data.length) {
            params.put("roleInfo", roleInfo);
            params.put("roleCount", resultRolePermMap.keySet().size());
            params.put("permCount", selectedRows.length);
        } else {
            HashSet roleSet = Sets.newHashSetWithExpectedSize((int)data.length);
            HashSet reRoleSet = Sets.newHashSetWithExpectedSize((int)data.length);
            HashSet permSet = Sets.newHashSetWithExpectedSize((int)data.length);
            for (int index : selectedRows) {
                DynamicObject row = data[index];
                DynamicObject permitem = row.getDynamicObject("permitem");
                String number = permitem.getString("number");
                permSet.add(number);
                String role = row.getString("role");
                String[] split = role.split(",");
                roleSet.addAll(Arrays.stream(split).collect(Collectors.toSet()));
            }
            Object object = resultRolePermMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entryMap = (Map.Entry)object.next();
                List value = (List)entryMap.getValue();
                List ntVale = value.stream().filter(it -> {
                    String permId = (String)it.get("permId");
                    return !permSet.contains(permId);
                }).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(ntVale)) {
                    List ntVale2 = (List)resultRolePermMapCp.get(entryMap.getKey());
                    if (CollectionUtils.isEmpty((Collection)ntVale2)) {
                        resultRolePermMapCp.put(entryMap.getKey(), ntVale);
                    } else {
                        ntVale2.addAll(ntVale);
                    }
                }
                value.removeIf(it -> {
                    String permId = (String)it.get("permId");
                    return !permSet.contains(permId);
                });
                if (value.size() != 0) continue;
                reRoleSet.add(entryMap.getKey());
            }
            reRoleSet.forEach(resultRolePermMap::remove);
            params.put("roleInfo", SerializationUtils.toJsonString((Object)resultRolePermMap));
            params.put("roleCount", roleSet.size());
            params.put("permCount", selectedRows.length);
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "permSyncTask");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobInfo.setAppId("hrcs");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        jobFormInfo.setCanStop(false);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname("kd.hr.hrcs.bussiness.service.perm.dimension.HRRelatePermTask");
        String sycRoleName = ResManager.loadKDString((String)"\u540c\u6b65\u89d2\u8272\u5173\u8054\u6743\u9650\u9879", (String)"PermRelateSyncEdit_04", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        jobInfo.setName(sycRoleName);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (actionId.equals("syncRoleBtn")) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"permSyncTask")) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            if (result == null) {
                return;
            }
            MultiLangEnumBridge opTName = new MultiLangEnumBridge("\u540c\u6b65\u89d2\u8272", "PermRelateSyncEdit_02", "hrmp-hrcs-formplugin");
            MultiLangEnumBridge sycOpt = new MultiLangEnumBridge("\u540c\u6b65\u89d2\u8272\u64cd\u4f5c\u6267\u884c\u6210\u529f\u3002", "PermRelateSyncEdit_03", "hrmp-hrcs-formplugin");
            PermRtSyncService.writeOpLog((boolean)true, (String)this.getView().getFormShowParameter().getAppId(), (String)"hrcs_permrelat", (MultiLangEnumBridge)opTName, (MultiLangEnumBridge)sycOpt, null, (String)closedCallBackEvent.getActionId());
            String taskInfoStr = (String)result.get("taskinfo");
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            Map taskInfoMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            String roleCount = (String)taskInfoMap.get("roleCount");
            String permCount = (String)taskInfoMap.get("permCount");
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("syncRoleBtn", (IFormPlugin)this);
            String confirmTip = String.format(ResManager.loadKDString((String)"\u89d2\u8272\u540c\u6b65\u6210\u529f\u3002\u5df2\u540c\u6b65%1$s\u4e2a\u5173\u8054\u6743\u9650\u9879\uff0c\u66f4\u65b0%2$s\u4e2a\u89d2\u8272\u3002", (String)"PermRelateSyncEdit_01", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), permCount, roleCount);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    public void afterCreateNewData(EventObject e) {
        LinkedHashMap<String, List<String>> entryMap = new LinkedHashMap<String, List<String>>(16);
        ArrayList roleIdList = Lists.newArrayListWithExpectedSize((int)16);
        this.initRolePermInfo(entryMap, roleIdList);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map roleMap = PermRelateServiceHelper.getRoleInfo((List)roleIdList);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("app", new Object[0]);
        vs.addField("busyobj", new Object[0]);
        vs.addField("permitem", new Object[0]);
        vs.addField("role", new Object[0]);
        for (Map.Entry<String, List<String>> entryRe : entryMap.entrySet()) {
            String[] key = entryRe.getKey().split("\\|");
            List<String> roles = entryRe.getValue();
            String role = this.getRoleName(roles, roleMap);
            vs.addRow(new Object[]{key[0], key[1], key[2], role});
            ++this.count;
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        entry.selectRows(this.getIntArray(this.count), 0);
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }
}

