/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dyna;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.formplugin.common.HrcsFormpluginRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaCondListPlugin
extends HRDataBaseList {
    private static final String V_APPLYSCOPE_GENERAL = "1";
    private static final String V_APPLYSCOPE_ASSIGN = "2";
    private static final String V_APPLYTYPE_ORGTEAM = "orgteam";
    private static final String V_APPLYTYPE_BASEDATA = "basedata";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "do_showapplydimension": {
                if (this.isSelectMult(listSelectedData)) {
                    args.setCancel(true);
                    return;
                }
                HRBaseServiceHelper service = new HRBaseServiceHelper("hrcs_dynacond");
                DynamicObject entitytypeDyn = service.queryOne("applyscope, applytype, applybdtype, applyteamcls", listSelectedData.get(0).getPrimaryKeyValue());
                this.showApplyDimensionPage(entitytypeDyn);
                break;
            }
        }
    }

    private boolean isSelectMult(ListSelectedRowCollection listSelectedData) {
        if (listSelectedData.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)HrcsFormpluginRes.DynaCondListPlugin_0.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void showApplyDimensionPage(DynamicObject entitytypeDyn) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hrcs_showapplydim");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setHasRight(true);
        showParameter.setLookUp(false);
        if (ObjectUtils.isEmpty((Object)entitytypeDyn)) {
            return;
        }
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        String applyScope = entitytypeDyn.getString("applyscope");
        if (!V_APPLYSCOPE_GENERAL.equals(applyScope)) {
            String applyType = entitytypeDyn.getString("applytype");
            if (V_APPLYTYPE_BASEDATA.equals(applyType)) {
                qFilters.add(HRQFilterHelper.buildEql((String)"datasource", (Object)V_APPLYTYPE_BASEDATA));
                DynamicObjectCollection applyBdTypes = entitytypeDyn.getDynamicObjectCollection("applybdtype");
                if (CollectionUtils.isNotEmpty((Collection)applyBdTypes)) {
                    Set baseDataIds = applyBdTypes.stream().map(item -> item.get("fbasedataid_id")).collect(Collectors.toSet());
                    qFilters.add(HRQFilterHelper.buildIn((String)"entitytype", baseDataIds));
                }
            } else if (V_APPLYTYPE_ORGTEAM.equals(applyType)) {
                qFilters.add(HRQFilterHelper.buildEql((String)"datasource", (Object)V_APPLYTYPE_ORGTEAM));
                DynamicObjectCollection applyTeamClss = entitytypeDyn.getDynamicObjectCollection("applyteamcls");
                if (CollectionUtils.isNotEmpty((Collection)applyTeamClss)) {
                    Set orgTeamTypes = applyTeamClss.stream().filter(item -> "1010".equals(item.get("fbasedataid_id"))).map(item -> item.get("fbasedataid_id")).collect(Collectors.toSet());
                    Set nonOrgTeamTypes = applyTeamClss.stream().filter(item -> !"1010".equals(item.get("fbasedataid_id"))).map(item -> item.get("fbasedataid_id")).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(orgTeamTypes)) {
                        qFilters.add(HRQFilterHelper.buildEql((String)"entitytype", (Object)"haos_adminorghr"));
                    } else if (CollectionUtils.isNotEmpty(nonOrgTeamTypes)) {
                        qFilters.add(HRQFilterHelper.buildIn((String)"teamtype", nonOrgTeamTypes));
                    }
                }
            }
            showParameter.setListFilterParameter(new ListFilterParameter((List)qFilters, null));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("enable desc, number, createtime desc");
    }
}

