/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dyna;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.formula.FormulaSettingEdit;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.DynaDataSourceServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRDynaPermConst;

@ExcludeFromJacocoGeneratedReport
public class DynaFormulaEditPlugin
extends FormulaSettingEdit
implements HRDynaPermConst {
    private static final Log LOGGER = LogFactory.getLog(DynaFormulaEditPlugin.class);

    protected Optional<List<TreeNodeItem>> getTreeNodeItemList() {
        try {
            String newCancel = (String)this.getView().getFormShowParameter().getCustomParam("newCancel");
            if (HRStringUtils.equals((String)"1", (String)newCancel)) {
                ArrayList publishEvenSourceList = DynaDataSourceServiceHelper.getAllSubMsgPublishEventDataSource();
                List nodes = DynaDataSourceServiceHelper.getTreeNodeItemList((ArrayList)publishEvenSourceList, (boolean)false);
                LOGGER.info("getTreeNodeItemList cacel={}", (Object)nodes);
                return Optional.of(nodes);
            }
            Object publishEventId = this.getView().getFormShowParameter().getCustomParam("msgpublisher");
            ArrayList publishEvenSourceList = DynaDataSourceServiceHelper.getPublishEvenSourceList((Long)((Long)publishEventId));
            boolean hasBusinessEntity = false;
            for (DynamicObject dynamicObject : publishEvenSourceList) {
                String sourceType = dynamicObject.getString("sourceclassify");
                if (!HRStringUtils.equals((String)sourceType, (String)"1")) continue;
                hasBusinessEntity = true;
            }
            List nodes = DynaDataSourceServiceHelper.getTreeNodeItemList((ArrayList)publishEvenSourceList, (boolean)hasBusinessEntity);
            LOGGER.info("getTreeNodeItemList={}", (Object)nodes);
            return Optional.of(nodes);
        }
        catch (Exception exception) {
            LOGGER.error("getTreeNodeItemList error", (Throwable)exception);
            return Optional.empty();
        }
    }

    protected Optional<List<ResultItem>> getResultItemList() {
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)16);
        Long ruleParamId = (Long)this.getView().getFormShowParameter().getCustomParam("ruleParamId");
        String nodeId = "id" + ruleParamId.toString();
        DynamicObject dynamicObject = DynaDataSourceServiceHelper.queryOne((Long)ruleParamId);
        String ruleParamDataType = dynamicObject.getString("datatype");
        ResultItem resultItem = new ResultItem();
        resultItem.setId(nodeId);
        resultItem.setItemCategory("formulaResultItemCategory");
        resultItem.setName(ResManager.loadKDString((String)"%s", (String)"DynaFormulaEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{dynamicObject.getLocaleString("name").getLocaleValue()}));
        resultItem.setUniqueCode(nodeId);
        nodes.add(resultItem);
        if (HRStringUtils.equals((String)"bd", (String)ruleParamDataType) || HRStringUtils.equals((String)"org", (String)ruleParamDataType)) {
            resultItem.setDataType(DataTypeEnum.BASE);
        } else if (HRStringUtils.equals((String)"enum", (String)ruleParamDataType)) {
            resultItem.setDataType(DataTypeEnum.TEXT);
        } else if (HRStringUtils.equals((String)"boolean", (String)ruleParamDataType)) {
            resultItem.setDataType(DataTypeEnum.BOOLEAN);
        }
        return Optional.of(nodes);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String pageId = this.getView().getPageId();
        String newCancel = (String)this.getView().getFormShowParameter().getCustomParam("newCancel");
        if (HRStringUtils.equals((String)"1", (String)newCancel)) {
            this.getView().getParentView().getPageCache().put("formulaPageId_cancel", pageId);
        } else {
            this.getView().getParentView().getPageCache().put("formulaPageId", pageId);
        }
        this.setModelVal("createorg", DynaDataSourceServiceHelper.getOrgRootId());
        this.setModelVal("ctrlstrategy", "5");
        this.setModelVal("bsed", new Date());
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long ruleParamId = (Long)this.getView().getFormShowParameter().getCustomParam("ruleParamId");
        this.getModel().setValue("resultitem", (Object)("id" + ruleParamId.toString()));
        this.getModel().setValue("name", this.getModelVal("number"));
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue != null && pkValue != 0L) {
            this.getView().invokeOperation("insertdata_his");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ((HRStringUtils.equals((String)"save", (String)operateKey) || HRStringUtils.equals((String)"confirmchangenoaudit", (String)operateKey)) && (this.refreshCacheAndCheckFormulaIsEmpty() || !this.checkAndParseExpBeforeSave())) {
            args.setCancel(true);
        }
    }

    protected void showErrorMsg(String errorMsg) {
        super.showErrorMsg(errorMsg);
        this.getView().getParentView().getPageCache().put("formulaErrorMsg", errorMsg);
    }
}

