/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dyna;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.bussiness.service.perm.hradmin.HRAdminGroupService;

@ExcludeFromJacocoGeneratedReport
public class SetOpenRangePlugin
extends HRDynamicFormBasePlugin
implements TreeNodeCheckListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(SetOpenRangePlugin.class);
    private static final String TREE_ADMIN_GROUP = "treeview";
    private static final String BTN_SEARCH = "searchap";
    private static final String FIELD_ADMIN_GROUP = "admingroup";
    private static final String FIELD_INCLUDE_SUB = "includesub";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(BTN_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView treeview = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        treeview.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        TreeNode root = null;
        try {
            List<Long> toCheckNodeIds = this.fillAssignAdminRange();
            this.getPageCache().put("toCheckNodeIds", SerializationUtils.toJsonString(toCheckNodeIds));
            TreeView treeView = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            root = HRAdminGroupService.initAdminGroupTreeForScheme((TreeView)treeView, (IPageCache)this.getView().getPageCache());
            treeView.focusNode(root);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            logger.error((Throwable)ex);
        }
    }

    private List<Long> fillAssignAdminRange() {
        long authSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("authSchemeId");
        HRBaseServiceHelper adminRangeHelper = new HRBaseServiceHelper("hrcs_dynaschemerange");
        DynamicObject[] adminRangeArr = adminRangeHelper.queryOriginalArray("admingroup.id,includesub", new QFilter[]{new QFilter("scheme", "=", (Object)authSchemeId)});
        ArrayList toCheckNodeIds = Lists.newArrayListWithExpectedSize((int)adminRangeArr.length);
        if (adminRangeArr.length <= 0) {
            return toCheckNodeIds;
        }
        TableValueSetter setter = new TableValueSetter(new String[]{FIELD_ADMIN_GROUP, FIELD_INCLUDE_SUB});
        for (DynamicObject adminRange : adminRangeArr) {
            long adminGroupId = adminRange.getLong("admingroup.id");
            setter.addRow(new Object[]{adminGroupId, adminRange.getBoolean(FIELD_INCLUDE_SUB)});
            toCheckNodeIds.add(adminGroupId);
        }
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", setter);
        this.getModel().endInit();
        return toCheckNodeIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasRight;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) && !(hasRight = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"15NPDX/GJFOO", (String)"hrcs_dynascheme", (String)"3WETX3ZXS3EC"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u52a8\u6001\u6388\u6743\u65b9\u6848\u201d\u7684\u201c\u8bbe\u7f6e\u7ba1\u7406\u5458\u8303\u56f4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SetOpenRangePlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if (HRStringUtils.equals((String)"donothing", (String)operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject adminGroup = (DynamicObject)this.getModel().getValue(FIELD_ADMIN_GROUP, index);
            String adminGroupId = adminGroup.getString("id");
            TreeView treeView = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            treeView.uncheckNode(adminGroupId);
            this.getModel().deleteEntryRow("entryentity", index);
        } else if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            long authSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("authSchemeId");
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            HRBaseServiceHelper adminRangeHelper = new HRBaseServiceHelper("hrcs_dynaschemerange");
            ArrayList toSaveRange = Lists.newArrayListWithExpectedSize((int)collection.size());
            for (DynamicObject row : collection) {
                DynamicObject dynamicObject = adminRangeHelper.generateEmptyDynamicObject();
                dynamicObject.set("scheme", (Object)authSchemeId);
                dynamicObject.set(FIELD_ADMIN_GROUP, (Object)row.getLong("admingroup.id"));
                dynamicObject.set(FIELD_INCLUDE_SUB, (Object)row.getBoolean(FIELD_INCLUDE_SUB));
                toSaveRange.add(dynamicObject);
            }
            adminRangeHelper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)authSchemeId)});
            adminRangeHelper.save(toSaveRange.toArray(new DynamicObject[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8bbe\u7f6e\u7ba1\u7406\u5458\u8303\u56f4", "SetOpenRangePlugin_1", "hrmp-hrcs-formplugin");
            MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u5206\u914d\u6388\u6743\u65b9\u6848\u7ba1\u7406\u5458\u8303\u56f4\u6210\u529f", "SetOpenRangePlugin_2", "hrmp-hrcs-formplugin");
            ESignDBServiceUtil.writeOpLog((String)"hrcs_dynaschemerange", (String)"15NPDX/GJFOO", (String)"SetOpenRange", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)descBridge, (String[])new String[0]);
        }
    }

    public void search(SearchEnterEvent see) {
        IPageCache pageCache = this.getView().getPageCache();
        TreeView tv = (TreeView)this.getView().getControl(TREE_ADMIN_GROUP);
        String searchText = see.getText();
        if (StringUtils.isNotEmpty((String)searchText)) {
            String lastSearchText = pageCache.get("lastSearchText");
            if (searchText.equals(lastSearchText)) {
                String searchResultStr = pageCache.get("searchResult");
                if (StringUtils.isNotEmpty((String)searchResultStr)) {
                    List searchResult = SerializationUtils.fromJsonStringToList((String)searchResultStr, String[].class);
                    int searchIndex = Integer.parseInt(pageCache.get("searchIndex"));
                    if (searchIndex == searchResult.size()) {
                        searchIndex = 0;
                    }
                    String[] searchInfo = (String[])searchResult.get(searchIndex);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId(searchInfo[1]);
                    treeNode.setParentid(searchInfo[2]);
                    pageCache.put("searchIndex", searchIndex + 1 + "");
                    tv.focusNode(treeNode);
                    tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u67e5\u8be2\u7ed3\u679c\u3002", (String)"AdminGroupTreeListPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
            } else {
                List treeNodeInfos = SerializationUtils.fromJsonStringToList((String)pageCache.get("treeNodeInfos"), String[].class);
                ArrayList<String[]> searchResult = new ArrayList<String[]>(treeNodeInfos.size());
                for (String[] treeNodeInfo : treeNodeInfos) {
                    if (!treeNodeInfo[0].contains(searchText)) continue;
                    searchResult.add(treeNodeInfo);
                }
                if (CollectionUtils.isEmpty(searchResult)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u67e5\u8be2\u7ed3\u679c\u3002", (String)"AdminGroupTreeListPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                } else {
                    pageCache.put("searchResult", SerializationUtils.toJsonString(searchResult));
                    pageCache.put("lastSearchText", searchText);
                    String[] searchInfo = (String[])searchResult.get(0);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId(searchInfo[1]);
                    treeNode.setParentid(searchInfo[2]);
                    pageCache.put("searchIndex", "1");
                    tv.focusNode(treeNode);
                    tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                }
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        IDataModel model = this.getView().getModel();
        boolean checked = evt.getChecked();
        long adminGroupId = Long.parseLong((String)evt.getNodeId());
        int entryRowCount = model.getEntryRowCount("entryentity");
        if (checked) {
            model.insertEntryRow("entryentity", entryRowCount);
            model.setValue(FIELD_ADMIN_GROUP, (Object)adminGroupId, entryRowCount);
        } else {
            DynamicObjectCollection collection = model.getEntryEntity("entryentity");
            Optional<DynamicObject> toDeleteRow = collection.stream().filter(it -> it.getLong("admingroup.id") == adminGroupId).findFirst();
            toDeleteRow.ifPresent(dynamicObject -> model.deleteEntryRow("entryentity", dynamicObject.getInt("seq") - 1));
        }
    }
}

