/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.hradmin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.service.perm.hradmin.HRAdminGroupService;

public class ChooseTargetAdminGroupPlugin
extends HRDynamicFormBasePlugin
implements TreeNodeCheckListener {
    private static final Log logger = LogFactory.getLog(ChooseTargetAdminGroupPlugin.class);
    private static final String TREE_ADMIN_GROUP = "treeview";
    private static final String FIELD_ADMIN_GROUP = "admingroup";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeview = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        treeview.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        this.getPageCache().put("toCheckNodeIds", SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)0)));
        String adminGroupLongNumber = (String)this.getView().getFormShowParameter().getCustomParam("adminGroupLongNumber");
        String adminGroupId = (String)this.getView().getFormShowParameter().getCustomParam("adminGroupId");
        String adminGroupName = (String)this.getView().getFormShowParameter().getCustomParam("adminGroupName");
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("justSub", "1");
        pageCache.put("adminGroupLongNumber", adminGroupLongNumber);
        pageCache.put("adminGroupId", adminGroupId);
        pageCache.put("adminGroupName", adminGroupName);
        this.rebuildTree();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if (HRStringUtils.equals((String)"donothing", (String)operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject adminGroup = (DynamicObject)this.getModel().getValue(FIELD_ADMIN_GROUP, index);
            String adminGroupId = adminGroup.getString("id");
            TreeView treeView = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            treeView.uncheckNode(adminGroupId);
            this.getModel().deleteEntryRow("entryentity", index);
        } else if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            TreeView treeView = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            List toCheckNodeIds = treeView.getTreeState().getCheckedNodeIds().stream().map(Long::parseLong).collect(Collectors.toList());
            this.getView().returnDataToParent(toCheckNodeIds);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        boolean checked = evt.getChecked();
        String curNodeIdStr = (String)evt.getNodeId();
        Long curNodeId = Long.parseLong(curNodeIdStr);
        boolean containSub = (Boolean)this.getModel().getValue("containsub");
        List toCheckNodeIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("toCheckNodeIds"), List.class);
        Map childNodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("childNodeMap"), Map.class);
        if (checked) {
            String parentNodeIdStr;
            toCheckNodeIds.add(curNodeId);
            String adminGroupId = (String)this.getView().getFormShowParameter().getCustomParam("adminGroupId");
            Map parentNodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("parentNodeMap"), Map.class);
            Long parentNodeId = (Long)parentNodeMap.get(curNodeIdStr);
            while (parentNodeId != null && !HRStringUtils.equals((String)adminGroupId, (String)(parentNodeIdStr = String.valueOf(parentNodeId)))) {
                toCheckNodeIds.add(parentNodeId);
                parentNodeId = (Long)parentNodeMap.get(parentNodeIdStr);
            }
            if (containSub && childNodeMap.containsKey(curNodeIdStr)) {
                toCheckNodeIds.addAll((Collection)childNodeMap.get(curNodeIdStr));
            }
        } else if (childNodeMap.containsKey(curNodeIdStr)) {
            List curNodeChildren = (List)childNodeMap.get(curNodeIdStr);
            boolean present = curNodeChildren.stream().anyMatch(toCheckNodeIds::contains);
            if (present) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u4e0b\u7ea7\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"ChooseTargetAdminGroupPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                toCheckNodeIds.remove(curNodeId);
            }
        } else {
            toCheckNodeIds.remove(curNodeId);
        }
        this.getPageCache().put("curNodeId", curNodeIdStr);
        this.getPageCache().put("toCheckNodeIds", SerializationUtils.toJsonString((Object)Sets.newHashSet((Iterable)toCheckNodeIds)));
        this.rebuildTree();
    }

    private void rebuildTree() {
        TreeNode root = null;
        try {
            TreeView treeView = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            root = HRAdminGroupService.initAdminGroupTreeForScheme((TreeView)treeView, (IPageCache)this.getPageCache());
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            logger.error((Throwable)ex);
        }
    }
}

