/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class DynaDimPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(DynaDimPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map customParams = ((FormShowParameter)args.getSource()).getCustomParams();
        String recordId = (String)customParams.get("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            return;
        }
        EntryAp entryAp = this.createEntryAp(recordId);
        HashMap<String, String> mapEntry = new HashMap<String, String>(2);
        mapEntry.put("id", "userdimentrymodel");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            super.getEntityType(args);
        } else {
            MainEntityType oldMainType = args.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOGGER.error(cloneNotSupportedException.getMessage());
            }
            this.registerEntityType(newMainType, recordId);
            args.setNewEntityType(newMainType);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isNotEmpty((String)recordId)) {
            EntryAp entryAp = this.createEntryAp(recordId);
            IFormView formView = this.getView();
            EntryGrid entryGrid = (EntryGrid)formView.getControl("userdimentrymodel");
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            entryGrid.getItems().addAll(fieldEdits);
            this.getView().createControlIndex(entryGrid.getItems());
            this.paintInitData(recordId);
        }
    }

    private void paintInitData(String recordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject initRecord = serviceHelper.queryOne((Object)recordId);
        this.paintDimEntry(initRecord);
    }

    private void paintDimEntry(DynamicObject initRecord) {
        DynamicObjectCollection dimCol = initRecord.getDynamicObjectCollection("userdimentry");
        TableValueSetter dimValueSetter = new TableValueSetter(new String[]{"dim_usermodel", "dim_fileorgmodel", "dim_rolemodel", "dim_customenablemodel", "dim_bucafuncmodel", "dim_orgrangemodel", "dim_validstartmodel", "dim_validendmodel"});
        this.getModel().beginInit();
        ArrayList<Map<Long, List<String>>> dimValList = new ArrayList<Map<Long, List<String>>>(10);
        ArrayList<Map<Long, List<String>>> dimValListContainsSub = new ArrayList<Map<Long, List<String>>>(10);
        ArrayList<Map<Long, List<Long>>> dimValListWithDynaCond = new ArrayList<Map<Long, List<Long>>>(10);
        ArrayList<Map<String, List<Long>>> orgTeamDimValListWithDynaCond = new ArrayList<Map<String, List<Long>>>(10);
        HashMap<Long, List<String>> allDimValList = new HashMap<Long, List<String>>(16);
        ArrayList<Map<String, List<String>>> otDimValList = new ArrayList<Map<String, List<String>>>(10);
        ArrayList otDimValListContainsSub = Lists.newArrayListWithCapacity((int)16);
        ArrayList<List<String>> isAllDimValList = new ArrayList<List<String>>(10);
        HashMap<String, String> customizableInfo = new HashMap<String, String>(2);
        customizableInfo.put("0", ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"DynaDimPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        customizableInfo.put("1", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"DynaDimPlugin_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        Map<Long, String> bucaFuncNames = this.queryAllBucaFuncNames();
        for (DynamicObject dimRow : dimCol) {
            String userName = dimRow.getString("dim_user.name");
            String orgName = dimRow.getString("dim_fileorg.name");
            String roleName = dimRow.getString("dim_role.name");
            String buName = bucaFuncNames.getOrDefault(dimRow.getLong("dim_bucafunc.id"), " ");
            DynamicObjectCollection orgRange = dimRow.getDynamicObjectCollection("dim_orgrange");
            String orgRangeContainsSub = dimRow.getString("dim_orgcontainssubstr");
            String orgRangeInfo = PermInitServiceHelper.getOrgInfo((DynamicObject)dimRow, (DynamicObjectCollection)orgRange, (String)orgRangeContainsSub);
            String validStart = dimRow.getString("dim_validstart");
            String validEnd = dimRow.getString("dim_validend");
            dimValueSetter.addRow(new Object[]{userName, orgName, roleName, customizableInfo.get(dimRow.getString("dim_customenable")), buName, orgRangeInfo, HRStringUtils.isNotEmpty((String)validStart) ? validStart.substring(0, 10) : validStart, HRStringUtils.isNotEmpty((String)validEnd) ? validEnd.substring(0, 10) : validEnd});
            DynamicObjectCollection dimValCol = dimRow.getDynamicObjectCollection("userdimvalueentry");
            HashMap<Long, ArrayList<String>> temp = new HashMap<Long, ArrayList<String>>(16);
            HashMap<String, ArrayList<String>> tempOt = new HashMap<String, ArrayList<String>>(16);
            ArrayList<String> isAllTemp = new ArrayList<String>(dimValCol.size());
            HashMap containsSubTempMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap dynaCondTempMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap orgTeamdynaCondTempMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap containsSubtempOtMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject dimVal : dimValCol) {
                String containsSubStr;
                String otClassId;
                String containsSubStr2;
                Long dimId = dimVal.getLong("dim_dimension.id");
                String dimValId = dimVal.getString("dim_dimval");
                String datasource = dimVal.getString("dim_dimension.datasource");
                boolean isAll = dimVal.getBoolean("dim_isall");
                boolean containsSub = dimVal.getBoolean("dim_containssub");
                String dim_valtype = dimVal.getString("dim_valtype");
                Long dim_dynacond = dimVal.getLong("dim_dynacond.id");
                if (HRStringUtils.equals((String)"2", (String)dim_valtype)) {
                    if (HRStringUtils.equals((String)datasource, (String)"orgteam")) {
                        String otClassId2 = dimVal.getString("dim_structproject.id");
                        String id = dimId + "#" + otClassId2;
                        ArrayList<Long> orgTeamListTemp = (ArrayList<Long>)orgTeamdynaCondTempMap.get(id);
                        if (null == orgTeamListTemp) {
                            orgTeamListTemp = new ArrayList<Long>(10);
                            orgTeamListTemp.add(dim_dynacond);
                            orgTeamdynaCondTempMap.put(id, orgTeamListTemp);
                            continue;
                        }
                        orgTeamListTemp.add(dim_dynacond);
                        continue;
                    }
                    ArrayList<Long> valDynaCond = (ArrayList<Long>)dynaCondTempMap.get(dimId);
                    if (null == valDynaCond) {
                        valDynaCond = new ArrayList<Long>(10);
                        valDynaCond.add(dim_dynacond);
                        dynaCondTempMap.put(dimId, valDynaCond);
                        continue;
                    }
                    valDynaCond.add(dim_dynacond);
                    continue;
                }
                if (isAll) {
                    isAllTemp.add(String.valueOf(dimId));
                    continue;
                }
                ArrayList<String> vals = (ArrayList<String>)temp.get(dimId);
                ArrayList<String> valContainsSubs = (ArrayList<String>)containsSubTempMap.get(dimId);
                if (null == vals) {
                    vals = new ArrayList<String>(10);
                    vals.add(dimValId);
                    if (valContainsSubs == null) {
                        valContainsSubs = new ArrayList(10);
                    }
                    containsSubStr2 = containsSub ? "1" : "0";
                    valContainsSubs.add(dimValId + "_" + containsSubStr2);
                    temp.put(dimId, vals);
                    containsSubTempMap.put(dimId, valContainsSubs);
                } else {
                    vals.add(dimValId);
                    if (valContainsSubs == null) {
                        valContainsSubs = new ArrayList<String>(10);
                    }
                    containsSubStr2 = containsSub ? "1" : "0";
                    valContainsSubs.add(dimValId + "_" + containsSubStr2);
                    containsSubTempMap.put(dimId, valContainsSubs);
                }
                if (!HRStringUtils.equals((String)datasource, (String)"orgteam") || !HRStringUtils.isNotEmpty((String)(otClassId = dimVal.getString("dim_structproject.id")))) continue;
                String id = dimId + "#" + otClassId;
                ArrayList<String> values = (ArrayList<String>)tempOt.get(id);
                ArrayList<String> valuesContainsSubs = (ArrayList<String>)containsSubtempOtMap.get(id);
                if (null == values) {
                    values = new ArrayList<String>(10);
                    values.add(dimValId);
                    tempOt.put(id, values);
                    if (valuesContainsSubs == null) {
                        valuesContainsSubs = new ArrayList(10);
                    }
                    containsSubStr = containsSub ? "1" : "0";
                    valuesContainsSubs.add(dimValId + "_" + containsSubStr);
                    containsSubtempOtMap.put(id, valuesContainsSubs);
                    continue;
                }
                values.add(dimValId);
                if (valuesContainsSubs == null) {
                    valuesContainsSubs = new ArrayList<String>(10);
                }
                containsSubStr = containsSub ? "1" : "0";
                valuesContainsSubs.add(dimValId + "_" + containsSubStr);
                containsSubtempOtMap.put(id, valuesContainsSubs);
            }
            for (Map.Entry entry : temp.entrySet()) {
                Long key = (Long)entry.getKey();
                List value = (List)entry.getValue();
                List dimVals = (List)allDimValList.get(key);
                if (null == dimVals) {
                    allDimValList.put(key, Lists.newArrayList((Iterable)value));
                    continue;
                }
                dimVals.addAll(value);
            }
            dimValList.add(temp);
            dimValListContainsSub.add(containsSubTempMap);
            otDimValList.add(tempOt);
            otDimValListContainsSub.add(containsSubtempOtMap);
            dimValListWithDynaCond.add(dynaCondTempMap);
            orgTeamDimValListWithDynaCond.add(orgTeamdynaCondTempMap);
            isAllDimValList.add(isAllTemp);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("userdimentrymodel", dimValueSetter);
        this.getModel().endInit();
        LOGGER.info("allDimValList = {},  dimValList = {}, otDimValList = {} ", new Object[]{allDimValList, dimValList, otDimValList});
        this.paintDynaDimCols(allDimValList, dimValList, otDimValList, isAllDimValList, dimValListContainsSub, otDimValListContainsSub, dimValListWithDynaCond, orgTeamDimValListWithDynaCond);
    }

    private void paintDynaDimCols(Map<Long, List<String>> allDimValList, List<Map<Long, List<String>>> dimValList, List<Map<String, List<String>>> otDimValList, List<List<String>> isAllDimValList, List<Map<Long, List<String>>> dimValListContainsSub, ArrayList<Map<String, List<String>>> otDimValListContainsSub, List<Map<Long, List<Long>>> dimValListWithDynaCond, List<Map<String, List<Long>>> orgTeamDimValListWithDynaCond) {
        Map allDimInfo = PermInitServiceHelper.structDimInfo(allDimValList);
        Map allDynaCondNameMap = PermInitServiceHelper.getAllDynaCondNameMap();
        this.getModel().beginInit();
        String separator = ";";
        for (int index = 0; index < dimValList.size(); ++index) {
            String key;
            String subEntryValue;
            ArrayList dynaValueName;
            List<Object> dynaValues;
            Long dimId;
            Map<Long, List<String>> valMap = dimValList.get(index);
            Map<Long, List<String>> valMapContainsSub = dimValListContainsSub.get(index);
            Map<String, List<String>> otValMapContainsSub = otDimValListContainsSub.get(index);
            Map<String, List<String>> otValMap = otDimValList.get(index);
            Map<Long, List<Long>> dimValWithDynaCondMap = dimValListWithDynaCond.get(index);
            Map<String, List<Long>> orgTeamDimValWithDynaCondMap = orgTeamDimValListWithDynaCond.get(index);
            int finalIndex = index;
            isAllDimValList.get(index).forEach(it -> this.getModel().setValue(it, (Object)"ALL", finalIndex));
            List otDimIds = otValMap.keySet().stream().map(it -> Long.valueOf(it.split("#")[0])).collect(Collectors.toList());
            for (Map.Entry<Long, List<String>> entry : valMap.entrySet()) {
                dimId = entry.getKey();
                List<String> valEntryContainsSub = valMapContainsSub.get(dimId);
                Map valInfo = (Map)allDimInfo.get(dimId);
                if (MapUtils.isEmpty((Map)valInfo) || otDimIds.contains(dimId)) continue;
                List<String> value = entry.getValue();
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)16);
                for (int i = 0; i < value.size(); ++i) {
                    String valName;
                    String dimVal = (String)value.get(i);
                    String dimValContainsSub = valEntryContainsSub.get(i);
                    if (dimValContainsSub.contains("_1")) {
                        if (!valInfo.containsKey(dimVal)) continue;
                        valName = (String)((Pair)valInfo.get(dimVal)).getKey();
                        arrayList.add(ResManager.loadKDString((String)"%s<\u5305\u542b\u4e0b\u7ea7>", (String)"PermRoleInitDrPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{valName}));
                        continue;
                    }
                    if (!valInfo.containsKey(dimVal)) continue;
                    valName = (String)((Pair)valInfo.get(dimVal)).getKey();
                    arrayList.add(valName);
                }
                this.getModel().setValue(String.valueOf(dimId), (Object)String.join((CharSequence)separator, arrayList), index);
            }
            for (Map.Entry<Long, List<Object>> entry : dimValWithDynaCondMap.entrySet()) {
                dimId = entry.getKey();
                if (otDimIds.contains(dimId)) continue;
                dynaValues = entry.getValue();
                dynaValueName = Lists.newArrayListWithCapacity((int)16);
                for (Long l : dynaValues) {
                    dynaValueName.add(allDynaCondNameMap.get(l));
                }
                subEntryValue = (String)this.getModel().getValue(String.valueOf(dimId), index);
                if (HRStringUtils.isEmpty((String)subEntryValue)) {
                    this.getModel().setValue(String.valueOf(dimId), (Object)String.join((CharSequence)separator, dynaValueName), index);
                    continue;
                }
                this.getModel().setValue(String.valueOf(dimId), (Object)(subEntryValue + separator + String.join((CharSequence)separator, dynaValueName)), index);
            }
            for (Map.Entry<Object, List<Object>> entry : otValMap.entrySet()) {
                key = (String)entry.getKey();
                List<String> otValues = otValMapContainsSub.get(key);
                String dimIdStr = key.split("#")[0];
                Map valInfo = (Map)allDimInfo.get(Long.valueOf(dimIdStr));
                if (MapUtils.isEmpty((Map)valInfo)) continue;
                List<Object> list = entry.getValue();
                ArrayList otValueContainsSubList = Lists.newArrayListWithCapacity((int)16);
                for (int i = 0; i < list.size(); ++i) {
                    String valName;
                    String otValue = (String)list.get(i);
                    String otValueContainsSub = otValues.get(i);
                    if (otValueContainsSub.contains("_1")) {
                        if (!valInfo.containsKey(otValue)) continue;
                        valName = (String)((Pair)valInfo.get(otValue)).getKey();
                        otValueContainsSubList.add(ResManager.loadKDString((String)"%s<\u5305\u542b\u4e0b\u7ea7>", (String)"PermRoleInitDrPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{valName}));
                        continue;
                    }
                    if (!valInfo.containsKey(otValue)) continue;
                    valName = (String)((Pair)valInfo.get(otValue)).getKey();
                    otValueContainsSubList.add(valName);
                }
                this.getModel().setValue(key, (Object)String.join((CharSequence)separator, otValueContainsSubList), index);
            }
            for (Map.Entry<Object, List<Object>> entry : orgTeamDimValWithDynaCondMap.entrySet()) {
                key = (String)entry.getKey();
                dynaValues = entry.getValue();
                dynaValueName = Lists.newArrayListWithCapacity((int)16);
                for (Long l : dynaValues) {
                    dynaValueName.add(allDynaCondNameMap.get(l));
                }
                subEntryValue = (String)this.getModel().getValue(key, index);
                if (HRStringUtils.isEmpty((String)subEntryValue)) {
                    this.getModel().setValue(key, (Object)String.join((CharSequence)separator, dynaValueName), index);
                    continue;
                }
                this.getModel().setValue(key, (Object)(subEntryValue + separator + String.join((CharSequence)separator, dynaValueName)), index);
            }
        }
        this.getModel().endInit();
    }

    private EntryAp createEntryAp(String recordId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        HashMap<String, String> dimensionInfos = new HashMap<String, String>(16);
        HashMap<String, Map<String, String>> orgTeamDimInfo = new HashMap<String, Map<String, String>>(16);
        this.queryInitDimensions(recordId, dimensionInfos, orgTeamDimInfo);
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordItem = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection userDimCol = recordItem.getDynamicObjectCollection("userdimentry");
        boolean hasOrg = userDimCol.stream().anyMatch(it -> it.getDynamicObjectCollection("dim_orgrange").size() > 0);
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        this.dynaAddColumn(entryAp, regularColInfo, hasOrg);
        this.createOtDim(entryAp, orgTeamDimInfo);
        this.dynaAddColumn(entryAp, dimensionInfos);
        return entryAp;
    }

    private void createOtDim(EntryAp entryAp, Map<String, Map<String, String>> orgTeamDimInfo) {
        if (MapUtils.isEmpty(orgTeamDimInfo)) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> dimEntry : orgTeamDimInfo.entrySet()) {
            String key = dimEntry.getKey();
            String[] dimInfos = key.split("#");
            EntryFieldGroupAp otFieldGroupAp = new EntryFieldGroupAp();
            otFieldGroupAp.setId(key);
            otFieldGroupAp.setKey(key);
            otFieldGroupAp.setName(new LocaleString(dimInfos[1]));
            Map<String, String> otMap = dimEntry.getValue();
            for (Map.Entry<String, String> otEntry : otMap.entrySet()) {
                String otKey = otEntry.getKey();
                EntryFieldAp textFieldAp = this.createTextFieldAp(otKey, otEntry.getValue());
                otFieldGroupAp.getItems().add(textFieldAp);
            }
            entryAp.getItems().add(otFieldGroupAp);
        }
    }

    private EntryFieldAp createTextFieldAp(String key, String name) {
        EntryFieldAp apMat = new EntryFieldAp();
        apMat.setId(key);
        apMat.setKey(key);
        LocaleString localeName = new LocaleString(name);
        apMat.setName(localeName);
        TextField textField = new TextField();
        textField.setKey(key);
        textField.setId(key);
        textField.setName(localeName);
        apMat.setField((Field)textField);
        return apMat;
    }

    private void dynaAddColumn(EntryAp entryAp, Map<String, String> dimInfo) {
        for (Map.Entry<String, String> dim : dimInfo.entrySet()) {
            String key = dim.getKey();
            String name = dim.getValue();
            EntryFieldAp apMat = this.createTextFieldAp(key, name);
            entryAp.getItems().add(apMat);
        }
    }

    private void dynaAddColumn(EntryAp entryAp, Map<String, String> dimInfo, boolean hasOrg) {
        for (Map.Entry<String, String> dim : dimInfo.entrySet()) {
            String key = dim.getKey();
            String name = dim.getValue();
            EntryFieldAp apMat = this.createTextFieldAp(key, name);
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            if ((HRStringUtils.equals((String)"dim_validstartmodel", (String)key) || HRStringUtils.equals((String)"dim_validendmodel", (String)key)) && !enableValidateTime) {
                apMat.setInvisible(true);
            }
            if (HRStringUtils.equals((String)"dim_orgrangemodel", (String)key) && !hasOrg) {
                apMat.setInvisible(true);
            }
            entryAp.getItems().add(apMat);
        }
    }

    private void registerEntityType(MainEntityType newMainType, String recordId) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("userdimentrymodel");
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        regularColInfo.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
        HashMap<String, String> dynaDimInfos = new HashMap<String, String>(16);
        HashMap<String, Map<String, String>> orgTeamDimInfo = new HashMap<String, Map<String, String>>(16);
        this.getInitDims(recordId, dynaDimInfos, orgTeamDimInfo);
        for (Map otMap : orgTeamDimInfo.values()) {
            otMap.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
        }
        dynaDimInfos.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
    }

    private void getInitDims(String recordId, Map<String, String> dynaDimInfos, Map<String, Map<String, String>> orgTeamDimInfo) {
        IPageCache pageCache = this.getPageCache();
        String dynaDimKey = recordId + "#" + "dynaDimInfos";
        String otDimKey = recordId + "#" + "orgTeamDimInfo";
        String dynaDimInfoStr = pageCache.get(dynaDimKey);
        String otDimInfoStr = pageCache.get(otDimKey);
        if (HRStringUtils.isNotEmpty((String)dynaDimInfoStr) && HRStringUtils.isNotEmpty((String)otDimInfoStr)) {
            dynaDimInfos.putAll((Map)SerializationUtils.fromJsonString((String)dynaDimInfoStr, Map.class));
            orgTeamDimInfo.putAll((Map)SerializationUtils.fromJsonString((String)otDimInfoStr, Map.class));
        } else {
            this.queryInitDimensions(recordId, dynaDimInfos, orgTeamDimInfo);
            pageCache.put(dynaDimKey, SerializationUtils.toJsonString(dynaDimInfos));
            pageCache.put(otDimKey, SerializationUtils.toJsonString(orgTeamDimInfo));
        }
    }

    private void queryInitDimensions(String recordId, Map<String, String> dimInfo, Map<String, Map<String, String>> orgTeamDimInfo) {
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordItem = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection userDimCol = recordItem.getDynamicObjectCollection("userdimentry");
        List dimValCol = userDimCol.stream().map(rt -> rt.getDynamicObjectCollection("userdimvalueentry")).collect(Collectors.toList());
        for (DynamicObjectCollection col : dimValCol) {
            for (DynamicObject dimRow : col) {
                String dimName = dimRow.getString("dim_dimension.name");
                if (HRStringUtils.isEmpty((String)dimName)) continue;
                String datasource = dimRow.getString("dim_dimension.datasource");
                String dimId = dimRow.getString("dim_dimension.id");
                if (!HRStringUtils.equals((String)datasource, (String)"orgteam")) {
                    dimInfo.put(dimId, dimName);
                    continue;
                }
                DynamicObject stType = dimRow.getDynamicObject("dim_structproject");
                if (!Objects.nonNull(stType)) continue;
                String otId = stType.getString("id");
                String otName = stType.getString("name");
                String id = dimId + "#" + dimName;
                Map otMap = orgTeamDimInfo.computeIfAbsent(id, key -> Maps.newHashMapWithExpectedSize((int)16));
                otMap.put(dimId + "#" + otId, otName);
            }
        }
    }

    private Map<Long, String> queryAllBucaFuncNames() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject[] dys = serviceHelper.query(new QFilter[0]);
        return Arrays.stream(dys).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("name")));
    }

    private Map<String, String> buildRegularColInfo() {
        LinkedHashMap<String, String> regularColInfo = new LinkedHashMap<String, String>(16);
        regularColInfo.put("dim_usermodel", ResManager.loadKDString((String)"\u7528\u6237", (String)"DynaDimPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_fileorgmodel", ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7", (String)"DynaDimPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_rolemodel", ResManager.loadKDString((String)"\u89d2\u8272", (String)"DynaDimPlugin_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_validstartmodel", ResManager.loadKDString((String)"\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"DynaDimPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_validendmodel", ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"DynaDimPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_customenablemodel", ResManager.loadKDString((String)"\u6210\u5458\u8303\u56f4\u5c5e\u6027", (String)"DynaDimPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_bucafuncmodel", ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"DynaDimPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("dim_orgrangemodel", ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"DynaDimPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        return regularColInfo;
    }
}

