/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.HRSheetHandler;
import kd.hr.hbp.formplugin.web.imp.ImportHelper;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermTemplateFieldMap;
import kd.hr.hrcs.common.model.perminit.ExcelCellInfo;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.xml.sax.SAXException;

@ExcludeFromJacocoGeneratedReport
public class PermImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(PermImportFailedSheetHandler.class);
    private static final String COLOR = "color";
    private final int ERR_ROW_COUNT = 5000;
    private Set<String> sheetSet = Sets.newHashSetWithExpectedSize((int)4);
    private boolean hasErrorCol;
    private SXSSFWorkbook book;
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>(16);
    private ImportContext ctx;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>(16);
    private Map<String, ImportLogger> importLoggerMap;
    private boolean isAll = false;
    private Map<String, String> urlMap;
    private ExportSheetStyle styles1;
    private Font originalFont;
    private Map<Integer, String> fieldMap;
    private Set<String> userRoleFixFieldSet = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> userRoleDealOtFieldSet = Sets.newHashSetWithExpectedSize((int)16);
    private boolean enableValidateTime;
    private String impFileName;
    private int userRoleCount = 0;
    private PermInitImportService permInitImportService = new PermInitImportService();
    private String errCellValue = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private Table<String, Integer, List<ExcelCellInfo>> headerUserTb;

    public PermImportFailedSheetHandler(ImportContext ctx, ImportLogger importLogger, Map<String, ImportLogger> importLoggerMap, boolean isAll, Map<String, String> urlMap, String impFileName, Table<String, Integer, List<ExcelCellInfo>> headerUserTb) {
        this.setInterrupt(false);
        this.ctx = ctx;
        importLogger.getDelRows().sort(Comparator.comparingInt(o -> o[0]));
        this.importLoggerMap = importLoggerMap;
        this.isAll = isAll;
        this.urlMap = urlMap;
        this.userRoleFixField();
        this.enableValidateTime = PermCommonUtil.isEnableValidateTime();
        this.impFileName = impFileName;
        this.headerUserTb = headerUserTb;
    }

    private void userRoleFixField() {
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"PermSheetHelper_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"PermSheetHelper_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*\u6570\u636e\u8303\u56f4\u5c5e\u6027", (String)"PermSheetHelper_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"*\u804c\u80fd\u7c7b\u578b", (String)"PermSheetHelper_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"PermSheetHelper_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.userRoleFixFieldSet.add(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void initStyle() {
        XSSFCellStyle tipsCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle();
        XSSFFont tipsFont = tipsCellStyle.getFont();
        tipsFont.setBold(true);
        tipsFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header");
        headerCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCellStyle.setBorderTop(BorderStyle.THIN);
        headerCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerCellFont = headerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerMustInputCellStyle = (XSSFCellStyle)this.styles1.getTitleMustInputStyle();
        headerMustInputCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerMustInputCellStyle.setBorderTop(BorderStyle.THIN);
        headerMustInputCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderRight(BorderStyle.THIN);
        headerMustInputCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderBottom(BorderStyle.THIN);
        headerMustInputCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderLeft(BorderStyle.THIN);
        headerMustInputCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerMustInputFont = headerMustInputCellStyle.getFont();
        headerMustInputFont.setBold(true);
        headerMustInputFont.setFontHeightInPoints((short)12);
        headerMustInputFont.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle headerCenterCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header-center");
        headerCenterCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCenterCellStyle.setBorderTop(BorderStyle.THIN);
        headerCenterCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderRight(BorderStyle.THIN);
        headerCenterCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCenterCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCenterCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCenterCellFont = headerCenterCellStyle.getFont();
        headerCenterCellFont.setBold(true);
        headerCenterCellFont.setFontHeightInPoints((short)12);
        CellStyle commonCellStyle1 = this.styles1.getTextStyle("body-common1");
        commonCellStyle1.setFont(this.originalFont);
        commonCellStyle1.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBorderTop(BorderStyle.THIN);
        commonCellStyle1.setBorderRight(BorderStyle.THIN);
        commonCellStyle1.setBorderBottom(BorderStyle.THIN);
        commonCellStyle1.setBorderLeft(BorderStyle.THIN);
        CellStyle redFontCellStyle = this.styles1.getTextStyle("body-redfont");
        redFontCellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setBorderTop(BorderStyle.THIN);
        redFontCellStyle.setBorderRight(BorderStyle.THIN);
        redFontCellStyle.setBorderBottom(BorderStyle.THIN);
        redFontCellStyle.setBorderLeft(BorderStyle.THIN);
        Font redFont = this.book.createFont();
        redFont.setFontHeightInPoints((short)12);
        redFont.setColor(IndexedColors.RED.getIndex());
        redFontCellStyle.setFont(redFont);
    }

    private Cell addMergeRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        sheet.addMergedRegion(cellRange);
        return sheet.getRow(firstRow).getCell(firstCol);
    }

    private void addMergedRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle) {
        this.addMergeRegionWithWhiteBorder(sheet, firstRow, lastRow, firstCol, lastCol);
        for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
            for (int colIndex = firstCol; colIndex <= lastCol; ++colIndex) {
                sheet.getRow(rowIndex).getCell(colIndex).setCellStyle(cellStyle);
            }
        }
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(10000);
                this.book.setCompressTempFiles(true);
            }
            if (!this.checkSheetName(row.getSheetName())) {
                return;
            }
            sheet = this.book.createSheet(row.getSheetName());
            sheet.setColumnWidth(0, 10000);
            this.styles1 = new ExportSheetStyle(this.book, null);
            this.originalFont = this.book.createFont();
            this.originalFont.setFontHeightInPoints((short)12);
            this.initStyle();
            this.sheets.put(row.getSheetName(), sheet);
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        SXSSFRow curRow = this.getRow(sheet, currRowNum);
        curRow.setHidden(Boolean.valueOf(row.isHideRow()));
        this.handleWorkSheet(row, sheet, currRowNum);
    }

    private boolean checkSheetName(String sheetName) {
        return this.permInitImportService.containsValue(sheetName);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, SXSSFSheet sheet, int currRowNum) {
        if (currRowNum == 1 && this.getSheetName().contains(PermTemplateFieldMap.getTemplateName((String)"importUserR"))) {
            this.fieldMap = row.getData();
        }
        if (currRowNum == 2) {
            this.hasErrName();
            SXSSFRow nameRow = this.getRow(sheet, currRowNum);
            CellStyle cellStyle = this.styles1.getTitleMustInputStyle();
            SXSSFCell sxssfCell = null;
            sxssfCell = this.getCell(nameRow);
            if (this.getSheetName().contains(PermTemplateFieldMap.getTemplateName((String)"importUserR"))) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, cellStyle);
            } else {
                sxssfCell.setCellStyle(cellStyle);
            }
            sxssfCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        } else if (currRowNum > 2 && (this.getSheetName().contains(PermTemplateFieldMap.getTemplateName((String)"importUserR")) ? currRowNum >= 5 && !this.setLogStr(sheet, currRowNum) && !this.isAll : !this.setLogStr(sheet, currRowNum) && !this.isAll)) {
            return;
        }
        if (this.getSheetName().equals(ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272", (String)"PermSheetHelper_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])) && this.currentRow.getRowNum() > 4) {
            ++this.userRoleCount;
        }
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            this.putSXSSFSheet(sheet, entry);
        }
    }

    private boolean hasErrName() {
        String cellValue = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        Map data = this.currentRow.getData();
        String errName = (String)data.get(0);
        this.hasErrorCol = HRStringUtils.equals((String)errName, (String)cellValue);
        return this.hasErrorCol;
    }

    protected SXSSFCell getCell(SXSSFRow row) {
        return row.getCell(0) != null ? row.getCell(0) : row.createCell(0);
    }

    private void putSXSSFSheet(SXSSFSheet sheet, Map.Entry<Integer, String> entry) {
        XSSFCellStyle headerCellStyle;
        int currRowNum = this.currentRow.getRowNum();
        int cellIndex = this.countIndex(entry.getKey(), currRowNum);
        if (this.errCellValue.equals(entry.getValue()) && currRowNum == 2) {
            return;
        }
        if (entry.getKey() == 0 && this.hasErrorCol) {
            return;
        }
        SXSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        if (currRowNum == 0) {
            headerCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle();
            sxssfCell.setCellStyle((CellStyle)headerCellStyle);
            int cellWidth = ImportHelper.calcColumnWidth((String)entry.getValue(), (int)0);
            if (cellWidth > sheet.getColumnWidth(cellIndex)) {
                sheet.setColumnWidth(cellIndex, cellWidth);
            }
        }
        if (currRowNum == 2) {
            headerCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header");
            CellStyle mustCellStyle = this.styles1.getTitleMustInputStyle();
            String cellValue = entry.getValue();
            if (cellValue.contains("*")) {
                sxssfCell.setCellStyle(mustCellStyle);
            } else {
                sxssfCell.setCellStyle((CellStyle)headerCellStyle);
            }
            int lineSeparatorIndex = cellValue.indexOf(System.getProperty("line.separator"));
            cellValue = lineSeparatorIndex > 0 ? cellValue.substring(0, lineSeparatorIndex) : cellValue;
            sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth((String)cellValue, (int)0));
        }
        if (currRowNum >= 2 && currRowNum <= 4 && this.getSheetName().contains(PermTemplateFieldMap.getTemplateName((String)"importUserR"))) {
            int lineSeparatorIndex;
            String cellValue;
            headerCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header");
            CellStyle centerCellStyle = this.styles1.getTitleStyle("header-center");
            CellStyle mustCellStyle = this.styles1.getTitleMustInputStyle();
            if (this.enableValidateTime) {
                if (cellIndex <= 11) {
                    this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, cellIndex, cellIndex, (CellStyle)headerCellStyle);
                }
            } else if (cellIndex <= 9) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, cellIndex, cellIndex, (CellStyle)headerCellStyle);
            }
            String roleDimStr = ResManager.loadKDString((String)"\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            if (entry.getValue().equals(roleDimStr) && cellIndex != this.fieldMap.size()) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, cellIndex, this.fieldMap.size(), centerCellStyle);
            }
            if ((cellValue = entry.getValue()).startsWith("*")) {
                sxssfCell.setCellStyle(mustCellStyle);
            } else if (!roleDimStr.equals(cellValue)) {
                sxssfCell.setCellStyle((CellStyle)headerCellStyle);
            }
            Integer key = entry.getKey();
            String field = this.fieldMap.get(key);
            if (!this.userRoleFixFieldSet.contains(entry.getValue())) {
                if (field.contains("#")) {
                    String[] split = field.split("#");
                    String prefix = split[0];
                    if (this.userRoleDealOtFieldSet.add(prefix)) {
                        long count = this.fieldMap.values().stream().filter(it -> it.startsWith(prefix + "#")).count();
                        if (--count > 0L) {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, cellIndex, cellIndex + Integer.parseInt(String.valueOf(count)), centerCellStyle);
                        }
                    }
                } else {
                    this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, cellIndex, cellIndex, (CellStyle)headerCellStyle);
                }
            }
            cellValue = (lineSeparatorIndex = cellValue.indexOf(System.getProperty("line.separator"))) > 0 ? cellValue.substring(0, lineSeparatorIndex) : cellValue;
            sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth((String)cellValue, (int)0));
        }
        sxssfCell.setCellValue(entry.getValue());
    }

    private boolean setLogStr(SXSSFSheet sheet, int currRowNum) {
        String entityId = PermTemplateFieldMap.getTemplateSheetName((String)sheet.getSheetName());
        List logs = Optional.ofNullable(this.importLoggerMap.get(entityId)).map(ImportLogger::getLogCache).map(importLogger -> (List)importLogger.get(currRowNum)).orElseGet(Lists::newArrayList);
        if (!logs.isEmpty()) {
            String mergeLogStr;
            if (currRowNum - 3 <= 5000) {
                StringBuilder sb = new StringBuilder();
                for (ImportLogger.ImportLog importLog : logs) {
                    if (!importLog.toString().endsWith(";")) {
                        sb.append(importLog.toString()).append(";");
                    } else {
                        sb.append(importLog.toString());
                    }
                    sb.append(System.lineSeparator());
                    if (sb.length() <= 4000) continue;
                    sb.replace(3997, 4000, "...").setLength(4000);
                    break;
                }
                mergeLogStr = sb.toString();
            } else {
                mergeLogStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e\u3002", (String)"PermImportFailedSheetHandler_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            }
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(0);
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleObj));
            cell.setCellValue(mergeLogStr);
            return Boolean.TRUE;
        }
        if (!this.isAll) {
            this.getRow(sheet, currRowNum).setHidden(Boolean.valueOf(true));
        }
        return Boolean.FALSE;
    }

    private int countIndex(int index, int currRowNum) {
        if (this.hasErrorCol) {
            return index;
        }
        if (this.headerUserTb != null && this.headerUserTb.size() > 0 && (currRowNum == 0 || currRowNum == 1)) {
            return index;
        }
        return ++index;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String defaultFmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short backGround = style.getShort("bg");
        Short titleColor = style.getShort(COLOR);
        String styleStr = String.format(Locale.ROOT, "%s_-_%d_-_%d_-_%s", defaultFmt, backGround, titleColor, align);
        CellStyle customCellStyle = this.styles.get(styleStr);
        if (customCellStyle == null) {
            customCellStyle = HRSheetHandler.getCellStyle((String)defaultFmt, (Short)backGround, (Short)titleColor, (String)styleStr, this.styles, (SXSSFWorkbook)this.book);
        }
        return customCellStyle;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int intdexRow) {
        SXSSFRow row = sheet.getRow(intdexRow);
        if (row == null) {
            row = sheet.createRow(intdexRow);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        boolean isContains = this.permInitImportService.containsValue(this.getSheetName().trim());
        if (this.currentRow != null && isContains) {
            this.sheetSet.add(this.getSheetName());
        }
        this.setInterrupt(false);
        if (this.getSheetName().equals(ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272", (String)"PermSheetHelper_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]))) {
            this.setRoleRange();
        }
        if (this.sheetSet.size() != 4) {
            return;
        }
        this.setInterrupt(true);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String fileName = null;
            fileName = this.isAll ? String.format(ResManager.loadKDString((String)"\u5168\u91cf\u62a5\u544a_%1$s", (String)"PermImportFailedSheetHandler_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), this.impFileName).replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "") : String.format(ResManager.loadKDString((String)"\u9519\u8bef\u62a5\u544a_%1$s", (String)"PermImportFailedSheetHandler_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), this.impFileName).replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
            String url = tempFile.saveAsUrl(fileName, data, 7200);
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.ctx.getAppId(), (String)(this.ctx.getBillFormId() + UUID.randomUUID().toString()), (String)fileName);
            FileService service = FileServiceFactory.getAttachmentFileService();
            url = service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
            if (this.isAll) {
                this.urlMap.put("allErrUrl", UrlService.getAttachmentFullUrl((String)url));
            } else {
                this.urlMap.put("errUrl", UrlService.getAttachmentFullUrl((String)url));
            }
        }
        catch (Exception exp) {
            throw new KDBizException((Throwable)exp, new ErrorCode("", exp instanceof KDBizException ? exp.getMessage() : ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"PermImportFailedSheetHandler_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            try {
                if (this.book != null) {
                    this.book.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            this.ctx = null;
            this.sheets.clear();
            this.book = null;
        }
    }

    private void setRoleRange() {
        int dropDownIndex = this.enableValidateTime ? 9 : 7;
        SXSSFSheet sheet = this.sheets.get(ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272", (String)"PermSheetHelper_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList dataScopeValueList = new CellRangeAddressList(5, 5 + this.userRoleCount, dropDownIndex, dropDownIndex);
        String[] dataScopeItems = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"PermSheetHelper_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermSheetHelper_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])};
        DataValidationConstraint dataScopeValueConstraint = helper.createExplicitListConstraint(dataScopeItems);
        DataValidation dataScopeDataValidation = helper.createValidation(dataScopeValueConstraint, dataScopeValueList);
        sheet.addValidationData(dataScopeDataValidation);
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
    }
}

