/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportValidateService;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitRecordSaveService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleDataPckService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitValidateService;
import kd.hr.hrcs.bussiness.service.perm.init.roleinit.PermRoleInitRecordSaveService;
import kd.hr.hrcs.common.model.perminit.ExcelCellInfo;
import kd.hr.hrcs.common.model.perminit.PermInitRecord;
import kd.hr.hrcs.common.model.perminit.PermRoleInitRecord;
import kd.hr.hrcs.common.model.perminit.PermRoleInitValidateBO;
import kd.hr.hrcs.common.utils.ImportFileUtil;
import kd.hr.hrcs.formplugin.web.perm.init.PermImportFailedSheetHandler;
import kd.hr.hrcs.formplugin.web.perm.init.PermImportRoleFailedSheetHandler;
import kd.hr.hrcs.formplugin.web.perm.init.PermImportSheetHandler;
import kd.hr.hrcs.formplugin.web.perm.init.PermRoleImportSheetHandler;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class PermInitImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(PermInitImportPlugin.class);
    private Map<String, Integer> countMap = Maps.newHashMapWithExpectedSize((int)4);
    private Long recordId;
    private Map<String, Long> dimMap;
    private IFormView view;
    private PermInitImportService permInitImportService = new PermInitImportService();
    private Set<String> roleSet = Sets.newHashSetWithExpectedSize((int)16);
    private Table<String, Integer, List<ExcelCellInfo>> headerTb = HashBasedTable.create();
    private Table<String, Integer, List<ExcelCellInfo>> headerUserTb = HashBasedTable.create();
    private PermInitImportValidateService permInitImportValidateService;
    private PermRoleInitValidateBO validateBo;
    private String importType;
    private Map<String, Set<String>> roleMap = Maps.newHashMapWithExpectedSize((int)5);
    private RequestContext requestContext;
    private Map<String, Integer> funcRoleMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Integer, List<Pair<Integer, String>>> colErrorMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Integer, String> dimErrorMap = Maps.newHashMapWithExpectedSize((int)16);
    private List<ExcelCellInfo> roleFunList = Lists.newArrayListWithExpectedSize((int)16);
    private Map<String, List<String>> dimMustMap = Maps.newHashMapWithExpectedSize((int)16);
    private boolean hasError = false;
    private Map<String, ImportLogger> importLoggerMap = Maps.newHashMapWithExpectedSize((int)4);

    public Long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    private boolean isUserPermImport() {
        return this.getImportType().equals("userRole");
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        if (this.isUserPermImport() && this.importLoggerMap.size() == 0) {
            this.importLoggerMap.put("importUserR", new ImportLogger());
            this.importLoggerMap.put("importUserDr", new ImportLogger());
            this.importLoggerMap.put("importUserBD", new ImportLogger());
            this.importLoggerMap.put("importUserFp", new ImportLogger());
        } else if (!this.isUserPermImport() && this.importLoggerMap.size() == 0) {
            this.importLoggerMap.put("importRoleList", new ImportLogger());
            this.importLoggerMap.put("importRoleFunc", new ImportLogger());
            this.importLoggerMap.put("importRoleDim", new ImportLogger());
            this.importLoggerMap.put("importRoleDataRange", new ImportLogger());
            this.importLoggerMap.put("importRoleFp", new ImportLogger());
        }
        if (this.isUserPermImport() && CollectionUtils.isEmpty(this.dimMap)) {
            this.dimMap = this.permInitImportService.getDims(false);
        } else if (!this.isUserPermImport() && CollectionUtils.isEmpty(this.dimMap)) {
            this.dimMap = this.permInitImportService.getDims(true);
        }
        ExcelReader excelReader = new ExcelReader();
        String localPath = null;
        for (String url : this.ctx.getAllUrls()) {
            try {
                Throwable throwable;
                FileInputStream inputStream;
                LOG.info("PermInitImportPlugin resolveExcel url:{}", (Object)url);
                localPath = ImportFileUtil.downloadFile((String)url);
                LOG.info("PermInitImportPlugin resolveExcel localPath:{}", (Object)localPath);
                if (this.isUserPermImport()) {
                    inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));
                    throwable = null;
                    try {
                        excelReader.read((InputStream)inputStream, (SheetHandler)new PermImportSheetHandler(this.ctx, url, this.countMap, this.dimMap, this.headerUserTb));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                        continue;
                    }
                }
                inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));
                throwable = null;
                try {
                    excelReader.read((InputStream)inputStream, (SheetHandler)new PermRoleImportSheetHandler(this.ctx, url, this.countMap, this.dimMap, this.roleSet, this.headerTb, this.funcRoleMap, this.roleFunList));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exc) {
                ImportLogger logger = this.ctx.getLogger(url);
                String errMessage = exc.getMessage();
                if (exc instanceof KDBizException) {
                    logger.log(Integer.valueOf(0), errMessage);
                } else {
                    logger.log(Integer.valueOf(3), ImportLogger.formatException((Throwable)exc));
                }
                LOG.error("PermInitImportPlugin resolveExcel error", (Throwable)exc);
                JSONObject json = new JSONObject();
                json.put("errCode", (Object)errMessage);
                this.ctx.getDataQueue(url).add(new ImportBillData(json, 0, 0, null));
            }
            finally {
                this.ctx.setResolveComplete(url);
                try {
                    ImportFileUtil.deleteLocalTempFile((String)localPath);
                }
                catch (IOException ex) {
                    LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex);
                }
            }
        }
    }

    protected void importData() throws Throwable {
        LOG.info("PermInitImportPlugin--begin to importData");
        this.importData(this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(ImportContext conf) {
        try {
            for (String url : conf.getAllUrls()) {
                LinkedBlockingQueue dataQ = conf.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = conf.getLogger(url);
                importLogger.setDelRows(delRows);
                this.fetchQueueData(conf, url, dataQ);
            }
        }
        finally {
            HashMap urlMap = Maps.newHashMapWithExpectedSize((int)2);
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getFailed();
                if (this.hasErrorLine() && this.isUserPermImport()) {
                    this.outputFailedForData(url, logger, false, urlMap);
                    this.outputFailedForData(url, logger, true, urlMap);
                    continue;
                }
                if (this.isUserPermImport() || !this.hasRoleErrorLine()) continue;
                this.outputRoleInitFailedForData(url, urlMap);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            if (this.isUserPermImport()) {
                String errUrl = (String)urlMap.get("errUrl");
                String allErrUrl = (String)urlMap.get("allErrUrl");
                this.permInitImportValidateService.feedbackProgress(true, errUrl, allErrUrl);
                urlMap.clear();
            } else {
                IHRAppCache appCache = HRAppCache.get((String)"hrcs");
                String status = (String)appCache.get("currentStatus" + RequestContext.get().getCurrUserId(), String.class);
                LOG.info("PermInitImportPlugin--finally to importData status:{}", (Object)status);
                if (!HRStringUtils.equals((String)"terminator", (String)status)) {
                    String allErrUrl = (String)urlMap.get("allErrUrl");
                    LOG.info("PermInitImportPlugin--finally to importData allErrUrl:{}", (Object)allErrUrl);
                    new PermRoleInitImportService(this.importLoggerMap, this.countMap, this.view).feedbackProgress(true, allErrUrl);
                } else {
                    LOG.info("PermInitImportPlugin--finally to importData remove status:{}", (Object)status);
                    appCache.remove("currentStatus" + RequestContext.get().getCurrUserId());
                }
            }
        }
    }

    private boolean hasRoleErrorLine() {
        List errorRoleNumList = this.validateBo.getErrorRoleNumList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)errorRoleNumList)) {
            return false;
        }
        return this.hasError;
    }

    private boolean hasErrorLine() {
        List collect = this.importLoggerMap.values().stream().filter(it -> it.getLogCache().size() > 0).collect(Collectors.toList());
        return collect.size() > 0;
    }

    private void fetchQueueData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ) {
        int timeout = 0;
        ArrayList<ImportBillData> allRowdatas = new ArrayList<ImportBillData>();
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 500)) {
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowdatas.size();
            int needCount = 5000 - lastLeftCount;
            if (needCount > 0) {
                ImportBillData rowData;
                try {
                    rowData = dataQ.poll(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (rowData == null || rowData.isEmpty()) {
                    ++timeout;
                    continue;
                }
                rowdatas.add(rowData);
                dataQ.drainTo(rowdatas, needCount);
                rowdatas.removeIf(ImportBillData::isEmpty);
                allRowdatas.addAll(rowdatas);
            }
            timeout = 0;
        }
        if (allRowdatas.size() > 0 && conf.isResolveComplete(url)) {
            this.ctx.feedbackProgress(25, null, null);
            this.importBatchData(allRowdatas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void outputFailedForData(String url, ImportLogger importLogger, boolean isAll, Map<String, String> urlMap) {
        block23: {
            String localPath = null;
            localPath = url.contains("http") ? ImportFileUtil.downloadTempFile((String)url) : ImportFileUtil.downloadFile((String)url);
            LOG.info("PermInitImportPlugin resolveExcel localPath:{}", (Object)localPath);
            IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
            String impFileName = cache.get("impfileName");
            try (FileInputStream inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));){
                new ExcelReader().read((InputStream)inputStream, (SheetHandler)new PermImportFailedSheetHandler(this.ctx, importLogger, this.importLoggerMap, isAll, urlMap, impFileName, this.headerUserTb));
            }
            try {
                ImportFileUtil.deleteLocalTempFile((String)localPath);
            }
            catch (IOException ex) {
                LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex);
            }
            break block23;
            catch (Exception ex) {
                try {
                    LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex);
                    importLogger.log(Integer.valueOf(0), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    try {
                        ImportFileUtil.deleteLocalTempFile(localPath);
                    }
                    catch (IOException ex2) {
                        LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex2);
                    }
                    throw throwable;
                }
                try {
                    ImportFileUtil.deleteLocalTempFile((String)localPath);
                }
                catch (IOException ex3) {
                    LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputRoleInitFailedForData(String url, Map<String, String> urlMap) {
        String localPath = null;
        try {
            localPath = ImportFileUtil.downloadFile((String)url);
            LOG.info("PermInitImportPlugin resolveExcel localPath:{}", (Object)localPath);
            IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
            String impFileName = cache.get("impfileName");
            try (FileInputStream inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));){
                new ExcelReader().read((InputStream)inputStream, (SheetHandler)new PermImportRoleFailedSheetHandler(this.ctx, this.importLoggerMap, urlMap, impFileName, this.headerTb, this.validateBo, this.countMap, this.dimMustMap));
            }
        }
        catch (Throwable ex) {
            LOG.error("PermInitImportPlugin--outputRoleInitFailedForData error,", ex);
        }
        finally {
            try {
                ImportFileUtil.deleteLocalTempFile((String)localPath);
            }
            catch (IOException ex) {
                LOG.error("PermInitImportPlugin--outputRoleInitFailedForData error,", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importBatchData(List<ImportBillData> rowDataList) {
        RequestContext.set((RequestContext)this.getRequestContext());
        try {
            LOG.info("PermInitImportPlugin importBatchData data:{}", rowDataList);
            if (this.isUserPermImport()) {
                this.permInitImportValidateService = new PermInitImportValidateService(this.importLoggerMap, this.countMap, this.view);
                PermInitRecord permInitRecord = new PermInitRecord();
                this.permInitImportValidateService.initExcelData(permInitRecord, rowDataList);
                this.permInitImportValidateService.initParams(permInitRecord, rowDataList, this.recordId);
                PermInitRecordSaveService.saveImportData((PermInitRecord)permInitRecord);
                this.setSuccessFlag("success");
            } else {
                HashMap logMap = Maps.newHashMapWithExpectedSize((int)16);
                PermRoleDataPckService permRoleDataPckService = new PermRoleDataPckService(this.roleSet);
                LOG.info("PermInitImportPlugin funcRoleMap:{},roleMap:{}, roleFunList:{}", new Object[]{this.funcRoleMap, this.roleMap, this.roleFunList});
                PermRoleInitRecord record = permRoleDataPckService.getExcelRowData(rowDataList, this.recordId, (Map)logMap, this.funcRoleMap, this.colErrorMap, this.headerTb, this.roleMap, this.dimErrorMap, this.roleFunList, this.dimMustMap);
                PermRoleInitValidateService permRoleInitValidateService = new PermRoleInitValidateService();
                this.validateBo = permRoleInitValidateService.validate(record);
                this.initValue(record, this.validateBo, logMap);
                PermRoleInitRecordSaveService.saveImportData((PermRoleInitRecord)record);
                this.setSuccessFlag("success");
                this.setErrorCount(logMap);
            }
        }
        catch (Throwable throwable) {
            this.getView().getPageCache().put("currentStatus", "terminator");
            this.setCacheError();
            this.setSuccessFlag("failed");
            LOG.error("PermInitImportPlugin-- importBatchData error:", throwable);
            if (this.isUserPermImport()) {
                this.setSuccessFlag("failed");
                this.importLoggerMap.get("importUserR").log(Integer.valueOf(3), ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38", (String)"PermDataImportPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            if (this.isUserPermImport()) {
                this.permInitImportValidateService.feedbackProgress(false, null, null);
            }
        }
    }

    private void initValue(PermRoleInitRecord record, PermRoleInitValidateBO validateBo, Map<String, Map<Integer, String>> logMap) {
        PermRoleDataPckService permRoleDataPckService = new PermRoleDataPckService(this.roleSet);
        if (record.getRoleInitModelList().size() > 0) {
            record.getRoleInitModelList().forEach(it -> {
                it.setUseScope(permRoleDataPckService.getUseScope(it.getUseScope()));
                it.setRoleCBisIntersection(permRoleDataPckService.getRoleBc(it.getRoleCBisIntersection()));
                it.setRoleProperty(permRoleDataPckService.getRoleProperty(it.getRoleProperty()));
            });
        }
        Map<Integer, String> roleListEmptyMap = logMap.get("importRoleList");
        Map<Integer, String> funcEmptyMap = logMap.get("importRoleFunc");
        Map<Integer, String> dimEmptyMap = logMap.get("importRoleDim");
        Map<Integer, String> dataRangeEmptyMap = logMap.get("importRoleDataRange");
        Map<Integer, String> fieldEmptyMap = logMap.get("importRoleFp");
        if (roleListEmptyMap != null && roleListEmptyMap.size() > 0) {
            validateBo.getRoleErrMsgMap().putAll(roleListEmptyMap);
        }
        if (funcEmptyMap != null && funcEmptyMap.size() > 0) {
            funcEmptyMap.forEach((key, value) -> {
                HashMap itMap = Maps.newHashMapWithExpectedSize((int)2);
                itMap.put(0, value);
                validateBo.getFunctionItemErrMsgMap().put(key, itMap);
            });
        }
        if (this.colErrorMap.size() > 0) {
            this.colErrorMap.forEach((key, value) -> {
                for (Pair pair : value) {
                    HashMap itMap = Maps.newHashMapWithExpectedSize((int)2);
                    itMap.put(pair.getLeft(), pair.getRight());
                    Map integerStringMap = (Map)validateBo.getFunctionItemErrMsgMap().get(4);
                    if (integerStringMap == null) {
                        validateBo.getFunctionItemErrMsgMap().put(4, itMap);
                        continue;
                    }
                    String tempStr = (String)integerStringMap.get(pair.getLeft());
                    if (HRStringUtils.isNotEmpty((String)tempStr)) {
                        String concat = tempStr.concat(";").concat((String)pair.getRight());
                        integerStringMap.put(pair.getLeft(), concat);
                        continue;
                    }
                    integerStringMap.put(pair.getLeft(), pair.getRight());
                }
            });
        }
        if (dimEmptyMap != null && dimEmptyMap.size() > 0) {
            validateBo.getDimErrMsgBO().getErrMsgMap().putAll(dimEmptyMap);
        }
        if (this.dimErrorMap.size() > 0) {
            Map errMsgMap = validateBo.getDimErrMsgBO().getErrMsgMap();
            this.dimErrorMap.forEach((key, val) -> {
                String errStr = (String)errMsgMap.get(key);
                if (HRStringUtils.isEmpty((String)errStr)) {
                    errMsgMap.put(key, val);
                } else {
                    errMsgMap.put(key, errStr.concat(";").concat((String)val));
                }
            });
        }
        if (dataRangeEmptyMap != null && dataRangeEmptyMap.size() > 0) {
            validateBo.getDataRangeInitValidateBO().getErrMsgMap().putAll(dataRangeEmptyMap);
        }
        if (fieldEmptyMap != null && fieldEmptyMap.size() > 0) {
            validateBo.getFieldPermInitValidateBO().getErrMsgMap().putAll(fieldEmptyMap);
        }
    }

    private void setErrorCount(Map<String, Map<Integer, String>> logMap) {
        int idx;
        Set<String> roleLtSet = this.roleMap.get("importRoleList");
        Set<String> roleFuncSet = this.roleMap.get("importRoleFunc");
        Set<String> roleDimSet = this.roleMap.get("importRoleDim");
        Set<String> roleDtDmSet = this.roleMap.get("importRoleDataRange");
        Set<String> roleFiledSet = this.roleMap.get("importRoleFp");
        this.countMap.put("importRoleList", CollectionUtils.isEmpty(roleLtSet) ? 0 : roleLtSet.size());
        this.countMap.put("importRoleFunc", CollectionUtils.isEmpty(roleFuncSet) ? 0 : roleFuncSet.size());
        this.countMap.put("importRoleDim", CollectionUtils.isEmpty(roleDimSet) ? 0 : roleDimSet.size());
        this.countMap.put("importRoleDataRange", CollectionUtils.isEmpty(roleDtDmSet) ? 0 : roleDtDmSet.size());
        this.countMap.put("importRoleFp", CollectionUtils.isEmpty(roleFiledSet) ? 0 : roleFiledSet.size());
        List errorRoleNumList = this.validateBo.getErrorRoleNumList();
        Map<Integer, String> roleListEmptyMap = logMap.get("importRoleList");
        Map<Integer, String> dimEmptyMap = logMap.get("importRoleDim");
        Map<Integer, String> dataRangeEmptyMap = logMap.get("importRoleDataRange");
        Map<Integer, String> fieldEmptyMap = logMap.get("importRoleFp");
        int roleListEmpCount = 0;
        int roleDimEmpCount = 0;
        int roleDtRangeEmpCount = 0;
        int roleFieldEmpCount = 0;
        if (roleListEmptyMap != null && roleListEmptyMap.size() > 0) {
            roleListEmpCount = roleListEmptyMap.size();
        }
        if (dimEmptyMap != null && dimEmptyMap.size() > 0) {
            roleDimEmpCount = dimEmptyMap.size();
        }
        if (dataRangeEmptyMap != null && dataRangeEmptyMap.size() > 0) {
            roleDtRangeEmpCount = dataRangeEmptyMap.size();
        }
        if (fieldEmptyMap != null && fieldEmptyMap.size() > 0) {
            roleFieldEmpCount = fieldEmptyMap.size();
        }
        int roleListCount = (Integer)errorRoleNumList.get(0) + roleListEmpCount;
        int roleFuncCount = Math.max((Integer)errorRoleNumList.get(1), roleListCount);
        int roleDimCount = (Integer)errorRoleNumList.get(2) + roleDimEmpCount;
        int roleDtRangeCount = (Integer)errorRoleNumList.get(3) + roleDtRangeEmpCount;
        int roleFieldCount = (Integer)errorRoleNumList.get(4) + roleFieldEmpCount;
        if (roleListCount > 0) {
            for (idx = 0; idx < roleListCount; ++idx) {
                this.importLoggerMap.get("importRoleList").getLogCache().put(idx, Lists.newArrayList());
                this.hasError = true;
            }
        }
        if (roleFuncCount > 0) {
            for (idx = 0; idx < roleFuncCount; ++idx) {
                this.importLoggerMap.get("importRoleFunc").getLogCache().put(idx, Lists.newArrayList());
                this.hasError = true;
            }
        }
        if (roleDimCount > 0) {
            for (idx = 0; idx < roleDimCount; ++idx) {
                this.importLoggerMap.get("importRoleDim").getLogCache().put(idx, Lists.newArrayList());
                this.hasError = true;
            }
        }
        if (roleDtRangeCount > 0) {
            for (idx = 0; idx < roleDtRangeCount; ++idx) {
                this.importLoggerMap.get("importRoleDataRange").getLogCache().put(idx, Lists.newArrayList());
                this.hasError = true;
            }
        }
        if (roleFieldCount > 0) {
            for (idx = 0; idx < roleFieldCount; ++idx) {
                this.importLoggerMap.get("importRoleFp").getLogCache().put(idx, Lists.newArrayList());
                this.hasError = true;
            }
        }
    }

    private void setCacheError() {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get("Cached_Import_Logger");
        JSONObject map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        map.put("sysError", (Object)"1");
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put("Cached_Import_Logger", cachedLogStr);
        cache.saveChanges();
    }

    private void setSuccessFlag(String msg) {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        cache.put("success", msg);
    }
}

