/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleTemplateFieldMap;
import kd.hr.hrcs.common.model.perminit.ExcelCellInfo;

@ExcludeFromJacocoGeneratedReport
public class PermRoleImportSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(PermRoleImportSheetHandler.class);
    private ImportContext importContext;
    private String url;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private Map<Integer, String> nameRow;
    private Map<String, String> dataRangFieldNameRow = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, String> dimFieldNameRow = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Integer, String> funcNumRow;
    private SheetHandler.ParsedRow currentRow;
    private int importRoleListCount = 0;
    private int importRoleFuncCount = 0;
    private int importRoleDimCount = 0;
    private int importRoleDataRangeCount = 0;
    private int importRoleFpCount = 0;
    private Map<String, Integer> countMap;
    private Map<String, Long> dimMap;
    private List<Map<String, Object>> dealDims;
    private Set<String> sheetSet = Sets.newHashSetWithExpectedSize((int)5);
    private PermInitImportService permInitImportService = new PermInitImportService();
    private PermRoleInitImportService roleInitImportService = new PermRoleInitImportService();
    private Set<String> roleSet;
    private Table<String, Integer, List<ExcelCellInfo>> headerTb = HashBasedTable.create();
    private String errCellValue = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private String errCellValue2 = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private boolean hasError;
    private Map<String, Integer> funcRoleMap;
    private List<ExcelCellInfo> roleFunList = Lists.newArrayListWithExpectedSize((int)16);

    public PermRoleImportSheetHandler(ImportContext importContext, String url, Map<String, Integer> countMap, Map<String, Long> dimMap, Set<String> roleSet, Table<String, Integer, List<ExcelCellInfo>> headerTb, Map<String, Integer> funcRoleMap, List<ExcelCellInfo> roleFunList) {
        this.importContext = importContext;
        this.url = url;
        this.dataQueue = importContext.getDataQueue(url);
        this.countMap = countMap;
        this.dimMap = dimMap;
        this.permInitImportService.getOtDim(dimMap);
        this.roleSet = roleSet;
        this.headerTb = headerTb;
        this.funcRoleMap = funcRoleMap;
        this.roleFunList = roleFunList;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        String sheetName = row.getSheetName();
        String sheetKey = PermRoleTemplateFieldMap.getRoleTemplateSheetName((String)sheetName);
        if (!this.roleInitImportService.containsValue(this.roleInitImportService.dealSheetName(sheetName))) {
            return;
        }
        if (row.getData().size() == 0) {
            return;
        }
        this.addSheetData(row, sheetKey);
        this.initSheetInfo(row, sheetKey);
        this.initFunRole(row, sheetKey);
    }

    private void initFunRole(SheetHandler.ParsedRow row, String sheetKey) {
        if ("importRoleFunc".equals(sheetKey) && row.getRowNum() == 2) {
            this.funcNumRow.forEach((key, value) -> {
                if (key > 5) {
                    this.funcRoleMap.put((String)value, (Integer)key);
                }
            });
        }
    }

    private void initSheetInfo(SheetHandler.ParsedRow row, String sheetKey) {
        if (row.getRowNum() < 4 && !"importRoleDataRange".equals(sheetKey)) {
            this.initHeaderInfo(row, sheetKey);
        } else if (row.getRowNum() < 5 && "importRoleDataRange".equals(sheetKey)) {
            this.initHeaderInfo(row, sheetKey);
        } else if (row.getRowNum() < 3 && "importRoleFp".equals(sheetKey)) {
            this.initHeaderInfo(row, sheetKey);
        }
    }

    private void initHeaderInfo(SheetHandler.ParsedRow row, String sheetKey) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        LinkedHashMap<Integer, String> sortMap = new LinkedHashMap<Integer, String>(16);
        row.getData().keySet().stream().sorted().forEach(it -> {
            String cfr_ignored_0 = (String)sortMap.put((Integer)it, (String)row.getData().get(it));
        });
        sortMap.forEach((key, value) -> {
            if (key == 0 && value.equals(this.errCellValue)) {
                this.hasError = true;
            }
            if (!value.equals(this.errCellValue)) {
                ExcelCellInfo excelCellInfo = new ExcelCellInfo();
                list.add(excelCellInfo);
                excelCellInfo.setRowIndex(row.getRowNum());
                excelCellInfo.setName(value);
                excelCellInfo.setColIndex(this.hasError ? key - 1 : key);
                excelCellInfo.setHasErrorLine(this.hasError);
            }
        });
        this.headerTb.put((Object)sheetKey, (Object)row.getRowNum(), (Object)list);
    }

    private List<Map<String, Object>> initDims(Map<Integer, String> data) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        data.forEach((key, value) -> {
            if (value.contains("#")) {
                String[] arr = value.split("#");
                String col = arr[0];
                if (this.dimMap.containsKey(col)) {
                    HashMap<String, Object> dim = new HashMap<String, Object>(2);
                    dim.put("code", col);
                    dim.put("id", this.dimMap.get(col));
                    dim.put("ot", "Y");
                    dim.put("type", this.dimMap.get(arr[1]));
                    dim.put("oldCode", value);
                    list.add(dim);
                }
            } else if (this.dimMap.containsKey(value)) {
                HashMap<String, Object> dim = new HashMap<String, Object>(2);
                dim.put("code", value);
                dim.put("id", this.dimMap.get(value));
                dim.put("ot", "N");
                list.add(dim);
            }
        });
        return list;
    }

    private void addSheetData(SheetHandler.ParsedRow row, String sheetKey) {
        if (row.getRowNum() == 1) {
            this.nameRow = row.getData();
            if ("importRoleDataRange".equals(sheetKey)) {
                this.dealDims = this.initDims(row.getData());
            }
        }
        this.initDimExcelName(row, sheetKey);
        this.initDataRangeExcelName(row, sheetKey);
        this.initFuncPerm(row, sheetKey);
        if ("importRoleList".equals(sheetKey) && row.getRowNum() > 4) {
            ++this.importRoleListCount;
            this.dealRoleFun(row);
            this.addData(row, sheetKey);
        } else if ("importRoleFunc".equals(sheetKey) && row.getRowNum() > 3) {
            ++this.importRoleFuncCount;
            this.addData(row, sheetKey);
        } else if ("importRoleDim".equals(sheetKey) && row.getRowNum() > 3) {
            ++this.importRoleDimCount;
            this.addData(row, sheetKey);
        } else if ("importRoleDataRange".equals(sheetKey) && row.getRowNum() > 4) {
            ++this.importRoleDataRangeCount;
            this.addData(row, sheetKey);
        } else if ("importRoleFp".equals(sheetKey) && row.getRowNum() > 2) {
            ++this.importRoleFpCount;
            this.addData(row, sheetKey);
        }
    }

    private void dealRoleFun(SheetHandler.ParsedRow row) {
        if (this.hasError) {
            ExcelCellInfo cellInfo = new ExcelCellInfo();
            int col = this.getRoleNumberCol();
            cellInfo.setName((String)row.getData().get(col));
            cellInfo.setRowIndex(row.getRowNum());
            cellInfo.setColIndex(row.getRowNum() + 5);
            this.roleFunList.add(cellInfo);
        }
    }

    private int getRoleNumberCol() {
        for (Map.Entry<Integer, String> entry : this.nameRow.entrySet()) {
            if (!HRStringUtils.equals((String)entry.getValue(), (String)"roleNumber")) continue;
            return entry.getKey();
        }
        return 1;
    }

    private void initFuncPerm(SheetHandler.ParsedRow row, String sheetKey) {
        if ("importRoleFunc".equals(sheetKey) && row.getRowNum() == 2) {
            this.funcNumRow = row.getData();
        }
    }

    private void initDataRangeExcelName(SheetHandler.ParsedRow row, String sheetKey) {
        if ("importRoleDataRange".equals(sheetKey) && row.getRowNum() == 4) {
            Map data = row.getData();
            data.forEach((key, value) -> {
                String code = this.nameRow.get(key);
                if (HRStringUtils.isNotEmpty((String)code) && key > 3) {
                    this.dataRangFieldNameRow.put(code, (String)value);
                }
            });
        }
    }

    private void initDimExcelName(SheetHandler.ParsedRow row, String sheetKey) {
        if ("importRoleDim".equals(sheetKey) && row.getRowNum() == 3) {
            Map data = row.getData();
            data.forEach((key, value) -> {
                String code = this.nameRow.get(key);
                if (HRStringUtils.isNotEmpty((String)code) && key > 2) {
                    this.dimFieldNameRow.put(code, (String)value);
                }
            });
        }
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"PermImportSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        catch (InterruptedException exp) {
            LOG.error("resolve thread error\u3002", (Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"PermImportSheetHandler_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    private JSONObject fieldMapping(Map<Integer, String> data) {
        JSONObject rowObj = new JSONObject();
        data.forEach((key, value) -> {
            String val = this.nameRow.get(key);
            if (HRStringUtils.isEmpty((String)val)) {
                rowObj.put(key + "", value);
            } else {
                rowObj.put(this.nameRow.get(key), value);
            }
        });
        return rowObj;
    }

    private void addData(SheetHandler.ParsedRow row, String sheetKey) {
        JSONObject rowObj = new JSONObject();
        if ("importRoleDataRange".equals(sheetKey)) {
            if (CollectionUtils.isNotEmpty(this.dealDims)) {
                rowObj.put("hasDim", (Object)"Y");
                rowObj.put("dim", this.dealDims);
            } else {
                rowObj.put("hasDim", (Object)"N");
            }
        }
        if ("importRoleFunc".equals(sheetKey) && row.getRowNum() > 3) {
            this.initRoleSet();
            row.getData().forEach((key, value) -> {
                String vl = this.funcNumRow.get(key);
                if (!this.hasError) {
                    rowObj.put(vl, value);
                }
            });
        }
        if ("importRoleDataRange".equals(sheetKey)) {
            rowObj.put("dimExcelName", this.dataRangFieldNameRow);
        }
        if ("importRoleDataRange".equals(sheetKey) || "importRoleDim".equals(sheetKey)) {
            rowObj.put("dimExcelName", this.dimFieldNameRow);
        }
        rowObj.put("column", (Object)this.getColumnMap(sheetKey));
        rowObj.putAll((Map)this.fieldMapping(this.currentRow.getData()));
        rowObj.put("rowNum", (Object)row.getRowNum());
        rowObj.put("sheetKey", (Object)sheetKey);
        this.addBillData(new ImportBillData(rowObj, row.getRowNum(), row.getRowNum(), null));
    }

    private boolean hasError() {
        if (this.funcNumRow != null && this.funcNumRow.size() > 0) {
            for (Map.Entry<Integer, String> entry : this.funcNumRow.entrySet()) {
                if (!HRStringUtils.isNotEmpty((String)entry.getValue()) || !HRStringUtils.equals((String)this.errCellValue, (String)entry.getValue()) && !HRStringUtils.equals((String)this.errCellValue2, (String)entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void initRoleSet() {
        if (this.roleSet.size() == 0) {
            if (this.hasError) {
                this.roleSet.addAll(this.roleFunList.stream().filter(it -> HRStringUtils.isNotEmpty((String)it.getName())).map(ExcelCellInfo::getName).collect(Collectors.toSet()));
            } else {
                this.funcNumRow.forEach((key, value) -> {
                    if (key > 5) {
                        this.roleSet.add((String)value);
                    }
                });
            }
        }
    }

    private JSONObject getColumnMap(String sheetKey) {
        JSONObject rowObj = new JSONObject();
        if ("importRoleFunc".equals(sheetKey)) {
            this.funcNumRow.forEach((key, value) -> rowObj.put(value, key));
            this.nameRow.forEach((key, value) -> rowObj.put(value, key));
            return rowObj;
        }
        this.nameRow.forEach((key, value) -> rowObj.put(value, key));
        return rowObj;
    }

    public void endDocument() {
        boolean isContains = this.roleInitImportService.containsValue(this.roleInitImportService.dealSheetName(this.getSheetName()));
        if (this.currentRow != null && isContains) {
            this.sheetSet.add(this.getSheetName());
        }
        this.setInterrupt(false);
        if (this.sheetSet.size() == 5) {
            this.setInterrupt(true);
            this.countMap.put("importRoleList", this.importRoleListCount);
            this.countMap.put("importRoleFunc", this.importRoleFuncCount);
            this.countMap.put("importRoleDim", this.importRoleDimCount);
            this.countMap.put("importRoleDataRange", this.importRoleDataRangeCount);
            this.countMap.put("importRoleFp", this.importRoleFpCount);
            this.importContext.setResolveComplete(this.url);
            this.importContext.feedbackProgress(5, null, null);
        }
    }
}

