/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.formplugin.web.perm.init.PermRoleInitFuncPlugin;
import org.jetbrains.annotations.NotNull;

public class PermRoleInitDimPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitFuncPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map customParams = ((FormShowParameter)args.getSource()).getCustomParams();
        String recordId = (String)customParams.get("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            return;
        }
        EntryAp entryAp = this.createEntryAp(recordId);
        HashMap<String, String> mapEntry = new HashMap<String, String>(2);
        mapEntry.put("id", "roledimentrymodel");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            super.getEntityType(args);
        } else {
            MainEntityType oldMainType = args.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOGGER.error(cloneNotSupportedException.getMessage());
            }
            this.registerDynamicProps(newMainType, recordId);
            args.setNewEntityType(newMainType);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.freezeColumn();
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isNotEmpty((String)recordId)) {
            EntryAp entryAp = this.createEntryAp(recordId);
            IFormView formView = this.getView();
            EntryGrid entryGrid = (EntryGrid)formView.getControl("roledimentrymodel");
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            entryGrid.getItems().addAll(fieldEdits);
            this.getView().createControlIndex(entryGrid.getItems());
            this.paintInitData(recordId);
        }
    }

    private void freezeColumn() {
        EntryGrid grid = (EntryGrid)this.getControl("roledimentrymodel");
        grid.setColumnProperty("rdim_rolename", "isFixed", (Object)true);
        grid.setColumnProperty("rdim_bucafunc", "isFixed", (Object)true);
    }

    private void paintInitData(String recordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject initRecord = serviceHelper.queryOne((Object)recordId);
        this.paintDimEntry(initRecord, recordId);
    }

    private void paintDimEntry(DynamicObject initRecord, String recordId) {
        List dimCol = initRecord.getDynamicObjectCollection("roledimentry").stream().sorted(Comparator.comparing(dy -> dy.getString("rdim_rolenumber") + dy.getString("rdim_bucafunc.fname"))).collect(Collectors.toList());
        TableValueSetter dimValueSetter = new TableValueSetter(new String[]{"rdim_rolename", "rdim_bucafunc"});
        LinkedHashMap roleDimMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        LinkedHashMap roleFuncMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Object dynamicObject : dimCol) {
            String string = dynamicObject.getString("rdim_rolenumber");
            String funcId = dynamicObject.getString("rdim_bucafunc.id");
            String funcNumber = dynamicObject.getString("rdim_bucafunc.fnumber");
            String funcName = dynamicObject.getString("rdim_bucafunc.fname");
            if (HRStringUtils.equals((String)funcNumber, (String)"11")) {
                funcName = ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7", (String)"PermRoleInitDimPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            }
            String dimName = dynamicObject.getString("rdim_dimension.name");
            String dimId = dynamicObject.getString("rdim_dimension.id");
            String key = string + "#" + funcId;
            Set dimSet = roleDimMap.getOrDefault(key, new HashSet(16));
            dimSet.add(dimId);
            roleDimMap.put(key, dimSet);
            roleFuncMap.put(key, funcName);
        }
        Map<String, String> roleNameMap = this.getRoleNameMap(recordId);
        for (Map.Entry entry : roleFuncMap.entrySet()) {
            String roleName = roleNameMap.get(((String)entry.getKey()).split("#")[0]);
            String funcName = (String)entry.getValue();
            dimValueSetter.addRow(new Object[]{roleName, funcName});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("roledimentrymodel", dimValueSetter);
        Map<String, String> map = this.getDimMap(recordId);
        int index = 0;
        for (String key : roleFuncMap.keySet()) {
            Set dimSet = (Set)roleDimMap.get(key);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String dimId = entry.getKey();
                if (!CollectionUtils.isNotEmpty((Collection)dimSet) || !dimSet.contains(dimId)) continue;
                this.getModel().setValue(dimId, (Object)"\u221a", index);
            }
            ++index;
        }
        this.getModel().beginInit();
    }

    private void registerDynamicProps(MainEntityType newMainType, String recordId) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("roledimentrymodel");
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        regularColInfo.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
        Map<String, String> dimMap = this.getDimMap(recordId);
        dimMap.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
    }

    private EntryAp createEntryAp(String recordId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        Map<String, String> dimMap = this.getDimMap(recordId);
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        this.dynaAddColumn(entryAp, regularColInfo);
        this.dynaAddColumn(entryAp, dimMap);
        return entryAp;
    }

    private Map<String, String> getDimMap(String recordId) {
        String dimName;
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordItem = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection dimCol = recordItem.getDynamicObjectCollection("roledimentry");
        LinkedHashMap roleDimMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        LinkedHashMap tempRoleDimMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        HashSet dimNum = Sets.newHashSetWithExpectedSize((int)dimCol.size());
        for (DynamicObject dynamicObject : dimCol) {
            String dimId = dynamicObject.getString("rdim_dimension.id");
            dimName = dynamicObject.getString("rdim_dimension.name");
            dimNum.add(dynamicObject.getString("rdim_dimension.number"));
            if (!HRStringUtils.isNotEmpty((String)dimId) || !HRStringUtils.isNotEmpty((String)dimName)) continue;
            tempRoleDimMap.put(dimId, dimName);
        }
        List<DynamicObject> dimList = this.getDimList(dimNum);
        for (DynamicObject dim : dimList) {
            dimName = dim.getString("name");
            String dimId = dim.getString("id");
            if (!tempRoleDimMap.containsValue(dimName)) continue;
            roleDimMap.put(dimId, dimName);
        }
        return roleDimMap;
    }

    public List<DynamicObject> getDimList(Set<String> dimNumberSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (null != dimNumberSet) {
            qFilter.and(new QFilter("number", "in", dimNumberSet));
        }
        DynamicObject[] results = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList typeListWithSort = Lists.newArrayList((Object[])new String[]{"orgteam", "basedata", "hrbu", "enum"});
        TreeMap dimGroup = Maps.newTreeMap((k1, k2) -> {
            int index1 = typeListWithSort.indexOf(k1);
            int index2 = typeListWithSort.indexOf(k2);
            index1 = index1 == -1 ? 999 : index1;
            index2 = index2 == -1 ? 999 : index2;
            return index1 - index2;
        });
        for (DynamicObject result : results) {
            String type = result.getString("datasource");
            List dimList = dimGroup.getOrDefault(type, Lists.newArrayListWithExpectedSize((int)results.length));
            dimList.add(result);
            dimGroup.put(type, dimList);
        }
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)results.length);
        for (Map.Entry entry : dimGroup.entrySet()) {
            ((List)entry.getValue()).sort((x1, x2) -> {
                boolean x1Sys = x1.getBoolean("issyspreset");
                boolean x2Sys = x2.getBoolean("issyspreset");
                Date createTime1 = x1.getDate("createtime");
                Date createTime2 = x2.getDate("createtime");
                if (x1Sys == x2Sys) {
                    return createTime1.compareTo(createTime2);
                }
                if (x1Sys) {
                    return -1;
                }
                return 1;
            });
            dimList.addAll((Collection)entry.getValue());
        }
        return dimList;
    }

    @NotNull
    private Map<String, String> getRoleNameMap(String recordId) {
        IPageCache pageCache = this.getPageCache();
        String roleNameKey = recordId + "#" + "roleNameInfo";
        if (Objects.nonNull(pageCache) && HRStringUtils.isNotEmpty((String)pageCache.get(roleNameKey))) {
            return (Map)SerializationUtils.fromJsonString((String)pageCache.get(roleNameKey), Map.class);
        }
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordItem = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection roleBaseCol = recordItem.getDynamicObjectCollection("rolebaseentry");
        LinkedHashMap roleNameMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : roleBaseCol) {
            String rbaseName = dynamicObject.getString("rbase_name");
            String rbaseNumber = dynamicObject.getString("rbase_number");
            roleNameMap.put(rbaseNumber, rbaseName);
        }
        if (Objects.nonNull(pageCache)) {
            pageCache.put(roleNameKey, SerializationUtils.toJsonString((Object)roleNameMap));
        }
        return roleNameMap;
    }

    private Map<String, String> buildRegularColInfo() {
        LinkedHashMap<String, String> regularColInfo = new LinkedHashMap<String, String>(16);
        regularColInfo.put("rdim_rolename", ResManager.loadKDString((String)"\u89d2\u8272", (String)"PermRoleInitDimPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("rdim_bucafunc", ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"PermRoleInitDimPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        return regularColInfo;
    }

    private void dynaAddColumn(EntryAp entryAp, Map<String, String> colInfo) {
        for (Map.Entry<String, String> col : colInfo.entrySet()) {
            String key = col.getKey();
            String name = col.getValue();
            EntryFieldAp apMat = this.createTextFieldAp(key, name);
            entryAp.getItems().add(apMat);
        }
    }

    private EntryFieldAp createTextFieldAp(String key, String name) {
        EntryFieldAp apMat = new EntryFieldAp();
        apMat.setId(key);
        apMat.setKey(key);
        LocaleString localeName = new LocaleString(name);
        apMat.setName(localeName);
        TextField textField = new TextField();
        textField.setKey(key);
        textField.setId(key);
        textField.setName(localeName);
        apMat.setField((Field)textField);
        return apMat;
    }
}

