/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class PermRoleInitDrPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitDrPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map customParams = ((FormShowParameter)args.getSource()).getCustomParams();
        String recordId = (String)customParams.get("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            return;
        }
        EntryAp entryAp = this.createEntryAp(recordId);
        HashMap<String, String> mapEntry = new HashMap<String, String>(2);
        mapEntry.put("id", "roledataentrymodel");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            super.getEntityType(args);
        } else {
            MainEntityType oldMainType = args.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOGGER.error(cloneNotSupportedException.getMessage());
            }
            this.registerDynamicProps(newMainType, recordId);
            args.setNewEntityType(newMainType);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.freezeColumn();
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isNotEmpty((String)recordId)) {
            EntryAp entryAp = this.createEntryAp(recordId);
            IFormView formView = this.getView();
            EntryGrid entryGrid = (EntryGrid)formView.getControl("roledataentrymodel");
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            entryGrid.getItems().addAll(fieldEdits);
            this.getView().createControlIndex(entryGrid.getItems());
            this.paintInitData(recordId);
        }
    }

    private void freezeColumn() {
        EntryGrid grid = (EntryGrid)this.getControl("roledataentrymodel");
        grid.setColumnProperty("rdata_rolename", "isFixed", (Object)true);
        grid.setColumnProperty("rdata_bucafunc", "isFixed", (Object)true);
        grid.setColumnProperty("rdata_orgrange", "isFixed", (Object)true);
    }

    private void paintInitData(String recordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject initRecord = serviceHelper.queryOne((Object)recordId);
        this.paintDimEntry(initRecord, recordId);
    }

    private void paintDimEntry(DynamicObject initRecord, String recordId) {
        List dimCol = initRecord.getDynamicObjectCollection("roledataentry").stream().sorted(Comparator.comparing(dy -> dy.getString("rdata_rolenumber") + dy.getString("rdata_bucafunc.fname"))).collect(Collectors.toList());
        TableValueSetter dataValueSetter = new TableValueSetter(new String[]{"rdata_rolename", "rdata_bucafunc", "rdata_orgrange"});
        Map<String, String> roleNameMap = this.getRoleNameMap(recordId);
        ArrayList<Map<Long, List<String>>> dimValList = new ArrayList<Map<Long, List<String>>>(10);
        ArrayList<Map<Long, List<String>>> dimValListContainsSub = new ArrayList<Map<Long, List<String>>>(10);
        ArrayList<Map<Long, List<Long>>> dimValListWithDynaCond = new ArrayList<Map<Long, List<Long>>>(10);
        ArrayList<Map<String, List<Long>>> orgTeamDimValListWithDynaCond = new ArrayList<Map<String, List<Long>>>(10);
        HashMap<Long, List<String>> allDimValList = new HashMap<Long, List<String>>(16);
        ArrayList<Map<String, List<String>>> otDimValList = new ArrayList<Map<String, List<String>>>(10);
        ArrayList otDimValListContainsSub = Lists.newArrayListWithCapacity((int)16);
        ArrayList<List<String>> isAllDimValList = new ArrayList<List<String>>(10);
        for (DynamicObject dataRow : dimCol) {
            String roleNumber = dataRow.getString("rdata_rolenumber");
            String funcId = dataRow.getString("rdata_bucafunc.id");
            String funcName = dataRow.getString("rdata_bucafunc.fname");
            String funcNumber = dataRow.getString("rdata_bucafunc.fnumber");
            if (HRStringUtils.equals((String)funcNumber, (String)"11")) {
                funcName = ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7", (String)"PermRoleInitDrPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            }
            DynamicObjectCollection orgRange = dataRow.getDynamicObjectCollection("rdata_orgrange");
            String orgRangeContainsSub = dataRow.getString("rdata_orgcontainssubstr");
            String orgRangeInfo = PermInitServiceHelper.getOrgInfo((DynamicObject)dataRow, (DynamicObjectCollection)orgRange, (String)orgRangeContainsSub);
            dataValueSetter.addRow(new Object[]{roleNameMap.get(roleNumber), funcName, orgRangeInfo});
            DynamicObjectCollection dimValCol = dataRow.getDynamicObjectCollection("roledatavalentry");
            HashMap<Long, ArrayList<String>> temp = new HashMap<Long, ArrayList<String>>(16);
            HashMap<String, ArrayList<String>> tempOt = new HashMap<String, ArrayList<String>>(16);
            HashMap containsSubTempMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap dynaCondTempMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap orgTeamdynaCondTempMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap containsSubtempOtMap = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList<String> isAllTemp = new ArrayList<String>(dimValCol.size());
            for (DynamicObject dimVal : dimValCol) {
                String containsSubStr;
                String containsSubStr2;
                Long dimId = dimVal.getLong("rdata_dimension.id");
                String dimValId = dimVal.getString("rdata_dimval");
                String datasource = dimVal.getString("rdata_dimension.datasource");
                boolean isAll = dimVal.getBoolean("rdata_isall");
                boolean containsSub = dimVal.getBoolean("rdata_containssub");
                String dim_valtype = dimVal.getString("rdata_valtype");
                Long dim_dynacond = dimVal.getLong("rdata_dynacond.id");
                if (HRStringUtils.equals((String)"2", (String)dim_valtype)) {
                    if (HRStringUtils.equals((String)datasource, (String)"orgteam")) {
                        String otClassId = dimVal.getString("rdata_structproject.id");
                        String id = dimId + "#" + otClassId;
                        ArrayList<Long> orgTeamListTemp = (ArrayList<Long>)orgTeamdynaCondTempMap.get(id);
                        if (null == orgTeamListTemp) {
                            orgTeamListTemp = new ArrayList<Long>(10);
                            orgTeamListTemp.add(dim_dynacond);
                            orgTeamdynaCondTempMap.put(id, orgTeamListTemp);
                            continue;
                        }
                        orgTeamListTemp.add(dim_dynacond);
                        continue;
                    }
                    ArrayList<Long> valDynaCond = (ArrayList<Long>)dynaCondTempMap.get(dimId);
                    if (null == valDynaCond) {
                        valDynaCond = new ArrayList<Long>(10);
                        valDynaCond.add(dim_dynacond);
                        dynaCondTempMap.put(dimId, valDynaCond);
                        continue;
                    }
                    valDynaCond.add(dim_dynacond);
                    continue;
                }
                if (isAll) {
                    isAllTemp.add(String.valueOf(dimId));
                    continue;
                }
                ArrayList<String> vals = (ArrayList<String>)temp.get(dimId);
                ArrayList<String> valContainsSubs = (ArrayList<String>)containsSubTempMap.get(dimId);
                if (null == vals) {
                    vals = new ArrayList<String>(10);
                    vals.add(dimValId);
                    temp.put(dimId, vals);
                    if (valContainsSubs == null) {
                        valContainsSubs = new ArrayList(10);
                    }
                    containsSubStr2 = containsSub ? "1" : "0";
                    valContainsSubs.add(dimValId + "_" + containsSubStr2);
                    containsSubTempMap.put(dimId, valContainsSubs);
                } else {
                    vals.add(dimValId);
                    if (valContainsSubs == null) {
                        valContainsSubs = new ArrayList<String>(10);
                    }
                    containsSubStr2 = containsSub ? "1" : "0";
                    valContainsSubs.add(dimValId + "_" + containsSubStr2);
                    containsSubTempMap.put(dimId, valContainsSubs);
                }
                if (!HRStringUtils.equals((String)datasource, (String)"orgteam")) continue;
                String structprojectId = dimVal.getString("rdata_structproject.id");
                String id = dimId + "#" + structprojectId;
                ArrayList<String> values = (ArrayList<String>)tempOt.get(id);
                ArrayList<String> valuesContainsSubs = (ArrayList<String>)containsSubtempOtMap.get(id);
                if (null == values) {
                    values = new ArrayList<String>(10);
                    values.add(dimValId);
                    tempOt.put(id, values);
                    if (valuesContainsSubs == null) {
                        valuesContainsSubs = new ArrayList(10);
                    }
                    containsSubStr = containsSub ? "1" : "0";
                    valuesContainsSubs.add(dimValId + "_" + containsSubStr);
                    containsSubtempOtMap.put(id, valuesContainsSubs);
                    continue;
                }
                values.add(dimValId);
                if (valuesContainsSubs == null) {
                    valuesContainsSubs = new ArrayList<String>(10);
                }
                containsSubStr = containsSub ? "1" : "0";
                valuesContainsSubs.add(dimValId + "_" + containsSubStr);
                containsSubtempOtMap.put(id, valuesContainsSubs);
            }
            for (Map.Entry entry : temp.entrySet()) {
                Long key = (Long)entry.getKey();
                List value = (List)entry.getValue();
                List dimVals = (List)allDimValList.get(key);
                if (null == dimVals) {
                    allDimValList.put(key, Lists.newArrayList((Iterable)value));
                    continue;
                }
                dimVals.addAll(value);
            }
            dimValList.add(temp);
            dimValListContainsSub.add(containsSubTempMap);
            otDimValList.add(tempOt);
            otDimValListContainsSub.add(containsSubtempOtMap);
            dimValListWithDynaCond.add(dynaCondTempMap);
            orgTeamDimValListWithDynaCond.add(orgTeamdynaCondTempMap);
            isAllDimValList.add(isAllTemp);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("roledataentrymodel", dataValueSetter);
        this.getModel().beginInit();
        this.paintDynaDimCols(allDimValList, dimValList, otDimValList, isAllDimValList, dimValListContainsSub, otDimValListContainsSub, dimValListWithDynaCond, orgTeamDimValListWithDynaCond);
    }

    private void paintDynaDimCols(Map<Long, List<String>> allDimValList, List<Map<Long, List<String>>> dimValList, List<Map<String, List<String>>> otDimValList, List<List<String>> isAllDimValList, List<Map<Long, List<String>>> dimValListContainsSub, ArrayList<Map<String, List<String>>> otDimValListContainsSub, List<Map<Long, List<Long>>> dimValListWithDynaCond, List<Map<String, List<Long>>> orgTeamDimValListWithDynaCond) {
        ArrayList orgteamIds = Lists.newArrayListWithCapacity((int)16);
        for (Map<String, List<String>> map : otDimValList) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                orgteamIds.addAll(entry.getValue().stream().map(it -> Long.valueOf(it)).collect(Collectors.toList()));
            }
        }
        Map allDimInfo = PermInitServiceHelper.structDimInfoById(allDimValList, (List)orgteamIds);
        Map allDynaCondNameMap = PermInitServiceHelper.getAllDynaCondNameMap();
        this.getModel().beginInit();
        String separator = ";";
        for (int index = 0; index < dimValList.size(); ++index) {
            String key;
            String subEntryValue;
            ArrayList dynaValueName;
            List<Object> dynaValues;
            Long dimId;
            Map<Long, List<String>> valMap = dimValList.get(index);
            Map<Long, List<String>> valMapContainsSub = dimValListContainsSub.get(index);
            Map<String, List<String>> otValMapContainsSub = otDimValListContainsSub.get(index);
            Map<String, List<String>> otValMap = otDimValList.get(index);
            Map<Long, List<Long>> dimValWithDynaCondMap = dimValListWithDynaCond.get(index);
            Map<String, List<Long>> orgTeamDimValWithDynaCondMap = orgTeamDimValListWithDynaCond.get(index);
            int finalIndex = index;
            isAllDimValList.get(index).forEach(it -> this.getModel().setValue(it, (Object)"ALL", finalIndex));
            List otDimIds = otValMap.keySet().stream().map(it -> Long.valueOf(it.split("#")[0])).collect(Collectors.toList());
            for (Map.Entry<Long, List<String>> entry : valMap.entrySet()) {
                dimId = entry.getKey();
                List<String> valEntryContainsSub = valMapContainsSub.get(dimId);
                Map valInfo = (Map)allDimInfo.get(dimId);
                if (MapUtils.isEmpty((Map)valInfo) || otDimIds.contains(dimId)) continue;
                List<String> value = entry.getValue();
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)16);
                for (int i = 0; i < value.size(); ++i) {
                    String valName;
                    String dimVal = (String)value.get(i);
                    String dimValContainsSub = valEntryContainsSub.get(i);
                    if (dimValContainsSub.contains("_1")) {
                        if (!valInfo.containsKey(dimVal)) continue;
                        valName = (String)((Pair)valInfo.get(dimVal)).getKey();
                        arrayList.add(ResManager.loadKDString((String)"%s<\u5305\u542b\u4e0b\u7ea7>", (String)"PermRoleInitDrPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{valName}));
                        continue;
                    }
                    if (!valInfo.containsKey(dimVal)) continue;
                    valName = (String)((Pair)valInfo.get(dimVal)).getKey();
                    arrayList.add(valName);
                }
                this.getModel().setValue(String.valueOf(dimId), (Object)String.join((CharSequence)separator, arrayList), index);
            }
            for (Map.Entry<Long, List<Object>> entry : dimValWithDynaCondMap.entrySet()) {
                dimId = entry.getKey();
                if (otDimIds.contains(dimId)) continue;
                dynaValues = entry.getValue();
                dynaValueName = Lists.newArrayListWithCapacity((int)16);
                for (Long l : dynaValues) {
                    dynaValueName.add(allDynaCondNameMap.get(l));
                }
                subEntryValue = (String)this.getModel().getValue(String.valueOf(dimId), index);
                if (HRStringUtils.isEmpty((String)subEntryValue)) {
                    this.getModel().setValue(String.valueOf(dimId), (Object)String.join((CharSequence)separator, dynaValueName), index);
                    continue;
                }
                this.getModel().setValue(String.valueOf(dimId), (Object)(subEntryValue + separator + String.join((CharSequence)separator, dynaValueName)), index);
            }
            for (Map.Entry<Object, List<Object>> entry : otValMap.entrySet()) {
                key = (String)entry.getKey();
                List<String> otValues = otValMapContainsSub.get(key);
                String dimIdStr = key.split("#")[0];
                Map valInfo = (Map)allDimInfo.get(Long.valueOf(dimIdStr));
                if (MapUtils.isEmpty((Map)valInfo)) continue;
                List<Object> list = entry.getValue();
                ArrayList otValueContainsSubList = Lists.newArrayListWithCapacity((int)16);
                for (int i = 0; i < list.size(); ++i) {
                    String valName;
                    String otValue = (String)list.get(i);
                    String otValueContainsSub = otValues.get(i);
                    if (otValueContainsSub.contains("_1")) {
                        if (!valInfo.containsKey(otValue)) continue;
                        valName = (String)((Pair)valInfo.get(otValue)).getKey();
                        otValueContainsSubList.add(ResManager.loadKDString((String)"%s<\u5305\u542b\u4e0b\u7ea7>", (String)"PermRoleInitDrPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{valName}));
                        continue;
                    }
                    if (!valInfo.containsKey(otValue)) continue;
                    valName = (String)((Pair)valInfo.get(otValue)).getKey();
                    otValueContainsSubList.add(valName);
                }
                this.getModel().setValue(key, (Object)String.join((CharSequence)separator, otValueContainsSubList), index);
            }
            for (Map.Entry<Object, List<Object>> entry : orgTeamDimValWithDynaCondMap.entrySet()) {
                key = (String)entry.getKey();
                dynaValues = entry.getValue();
                dynaValueName = Lists.newArrayListWithCapacity((int)16);
                for (Long l : dynaValues) {
                    dynaValueName.add(allDynaCondNameMap.get(l));
                }
                subEntryValue = (String)this.getModel().getValue(key, index);
                if (HRStringUtils.isEmpty((String)subEntryValue)) {
                    this.getModel().setValue(key, (Object)String.join((CharSequence)separator, dynaValueName), index);
                    continue;
                }
                this.getModel().setValue(key, (Object)(subEntryValue + separator + String.join((CharSequence)separator, dynaValueName)), index);
            }
        }
        this.getModel().endInit();
    }

    @NotNull
    private Map<String, String> getRoleNameMap(String recordId) {
        IPageCache pageCache = this.getPageCache();
        String roleNameKey = recordId + "#" + "roleNameInfo";
        if (Objects.nonNull(pageCache) && HRStringUtils.isNotEmpty((String)pageCache.get(roleNameKey))) {
            return (Map)SerializationUtils.fromJsonString((String)pageCache.get(roleNameKey), Map.class);
        }
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordItem = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection roleBaseCol = recordItem.getDynamicObjectCollection("rolebaseentry");
        LinkedHashMap roleNameMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : roleBaseCol) {
            String rbaseName = dynamicObject.getString("rbase_name");
            String rbaseNumber = dynamicObject.getString("rbase_number");
            roleNameMap.put(rbaseNumber, rbaseName);
        }
        if (Objects.nonNull(pageCache)) {
            pageCache.put(roleNameKey, SerializationUtils.toJsonString((Object)roleNameMap));
        }
        return roleNameMap;
    }

    private void registerDynamicProps(MainEntityType newMainType, String recordId) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("roledataentrymodel");
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        regularColInfo.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
        HashMap<String, String> dynaDimInfos = new HashMap<String, String>(16);
        LinkedHashMap<String, LinkedHashMap<String, String>> orgTeamDimInfo = new LinkedHashMap<String, LinkedHashMap<String, String>>(16);
        this.getInitDims(recordId, dynaDimInfos, orgTeamDimInfo);
        for (Map map : orgTeamDimInfo.values()) {
            map.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
        }
        dynaDimInfos.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
    }

    private EntryAp createEntryAp(String recordId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        LinkedHashMap<String, String> dimensionInfos = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, LinkedHashMap<String, String>> orgTeamDimInfo = new LinkedHashMap<String, LinkedHashMap<String, String>>(16);
        this.queryInitDimensions(recordId, dimensionInfos, orgTeamDimInfo);
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        this.dynaAddColumn(entryAp, regularColInfo);
        this.createOtDim(entryAp, orgTeamDimInfo);
        this.dynaAddColumn(entryAp, dimensionInfos);
        return entryAp;
    }

    private void createOtDim(EntryAp entryAp, LinkedHashMap<String, LinkedHashMap<String, String>> orgTeamDimInfo) {
        if (MapUtils.isEmpty(orgTeamDimInfo)) {
            return;
        }
        for (Map.Entry<String, LinkedHashMap<String, String>> dimEntry : orgTeamDimInfo.entrySet()) {
            String key = dimEntry.getKey();
            String[] dimInfos = key.split("#");
            EntryFieldGroupAp otFieldGroupAp = new EntryFieldGroupAp();
            otFieldGroupAp.setId(key);
            otFieldGroupAp.setKey(key);
            otFieldGroupAp.setName(new LocaleString(dimInfos[1]));
            Map otMap = dimEntry.getValue();
            for (Map.Entry otEntry : otMap.entrySet()) {
                String otKey = (String)otEntry.getKey();
                EntryFieldAp textFieldAp = this.createTextFieldAp(otKey, (String)otEntry.getValue());
                otFieldGroupAp.getItems().add(textFieldAp);
            }
            entryAp.getItems().add(otFieldGroupAp);
        }
    }

    private void getInitDims(String recordId, Map<String, String> dynaDimInfos, LinkedHashMap<String, LinkedHashMap<String, String>> orgTeamDimInfo) {
        IPageCache pageCache = this.getPageCache();
        String dynaDimKey = recordId + "#" + "dynaDimInfos";
        String otDimKey = recordId + "#" + "orgTeamDimInfo";
        String dynaDimInfoStr = pageCache.get(dynaDimKey);
        String otDimInfoStr = pageCache.get(otDimKey);
        if (HRStringUtils.isNotEmpty((String)dynaDimInfoStr) && HRStringUtils.isNotEmpty((String)otDimInfoStr)) {
            dynaDimInfos.putAll((Map)SerializationUtils.fromJsonString((String)dynaDimInfoStr, Map.class));
            orgTeamDimInfo.putAll((Map)SerializationUtils.fromJsonString((String)otDimInfoStr, Map.class));
        } else {
            this.queryInitDimensions(recordId, dynaDimInfos, orgTeamDimInfo);
            pageCache.put(dynaDimKey, SerializationUtils.toJsonString(dynaDimInfos));
            pageCache.put(otDimKey, SerializationUtils.toJsonString(orgTeamDimInfo));
        }
    }

    private void queryInitDimensions(String recordId, Map<String, String> dimInfo, LinkedHashMap<String, LinkedHashMap<String, String>> orgTeamDimInfo) {
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject record = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection dataCol = record.getDynamicObjectCollection("roledataentry");
        List dimValCol = dataCol.stream().map(rt -> rt.getDynamicObjectCollection("roledatavalentry")).collect(Collectors.toList());
        HashSet dimNum = Sets.newHashSetWithExpectedSize((int)dimValCol.size());
        HashMap tempDimInfo = Maps.newHashMapWithExpectedSize((int)dimValCol.size());
        ArrayList structIds = Lists.newArrayListWithExpectedSize((int)16);
        for (Object col : dimValCol) {
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                DynamicObject dimRow = (DynamicObject)iterator.next();
                String dimName = dimRow.getString("rdata_dimension.name");
                dimNum.add(dimRow.getString("rdata_dimension.number"));
                if (HRStringUtils.isEmpty((String)dimName)) continue;
                String datasource = dimRow.getString("rdata_dimension.datasource");
                String dimId = dimRow.getString("rdata_dimension.id");
                if (!HRStringUtils.equals((String)datasource, (String)"orgteam")) {
                    tempDimInfo.put(dimId, dimName);
                    continue;
                }
                DynamicObject stType = dimRow.getDynamicObject("rdata_structproject");
                if (!Objects.nonNull(stType)) continue;
                String otId = stType.getString("id");
                String otName = stType.getString("name");
                String id = dimId + "#" + dimName;
                LinkedHashMap otMap = orgTeamDimInfo.computeIfAbsent(id, key -> Maps.newLinkedHashMapWithExpectedSize((int)16));
                otMap.put(dimId + "#" + otId, otName);
                structIds.add(Long.valueOf(otId));
            }
        }
        List<DynamicObject> dimList = this.getDimList(dimNum);
        for (DynamicObject dim : dimList) {
            String dimName = dim.getString("name");
            String dimId = dim.getString("id");
            if (!tempDimInfo.containsValue(dimName)) continue;
            dimInfo.put(dimId, dimName);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] sortedStruct = serviceHelper.query("id,name,number,otclassify.teamtype", new QFilter[]{new QFilter("id", "in", (Object)structIds), new QFilter("enable", "!=", (Object)"10")}, "createtime");
        LinkedHashMap tempOrgTeamDimInfo = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : sortedStruct) {
            String structName = dynamicObject.getString("name");
            for (Map.Entry entry : orgTeamDimInfo.entrySet()) {
                String dimId = (String)entry.getKey();
                LinkedHashMap otMap = tempOrgTeamDimInfo.computeIfAbsent(dimId, key -> Maps.newLinkedHashMapWithExpectedSize((int)16));
                for (Map.Entry structEntry : ((LinkedHashMap)entry.getValue()).entrySet()) {
                    String value = (String)structEntry.getValue();
                    if (!HRStringUtils.equals((String)structName, (String)value)) continue;
                    otMap.put(structEntry.getKey(), structName);
                }
            }
        }
        orgTeamDimInfo = tempOrgTeamDimInfo;
    }

    public List<DynamicObject> getDimList(Set<String> dimNumberSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (null != dimNumberSet) {
            qFilter.and(new QFilter("number", "in", dimNumberSet));
        }
        DynamicObject[] results = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList typeListWithSort = Lists.newArrayList((Object[])new String[]{"orgteam", "basedata", "hrbu", "enum"});
        TreeMap dimGroup = Maps.newTreeMap((k1, k2) -> {
            int index1 = typeListWithSort.indexOf(k1);
            int index2 = typeListWithSort.indexOf(k2);
            index1 = index1 == -1 ? 999 : index1;
            index2 = index2 == -1 ? 999 : index2;
            return index1 - index2;
        });
        for (DynamicObject result : results) {
            String type = result.getString("datasource");
            List dimList = dimGroup.getOrDefault(type, Lists.newArrayListWithExpectedSize((int)results.length));
            dimList.add(result);
            dimGroup.put(type, dimList);
        }
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)results.length);
        for (Map.Entry entry : dimGroup.entrySet()) {
            ((List)entry.getValue()).sort((x1, x2) -> {
                boolean x1Sys = x1.getBoolean("issyspreset");
                boolean x2Sys = x2.getBoolean("issyspreset");
                Date createTime1 = x1.getDate("createtime");
                Date createTime2 = x2.getDate("createtime");
                if (x1Sys == x2Sys) {
                    return createTime1.compareTo(createTime2);
                }
                if (x1Sys) {
                    return -1;
                }
                return 1;
            });
            dimList.addAll((Collection)entry.getValue());
        }
        return dimList;
    }

    private Map<String, String> buildRegularColInfo() {
        LinkedHashMap<String, String> regularColInfo = new LinkedHashMap<String, String>(16);
        regularColInfo.put("rdata_rolename", ResManager.loadKDString((String)"\u89d2\u8272", (String)"PermRoleInitDrPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("rdata_bucafunc", ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"PermRoleInitDrPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("rdata_orgrange", ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"PermRoleInitDrPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        return regularColInfo;
    }

    private void dynaAddColumn(EntryAp entryAp, Map<String, String> colInfo) {
        for (Map.Entry<String, String> col : colInfo.entrySet()) {
            String key = col.getKey();
            String name = col.getValue();
            EntryFieldAp apMat = this.createTextFieldAp(key, name);
            entryAp.getItems().add(apMat);
        }
    }

    private EntryFieldAp createTextFieldAp(String key, String name) {
        EntryFieldAp apMat = new EntryFieldAp();
        apMat.setId(key);
        apMat.setKey(key);
        LocaleString localeName = new LocaleString(name);
        apMat.setName(localeName);
        TextField textField = new TextField();
        textField.setKey(key);
        textField.setId(key);
        textField.setName(localeName);
        apMat.setField((Field)textField);
        return apMat;
    }
}

