/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.common.model.perminit.RoleInitFuncInfo;
import org.jetbrains.annotations.NotNull;

public class PermRoleInitFuncPlugin
extends HRDynamicFormBasePlugin
implements IListPlugin {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitFuncPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map customParams = ((FormShowParameter)args.getSource()).getCustomParams();
        String recordId = (String)customParams.get("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            return;
        }
        EntryAp entryAp = this.createEntryAp(recordId);
        HashMap<String, String> mapEntry = new HashMap<String, String>(2);
        mapEntry.put("id", "rolefuncentrymodel");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isEmpty((String)recordId)) {
            super.getEntityType(args);
        } else {
            MainEntityType oldMainType = args.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOGGER.error(cloneNotSupportedException.getMessage());
            }
            this.registerDynamicProps(newMainType, recordId);
            args.setNewEntityType(newMainType);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.freezeColumn();
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (HRStringUtils.isNotEmpty((String)recordId)) {
            EntryAp entryAp = this.createEntryAp(recordId);
            IFormView formView = this.getView();
            EntryGrid entryGrid = (EntryGrid)formView.getControl("rolefuncentrymodel");
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            entryGrid.getItems().addAll(fieldEdits);
            this.getView().createControlIndex(entryGrid.getItems());
            this.paintInitData(recordId);
        }
    }

    private void freezeColumn() {
        EntryGrid grid = (EntryGrid)this.getControl("rolefuncentrymodel");
        grid.setColumnProperty("rfunc_cloud", "isFixed", (Object)true);
        grid.setColumnProperty("rfunc_app", "isFixed", (Object)true);
        grid.setColumnProperty("rfunc_entitytype", "isFixed", (Object)true);
        grid.setColumnProperty("rfunc_permitem", "isFixed", (Object)true);
    }

    private void paintInitData(String recordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject initRecord = serviceHelper.queryOne((Object)recordId);
        this.paintDimEntry(initRecord, recordId);
    }

    private void paintDimEntry(DynamicObject initRecord, String recordId) {
        DynamicObjectCollection funcCol = initRecord.getDynamicObjectCollection("rolefuncentry");
        TableValueSetter permValueSetter = new TableValueSetter(new String[]{"rfunc_cloud", "rfunc_app", "rfunc_entitytype", "rfunc_permitem"});
        LinkedHashMap permItemRoleMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        LinkedHashMap permItemMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : funcCol) {
            String permItemId = dynamicObject.getString("rfunc_permitem.id");
            String permItemName = dynamicObject.getString("rfunc_permitem.name");
            String roleNumber = dynamicObject.getString("rfunc_rolenumber");
            String entityName = dynamicObject.getString("rfunc_entitytype.name");
            String entityId = dynamicObject.getString("rfunc_entitytype.id");
            String appName = dynamicObject.getString("rfunc_app.name");
            String appId = dynamicObject.getString("rfunc_app.id");
            String bizCloudName = dynamicObject.getString("rfunc_app.bizcloud.name");
            String bizCloudId = dynamicObject.getString("rfunc_app.bizcloud.id");
            permItemId = bizCloudId + "#" + appId + "#" + entityId + "#" + permItemId;
            Set roleSet = permItemRoleMap.getOrDefault(permItemId, new HashSet(16));
            roleSet.add(roleNumber);
            permItemRoleMap.put(permItemId, roleSet);
            permItemMap.put(permItemId, new RoleInitFuncInfo(bizCloudName, appName, entityName, permItemName));
        }
        for (Map.Entry entry : permItemMap.entrySet()) {
            RoleInitFuncInfo roleInitFuncInfo = (RoleInitFuncInfo)entry.getValue();
            permValueSetter.addRow(new Object[]{roleInitFuncInfo.getBizCloudName(), roleInitFuncInfo.getAppName(), roleInitFuncInfo.getEntityType(), roleInitFuncInfo.getPermItemName()});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("rolefuncentrymodel", permValueSetter);
        Map<String, String> roleNameMap = this.getRoleNameMap(recordId);
        int index = 0;
        for (Map.Entry itemEntry : permItemRoleMap.entrySet()) {
            Set roleSet = (Set)itemEntry.getValue();
            for (Map.Entry<String, String> entry : roleNameMap.entrySet()) {
                String roleNumber = entry.getKey();
                if (!CollectionUtils.isNotEmpty((Collection)roleSet) || !roleSet.contains(roleNumber)) continue;
                this.getModel().setValue(roleNumber, (Object)"\u221a", index);
            }
            ++index;
        }
        this.getModel().beginInit();
    }

    private void registerDynamicProps(MainEntityType newMainType, String recordId) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("rolefuncentrymodel");
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        regularColInfo.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
        Map<String, String> roleNameInfo = this.getRoleNameMap(recordId);
        roleNameInfo.keySet().forEach(it -> entryType.registerProperty(it, TextProp.class, (Object)"", false));
    }

    private EntryAp createEntryAp(String recordId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        Map<String, String> roleNameMap = this.getRoleNameMap(recordId);
        Map<String, String> regularColInfo = this.buildRegularColInfo();
        this.dynaAddColumn(entryAp, regularColInfo);
        this.dynaAddColumn(entryAp, roleNameMap);
        return entryAp;
    }

    @NotNull
    private Map<String, String> getRoleNameMap(String recordId) {
        IPageCache pageCache = this.getPageCache();
        String roleNameKey = recordId + "#" + "roleNameInfo";
        if (Objects.nonNull(pageCache) && HRStringUtils.isNotEmpty((String)pageCache.get(roleNameKey))) {
            return (Map)SerializationUtils.fromJsonString((String)pageCache.get(roleNameKey), Map.class);
        }
        HRBaseServiceHelper initRecord = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordItem = initRecord.queryOne((Object)recordId);
        DynamicObjectCollection roleBaseCol = recordItem.getDynamicObjectCollection("rolebaseentry");
        DynamicObjectCollection funcCol = recordItem.getDynamicObjectCollection("rolefuncentry");
        LinkedHashMap roleNameMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        List rfuncRolenumber = funcCol.stream().map(it -> it.getString("rfunc_rolenumber")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : roleBaseCol) {
            String rbaseName = dynamicObject.getString("rbase_name");
            String rbaseNumber = dynamicObject.getString("rbase_number");
            if (!rfuncRolenumber.contains(rbaseNumber)) continue;
            roleNameMap.put(rbaseNumber, rbaseName);
        }
        if (Objects.nonNull(pageCache)) {
            pageCache.put(roleNameKey, SerializationUtils.toJsonString((Object)roleNameMap));
        }
        return roleNameMap;
    }

    private void dynaAddColumn(EntryAp entryAp, Map<String, String> colInfo) {
        for (Map.Entry<String, String> col : colInfo.entrySet()) {
            String key = col.getKey();
            String name = col.getValue();
            EntryFieldAp apMat = this.createTextFieldAp(key, name);
            entryAp.getItems().add(apMat);
        }
    }

    private Map<String, String> buildRegularColInfo() {
        LinkedHashMap<String, String> regularColInfo = new LinkedHashMap<String, String>(16);
        regularColInfo.put("rfunc_cloud", ResManager.loadKDString((String)"\u4e91", (String)"PermRoleInitFuncPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("rfunc_app", ResManager.loadKDString((String)"\u5e94\u7528", (String)"PermRoleInitFuncPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("rfunc_entitytype", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"PermRoleInitFuncPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        regularColInfo.put("rfunc_permitem", ResManager.loadKDString((String)"\u6743\u9650\u9879", (String)"PermRoleInitFuncPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        return regularColInfo;
    }

    private EntryFieldAp createTextFieldAp(String key, String name) {
        EntryFieldAp apMat = new EntryFieldAp();
        apMat.setId(key);
        apMat.setKey(key);
        LocaleString localeName = new LocaleString(name);
        apMat.setName(localeName);
        TextField textField = new TextField();
        textField.setKey(key);
        textField.setId(key);
        textField.setName(localeName);
        apMat.setField((Field)textField);
        return apMat;
    }
}

