/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import java.awt.Color;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class AbstractWriter
extends ExcelWriter {
    private static final String DATE_FORMAT = "yyyy/M/d";
    private static final int THRESHOLD = 32000;

    public abstract Font getOriginalFont();

    protected String formatDate(Date date) {
        if (Objects.isNull(date)) {
            return "";
        }
        return HRDateTimeUtils.format((Date)date, (String)DATE_FORMAT);
    }

    public String[] getFunctionTypeNames() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        return (String[])Arrays.stream(serviceHelper.queryOriginalArray("name", new QFilter[]{new QFilter("id", "!=", (Object)618L)}, "number asc")).map(it -> it.getString("name")).toArray(String[]::new);
    }

    protected void setPinkBackground(SXSSFSheet sheet, int rowIndex, int colIndex, CellStyle originalCellStyle) {
        SXSSFCell cell = AbstractWriter.getRow((SXSSFSheet)sheet, (int)rowIndex).getCell(colIndex);
        if (null == cell) {
            cell = AbstractWriter.getRow((SXSSFSheet)sheet, (int)rowIndex).createCell(colIndex);
            cell.setCellStyle(originalCellStyle);
        }
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getCellStyle();
        XSSFCellStyle newCellStyle = (XSSFCellStyle)this.wb.createCellStyle();
        newCellStyle.cloneStyleFrom((CellStyle)cellStyle);
        newCellStyle.setFillForegroundColor(new XSSFColor(new Color(254, 239, 242), null));
        newCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell.setCellStyle((CellStyle)newCellStyle);
    }

    protected Cell addMergedRegionWithGrayBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.GREY_25_PERCENT.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.GREY_25_PERCENT.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.GREY_25_PERCENT.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.GREY_25_PERCENT.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        sheet.addMergedRegion(cellRange);
        return sheet.getRow(firstRow).getCell(firstCol);
    }

    protected Cell addMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(cellRange);
        CellUtil.getCell((Row)CellUtil.getRow((int)firstRow, (Sheet)sheet), (int)firstCol);
        Cell cell = sheet.getRow(firstRow).getCell(firstCol);
        cell.getCellStyle().setFont(this.getOriginalFont());
        cell.getCellStyle().setVerticalAlignment(VerticalAlignment.CENTER);
        cell.getCellStyle().setAlignment(HorizontalAlignment.LEFT);
        return cell;
    }

    protected Cell addMergeRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        sheet.addMergedRegion(cellRange);
        return sheet.getRow(firstRow).getCell(firstCol);
    }

    protected Cell addMergeRegionWithBlackBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        sheet.addMergedRegion(cellRange);
        return sheet.getRow(firstRow).getCell(firstCol);
    }

    protected Cell addMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addMergedRegion(sheet, firstRow, lastRow, firstCol, lastCol);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addMergedRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addMergeRegionWithWhiteBorder(sheet, firstRow, lastRow, firstCol, lastCol);
        for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
            for (int colIndex = firstCol; colIndex <= lastCol; ++colIndex) {
                sheet.getRow(rowIndex).getCell(colIndex).setCellStyle(cellStyle);
            }
        }
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addMergedRegionWithBlackBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addMergeRegionWithBlackBorder(sheet, firstRow, lastRow, firstCol, lastCol);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addMergedRegion(sheet, firstRow, lastRow, firstCol, lastCol, cellStyle, cellValue);
        Drawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(10, 10, 0, 0, firstCol, firstRow, firstCol + 4, firstRow + 6));
        XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
        xssRichTextString.applyFont(this.getOriginalFont());
        comment.setString((RichTextString)xssRichTextString);
        cell.setCellComment(comment);
        return cell;
    }

    protected Cell addMergedRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addMergedRegionWithWhiteBorder(sheet, firstRow, lastRow, firstCol, lastCol, cellStyle, cellValue);
        Drawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, firstCol, firstRow, firstCol + 4, firstRow + 6));
        XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
        xssRichTextString.applyFont(this.getOriginalFont());
        comment.setString((RichTextString)xssRichTextString);
        cell.setCellComment(comment);
        return cell;
    }

    protected Cell addMergedRegionWithBlackBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addMergedRegionWithBlackBorder(sheet, firstRow, lastRow, firstCol, lastCol, cellStyle, cellValue);
        Drawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(10, 10, 0, 0, firstCol, firstRow, firstCol + 4, firstRow + 6));
        XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
        xssRichTextString.applyFont(this.getOriginalFont());
        comment.setString((RichTextString)xssRichTextString);
        cell.setCellComment(comment);
        return cell;
    }

    protected Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell;
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        if (null == (cell = row.getCell(colIndex))) {
            cell = row.createCell(colIndex);
        }
        CellStyle cellstyle = cell.getCellStyle();
        cellstyle.setFont(this.getOriginalFont());
        cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellstyle.setAlignment(HorizontalAlignment.LEFT);
        return cell;
    }

    protected Cell addCellRegionWithWhiteBorder(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        cell.getCellStyle().setTopBorderColor(IndexedColors.WHITE.getIndex());
        cell.getCellStyle().setRightBorderColor(IndexedColors.WHITE.getIndex());
        cell.getCellStyle().setBottomBorderColor(IndexedColors.WHITE.getIndex());
        cell.getCellStyle().setLeftBorderColor(IndexedColors.WHITE.getIndex());
        return cell;
    }

    protected Cell addCellRegionWithBlackBorder(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        cell.getCellStyle().setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        cell.getCellStyle().setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        cell.getCellStyle().setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        cell.getCellStyle().setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        return cell;
    }

    protected Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, RichTextString cellValue) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(arg_0 -> ((Cell)cell).setCellValue(arg_0));
        return cell;
    }

    protected Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        if (HRStringUtils.isNotEmpty((String)tips)) {
            Drawing p = sheet.createDrawingPatriarch();
            Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(10, 10, 0, 0, colIndex, rowIndex, colIndex + 4, rowIndex + 6));
            XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
            xssRichTextString.applyFont(this.getOriginalFont());
            comment.setString((RichTextString)xssRichTextString);
            cell.setCellComment(comment);
        }
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addCellRegionWithWhiteBorder(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addCellRegionWithWhiteBorder(sheet, rowIndex, colIndex);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addCellRegionWithWhiteBorder(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addCellRegionWithWhiteBorder(sheet, rowIndex, colIndex, cellStyle, cellValue);
        if (HRStringUtils.isNotEmpty((String)tips)) {
            Drawing p = sheet.createDrawingPatriarch();
            Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(10, 10, 0, 0, colIndex, rowIndex, colIndex + 4, rowIndex + 6));
            XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
            xssRichTextString.applyFont(this.getOriginalFont());
            comment.setString((RichTextString)xssRichTextString);
            cell.setCellComment(comment);
        }
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    protected Cell addCellRegionWithBlackBorder(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addCellRegionWithBlackBorder(sheet, rowIndex, colIndex);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 32000) {
                cv = cv.substring(0, 32000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }
}

