/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.AbstractWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class DemoExcelWriter
extends AbstractWriter {
    private static final int SCENE1 = 10000;
    private static final int SCENE2 = 20000;
    private static final int SCENE3 = 30000;
    private static final int SCENE4 = 40000;
    private static final int SCENE5 = 50000;
    private ExportSheetStyle styles;
    private final Font originalFont;

    public DemoExcelWriter() {
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.styles = new ExportSheetStyle(this.wb, null);
        this.originalFont = this.wb.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        XSSFCellStyle tipsCellStyle = (XSSFCellStyle)this.styles.getTitleStyle();
        XSSFFont tipsFont = tipsCellStyle.getFont();
        tipsFont.setBold(true);
        tipsFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header");
        headerCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerCellFont = headerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerMustInputCellStyle = (XSSFCellStyle)this.styles.getTitleMustInputStyle();
        headerMustInputCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerMustInputCellStyle.setBorderTop(BorderStyle.THIN);
        headerMustInputCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderRight(BorderStyle.THIN);
        headerMustInputCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderBottom(BorderStyle.THIN);
        headerMustInputCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderLeft(BorderStyle.THIN);
        headerMustInputCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerMustInputFont = headerMustInputCellStyle.getFont();
        headerMustInputFont.setBold(true);
        headerMustInputFont.setFontHeightInPoints((short)12);
        headerMustInputFont.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle headerCenterCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header-center");
        headerCenterCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCenterCellStyle.setBorderTop(BorderStyle.THIN);
        headerCenterCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderRight(BorderStyle.THIN);
        headerCenterCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCenterCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCenterCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCenterCellFont = headerCenterCellStyle.getFont();
        headerCenterCellFont.setBold(true);
        headerCenterCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle commonColumnCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("body-common-column");
        commonColumnCellStyle.setFillForegroundColor(new XSSFColor(new Color(253, 233, 217), null));
        commonColumnCellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setBorderTop(BorderStyle.THIN);
        commonColumnCellStyle.setBorderRight(BorderStyle.THIN);
        commonColumnCellStyle.setBorderBottom(BorderStyle.THIN);
        commonColumnCellStyle.setBorderLeft(BorderStyle.THIN);
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        commonCellStyle1.setFont(this.originalFont);
        commonCellStyle1.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBorderTop(BorderStyle.THIN);
        commonCellStyle1.setBorderRight(BorderStyle.THIN);
        commonCellStyle1.setBorderBottom(BorderStyle.THIN);
        commonCellStyle1.setBorderLeft(BorderStyle.THIN);
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        commonCellStyle3.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setBorderTop(BorderStyle.THIN);
        commonCellStyle3.setBorderRight(BorderStyle.THIN);
        commonCellStyle3.setBorderBottom(BorderStyle.THIN);
        commonCellStyle3.setBorderLeft(BorderStyle.THIN);
        Font font = this.wb.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        commonCellStyle3.setFont(font);
    }

    @Override
    public Font getOriginalFont() {
        return this.originalFont;
    }

    private void setWhiteTopBorder(SXSSFSheet sheet, int rowIndex, int colIndex) {
        SXSSFCell cell = DemoExcelWriter.getRow((SXSSFSheet)sheet, (int)rowIndex).getCell(colIndex);
        CellStyle cellStyle = this.wb.createCellStyle();
        cellStyle.cloneStyleFrom(cell.getCellStyle());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        cell.setCellStyle(cellStyle);
    }

    public void addMemberRoleSheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addMemberRoleHeader(sheet);
        this.addMemberRoleSheetBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(8, 3616);
        sheet.setColumnWidth(9, 3616);
        sheet.setColumnWidth(10, 3616);
        sheet.setColumnWidth(11, 3616);
        sheet.setColumnWidth(12, 5000);
        sheet.setColumnWidth(13, 5000);
        sheet.setColumnWidth(14, 5000);
        sheet.setColumnWidth(15, 5000);
    }

    private void addMemberRoleHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u4e0d\u5141\u8bb8\u8c03\u6574\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6\u7684\u987a\u5e8f\uff1b4\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, 2).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, 3).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, 4).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, 5).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, 6).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, 7).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, 8).setCellValue("starttime");
        this.addCellRegion((Sheet)sheet, 1, 9).setCellValue("endtime");
        this.addCellRegion((Sheet)sheet, 1, 10).setCellValue("datascope");
        this.addCellRegion((Sheet)sheet, 1, 11).setCellValue("butype");
        this.addCellRegion((Sheet)sheet, 1, 12).setCellValue("buorg");
        this.addCellRegion((Sheet)sheet, 1, 13).setCellValue("adminorgteam#1010_S");
        this.addCellRegion((Sheet)sheet, 1, 14).setCellValue("adminorgteam#1020_S");
        this.addCellRegion((Sheet)sheet, 1, 15).setCellValue("payrollgrp");
        this.addCellRegion((Sheet)sheet, 1, 16).setCellValue("country");
        sheet.getRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        mustCellStyle.setWrapText(true);
        cellStyle.setWrapText(true);
        centerCellStyle.setWrapText(true);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 1, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 3, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 4, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 5, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 6, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 7, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 8, 8, mustCellStyle, ResManager.loadKDString((String)"*\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"PermSheetHelper_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u6309\u7167YYYY-MM-DD\u3001YYYY\u5e74MM\u6708DD\u65e5\u6216YYYY/MM/DD\u7684\u683c\u5f0f\u8f93\u5165\u6709\u6548\u671f\u3002", (String)"PermSheetHelper_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 9, 9, mustCellStyle, ResManager.loadKDString((String)"*\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"PermSheetHelper_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u6309\u7167YYYY-MM-DD\u3001YYYY\u5e74MM\u6708DD\u65e5\u6216YYYY/MM/DD\u7684\u683c\u5f0f\u8f93\u5165\u6709\u6548\u671f\u3002", (String)"PermSheetHelper_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 10, 10, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u8303\u56f4\u5c5e\u6027", (String)"PermSheetHelper_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u679c\u4e0b\u8f7d\u7684\u6570\u636e\u81ea\u5e26\u503c\uff0c\u5219\u8868\u793a\u89d2\u8272\u53ea\u5141\u8bb8\u6309\u5f53\u524d\u503c\u5bfc\u5165\uff1b\n\u5982\u679c\u4e0b\u8f7d\u7684\u89d2\u8272\u65e0\u503c\uff0c\u5219\u53ef\u9009\uff1a\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u6216\u81ea\u5b9a\u4e49\u8303\u56f4\u3002", (String)"PermSheetHelper_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 11, 11, mustCellStyle, ResManager.loadKDString((String)"*\u804c\u80fd\u7c7b\u578b", (String)"PermSheetHelper_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0b\u8f7d\u7684\u89d2\u8272\u81ea\u52a8\u8bc6\u522b\u804c\u80fd\u7c7b\u578b\u3002\n\u5982\u679c\u540c\u4e2a\u89d2\u8272\u67092\u884c\u8bb0\u5f55\uff0c\u5219\u8868\u793a\u89d2\u8272\u67092\u4e2a\u4e0d\u540c\u7684\u804c\u80fd\u7c7b\u578b\n\u6570\u636e\u5305\u62ec\uff1a", (String)"PermSheetHelper_97", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]) + "\n" + StringUtils.join((Object[])this.getFunctionTypeNames(), (String)"\n"));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 12, 12, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"PermSheetHelper_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u201c\u6570\u636e\u8303\u56f4\u5c5e\u6027\u201d\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\u65f6\uff0c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u5fc5\u987b\u586b\u5199\u3002\n\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002", (String)"PermSheetHelper_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, 13, 14, centerCellStyle, ResManager.loadKDString((String)"\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f", (String)"PermSheetHelper_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\norg2\u3010**\u516c\u53f8\u3011<\u5305\u542b\u4e0b\u7ea7>;\norg2<\u5305\u542b\u4e0b\u7ea7>\uff1b\n4\u3001\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u6570\u636e\u8303\u56f4\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\nDYNA_COND_10020\u3010\u4efb\u804c\u90e8\u95e8\u53ca\u4e0b\u7ea7\u90e8\u95e8\u3011\u3002", (String)"PermSheetHelper_50", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 4, 13, cellStyle, ResManager.loadKDString((String)"\u884c\u653f\u67b6\u6784", (String)"PermSheetHelper_42", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 4, 14, cellStyle, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u67b6\u6784", (String)"PermSheetHelper_43", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, 15, 15, centerCellStyle, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"PermSheetHelper_44", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, 16, 16, centerCellStyle, ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"PermSheetHelper_45", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, 13, 16, centerCellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u3010\u6570\u636e\u8303\u56f4\u5c5e\u6027=\u81ea\u5b9a\u4e49\u8303\u56f4\u3011\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6807\u8272\u533a\u57df\u7684\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_22", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addMemberRoleSheetBody(SXSSFSheet sheet) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)this.styles.getTitleStyle("body-common-column");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userdim");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,validstart,validstarttip,validend,validendtip,customenable,customenabletip,bucafunc,bucafunctip,orgrange,orgrangetip,dim_adminorg,dim_adminorgtip,dim_projectteam,dim_projectteamtip,dim_salarygroup,dim_salarygrouptip,dim_countryarea,dim_countryareatip", new QFilter[0], "sceneid,index");
        this.scene1(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 10, 10, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(10).setHeight((short)200);
        this.scene2(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 12, 12, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(12).setHeight((short)200);
        this.scene3(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 14, 14, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(14).setHeight((short)200);
        this.scene4(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 17, 17, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(17).setHeight((short)200);
        this.scene5(sheet, items);
    }

    private void scene1(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        XSSFCellStyle commonCellStyle2 = (XSSFCellStyle)this.styles.getTextStyle("body-common2");
        int rowIndex = 5;
        List newItems = Arrays.stream(items).filter(it -> 10000 == it.getInt("sceneid")).collect(Collectors.toList());
        for (DynamicObject item : newItems) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("customenable"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("bucafunc"));
            ++rowIndex;
        }
        this.addMergedRegion((Sheet)sheet, 5, 9, 0, 0, null, null);
        this.addMergedRegion((Sheet)sheet, 5, 9, 1, 1, (CellStyle)commonCellStyle2, null);
        this.setPinkBackground(sheet, 6, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 6, 15, commonCellStyle1);
        this.setPinkBackground(sheet, 7, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 7, 15, commonCellStyle1);
        this.setPinkBackground(sheet, 8, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 8, 14, commonCellStyle1);
    }

    private void scene2(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        DynamicObject item = Arrays.stream(items).filter(it -> 20000 == it.getInt("sceneid")).findAny().get();
        sheet.createRow(11).setRowStyle(commonCellStyle1);
        this.addCellRegion((Sheet)sheet, 11, 0, commonCellStyle1, item.getString("scenename"));
        this.addCellRegion((Sheet)sheet, 11, 1, commonCellStyle2, item.getString("scenedesc"));
        this.addCellRegion((Sheet)sheet, 11, 2, commonCellStyle1, item.getString("usernumber"));
        this.addCellRegion((Sheet)sheet, 11, 3, commonCellStyle1, item.getString("username"));
        this.addCellRegion((Sheet)sheet, 11, 4, commonCellStyle1, item.getString("fileorgnumber"));
        this.addCellRegion((Sheet)sheet, 11, 5, commonCellStyle1, item.getString("fileorgname"));
        this.addCellRegion((Sheet)sheet, 11, 6, commonCellStyle1, item.getString("rolenumber"));
        this.addCellRegion((Sheet)sheet, 11, 7, commonCellStyle1, item.getString("rolename"));
        this.addCellRegion((Sheet)sheet, 11, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
        this.addCellRegion((Sheet)sheet, 11, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
        this.addCellRegion((Sheet)sheet, 11, 10, commonCellStyle3, item.getString("customenable"));
        this.addCellRegion((Sheet)sheet, 11, 11, commonCellStyle1, item.getString("bucafunc"));
        XSSFCellStyle noLimitCellStyle = (XSSFCellStyle)this.wb.createCellStyle();
        noLimitCellStyle.cloneStyleFrom(commonCellStyle1);
        noLimitCellStyle.setAlignment(HorizontalAlignment.CENTER);
        Font font = this.wb.createFont();
        font.setColor(IndexedColors.GREY_25_PERCENT.getIndex());
        noLimitCellStyle.setFont(font);
        this.addMergedRegion((Sheet)sheet, 11, 11, 12, 16, (CellStyle)noLimitCellStyle, ResManager.loadKDString((String)"\u6b64\u533a\u57df\u65e0\u9700\u8bbe\u7f6e\u3002", (String)"PermSheetHelper_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6b64\u533a\u57df\u65e0\u9700\u8bbe\u7f6e\u3002", (String)"PermSheetHelper_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void scene3(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        DynamicObject item = Arrays.stream(items).filter(it -> 30000 == it.getInt("sceneid")).findAny().get();
        sheet.createRow(13).setRowStyle(commonCellStyle1);
        this.addCellRegion((Sheet)sheet, 13, 0, commonCellStyle1, item.getString("scenename"));
        this.addCellRegion((Sheet)sheet, 13, 1, commonCellStyle2, item.getString("scenedesc"));
        this.addCellRegion((Sheet)sheet, 13, 2, commonCellStyle1, item.getString("usernumber"));
        this.addCellRegion((Sheet)sheet, 13, 3, commonCellStyle1, item.getString("username"));
        this.addCellRegion((Sheet)sheet, 13, 4, commonCellStyle1, item.getString("fileorgnumber"));
        this.addCellRegion((Sheet)sheet, 13, 5, commonCellStyle1, item.getString("fileorgname"));
        this.addCellRegion((Sheet)sheet, 13, 6, commonCellStyle1, item.getString("rolenumber"));
        this.addCellRegion((Sheet)sheet, 13, 7, commonCellStyle1, item.getString("rolename"));
        this.addCellRegion((Sheet)sheet, 13, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
        this.addCellRegion((Sheet)sheet, 13, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
        this.addCellRegion((Sheet)sheet, 13, 10, commonCellStyle3, item.getString("customenable"));
        this.addCellRegion((Sheet)sheet, 13, 11, commonCellStyle1, item.getString("bucafunc"));
        this.addCellRegion((Sheet)sheet, 13, 12, commonCellStyle1, item.getString("orgrange").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
        this.addCellRegion((Sheet)sheet, 13, 13, commonCellStyle1, item.getString("dim_adminorg").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("dim_adminorgtip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n").replaceAll("\uff1a", "\uff1a\n"));
        this.addCellRegion((Sheet)sheet, 13, 15, commonCellStyle1, item.getString("dim_salarygroup").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("dim_salarygrouptip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
        this.setPinkBackground(sheet, 13, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 13, 15, commonCellStyle1);
    }

    private void scene4(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        boolean isFirst = true;
        int rowIndex = 15;
        List newItems = Arrays.stream(items).filter(it -> 40000 == it.getInt("sceneid")).collect(Collectors.toList());
        for (DynamicObject item : newItems) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, isFirst ? commonCellStyle2 : commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("customenable"), item.getString("customenabletip"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle3, item.getString("bucafunc").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle1, item.getString("orgrange").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle1, item.getString("dim_adminorg").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 14, commonCellStyle1, item.getString("dim_projectteam").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            ++rowIndex;
            isFirst = false;
        }
        this.addMergedRegion((Sheet)sheet, 15, 16, 0, 0, commonCellStyle1, null);
        DemoExcelWriter.getRow((SXSSFSheet)sheet, (int)16).getCell(1).getCellStyle().setBorderTop(BorderStyle.NONE);
        this.setWhiteTopBorder(sheet, 16, 1);
        this.setPinkBackground(sheet, 15, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 15, 14, commonCellStyle1);
    }

    private void scene5(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        boolean isFirst = true;
        int rowIndex = 18;
        List newItems = Arrays.stream(items).filter(it -> 50000 == it.getInt("sceneid")).collect(Collectors.toList());
        for (DynamicObject item : newItems) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, isFirst ? commonCellStyle2 : commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("customenable"), item.getString("customenabletip"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("bucafunc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle1, item.getString("orgrange").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle3, item.getString("dim_adminorg").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 15, commonCellStyle3, item.getString("dim_salarygroup").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            ++rowIndex;
            isFirst = false;
        }
        this.addMergedRegion((Sheet)sheet, 18, 19, 0, 0, commonCellStyle1, null);
        this.setWhiteTopBorder(sheet, 19, 1);
        this.setPinkBackground(sheet, 18, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 18, 15, commonCellStyle1);
        this.setPinkBackground(sheet, 19, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 19, 15, commonCellStyle1);
    }

    public void addCustomRoleDataRuleSheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addCustomRoleDataRuleHeader(sheet);
        this.addCustomRoleDataRuleBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(10, 3560);
        sheet.setColumnWidth(11, 3560);
        sheet.setColumnWidth(12, 2486);
        sheet.setColumnWidth(13, 3560);
        sheet.setColumnWidth(14, 3560);
    }

    private void addCustomRoleDataRuleHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u6743\u9650\u9879", (String)"PermSheetHelper_30", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"1\u3001\u5141\u8bb8\u5f55\u5165\u591a\u4e2a\u503c\n2\u3001\u503c\u4e3a\u7a7a\u65f6\uff0c\u9ed8\u8ba4\u89d2\u8272\u4e0b\u4e1a\u52a1\u5bf9\u8c61\u7684\u6240\u6709\u6743\u9650\u9879\u8303\u56f4\u90fd\u6309\u540c\u4e2a\u6570\u636e\u89c4\u5219\u65b9\u6848", (String)"PermSheetHelper_99", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 14, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRoleDataRuleBody(SXSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userdr");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,appnumber,appnumbertip,appname,appnametip,entitynumber,entitynumbertip,entityname,entitynametip,permitem,permitemtip,datarulenumber,datarulenumbertip,datarulename,datarulenametip", new QFilter[0], "sceneid,index");
        int rowIndex = 3;
        for (DynamicObject item : items) {
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle3, item.getString("permitem"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle3, item.getString("datarulenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 14, commonCellStyle3, item.getString("datarulename"));
            ++rowIndex;
        }
        this.addMergedRegion((Sheet)sheet, 5, 6, 0, 0, null, null);
        this.addMergedRegion((Sheet)sheet, 5, 6, 1, 1, null, null);
        sheet.getRow(rowIndex - 1).setHeight((short)1000);
    }

    public void addCustomRoleBaseDataDataScopePropertySheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addCustomRoleBaseDataDataScopePropertyHeader(sheet);
        this.addCustomRoleBaseDataDataScopePropertyBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(10, 3560);
        sheet.setColumnWidth(11, 3560);
        sheet.setColumnWidth(12, 3560);
        sheet.setColumnWidth(13, 3560);
        sheet.setColumnWidth(14, 4633);
        sheet.setColumnWidth(15, 4633);
    }

    private void addCustomRoleBaseDataDataScopePropertyHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u57fa\u7840\u8d44\u6599\u5c5e\u6027", (String)"PermSheetHelper_100", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, cellStyle, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"PermSheetHelper_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 14, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 15, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRoleBaseDataDataScopePropertyBody(SXSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userbd");
        DynamicObject item = serviceHelper.queryOne("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,appnumber,appnumbertip,appname,appnametip,entitynumber,entitynumbertip,entityname,entitynametip,propkey,propkeytip,propname,propnametip,datarulenumber,datarulenumbertip,datarulename,datarulenametip", new QFilter[0], "sceneid,index");
        if (null != item) {
            this.addCellRegion((Sheet)sheet, 3, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, 3, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, 3, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, 3, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, 3, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, 3, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, 3, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, 3, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, 3, 8, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, 3, 9, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, 3, 10, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, 3, 11, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, 3, 12, commonCellStyle3, item.getString("propkey"));
            this.addCellRegion((Sheet)sheet, 3, 13, commonCellStyle3, item.getString("propname"));
            this.addCellRegion((Sheet)sheet, 3, 14, commonCellStyle3, item.getString("datarulenumber"));
            this.addCellRegion((Sheet)sheet, 3, 15, commonCellStyle3, item.getString("datarulename"));
        }
    }

    public void addCustomRolePropertyPermSheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addCustomRolePropertyPermHeader(sheet);
        this.addCustomRolePropertyPermBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(10, 3560);
        sheet.setColumnWidth(11, 3560);
    }

    private void addCustomRolePropertyPermHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u5b57\u6bb5\u5c5e\u6027", (String)"PermSheetHelper_101", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, cellStyle, ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"PermSheetHelper_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 14, mustCellStyle, ResManager.loadKDString((String)"*\u67e5\u770b", (String)"PermSheetHelper_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002", (String)"PermSheetHelper_55", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 15, mustCellStyle, ResManager.loadKDString((String)"*\u7f16\u8f91", (String)"PermSheetHelper_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f55\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\n\u5f55\u5165\u8981\u6c42\uff1a\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PermSheetHelper_56", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRolePropertyPermBody(SXSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userfld");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,appnumber,appnumbertip,appname,appnametip,entitynumber,entitynumbertip,entityname,entitynametip,propkey,propkeytip,propname,propnametip,canread,canreadtip,canwrite,canwritetip", new QFilter[0], "sceneid,index");
        int rowIndex = 3;
        for (DynamicObject item : items) {
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle1, item.getString("propkey"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle1, item.getString("propname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 14, commonCellStyle3, item.getString("canread"));
            this.addCellRegion((Sheet)sheet, rowIndex, 15, commonCellStyle3, item.getString("canwrite"));
            ++rowIndex;
        }
    }
}

