/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.formplugin.web.perm.init.excel.MemberRoleSheet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PermHelper {
    private static final Log LOGGER = LogFactory.getLog(PermHelper.class);

    public static List<MemberRoleSheet> getRole(Consumer<Triple<String, Long, Long>> feedbackProgress, List<MemberRoleSheet> memberRoleSheetList, boolean queryDimValue) {
        return PermHelper.getRole(feedbackProgress, memberRoleSheetList, queryDimValue, true);
    }

    public static List<MemberRoleSheet> getRole(Consumer<Triple<String, Long, Long>> feedbackProgress, List<MemberRoleSheet> memberRoleSheetList, boolean queryDimValue, boolean generateForEmptyDimGroup) {
        Set roleIds = memberRoleSheetList.stream().map(MemberRoleSheet::getRoleId).collect(Collectors.toSet());
        HRBaseServiceHelper roleFunHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        Map hrFunMap = Arrays.stream(roleFunHelper.query("role,hrbucafunc", new QFilter[]{new QFilter("role", "in", roleIds)})).map(it -> Pair.of((Object)it.getString("role"), (Object)it.getLong("hrbucafunc"))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
        Set allFunIds = hrFunMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        HRBaseServiceHelper hrFunHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        Map<Long, String> allFunMap = Arrays.stream(hrFunHelper.query("id,name", new QFilter[]{new QFilter("id", "in", allFunIds)})).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("name")));
        LOGGER.info("Got role data with hrFunMap: {}, allFunMap: {}.", hrFunMap, allFunMap);
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)30L));
        Map<String, Set> roleFunMap = hrFunMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((Set)it.getValue()).stream().map(funId -> new MemberRoleSheet.FunctionType((Long)funId, (String)allFunMap.get(funId), (Set<Triple<String, String, Boolean>>)new HashSet<Triple<String, String, Boolean>>(), (List<MemberRoleSheet.Dim>)new ArrayList<MemberRoleSheet.Dim>())).collect(Collectors.toSet()), (oldValue, newValue) -> oldValue));
        HRBaseServiceHelper roleDimensionHelper = new HRBaseServiceHelper("hrcs_roledimension");
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        HRBaseServiceHelper userRoleBuHelper = new HRBaseServiceHelper("hrcs_userrole");
        List roleDimensionFilterList = memberRoleSheetList.stream().flatMap(role -> {
            Set roleFunSet = roleFunMap.getOrDefault(role.getRoleId(), new HashSet());
            role.setFuns(roleFunSet.stream().map(MemberRoleSheet.FunctionType::clone).collect(Collectors.toSet()));
            return roleFunSet.stream().map(fun -> Pair.of((Object)role.getRoleId(), (Object)fun.getId()));
        }).collect(Collectors.toList());
        LOGGER.info("Got role dimension filter str size: {}.", (Object)roleDimensionFilterList.size());
        HashMap roleDimensionMap = new HashMap();
        HashMap roleBuMap = new HashMap();
        Lists.partition(roleDimensionFilterList, (int)100).forEach(roleDimensionFilterItem -> {
            String roleDimensionFilterStr = roleDimensionFilterItem.stream().map(fl -> "(role.id = '" + (String)fl.getKey() + "' and bucafunc.id = " + fl.getValue() + ")").reduce((acc, item) -> acc + " or " + item).orElse("1!=1");
            QFilter roleDimensionFilter = QFilter.of((String)roleDimensionFilterStr, (Object[])new Object[0]);
            roleDimensionMap.putAll(Arrays.stream(roleDimensionHelper.query("role.id,bucafunc.id,dimension.id,dimension.name,dimension.number,dimension.enable,dimension.datasource,entry.entitytype", new QFilter[]{roleDimensionFilter})).collect(Collectors.groupingBy(it -> it.getString("role.id") + "#" + it.getString("bucafunc.id"))));
            if (!queryDimValue || !generateForEmptyDimGroup) {
                String roleBuFilterStr = roleDimensionFilterItem.stream().map(fl -> "(role = '" + (String)fl.getKey() + "' and hrbucafunc = " + fl.getValue() + ")").reduce((acc, item) -> acc + " or " + item).orElse("1!=1");
                QFilter roleBuFilter = QFilter.of((String)roleBuFilterStr, (Object[])new Object[0]);
                roleBuMap.putAll(Arrays.stream(roleBuHelper.query("org.id,org.name,org.number,role,hrbucafunc,containssub", new QFilter[]{roleBuFilter})).collect(Collectors.groupingBy(it -> it.getString("role") + "#" + it.getString("hrbucafunc"))));
            }
        });
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)40L));
        LOGGER.info("Got role data with roleDimensionMap: {}, roleBuMap: {}.", roleDimensionMap, roleBuMap);
        HRBaseServiceHelper roleDimGroupHelper = new HRBaseServiceHelper("hrcs_roledimgrp");
        HRBaseServiceHelper userRoleDimGroupHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        long memberCount = memberRoleSheetList.stream().filter(role -> Objects.nonNull(role.getFuns())).count();
        BigDecimal perItemCount = memberCount > 0L ? new BigDecimal(50).divide(new BigDecimal(memberCount), 5, RoundingMode.HALF_DOWN) : new BigDecimal(0);
        AtomicInteger index = new AtomicInteger(1);
        LOGGER.info("start.");
        HashMap structProConfigMap = new HashMap();
        AtomicBoolean initEmptyStructConfig = new AtomicBoolean(false);
        Map allDynaCondNameMap = PermInitServiceHelper.getAllDynaCondNameMap();
        Map allDynaCondMapIdNumber = PermInitServiceHelper.getAllDynaCondMapIdNumber();
        LOGGER.info("end.");
        return memberRoleSheetList.stream().filter(role -> Objects.nonNull(role.getFuns())).peek(role -> {
            feedbackProgress.accept(Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)(40L + (long)perItemCount.multiply(new BigDecimal(index.getAndIncrement())).intValue())));
            role.getFuns().forEach(fun -> {
                String key = role.getRoleId() + "#" + fun.getId();
                AtomicLong defaultGroupId = new AtomicLong(0L);
                List dims = ((List)roleDimensionMap.getOrDefault(key, new ArrayList())).stream().map(dimension -> {
                    DynamicObject[] roleDimensions;
                    if (null != role.getMemberRoleRelateId() && 0L != role.getMemberRoleRelateId()) {
                        roleDimensions = userRoleDimGroupHelper.query("id,entry.dimension,entry.otclassify,entry.structproject,entry.isall,entry.dimval,entry.valtype,entry.dynacond,entry.containssub", new QFilter[]{new QFilter("userrolerelat.id", "=", (Object)role.getMemberRoleRelateId()), new QFilter("bucafunc.id", "=", (Object)fun.getId()), new QFilter("entry.dimension.id", "=", (Object)dimension.getLong("dimension.id"))});
                        if (roleDimensions.length <= 0) {
                            roleDimensions = new DynamicObject[]{userRoleDimGroupHelper.generateEmptyDynamicObject()};
                        } else {
                            defaultGroupId.set(roleDimensions[0].getLong("id"));
                        }
                    } else {
                        roleDimensions = generateForEmptyDimGroup ? new DynamicObject[]{roleDimGroupHelper.generateEmptyDynamicObject()} : roleDimGroupHelper.query("id,entry.dimension,entry.otclassify,entry.structproject,entry.isall,entry.dimval,entry.valtype,entry.dynacond,entry.containssub", new QFilter[]{new QFilter("role.id", "=", (Object)role.getRoleId()), new QFilter("bucafunc.id", "=", (Object)fun.getId()), new QFilter("entry.dimension.id", "=", (Object)dimension.getLong("dimension.id"))});
                    }
                    return Arrays.stream(roleDimensions).map(roleDimension -> {
                        Set<Object> structProject = new HashSet<Triple<String, String, List<DimValueBean>>>();
                        String dataSource = dimension.getString("dimension.datasource");
                        boolean isAll = false;
                        ArrayList<DimValueBean> dimValueBeans = new ArrayList<DimValueBean>();
                        ArrayList dimValueBeanList = Lists.newArrayListWithCapacity((int)16);
                        LOGGER.info("Got role dim data with role-id: {}, func-id: {}, dimension-id: {}, role-dimension: {}.", new Object[]{role.getRoleId(), fun.getId(), dimension.getLong("dimension.id"), roleDimension});
                        if (queryDimValue) {
                            HashMap<Long, List> dimValueList = new HashMap<Long, List>(16);
                            DynamicObjectCollection dimensionDynamicObjectCollection = roleDimension.getDynamicObjectCollection("entry");
                            List orderDimValEntry = dimensionDynamicObjectCollection.stream().sorted((o1, o2) -> o2.getString("valtype").compareTo(o1.getString("valtype"))).collect(Collectors.toList());
                            for (Object roleDimGroupEntry2 : orderDimValEntry) {
                                if (dimension.getLong("dimension.id") != roleDimGroupEntry2.getLong("dimension.id")) continue;
                                isAll = roleDimGroupEntry2.getBoolean("isall");
                                String dimVal = roleDimGroupEntry2.getString("dimval");
                                if (!isAll && HRStringUtils.isNotEmpty((String)dimVal)) {
                                    dimValueList.computeIfAbsent(roleDimGroupEntry2.getLong("dimension.id"), k -> new ArrayList(10)).add(roleDimGroupEntry2.getString("dimval"));
                                }
                                DimValueBean dimValueBean = new DimValueBean(Long.valueOf(roleDimGroupEntry2.getLong("dimension.id")), Long.valueOf(roleDimGroupEntry2.getLong("otclassify.id")), dimVal, roleDimGroupEntry2.getString("valtype"), roleDimGroupEntry2.getBoolean("containssub"), Long.valueOf(roleDimGroupEntry2.getLong("dynacond.id")));
                                dimValueBeanList.add(dimValueBean);
                            }
                            Map dimValueMap = PermInitServiceHelper.structDimInfo(dimValueList);
                            for (DimValueBean dimValueBean : dimValueBeanList) {
                                Pair stringStringPair;
                                String valueType = dimValueBean.getValueType();
                                if (HRStringUtils.equals((String)"2", (String)valueType)) {
                                    dimValueBean.setDimValName((String)allDynaCondNameMap.get(Long.valueOf(dimValueBean.getDimVal())));
                                    dimValueBean.setDimValCode((String)allDynaCondMapIdNumber.get(Long.valueOf(dimValueBean.getDimVal())));
                                    continue;
                                }
                                Map stringPairMap = (Map)dimValueMap.get(dimValueBean.getDimId());
                                if (null == stringPairMap || null == (stringStringPair = (Pair)stringPairMap.get(dimValueBean.getDimVal()))) continue;
                                dimValueBean.setDimValCode((String)stringStringPair.getValue());
                                dimValueBean.setDimValName((String)stringStringPair.getKey());
                            }
                            if (HRStringUtils.equals((String)"orgteam", (String)dataSource)) {
                                Map currentDimValueMap = dimValueMap.getOrDefault(dimension.getLong("dimension.id"), new HashMap(16));
                                Map<String, List<DynamicObject>> listMap = roleDimension.getDynamicObjectCollection("entry").stream().sorted((o1, o2) -> o2.getString("valtype").compareTo(o1.getString("valtype"))).filter(roleDimGroupEntry -> roleDimGroupEntry.getLong("dimension.id") == dimension.getLong("dimension.id") && HRStringUtils.isNotEmpty((String)roleDimGroupEntry.getString("structproject.number"))).collect(Collectors.groupingBy(roleDimGroupEntry -> roleDimGroupEntry.getString("structproject.number") + "#" + roleDimGroupEntry.getString("structproject.name")));
                                if (listMap.isEmpty()) {
                                    if (!initEmptyStructConfig.get()) {
                                        LOGGER.info("Start init empyt struct config.");
                                        structProConfigMap.putAll(PermHelper.queryStructProConfig());
                                        initEmptyStructConfig.set(true);
                                    }
                                    structProject = PermHelper.getEmptyStructProject(role.getRoleId(), dimension.getLong("dimension.id"), fun.getId(), structProConfigMap);
                                } else {
                                    LOGGER.info("currentDimValueMap: {}, listMap: {}", (Object)currentDimValueMap, listMap);
                                    structProject = listMap.entrySet().stream().map(entry -> {
                                        String structProjectNumber = ((String)entry.getKey()).split("#")[0];
                                        String structProjectName = ((String)entry.getKey()).split("#")[1];
                                        ArrayList structDimValBeans = Lists.newArrayListWithCapacity((int)16);
                                        for (DynamicObject dynamicObject : (List)entry.getValue()) {
                                            DimValueBean dimStructValueBean;
                                            String dimval = dynamicObject.getString("dimval");
                                            boolean containssub = dynamicObject.getBoolean("containssub");
                                            String valueType = dynamicObject.getString("valtype");
                                            Long dynacond = dynamicObject.getLong("dynacond.id");
                                            if (HRStringUtils.equals((String)"2", (String)valueType)) {
                                                dimStructValueBean = new DimValueBean();
                                                structDimValBeans.add(dimStructValueBean);
                                                dimStructValueBean.setDimValName((String)allDynaCondNameMap.get(Long.valueOf(dimval)));
                                                dimStructValueBean.setDimValCode((String)allDynaCondMapIdNumber.get(Long.valueOf(dimval)));
                                                dimStructValueBean.setContainsSub(containssub);
                                                dimStructValueBean.setValueType(valueType);
                                                dimStructValueBean.setDynacondId(dynacond);
                                                dimStructValueBean.setDimVal(dynacond.toString());
                                                continue;
                                            }
                                            if (null == dimval) continue;
                                            dimStructValueBean = new DimValueBean();
                                            structDimValBeans.add(dimStructValueBean);
                                            Pair stringStringPair = (Pair)currentDimValueMap.get(dimval);
                                            if (stringStringPair == null) continue;
                                            dimStructValueBean.setDimValCode((String)stringStringPair.getValue());
                                            dimStructValueBean.setDimValName((String)stringStringPair.getKey());
                                            dimStructValueBean.setContainsSub(containssub);
                                        }
                                        return Triple.of((Object)structProjectNumber, (Object)structProjectName, (Object)structDimValBeans);
                                    }).collect(Collectors.toSet());
                                }
                            } else {
                                dimValueBeans.addAll(dimValueBeanList);
                            }
                        }
                        return new MemberRoleSheet.Dim(roleDimension.getLong("id"), dimension.getLong("dimension.id"), dimension.getString("dimension.name"), dimension.getString("dimension.number"), dimension.getInt("dimension.enable"), dimension.getString("dimension.datasource"), structProject, isAll, dimValueBeans);
                    }).collect(Collectors.toList());
                }).flatMap(Collection::stream).collect(Collectors.toList());
                fun.setDims(dims.stream().peek(dim -> {
                    if (dim.getGroupId() == 0L && defaultGroupId.get() != 0L) {
                        dim.setGroupId(defaultGroupId.get());
                    }
                }).collect(Collectors.toList()));
                if (generateForEmptyDimGroup) {
                    if (queryDimValue) {
                        fun.setBuOrgs(Arrays.stream(userRoleBuHelper.query("org.number,org.name,includesuborg", new QFilter[]{new QFilter("userrolerealt.id", "=", (Object)role.getMemberRoleRelateId()), new QFilter("bucafunc", "=", (Object)fun.getId())})).map(bu -> Triple.of((Object)bu.getString("org.number"), (Object)bu.getString("org.name"), (Object)bu.getBoolean("includesuborg"))).collect(Collectors.toSet()));
                    } else {
                        fun.setBuOrgs(((List)roleBuMap.getOrDefault(key, new ArrayList())).stream().map(bu -> Triple.of((Object)bu.getString("org.number"), (Object)bu.getString("org.name"), (Object)bu.getBoolean("containssub"))).collect(Collectors.toSet()));
                    }
                } else {
                    fun.setBuOrgs(((List)roleBuMap.getOrDefault(key, new ArrayList())).stream().map(bu -> Triple.of((Object)bu.getString("org.number"), (Object)bu.getString("org.name"), (Object)bu.getBoolean("containssub"))).collect(Collectors.toSet()));
                }
            });
        }).collect(Collectors.toList());
    }

    public static List<MemberRoleSheet> getRoleMemberByRoleIds(Consumer<Triple<String, Long, Long>> feedbackProgress, Object[] roleIds, QFilter[] filterArr) {
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)5L));
        DynamicObject[] userRoleRelates = PermHelper.getUserRelatesByRoleIds(filterArr);
        LOGGER.info("Got user role relation ids: {}.", Arrays.stream(userRoleRelates).map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        return PermHelper.doGetRoleMember(feedbackProgress, userRoleRelates, roleIds);
    }

    public static List<MemberRoleSheet> getRoleMemberByPermFileIds(Consumer<Triple<String, Long, Long>> feedbackProgress, Object[] permFileIds) {
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)5L));
        DynamicObject[] userRoleRelates = PermHelper.getUserRelatesByPermFields(permFileIds);
        Object[] roleIds = Arrays.stream(userRoleRelates).map(it -> it.getString("role.id")).collect(Collectors.toSet()).toArray(new String[0]);
        return PermHelper.doGetRoleMember(feedbackProgress, userRoleRelates, roleIds);
    }

    public static DynamicObject[] getUserRelatesByRoleIds(Object[] roleIds) {
        return PermHelper.getUserRelatesByRoleIds(new QFilter[]{new QFilter("role.id", "in", (Object)roleIds)});
    }

    public static DynamicObject[] getUserRelatesByRoleIds(QFilter[] filterArr) {
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        return permFileHelper.query("user.id,user.name,user.number,permfile.org.id,permfile.org.name,permfile.org.number,role.id,role.number,role.name,customenable,validstart,validend", filterArr, "role.number,user.name");
    }

    public static DynamicObject[] getUserRelatesByPermFields(Object[] permFileIds) {
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        return permFileHelper.query("user.id,user.name,user.number,permfile.org.id,permfile.org.name,permfile.org.number,role.id,role.number,role.name,customenable,validstart,validend", new QFilter[]{new QFilter("permfile.id", "in", (Object)permFileIds)}, "role.number,user.name");
    }

    private static List<MemberRoleSheet> doGetRoleMember(Consumer<Triple<String, Long, Long>> feedbackProgress, DynamicObject[] userRoleRelates, Object[] roleIds) {
        HRBaseServiceHelper userRoleDataRuleServiceHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper userRoleFieldServiceHelper = new HRBaseServiceHelper("hrcs_userfield");
        Set userRoleRelateIds = Arrays.stream(userRoleRelates).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObject[] userRoleDataRules = userRoleDataRuleServiceHelper.query("userrolerelate.id,userrolerelate.role.id,app,entitytype,dataruleentry.permitem,dataruleentry.datarule,bddataruleentry.propkey,bddataruleentry.propentnum,bddataruleentry.bddatarule", new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelateIds)});
        Map<String, List<DynamicObject>> roleDataRuleMap = Arrays.stream(userRoleDataRules).collect(Collectors.groupingBy(it -> it.getString("userrolerelate.role.id") + "#" + it.getString("userrolerelate.id")));
        Set roleBaseDataRulePropEntityNumber = Arrays.stream(userRoleDataRules).flatMap(it -> it.getDynamicObjectCollection("bddataruleentry").stream().map(roleBaseDataRuleEntry -> roleBaseDataRuleEntry.getString("propentnum"))).collect(Collectors.toSet());
        DynamicObject[] userRoleFields = userRoleFieldServiceHelper.query("userrolerealt.id,userrolerealt.role.id,userrolerealt.user.id,app,entitytype.id,entitytype.number,entitytype.name,entryentity.fieldname,entryentity.isbanread,entryentity.isbanwrite", new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIds)});
        Map<String, List<DynamicObject>> roleFieldMap = Arrays.stream(userRoleFields).collect(Collectors.groupingBy(it -> it.getString("userrolerealt.role.id") + "#" + it.getString("userrolerealt.id")));
        LOGGER.info("Got role data with roleDataRuleMap: {}, roleBaseDataRulePropEntityNumber: {}, roleFieldMap: {}.", new Object[]{roleDataRuleMap, roleBaseDataRulePropEntityNumber, roleFieldMap});
        HashSet roleDataRuleAppIds = new HashSet(16);
        HashSet roleDataRuleEntityNumbers = new HashSet(16);
        Arrays.stream(userRoleDataRules).forEach(it -> {
            roleDataRuleAppIds.add(it.getString("app.id"));
            roleDataRuleEntityNumbers.add(it.getString("entitytype.id"));
        });
        Arrays.stream(userRoleFields).forEach(it -> {
            roleDataRuleAppIds.add(it.getString("app.id"));
            roleDataRuleEntityNumbers.add(it.getString("entitytype.id"));
        });
        roleDataRuleEntityNumbers.addAll(roleBaseDataRulePropEntityNumber);
        HRBaseServiceHelper entityServiceHelper = new HRBaseServiceHelper("bos_entitymeta");
        Map<String, DynamicObject> roleDataRuleEntityMap = Arrays.stream(entityServiceHelper.query("number,name", new QFilter[]{new QFilter("number", "in", roleDataRuleEntityNumbers)})).collect(Collectors.toMap(it -> it.getString("number"), it -> it, (oldValue, newValue) -> oldValue));
        LOGGER.info("Got role data with roleDataRuleEntityNumbers: {}, roleDataRuleEntityMap: {}, roleDataRuleAppIds: {}.", new Object[]{roleDataRuleEntityNumbers, roleDataRuleEntityMap, roleDataRuleAppIds});
        if (userRoleRelates.length == 0) {
            HRBaseServiceHelper userRoleRelateServiceHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
            HRBaseServiceHelper roleServiceHelper = new HRBaseServiceHelper("perm_role");
            DynamicObject[] roles = roleServiceHelper.query("id,number,name", new QFilter[]{new QFilter("id", "in", (Object)roleIds)});
            userRoleRelates = new DynamicObject[roles.length];
            for (int roleIndex = 0; roleIndex < roles.length; ++roleIndex) {
                userRoleRelates[roleIndex] = userRoleRelateServiceHelper.generateEmptyDynamicObject();
                userRoleRelates[roleIndex].set("role", (Object)roles[roleIndex]);
            }
        }
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)20L));
        List<MemberRoleSheet> memberRoleSheetList = Arrays.stream(userRoleRelates).map(userRoleRelate -> {
            MemberRoleSheet memberRoleSheet = new MemberRoleSheet();
            memberRoleSheet.setMemberId(userRoleRelate.getString("user.id"));
            memberRoleSheet.setMemberNumber(userRoleRelate.getString("user.number"));
            memberRoleSheet.setMemberName(userRoleRelate.getString("user.name"));
            memberRoleSheet.setOrgId(userRoleRelate.getString("permfile.org.id"));
            memberRoleSheet.setOrgNumber(userRoleRelate.getString("permfile.org.number"));
            memberRoleSheet.setOrgName(userRoleRelate.getString("permfile.org.name"));
            memberRoleSheet.setRoleId(userRoleRelate.getString("role.id"));
            memberRoleSheet.setRoleNumber(userRoleRelate.getString("role.number"));
            memberRoleSheet.setRoleName(userRoleRelate.getString("role.name"));
            memberRoleSheet.setMemberRoleRelateId(userRoleRelate.getLong("id"));
            memberRoleSheet.setValidStart(userRoleRelate.getDate("validstart"));
            memberRoleSheet.setValidEnd(userRoleRelate.getDate("validend"));
            memberRoleSheet.setCustomEnable(userRoleRelate.getString("customenable"));
            Optional.ofNullable(roleDataRuleMap.get(memberRoleSheet.getRoleId() + "#" + memberRoleSheet.getMemberRoleRelateId())).ifPresent(roleDataRules -> {
                HashSet<MemberRoleSheet.DataRule> allMemberDataRules = new HashSet<MemberRoleSheet.DataRule>(16);
                HashSet<MemberRoleSheet.BaseDataRule> allMemberBaseDataRules = new HashSet<MemberRoleSheet.BaseDataRule>(16);
                roleDataRules.forEach(roleDataRule -> {
                    String appNumber = roleDataRule.getString("app.number");
                    String appName = roleDataRule.getString("app.name");
                    String entityNumber = roleDataRule.getString("entitytype.id");
                    if (HRStringUtils.isEmpty((String)entityNumber)) {
                        return;
                    }
                    String entityName = ((DynamicObject)roleDataRuleEntityMap.get(entityNumber)).getString("name");
                    Set memberDataRules = roleDataRule.getDynamicObjectCollection("dataruleentry").stream().map(roleDataRuleEntry -> {
                        DynamicObject permItem = roleDataRuleEntry.getDynamicObject("permitem");
                        DynamicObject dataRule = roleDataRuleEntry.getDynamicObject("datarule");
                        return new MemberRoleSheet.DataRule(appNumber, appName, entityNumber, entityName, permItem.getString("id"), permItem.getString("number"), permItem.getString("name"), Optional.ofNullable(dataRule).map(dr -> dr.getString("number")).orElse(""), Optional.ofNullable(dataRule).map(dr -> dr.getString("name")).orElse(""));
                    }).collect(Collectors.toSet());
                    Set memberBaseDataRules = roleDataRule.getDynamicObjectCollection("bddataruleentry").stream().filter(roleBaseDataRuleEntry -> null != roleBaseDataRuleEntry.getDynamicObject("bddatarule")).map(roleBaseDataRuleEntry -> {
                        DynamicObject dataRule = roleBaseDataRuleEntry.getDynamicObject("bddatarule");
                        return new MemberRoleSheet.BaseDataRule(appNumber, appName, entityNumber, entityName, roleBaseDataRuleEntry.getString("propkey"), ((DynamicObject)roleDataRuleEntityMap.get(roleBaseDataRuleEntry.getString("propentnum"))).getString("name"), Optional.ofNullable(dataRule).map(dr -> dr.getString("number")).orElse(""), Optional.ofNullable(dataRule).map(dr -> dr.getString("name")).orElse(""));
                    }).collect(Collectors.toSet());
                    allMemberDataRules.addAll(memberDataRules);
                    allMemberBaseDataRules.addAll(memberBaseDataRules);
                });
                memberRoleSheet.setDataRules(allMemberDataRules);
                memberRoleSheet.setBaseDataRules(allMemberBaseDataRules);
            });
            Optional.ofNullable(roleFieldMap.get(memberRoleSheet.getRoleId() + "#" + memberRoleSheet.getMemberRoleRelateId())).ifPresent(roleFields -> {
                HashSet<MemberRoleSheet.FieldPerm> allMemberFieldPerms = new HashSet<MemberRoleSheet.FieldPerm>(16);
                roleFields.forEach(roleField -> {
                    String appNumber = roleField.getString("app.number");
                    String appName = roleField.getString("app.name");
                    String entityNumber = roleField.getString("entitytype.id");
                    String entityName = ((DynamicObject)roleDataRuleEntityMap.get(entityNumber)).getString("name");
                    ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
                    Map fieldNameMap = customQuery.parseProperty((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber)).stream().reduce(new HashMap(), (acc, item) -> {
                        acc.put(item.get("field_id"), item.get("field_name"));
                        return acc;
                    });
                    Set memberFieldPerms = roleField.getDynamicObjectCollection("entryentity").stream().map(fieldPermEntry -> {
                        String fieldNumber = fieldPermEntry.getString("fieldname");
                        String filedName = fieldNameMap.getOrDefault(fieldNumber, "");
                        boolean noView = fieldPermEntry.getBoolean("isbanread");
                        boolean noEdit = fieldPermEntry.getBoolean("isbanwrite");
                        return new MemberRoleSheet.FieldPerm(appNumber, appName, entityNumber, entityName, fieldNumber, filedName, noView, noEdit);
                    }).collect(Collectors.toSet());
                    allMemberFieldPerms.addAll(memberFieldPerms);
                });
                memberRoleSheet.setFieldPerms(allMemberFieldPerms);
            });
            return memberRoleSheet;
        }).collect(Collectors.toList());
        return PermHelper.getRole(feedbackProgress, memberRoleSheetList, true);
    }

    private static HashMap<String, Map<String, Object>> queryStructProConfig() {
        Object[] param = new Object[]{};
        String sql = "select fentitytypeid,fpropkey from t_hrcs_dimensionprop";
        HashMultimap structConfigParam = HashMultimap.create();
        DB.query((DBRoute)DBRoute.of((String)"hmp"), (String)sql, (Object[])param, arg_0 -> PermHelper.lambda$queryStructProConfig$55((SetMultimap)structConfigParam, arg_0));
        HashMap<String, Map<String, Object>> structProConfigMap = new HashMap<String, Map<String, Object>>(16);
        Map allStructConfigParam = Multimaps.asMap((SetMultimap)structConfigParam);
        if (ObjectUtils.isEmpty((Object)allStructConfigParam)) {
            return structProConfigMap;
        }
        int chunkSize = allStructConfigParam.size();
        if (chunkSize > 10000) {
            chunkSize = allStructConfigParam.size() / 10;
            chunkSize = chunkSize > 10000 ? 10000 : chunkSize;
        }
        HRBaseServiceHelper dynaFormCtrl = new HRBaseServiceHelper("hrcs_dynaformctrl");
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        ArrayList entityIds = new ArrayList(structConfigParam.keys());
        DynamicObject[] dynamicObjects = entityHelper.queryOriginalArray("id,modeltype", new QFilter[]{new QFilter("id", "in", entityIds)});
        HashMap entityTypeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            entityTypeMap.put(dynamicObject.getString("id"), dynamicObject);
        }
        List maps = PermHelper.splitByChunkSize(allStructConfigParam, chunkSize);
        for (Map tempStructConfigMap : maps) {
            HashMap structConfigMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry entry : tempStructConfigMap.entrySet()) {
                boolean isDynamicFormType;
                DynamicObject entityType;
                HashMap<String, List<Object>> config = new HashMap<String, List<Object>>();
                ArrayList properKeys = new ArrayList((Collection)entry.getValue());
                config.put("propkey", properKeys);
                String entityId = (String)entry.getKey();
                if (PermHelper.isExists(entityId)) {
                    structConfigMap.put(entityId, config);
                }
                if (!Objects.nonNull(entityType = (DynamicObject)entityTypeMap.get(entityId)) || !(isDynamicFormType = EntityCtrlServiceHelper.checkModelType((DynamicObject)entityType))) continue;
                List dataTypes = Arrays.stream(dynaFormCtrl.query("entryentity.propkey,entryentity.bdtype", new QFilter[]{new QFilter("entitytype.id", "=", (Object)entityId), new QFilter("entryentity.propkey", "in", properKeys)})).flatMap(dyItems -> dyItems.getDynamicObjectCollection("entryentity").stream()).filter(dyItem -> properKeys.contains(dyItem.getString("propkey"))).map(dyItem -> dyItem.getString("bdtype.number")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                config.put("baseDataType", dataTypes);
            }
            List viewUseConfig = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"batchQueryStructProConfig", (Object[])new Object[]{structConfigMap});
            for (Map entry : viewUseConfig) {
                String entityType = (String)entry.get("entitytype");
                String propKey = (String)entry.get("propkey");
                structProConfigMap.put(entityType + "#" + propKey, entry);
            }
        }
        return structProConfigMap;
    }

    private static Set<Triple<String, String, List<DimValueBean>>> getEmptyStructProject(String roleId, Long dimensionId, Long bucaFuncId, HashMap<String, Map<String, Object>> structProConfigMap) {
        Object[] param = new Object[]{roleId, dimensionId, bucaFuncId};
        String sql = "select fentitytypeid,fpropkey from t_hrcs_dimensionprop where fid in (select fid from t_hrcs_roledimension where froleid = ? and fdimensionid = ? and fbucafuncid = ?)";
        ArrayList viewUseConfig = Lists.newArrayListWithCapacity((int)16);
        DB.query((DBRoute)DBRoute.of((String)"hmp"), (String)sql, (Object[])param, rs -> {
            while (rs.next()) {
                Map config = (Map)structProConfigMap.get(rs.getString("fentitytypeid") + "#" + rs.getString("fpropkey"));
                if (!Objects.nonNull(config)) continue;
                viewUseConfig.add(config);
            }
            return null;
        });
        if (CollectionUtils.isNotEmpty((Collection)viewUseConfig)) {
            ArrayList emptyList = new ArrayList();
            return viewUseConfig.stream().flatMap(structConfig -> ((ArrayList)structConfig.get("structproject")).stream().filter(structProject -> ObjectUtils.isNotEmpty(structProject.get("number"))).map(structProject -> Triple.of((Object)((String)structProject.get("number")), (Object)((String)structProject.get("name")), (Object)emptyList))).collect(Collectors.toSet());
        }
        return new HashSet<Triple<String, String, List<DimValueBean>>>();
    }

    private static boolean isExists(String entityName) {
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
            return mainType != null;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static <K, V> List<Map<K, V>> splitByChunkSize(Map<K, V> map, int chunkSize) {
        if (Objects.isNull(map) || map.isEmpty() || chunkSize < 1) {
            return Collections.emptyList();
        }
        int mapSize = map.size();
        int groupSize = mapSize / chunkSize + (mapSize % chunkSize == 0 ? 0 : 1);
        ArrayList list = Lists.newArrayListWithCapacity((int)groupSize);
        if (chunkSize >= mapSize) {
            list.add(map);
            return list;
        }
        int count = 0;
        HashMap subMap = Maps.newHashMapWithExpectedSize((int)chunkSize);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (count < chunkSize) {
                subMap.put(entry.getKey(), entry.getValue());
                ++count;
                continue;
            }
            list.add(subMap);
            subMap = Maps.newHashMapWithExpectedSize((int)chunkSize);
            subMap.put(entry.getKey(), entry.getValue());
            count = 1;
        }
        list.add(subMap);
        return list;
    }

    private static /* synthetic */ Object lambda$queryStructProConfig$55(SetMultimap structConfigParam, ResultSet rs) throws Exception {
        while (rs.next()) {
            structConfigParam.put((Object)rs.getString("fentitytypeid"), (Object)rs.getString("fpropkey"));
        }
        return null;
    }
}

