/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimBean;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.formplugin.web.perm.init.excel.AbstractWriter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class RecordExcelWriter
extends AbstractWriter {
    private static final Log LOGGER = LogFactory.getLog(RecordExcelWriter.class);
    private boolean showErrorMsg = false;
    private boolean showAllRow = true;
    private int errorColNum = 0;
    private static final String DIM_ORGTEAM_TYPE = "orgteam";
    private ExportSheetStyle styles;
    private final Font originalFont;
    private Map<Integer, Integer> columnWidthMap;
    Map<String, Map<String, String>> entityFieldNameMap = Maps.newHashMapWithExpectedSize((int)16);

    public static void downloadRecordExcel(Long recordId, String recordNumber, boolean showErrorMsg, boolean showAllRow, IFormView view) {
        RecordExcelWriter writer = new RecordExcelWriter(showErrorMsg, showAllRow);
        writer.addExcelContent(recordId);
        String fileName = ResManager.loadKDString((String)"\u7528\u6237\u6743\u9650_%s", (String)"PermInitRecordList_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{recordNumber});
        String excelUrl = writer.flush(fileName, 7200);
        view.download(excelUrl);
    }

    private String getEntityFieldName(String entityNumber, String propKey) {
        String propName;
        if (ObjectUtils.isEmpty((Object)entityNumber)) {
            return propKey;
        }
        Map<String, String> fieldMap = this.entityFieldNameMap.get(entityNumber);
        if (MapUtils.isEmpty(fieldMap)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
            fieldMap = customQuery.parseProperty((IDataEntityType)mainEntityType).stream().collect(Collectors.toMap(it -> (String)it.get("field_id"), it -> (String)it.get("field_name"), (newVal, oldVal) -> oldVal));
            this.entityFieldNameMap.put(entityNumber, fieldMap);
        }
        return HRStringUtils.isEmpty((String)(propName = fieldMap.get(propKey))) ? propKey : propName;
    }

    @Override
    public Font getOriginalFont() {
        return this.originalFont;
    }

    public RecordExcelWriter(boolean showErrorMsg, boolean showAllRow) {
        this.showErrorMsg = showErrorMsg;
        this.showAllRow = showAllRow;
        if (showErrorMsg) {
            this.errorColNum = 1;
        }
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.styles = new ExportSheetStyle(this.wb, null);
        this.originalFont = this.wb.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        XSSFCellStyle tipsCellStyle = (XSSFCellStyle)this.styles.getTitleStyle();
        XSSFFont tipsFont = tipsCellStyle.getFont();
        tipsFont.setBold(true);
        tipsFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header");
        headerCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCellStyle.setBorderTop(BorderStyle.THIN);
        headerCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerCellFont = headerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerMustInputCellStyle = (XSSFCellStyle)this.styles.getTitleMustInputStyle();
        headerMustInputCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerMustInputCellStyle.setBorderTop(BorderStyle.THIN);
        headerMustInputCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderRight(BorderStyle.THIN);
        headerMustInputCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderBottom(BorderStyle.THIN);
        headerMustInputCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderLeft(BorderStyle.THIN);
        headerMustInputCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerMustInputFont = headerMustInputCellStyle.getFont();
        headerMustInputFont.setBold(true);
        headerMustInputFont.setFontHeightInPoints((short)12);
        headerMustInputFont.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle headerCenterCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header-center");
        headerCenterCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCenterCellStyle.setBorderTop(BorderStyle.THIN);
        headerCenterCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderRight(BorderStyle.THIN);
        headerCenterCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCenterCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCenterCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCenterCellFont = headerCenterCellStyle.getFont();
        headerCenterCellFont.setBold(true);
        headerCenterCellFont.setFontHeightInPoints((short)12);
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        commonCellStyle1.setFont(this.originalFont);
        commonCellStyle1.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBorderTop(BorderStyle.THIN);
        commonCellStyle1.setBorderRight(BorderStyle.THIN);
        commonCellStyle1.setBorderBottom(BorderStyle.THIN);
        commonCellStyle1.setBorderLeft(BorderStyle.THIN);
        CellStyle redFontCellStyle = this.styles.getTextStyle("body-redfont");
        redFontCellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setBorderTop(BorderStyle.THIN);
        redFontCellStyle.setBorderRight(BorderStyle.THIN);
        redFontCellStyle.setBorderBottom(BorderStyle.THIN);
        redFontCellStyle.setBorderLeft(BorderStyle.THIN);
        Font redFont = this.wb.createFont();
        redFont.setFontHeightInPoints((short)12);
        redFont.setColor(IndexedColors.RED.getIndex());
        redFontCellStyle.setFont(redFont);
    }

    public void addExcelContent(Long recordId) {
        HRBaseServiceHelper permInitRecordHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordDyna = permInitRecordHelper.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
        if (recordDyna == null) {
            throw new KDBizException("PermInitRecord not exist. recordId=" + recordId);
        }
        this.addUserRoleSheet(recordDyna);
        this.addUserDataRuleSheet(recordDyna);
        this.addUserBaseDataRangeSheet(recordDyna);
        this.addUserFieldSheet(recordDyna);
    }

    private void addUserRoleSheet(DynamicObject recordDyna) {
        this.columnWidthMap = new HashMap<Integer, Integer>(16);
        String sheetName = ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272", (String)"PermSheetHelper_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        DynamicObjectCollection userDimEntryColl = recordDyna.getDynamicObjectCollection("userdimentry");
        LinkedHashSet dimBeanSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        for (DynamicObject userDimEntry : userDimEntryColl) {
            DynamicObjectCollection dimValSubEntryColl = userDimEntry.getDynamicObjectCollection("userdimvalueentry");
            for (DynamicObject dimValDyna : dimValSubEntryColl) {
                DimBean dimBean = new DimBean(Long.valueOf(dimValDyna.getLong("dim_dimension.id")), dimValDyna.getString("dim_dimension.number"), dimValDyna.getString("dim_dimension.name"));
                dimBean.setDimType(dimValDyna.getString("dim_dimension.datasource"));
                dimBean.setOtClassifyId(Long.valueOf(dimValDyna.getLong("dim_otclassify.id")));
                dimBean.setOtClassifyName(dimValDyna.getString("dim_otclassify.name"));
                dimBean.setStructProjectNumber(dimValDyna.getString("dim_structproject.number"));
                dimBean.setStructProjectName(dimValDyna.getString("dim_structproject.name"));
                dimBeanSet.add(dimBean);
            }
        }
        ArrayList dimBeanList = Lists.newArrayList((Iterable)dimBeanSet);
        Collections.sort(dimBeanList, (o1, o2) -> {
            if (HRStringUtils.equals((String)o1.getDimType(), (String)DIM_ORGTEAM_TYPE) && !HRStringUtils.equals((String)o2.getDimType(), (String)DIM_ORGTEAM_TYPE)) {
                return -1;
            }
            if (!HRStringUtils.equals((String)o1.getDimType(), (String)DIM_ORGTEAM_TYPE) && HRStringUtils.equals((String)o2.getDimType(), (String)DIM_ORGTEAM_TYPE)) {
                return 1;
            }
            if (HRStringUtils.equals((String)o1.getDimType(), (String)DIM_ORGTEAM_TYPE) && HRStringUtils.equals((String)o2.getDimType(), (String)DIM_ORGTEAM_TYPE)) {
                return o1.getStructProjectNumber().compareTo(o2.getStructProjectNumber());
            }
            return o1.getDimNumber().compareToIgnoreCase(o2.getDimNumber());
        });
        this.addUserRoleHeader(sheet, enableValidateTime, dimBeanList);
        this.addUserRoleBody(sheet, enableValidateTime, userDimEntryColl, dimBeanList);
        sheet.trackAllColumnsForAutoSizing();
        this.columnWidthMap.forEach((key, value) -> sheet.setColumnWidth(key.intValue(), value * 256));
    }

    private void addUserRoleHeader(SXSSFSheet sheet, boolean enableValidateTime, List<DimBean> dimBeanList) {
        LOGGER.info("Begin  addMemberRoleHeader.");
        String sheetRemark = ResManager.loadKDString((String)"\u8bf4\u660e\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u4e0d\u5141\u8bb8\u8c03\u6574\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6\u7684\u987a\u5e8f\uff1b4\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), sheetRemark);
        LOGGER.info("Begin  addMemberRoleHeader 2.");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 5).setCellValue("rolename");
        int secondRowCurColumnIndex = this.errorColNum + 6;
        if (enableValidateTime) {
            this.addCellRegion((Sheet)sheet, 1, secondRowCurColumnIndex++).setCellValue("starttime");
            this.addCellRegion((Sheet)sheet, 1, secondRowCurColumnIndex++).setCellValue("endtime");
        }
        this.addCellRegion((Sheet)sheet, 1, secondRowCurColumnIndex++).setCellValue("datascope");
        this.addCellRegion((Sheet)sheet, 1, secondRowCurColumnIndex++).setCellValue("butype");
        this.addCellRegion((Sheet)sheet, 1, secondRowCurColumnIndex++).setCellValue("buorg");
        RecordExcelWriter.getRow((SXSSFSheet)sheet, (int)1).setHidden(Boolean.valueOf(true));
        LOGGER.info("Begin addMemberRoleHeader3.");
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        if (this.showErrorMsg) {
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, mustCellStyle, ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        String content = ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, this.errorColNum, this.errorColNum, mustCellStyle, content);
        this.cacheColumnWidth(this.errorColNum, content);
        content = ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, this.errorColNum + 1, this.errorColNum + 1, cellStyle, content);
        this.cacheColumnWidth(this.errorColNum + 1, content);
        content = ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, this.errorColNum + 2, this.errorColNum + 2, mustCellStyle, content);
        this.cacheColumnWidth(this.errorColNum + 2, content);
        content = ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, this.errorColNum + 3, this.errorColNum + 3, cellStyle, content);
        this.cacheColumnWidth(this.errorColNum + 3, content);
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, this.errorColNum + 4, this.errorColNum + 4, mustCellStyle, content);
        this.cacheColumnWidth(this.errorColNum + 4, content);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, this.errorColNum + 5, this.errorColNum + 5, cellStyle, content);
        this.cacheColumnWidth(this.errorColNum + 5, content);
        int thirdRowCurColumnIndex = this.errorColNum + 6;
        if (enableValidateTime) {
            content = ResManager.loadKDString((String)"*\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"PermSheetHelper_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, thirdRowCurColumnIndex, thirdRowCurColumnIndex, mustCellStyle, content, ResManager.loadKDString((String)"\u8bf7\u6309\u7167YYYY-MM-DD\u3001YYYY\u5e74MM\u6708DD\u65e5\u6216YYYY/MM/DD\u7684\u683c\u5f0f\u8f93\u5165\u6709\u6548\u671f\u3002", (String)"PermSheetHelper_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            this.cacheColumnWidth(thirdRowCurColumnIndex, content);
            content = ResManager.loadKDString((String)"*\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"PermSheetHelper_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++thirdRowCurColumnIndex, thirdRowCurColumnIndex, mustCellStyle, content, ResManager.loadKDString((String)"\u8bf7\u6309\u7167YYYY-MM-DD\u3001YYYY\u5e74MM\u6708DD\u65e5\u6216YYYY/MM/DD\u7684\u683c\u5f0f\u8f93\u5165\u6709\u6548\u671f\u3002", (String)"PermSheetHelper_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            this.cacheColumnWidth(thirdRowCurColumnIndex, content);
            ++thirdRowCurColumnIndex;
        }
        content = ResManager.loadKDString((String)"*\u6570\u636e\u8303\u56f4\u5c5e\u6027", (String)"PermSheetHelper_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, thirdRowCurColumnIndex, thirdRowCurColumnIndex, mustCellStyle, content, ResManager.loadKDString((String)"\u5982\u679c\u4e0b\u8f7d\u7684\u6570\u636e\u81ea\u5e26\u503c\uff0c\u5219\u8868\u793a\u89d2\u8272\u53ea\u5141\u8bb8\u6309\u5f53\u524d\u503c\u5bfc\u5165\uff1b\n\u5982\u679c\u4e0b\u8f7d\u7684\u89d2\u8272\u65e0\u503c\uff0c\u5219\u53ef\u9009\uff1a\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u6216\u81ea\u5b9a\u4e49\u8303\u56f4\u3002", (String)"PermSheetHelper_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.cacheColumnWidth(thirdRowCurColumnIndex, content);
        content = ResManager.loadKDString((String)"*\u804c\u80fd\u7c7b\u578b", (String)"PermSheetHelper_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++thirdRowCurColumnIndex, thirdRowCurColumnIndex, mustCellStyle, content, ResManager.loadKDString((String)"\u4e0b\u8f7d\u7684\u89d2\u8272\u81ea\u52a8\u8bc6\u522b\u804c\u80fd\u7c7b\u578b\u3002\n\u5982\u679c\u540c\u4e00\u4e2a\u89d2\u8272\u6709\u591a\u884c\u8bb0\u5f55\uff0c\u5219\u8868\u793a\u89d2\u8272\u6709\u591a\u4e2a\u4e0d\u540c\u7684\u804c\u80fd\u7c7b\u578b\u3002\n\u804c\u80fd\u7c7b\u578b\u5305\u62ec\uff1a", (String)"PermSheetHelper_98", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]) + "\n" + StringUtils.join((Object[])this.getFunctionTypeNames(), (String)"\n"));
        this.cacheColumnWidth(thirdRowCurColumnIndex, content);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"PermSheetHelper_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++thirdRowCurColumnIndex, thirdRowCurColumnIndex, cellStyle, content, ResManager.loadKDString((String)"\u5f53\u201c\u6570\u636e\u8303\u56f4\u5c5e\u6027\u201d\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\u65f6\uff0c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u5fc5\u987b\u586b\u5199\u3002\n\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002", (String)"PermSheetHelper_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.cacheColumnWidth(thirdRowCurColumnIndex, content);
        ++thirdRowCurColumnIndex;
        if (CollectionUtils.isEmpty(dimBeanList)) {
            return;
        }
        String roleDimStr = ResManager.loadKDString((String)"\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String roleDimTips = ResManager.loadKDString((String)"\u5f53\u3010\u6570\u636e\u8303\u56f4\u5c5e\u6027=\u81ea\u5b9a\u4e49\u8303\u56f4\u3011\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6807\u8272\u533a\u57df\u7684\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_22", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        if (dimBeanList.size() == 1) {
            this.addCellRegionWithWhiteBorder((Sheet)sheet, 2, thirdRowCurColumnIndex, centerCellStyle, roleDimStr, roleDimTips);
        } else {
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, thirdRowCurColumnIndex, thirdRowCurColumnIndex + dimBeanList.size() - 1, centerCellStyle, roleDimStr, roleDimTips);
        }
        int otDimIndex = thirdRowCurColumnIndex;
        List orgTeamCollect = dimBeanList.stream().filter(dimBean -> Objects.equals(dimBean.getDimType(), DIM_ORGTEAM_TYPE)).collect(Collectors.toList());
        List collect = dimBeanList.stream().filter(dimBean -> !Objects.equals(dimBean.getDimType(), DIM_ORGTEAM_TYPE)).collect(Collectors.toList());
        Map<String, List<DimBean>> boMap = orgTeamCollect.stream().collect(Collectors.groupingBy(DimBean::getDimName));
        for (Map.Entry<String, List<DimBean>> entry : boMap.entrySet()) {
            if (entry.getValue().size() > 1) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, otDimIndex, otDimIndex + entry.getValue().size() - 1, cellStyle, entry.getKey());
            } else {
                this.addCellRegion((Sheet)sheet, 3, otDimIndex, cellStyle, entry.getKey());
            }
            otDimIndex += entry.getValue().size();
        }
        for (Map.Entry<String, List<DimBean>> entry : boMap.entrySet()) {
            for (DimBean dimBean2 : entry.getValue()) {
                if (Objects.equals(dimBean2.getDimType(), DIM_ORGTEAM_TYPE)) {
                    this.addCellRegion((Sheet)sheet, 4, thirdRowCurColumnIndex, cellStyle, dimBean2.getStructProjectName());
                } else {
                    this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, thirdRowCurColumnIndex, thirdRowCurColumnIndex, cellStyle, dimBean2.getDimName());
                }
                dimBean2.setColumnIndex(thirdRowCurColumnIndex);
                ++thirdRowCurColumnIndex;
            }
        }
        for (DimBean dimBean3 : collect) {
            if (Objects.equals(dimBean3.getDimType(), DIM_ORGTEAM_TYPE)) {
                this.addCellRegion((Sheet)sheet, 4, thirdRowCurColumnIndex, cellStyle, dimBean3.getStructProjectName());
            } else {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, thirdRowCurColumnIndex, thirdRowCurColumnIndex, cellStyle, dimBean3.getDimName());
            }
            dimBean3.setColumnIndex(thirdRowCurColumnIndex);
            ++thirdRowCurColumnIndex;
        }
        for (DimBean dimBean3 : dimBeanList) {
            if (HRStringUtils.equals((String)dimBean3.getDimType(), (String)DIM_ORGTEAM_TYPE)) {
                this.addCellRegion((Sheet)sheet, 1, dimBean3.getColumnIndex()).setCellValue(dimBean3.getDimNumber() + "#" + dimBean3.getStructProjectNumber());
                continue;
            }
            this.addCellRegion((Sheet)sheet, 1, dimBean3.getColumnIndex()).setCellValue(dimBean3.getDimNumber());
        }
    }

    private void addUserRoleBody(SXSSFSheet sheet, boolean enableValidateTime, DynamicObjectCollection userDimEntryColl, List<DimBean> dimBeanList) {
        HashMap allDimValMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap dimValBeanResult = Maps.newHashMapWithExpectedSize((int)16);
        Map allDynaCondNameMap = PermInitServiceHelper.getAllDynaCondNameMap();
        Map allDynaCondMapIdNumber = PermInitServiceHelper.getAllDynaCondMapIdNumber();
        for (DynamicObject userDimEntry : userDimEntryColl) {
            DynamicObjectCollection dimValSubEntryColl = userDimEntry.getDynamicObjectCollection("userdimvalueentry");
            for (DynamicObject dimValDyna : dimValSubEntryColl) {
                Long dimensionId = dimValDyna.getLong("dim_dimension.id");
                List dimValList = (List)allDimValMap.get(dimensionId);
                if (dimValList == null) {
                    dimValList = Lists.newArrayListWithExpectedSize((int)16);
                    allDimValMap.put(dimensionId, dimValList);
                }
                dimValList.add(dimValDyna.getString("dim_dimval"));
                boolean dim_containssub = dimValDyna.getBoolean("dim_containssub");
                String dim_valtype = dimValDyna.getString("dim_valtype");
                Long dim_dynacond = dimValDyna.getLong("dim_dynacond.id");
                DimValueBean dimValueBean = new DimValueBean();
                dimValueBean.setContainsSub(dim_containssub);
                dimValueBean.setValueType(dim_valtype);
                if (HRStringUtils.equals((String)"2", (String)dim_valtype)) {
                    dimValueBean.setDynacondId(dim_dynacond);
                    dimValueBean.setDimVal(dim_dynacond.toString());
                } else {
                    dimValueBean.setDimVal(dimValDyna.getString("dim_dimval"));
                }
                Map stringDimValueBeanMap = dimValBeanResult.computeIfAbsent(dimensionId, k -> Maps.newHashMapWithExpectedSize((int)16));
                stringDimValueBeanMap.put(dimValDyna.getString("dim_dimval"), dimValueBean);
            }
        }
        Map dimValNameResult = PermInitServiceHelper.structDimInfo((Map)allDimValMap);
        dimValBeanResult.forEach((key, value) -> value.forEach((subKey, subValue) -> {
            String valueType = subValue.getValueType();
            if (HRStringUtils.equals((String)"2", (String)valueType)) {
                subValue.setDimValName((String)allDynaCondNameMap.get(Long.valueOf(subKey)));
                subValue.setDimValCode((String)allDynaCondMapIdNumber.get(Long.valueOf(subKey)));
            } else {
                Pair stringStringPair;
                Map stringPairMap = (Map)dimValNameResult.get(key);
                if (null != stringPairMap && null != (stringStringPair = (Pair)stringPairMap.get(subKey))) {
                    subValue.setDimValName((String)stringStringPair.getKey());
                    subValue.setDimValCode((String)stringStringPair.getValue());
                }
            }
        }));
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        int curRowIndex = 5;
        for (DynamicObject userDimEntry : userDimEntryColl) {
            List dimValDynaList;
            String key2;
            if (!this.showAllRow && HRStringUtils.isEmpty((String)userDimEntry.getString("dim_errormsg"))) continue;
            if (this.showErrorMsg) {
                XSSFCellStyle redFontCellStyle = (XSSFCellStyle)this.styles.getTextStyle("body-redfont");
                this.addCellRegion((Sheet)sheet, curRowIndex, 0, (CellStyle)redFontCellStyle, userDimEntry.getString("dim_errormsg"));
            }
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum, commonCellStyle1, userDimEntry.getString("dim_user.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 1, commonCellStyle1, userDimEntry.getString("dim_user.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 2, commonCellStyle1, userDimEntry.getString("dim_fileorg.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 3, commonCellStyle1, userDimEntry.getString("dim_fileorg.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 4, commonCellStyle1, userDimEntry.getString("dim_role.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 5, commonCellStyle1, userDimEntry.getString("dim_role.name"));
            int curColumnIndex = this.errorColNum + 6;
            if (enableValidateTime) {
                this.addCellRegion((Sheet)sheet, curRowIndex, curColumnIndex++, commonCellStyle1, this.formatDate(userDimEntry.getDate("dim_validstart")));
                this.addCellRegion((Sheet)sheet, curRowIndex, curColumnIndex++, commonCellStyle1, this.formatDate(userDimEntry.getDate("dim_validend")));
            }
            String customEnable = userDimEntry.getString("dim_customenable");
            this.addCellRegion((Sheet)sheet, curRowIndex, curColumnIndex++, commonCellStyle1, this.getCustomEnableStr(customEnable));
            String number = userDimEntry.getString("dim_bucafunc.fnumber");
            if (HRStringUtils.equals((String)number, (String)"11")) {
                this.addCellRegion((Sheet)sheet, curRowIndex, curColumnIndex++, commonCellStyle1, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7", (String)"RecordExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            } else {
                this.addCellRegion((Sheet)sheet, curRowIndex, curColumnIndex++, commonCellStyle1, userDimEntry.getString("dim_bucafunc.fname"));
            }
            if (HRStringUtils.equals((String)customEnable, (String)"0")) {
                ++curRowIndex;
                continue;
            }
            DynamicObjectCollection orgRangeColl = userDimEntry.getDynamicObjectCollection("dim_orgrange");
            String dim_orgcontainssubstr = userDimEntry.getString("dim_orgcontainssubstr");
            Map orgRangeContainsSubMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!HRStringUtils.isEmpty((String)dim_orgcontainssubstr)) {
                orgRangeContainsSubMap = (Map)SerializationUtils.fromJsonString((String)dim_orgcontainssubstr, Map.class);
            }
            ArrayList orgRanges = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject orgRange : orgRangeColl) {
                String isContainsSub = (String)orgRangeContainsSubMap.get(String.valueOf(orgRange.getLong("fbasedataid_id")));
                String orgStr = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), orgRange.getString("fbasedataid.number"), orgRange.getString("fbasedataid.name"), HRStringUtils.equals((String)"1", (String)isContainsSub) ? PermInitServiceHelper.getContainsSubText() : "");
                orgRanges.add(orgStr);
            }
            String orgRangeFullStr = String.join((CharSequence)System.lineSeparator(), orgRanges);
            this.addCellRegion((Sheet)sheet, curRowIndex, curColumnIndex++, commonCellStyle1, orgRangeFullStr);
            DynamicObjectCollection dimValSubEntryColl = userDimEntry.getDynamicObjectCollection("userdimvalueentry");
            HashMap dimValMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject dimValDyna : dimValSubEntryColl) {
                key2 = "" + dimValDyna.getLong("dim_dimension.id") + "_" + dimValDyna.getString("dim_structproject.number");
                dimValDynaList = (List)dimValMap.get(key2);
                if (dimValDynaList == null) {
                    dimValDynaList = Lists.newArrayListWithExpectedSize((int)16);
                    dimValMap.put(key2, dimValDynaList);
                }
                dimValDynaList.add(dimValDyna);
            }
            for (DimBean dimBean : dimBeanList) {
                key2 = dimBean.getDimId() + "_" + dimBean.getStructProjectNumber();
                dimValDynaList = (List)dimValMap.get(key2);
                StringBuilder dimValStrBuilder = new StringBuilder();
                if (!CollectionUtils.isEmpty((Collection)dimValDynaList)) {
                    for (DynamicObject dimValDyna : dimValDynaList) {
                        String dimValDisplay = this.getDimValDisplayName(dimValBeanResult, dimBean.getDimId(), dimValDyna.getString("dim_dimval"), dimValDyna.getBoolean("dim_isall"));
                        dimValStrBuilder.append(dimValDisplay);
                    }
                }
                this.addCellRegion((Sheet)sheet, curRowIndex, dimBean.getColumnIndex(), commonCellStyle1, dimValStrBuilder.toString());
                ++curColumnIndex;
            }
            ++curRowIndex;
        }
    }

    private String getDimValDisplayName(Map<Long, Map<String, DimValueBean>> dimValNameResult, Long dimensionId, String dimVal, boolean isAll) {
        if (isAll) {
            return "ALL";
        }
        Map<String, DimValueBean> dimValMap = dimValNameResult.get(dimensionId);
        if (dimValMap == null) {
            return "ERROR_" + dimVal;
        }
        DimValueBean displayNamePair = dimValMap.get(dimVal);
        if (displayNamePair == null) {
            return "ERROR_" + dimVal;
        }
        String displayNameStr = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b\n", (String)"TemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), displayNamePair.getDimValCode(), displayNamePair.getDimValName(), displayNamePair.isContainsSub() ? PermInitServiceHelper.getContainsSubText() : "");
        return displayNameStr;
    }

    private void cacheColumnWidth(int columnIndex, String content) {
        this.columnWidthMap.put(columnIndex, Math.max(this.columnWidthMap.getOrDefault(columnIndex, 0), Optional.ofNullable(content).map(it -> it.getBytes().length).orElseGet(() -> 0)));
    }

    private void addUserDataRuleSheet(DynamicObject recordDyna) {
        String sheetName = ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5b9a\u4e49\u89d2\u8272\u6570\u636e\u89c4\u5219", (String)"PermSheetHelper_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        this.addUserDataRuleSheetHeader(sheet);
        DynamicObjectCollection userDataRuleEntryColl = recordDyna.getDynamicObjectCollection("userdataruleentry");
        this.addUserDataRuleSheetBody(sheet, userDataRuleEntryColl);
    }

    private void addUserDataRuleSheetHeader(SXSSFSheet sheet) {
        Cell tipsCell = this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0);
        tipsCell.setCellValue(ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 5).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 6).setCellValue("appnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 7).setCellValue("appname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 8).setCellValue("entitynum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 9).setCellValue("entityname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 10).setCellValue("perm");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 11).setCellValue("rulenum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 12).setCellValue("rulename");
        sheet.getRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        if (this.showErrorMsg) {
            this.addCellRegion((Sheet)sheet, 2, 0, mustCellStyle, ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 1, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 2, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 3, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 4, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 5, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 6, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 7, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 8, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 9, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 10, cellStyle, ResManager.loadKDString((String)"*\u6743\u9650\u9879", (String)"PermSheetHelper_30", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 11, mustCellStyle, ResManager.loadKDString((String)"*\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_31", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 12, cellStyle, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_32", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addUserDataRuleSheetBody(SXSSFSheet sheet, DynamicObjectCollection userDataRuleEntryColl) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        int curRowIndex = 3;
        for (DynamicObject userDataRuleEntry : userDataRuleEntryColl) {
            if (!this.showAllRow && HRStringUtils.isEmpty((String)userDataRuleEntry.getString("dr_errormsg"))) continue;
            if (this.showErrorMsg) {
                XSSFCellStyle redFontCellStyle = (XSSFCellStyle)this.styles.getTextStyle("body-redfont");
                this.addCellRegion((Sheet)sheet, curRowIndex, 0, (CellStyle)redFontCellStyle, userDataRuleEntry.getString("dr_errormsg"));
            }
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum, commonCellStyle1, userDataRuleEntry.getString("dr_user.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 1, commonCellStyle1, userDataRuleEntry.getString("dr_user.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 2, commonCellStyle1, userDataRuleEntry.getString("dr_fileorg.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 3, commonCellStyle1, userDataRuleEntry.getString("dr_fileorg.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 4, commonCellStyle1, userDataRuleEntry.getString("dr_role.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 5, commonCellStyle1, userDataRuleEntry.getString("dr_role.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 6, commonCellStyle1, userDataRuleEntry.getString("dr_app.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 7, commonCellStyle1, userDataRuleEntry.getString("dr_app.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 8, commonCellStyle1, userDataRuleEntry.getString("dr_entitytype.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 9, commonCellStyle1, userDataRuleEntry.getString("dr_entitytype.name"));
            StringJoiner joiner = new StringJoiner(";");
            DynamicObjectCollection permItemColl = userDataRuleEntry.getDynamicObjectCollection("dr_permitemmulti");
            permItemColl.stream().filter(permItemDyan -> permItemDyan.getString("fbasedataid.name") != null).forEach(permItemDyan -> joiner.add(permItemDyan.getString("fbasedataid.name")));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 10, commonCellStyle1, joiner.toString());
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 11, commonCellStyle1, userDataRuleEntry.getString("dr_datarule.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 12, commonCellStyle1, userDataRuleEntry.getString("dr_datarule.name"));
            ++curRowIndex;
        }
    }

    public void addUserBaseDataRangeSheet(DynamicObject recordDyna) {
        String sheetName = ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5b9a\u4e49\u89d2\u8272\u57fa\u7840\u8d44\u6599\u6570\u636e\u8303\u56f4", (String)"PermSheetHelper_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        this.addUserBaseDataRangeSheetHeader(sheet);
        DynamicObjectCollection userBdEntryColl = recordDyna.getDynamicObjectCollection("userbdentry");
        this.addUserBaseDataRangeSheetBody(sheet, userBdEntryColl);
        sheet.setColumnWidth(2, 4900);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4700);
        sheet.setColumnWidth(5, 4700);
        sheet.setColumnWidth(6, 4700);
        sheet.setColumnWidth(7, 4700);
        sheet.setColumnWidth(8, 4700);
        sheet.setColumnWidth(9, 4900);
        sheet.setColumnWidth(10, 4900);
        sheet.setColumnWidth(11, 4700);
        sheet.setColumnWidth(12, 5000);
        sheet.setColumnWidth(13, 5300);
    }

    private void addUserBaseDataRangeSheetHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 5).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 6).setCellValue("appnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 7).setCellValue("appname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 8).setCellValue("entitynum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 9).setCellValue("entityname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 10).setCellValue("basedataprop");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 11).setCellValue("basedataname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 12).setCellValue("rulenum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 13).setCellValue("rulename");
        sheet.getRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        if (this.showErrorMsg) {
            this.addCellRegion((Sheet)sheet, 2, 0, mustCellStyle, ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 1, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 2, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 3, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 4, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 5, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 6, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 7, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 8, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 9, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 10, mustCellStyle, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027", (String)"PermSheetHelper_33", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 11, cellStyle, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"PermSheetHelper_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 12, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 13, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addUserBaseDataRangeSheetBody(SXSSFSheet sheet, DynamicObjectCollection userBdEntryColl) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        int curRowIndex = 3;
        for (DynamicObject userBdEntry : userBdEntryColl) {
            if (!this.showAllRow && HRStringUtils.isEmpty((String)userBdEntry.getString("bd_errormsg"))) continue;
            if (this.showErrorMsg) {
                XSSFCellStyle redFontCellStyle = (XSSFCellStyle)this.styles.getTextStyle("body-redfont");
                this.addCellRegion((Sheet)sheet, curRowIndex, 0, (CellStyle)redFontCellStyle, userBdEntry.getString("bd_errormsg"));
            }
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum, commonCellStyle1, userBdEntry.getString("bd_user.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 1, commonCellStyle1, userBdEntry.getString("bd_user.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 2, commonCellStyle1, userBdEntry.getString("bd_fileorg.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 3, commonCellStyle1, userBdEntry.getString("bd_fileorg.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 4, commonCellStyle1, userBdEntry.getString("bd_role.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 5, commonCellStyle1, userBdEntry.getString("bd_role.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 6, commonCellStyle1, userBdEntry.getString("bd_app.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 7, commonCellStyle1, userBdEntry.getString("bd_app.name"));
            String entityNumber = userBdEntry.getString("bd_entitytype.number");
            String propKey = userBdEntry.getString("bd_propkey");
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 8, commonCellStyle1, entityNumber);
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 9, commonCellStyle1, userBdEntry.getString("bd_entitytype.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 10, commonCellStyle1, propKey);
            String propName = this.getEntityFieldName(entityNumber, propKey);
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 11, commonCellStyle1, propName);
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 12, commonCellStyle1, userBdEntry.getString("bd_datarule.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 13, commonCellStyle1, userBdEntry.getString("bd_datarule.name"));
            ++curRowIndex;
        }
    }

    public void addUserFieldSheet(DynamicObject recordDyna) {
        String sheetName = ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5b9a\u4e49\u89d2\u8272\u5b57\u6bb5\u6743\u9650", (String)"PermSheetHelper_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        this.addUserFieldSheetHeader(sheet);
        DynamicObjectCollection userFieldEntryColl = recordDyna.getDynamicObjectCollection("userfieldentry");
        this.addUserFieldSheetBody(sheet, userFieldEntryColl);
        sheet.setColumnWidth(2, 4900);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4700);
        sheet.setColumnWidth(5, 4700);
        sheet.setColumnWidth(6, 4700);
        sheet.setColumnWidth(7, 4700);
        sheet.setColumnWidth(8, 4700);
        sheet.setColumnWidth(9, 4900);
        sheet.setColumnWidth(10, 4900);
        sheet.setColumnWidth(11, 4700);
    }

    private void addUserFieldSheetHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 5).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 6).setCellValue("appnum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 7).setCellValue("appname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 8).setCellValue("entitynum");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 9).setCellValue("entityname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 10).setCellValue("fieldprop");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 11).setCellValue("fieldname");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 12).setCellValue("view");
        this.addCellRegion((Sheet)sheet, 1, this.errorColNum + 13).setCellValue("edit");
        RecordExcelWriter.getRow((SXSSFSheet)sheet, (int)1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        if (this.showErrorMsg) {
            this.addCellRegion((Sheet)sheet, 2, 0, mustCellStyle, ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 1, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 2, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 3, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 4, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 5, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 6, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 7, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 8, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 9, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 10, mustCellStyle, ResManager.loadKDString((String)"*\u5b57\u6bb5\u5c5e\u6027", (String)"PermSheetHelper_101", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 11, cellStyle, ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"PermSheetHelper_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 12, mustCellStyle, ResManager.loadKDString((String)"*\u67e5\u770b", (String)"PermSheetHelper_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002", (String)"PermSheetHelper_48", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, this.errorColNum + 13, mustCellStyle, ResManager.loadKDString((String)"*\u7f16\u8f91", (String)"PermSheetHelper_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f55\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002\n\u5f55\u5165\u8981\u6c42\uff1a\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PermSheetHelper_49", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addUserFieldSheetBody(SXSSFSheet sheet, DynamicObjectCollection userFieldEntryColl) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        int curRowIndex = 3;
        for (DynamicObject userFieldEntry : userFieldEntryColl) {
            if (!this.showAllRow && HRStringUtils.isEmpty((String)userFieldEntry.getString("field_errormsg"))) continue;
            if (this.showErrorMsg) {
                XSSFCellStyle redFontCellStyle = (XSSFCellStyle)this.styles.getTextStyle("body-redfont");
                this.addCellRegion((Sheet)sheet, curRowIndex, 0, (CellStyle)redFontCellStyle, userFieldEntry.getString("field_errormsg"));
            }
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum, commonCellStyle1, userFieldEntry.getString("field_user.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 1, commonCellStyle1, userFieldEntry.getString("field_user.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 2, commonCellStyle1, userFieldEntry.getString("field_fileorg.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 3, commonCellStyle1, userFieldEntry.getString("field_fileorg.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 4, commonCellStyle1, userFieldEntry.getString("field_role.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 5, commonCellStyle1, userFieldEntry.getString("field_role.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 6, commonCellStyle1, userFieldEntry.getString("field_app.number"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 7, commonCellStyle1, userFieldEntry.getString("field_app.name"));
            String entityNumber = userFieldEntry.getString("field_entitytype.number");
            String propKey = userFieldEntry.getString("field_propkey");
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 8, commonCellStyle1, entityNumber);
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 9, commonCellStyle1, userFieldEntry.getString("field_entitytype.name"));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 10, commonCellStyle1, propKey);
            String propName = this.getEntityFieldName(entityNumber, propKey);
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 11, commonCellStyle1, propName);
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 12, commonCellStyle1, this.getFieldCanStr(userFieldEntry.getBoolean("field_canread")));
            this.addCellRegion((Sheet)sheet, curRowIndex, this.errorColNum + 13, commonCellStyle1, this.getFieldCanStr(userFieldEntry.getBoolean("field_canwrite")));
            ++curRowIndex;
        }
    }

    private String getFieldCanStr(boolean can) {
        if (can) {
            return ResManager.loadKDString((String)"\u5141\u8bb8", (String)"PermSheetHelper_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"PermSheetHelper_58", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getCustomEnableStr(String customEnable) {
        if (HRStringUtils.equals((String)customEnable, (String)"1")) {
            return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"PermSheetHelper_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermSheetHelper_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }
}

