/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitFinishValidateService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DataRangeInitModel;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.formplugin.web.perm.init.excel.MemberRoleSheet;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleExcel;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleTemplateExcelWriter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class RoleRecordExcelWriter
extends RoleTemplateExcelWriter {
    private static final Log LOGGER = LogFactory.getLog(RoleRecordExcelWriter.class);
    private static final String ERROR_MSG = "errormsg";
    final PermRoleInitFinishValidateService service = new PermRoleInitFinishValidateService();
    private boolean showErrorMsg = false;
    private boolean showAllRow = true;
    private int errorColNum = 0;

    public RoleRecordExcelWriter(boolean showErrorMsg, boolean showAllRow) {
        this.showErrorMsg = showErrorMsg;
        this.showAllRow = showAllRow;
        if (showErrorMsg) {
            this.errorColNum = 1;
        }
    }

    public static void downloadRecordExcel(Long recordId, String recordNumber, boolean showErrorMsg, String type, IFormView view) {
        HRBaseServiceHelper permInitRecordHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordDyna = permInitRecordHelper.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
        if (recordDyna == null) {
            throw new KDBizException("PermInitRecord not exist. recordId=" + recordId);
        }
        Map<String, String> roleNameMap = RoleRecordExcelWriter.getRoleNameMap(recordDyna);
        RoleExcel roleExcel = RoleRecordExcelWriter.buildRoleExcel(recordDyna, roleNameMap, showErrorMsg);
        roleExcel.setSource("1");
        RoleTemplateExcelWriter writer = new RoleTemplateExcelWriter(showErrorMsg);
        writer.addRoleSheet(ResManager.loadKDString((String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f", (String)"PermSheetHelper_91", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), roleExcel);
        writer.addFunctionItemSheet(ResManager.loadKDString((String)"\u89d2\u8272\u529f\u80fd\u6743\u9650", (String)"PermSheetHelper_92", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), roleExcel);
        writer.addDimSheet(ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6", (String)"PermSheetHelper_93", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), roleExcel);
        int lastCol = writer.addDataRangeSheet(ResManager.loadKDString((String)"\u89d2\u8272\u6570\u636e\u8303\u56f4", (String)"PermSheetHelper_94", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), roleExcel);
        writer.addFieldPermSheet(ResManager.loadKDString((String)"\u89d2\u8272\u5b57\u6bb5\u6743\u9650", (String)"PermSheetHelper_95", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), roleExcel);
        RoleRecordExcelWriter roleRecordExcelWriter = new RoleRecordExcelWriter(showErrorMsg, true);
        roleRecordExcelWriter.writeDataRangeError(recordDyna, roleNameMap, writer, lastCol, showErrorMsg);
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append('_').append(recordNumber);
        String excelUrl = writer.flush(sb.toString(), 7200);
        view.download(excelUrl);
    }

    public static RoleExcel buildRoleExcel(DynamicObject recordDyna, Map<String, String> roleNameMap, boolean showErrorMsg) {
        Set<RoleExcel.RoleSheet> roleSheets = RoleRecordExcelWriter.getRoleSheets(recordDyna);
        Set<RoleExcel.FunctionItemSheet> functionItemSet = RoleRecordExcelWriter.getRolePerm(recordDyna, showErrorMsg, roleNameMap);
        RoleExcel.DimSheet dim = RoleRecordExcelWriter.getRoleDim(recordDyna, showErrorMsg, roleNameMap);
        Set<RoleExcel.FieldPermSheet> fieldPermSet = RoleRecordExcelWriter.getRoleFieldPerm(recordDyna, roleNameMap);
        RoleExcel roleExcel = new RoleExcel();
        roleExcel.setRoleSet(new ArrayList<RoleExcel.RoleSheet>(roleSheets));
        roleExcel.setFunctionItemSet(functionItemSet);
        roleExcel.setDim(dim);
        roleExcel.setFieldPermSet(fieldPermSet);
        return roleExcel;
    }

    private static Set<RoleExcel.RoleSheet> getRoleSheets(DynamicObject recordDyna) {
        DynamicObjectCollection roleEntryColl = recordDyna.getDynamicObjectCollection("rolebaseentry");
        Set roleSheets = roleEntryColl.stream().map(it -> {
            RoleExcel.RoleSheet roleSheet = new RoleExcel.RoleSheet();
            roleSheet.setRoleNumber(it.getString("rbase_number"));
            roleSheet.setRoleName(it.getLocaleString("rbase_name"));
            roleSheet.setRoleRemark(it.getLocaleString("rbase_remark"));
            roleSheet.setRoleGroupNumber(it.getString("rbase_group.number"));
            roleSheet.setRoleGroupName(it.getString("rbase_group.name"));
            roleSheet.setRoleProperty(it.getString("rbase_property"));
            roleSheet.setRoleCBisIntersection(it.getString("rbase_isintersection"));
            roleSheet.setUseScope(it.getString("rbase_usescope"));
            roleSheet.setCreateAdminGrpNumber(it.getString("rbase_createadmingrp.number"));
            roleSheet.setCreateAdminGrpName(it.getString("rbase_createadmingrp.name"));
            DynamicObjectCollection openScopeView = it.getDynamicObjectCollection("rbase_openscopeview");
            String openScopeViewInfo = openScopeView.stream().filter(item -> !ObjectUtils.isEmpty((Object)item.getDynamicObject("fbasedataid"))).map(item -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\uff1b", (String)"RoleRecordExcelWriter_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), item.getString("fbasedataid.number"), item.getString("fbasedataid.name"))).collect(Collectors.joining(";"));
            roleSheet.setOpenRangeWithView(StringUtils.join((Object[])new String[]{openScopeViewInfo, "\n"}));
            DynamicObjectCollection openScopeEdit = it.getDynamicObjectCollection("rbase_openscopeedit");
            String openScopeEditInfo = openScopeEdit.stream().filter(item -> !ObjectUtils.isEmpty((Object)item.getDynamicObject("fbasedataid"))).map(item -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\uff1b", (String)"RoleRecordExcelWriter_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), item.getString("fbasedataid.number"), item.getString("fbasedataid.name"))).collect(Collectors.joining(";"));
            roleSheet.setOpenRangeWithEdit(StringUtils.join((Object[])new String[]{openScopeEditInfo, "\n"}));
            roleSheet.setErrorMsg(it.getString("rbase_errormsg"));
            return roleSheet;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        return roleSheets;
    }

    private static Set<RoleExcel.FunctionItemSheet> getRolePerm(DynamicObject initRecord, boolean showErrorMsg, Map<String, String> roleNameMap) {
        DynamicObjectCollection funcEntryColl = initRecord.getDynamicObjectCollection("rolefuncentry");
        HashMap roleBuCaMap = new HashMap(16);
        Map<String, List> entityMap = funcEntryColl.stream().collect(Collectors.toMap(it -> it.getString("rfunc_app.id"), it -> Lists.newArrayList((Object[])new String[]{it.getString("rfunc_entitytype.number")}), (oldValue, newValue) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)oldValue, (Iterable)newValue))));
        HRBuCaServiceHelper.getBuCaFuncFromSpec(entityMap).entrySet().forEach(entry -> ((Map)entry.getValue()).entrySet().forEach(item -> roleBuCaMap.put((String)entry.getKey() + "#" + (String)item.getKey(), ((DynamicObject)item.getValue()).getString("name"))));
        Set entities = funcEntryColl.stream().map(it -> it.getString("rfunc_entitytype.number")).collect(Collectors.toSet());
        HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        Map<String, List> dimMap = Arrays.stream(dimServiceHelper.query("entitytype.id,entryentity.dimension", new QFilter[]{new QFilter("entitytype.id", "in", entities)})).collect(Collectors.toMap(it -> it.getString("entitytype.id"), it -> it.getDynamicObjectCollection("entryentity").stream().map(entry -> entry.getString("dimension.name")).collect(Collectors.toList()), (oldValue, newValue) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)oldValue, (Iterable)newValue))));
        Map<String, String> roleErrMap = initRecord.getDynamicObjectCollection("rolefunccolerrorentry").stream().collect(Collectors.toMap(it -> it.getString("rfunccol_rolenumber"), it -> it.getString("rfunccol_errormsg"), (newVal, oldVal) -> newVal));
        Map<String, String> permErrMap = initRecord.getDynamicObjectCollection("rolefuncrowerrorentry").stream().collect(Collectors.toMap(it -> it.getString("rfuncrow_app.number") + "#" + it.getString("rfuncrow_entitytype.id") + "#" + it.getString("rfuncrow_permitem.id"), it -> it.getString("rfuncrow_errormsg"), (newVal, oldVal) -> newVal));
        HashMap<String, RoleExcel.FunctionItemSheet> result = new HashMap<String, RoleExcel.FunctionItemSheet>(16);
        for (DynamicObject dynamicObject : funcEntryColl) {
            String key;
            RoleExcel.FunctionItemSheet tempFunctionItem;
            List dims = dimMap.getOrDefault(dynamicObject.getString("rfunc_entitytype.number"), Collections.emptyList());
            RoleExcel.FunctionItemSheet functionItem = new RoleExcel.FunctionItemSheet();
            functionItem.setId(dynamicObject.getString("rfunc_permitem.id"));
            functionItem.setName(dynamicObject.getString("rfunc_permitem.name"));
            functionItem.setAppNumber(dynamicObject.getString("rfunc_app.number"));
            functionItem.setAppName(dynamicObject.getString("rfunc_app.name"));
            functionItem.setCloudNumber(dynamicObject.getString("rfunc_app.bizcloud.number"));
            functionItem.setCloudName(dynamicObject.getString("rfunc_app.bizcloud.name"));
            functionItem.setEntityNumber(dynamicObject.getString("rfunc_entitytype.number"));
            functionItem.setEntityName(dynamicObject.getString("rfunc_entitytype.name"));
            functionItem.setBuCaFuncName(roleBuCaMap.getOrDefault(dynamicObject.getString("rfunc_app.id") + "#" + dynamicObject.getString("rfunc_entitytype.number"), ""));
            functionItem.setDimName(String.join((CharSequence)";", dims));
            String roleNumber = dynamicObject.getString("rfunc_rolenumber");
            functionItem.setRoleSet(Sets.newHashSet((Object[])new Pair[]{Pair.of((Object)roleNumber, (Object)roleNameMap.get(roleNumber))}));
            String funcKey = functionItem.getAppNumber() + "#" + functionItem.getEntityNumber() + "#" + functionItem.getId();
            if (showErrorMsg && permErrMap.containsKey(funcKey)) {
                functionItem.setPermErrMsg(permErrMap.get(funcKey));
            }
            if (null != (tempFunctionItem = (RoleExcel.FunctionItemSheet)result.get(key = functionItem.getCloudNumber() + "#" + funcKey))) {
                tempFunctionItem.getRoleSet().addAll(functionItem.getRoleSet());
                continue;
            }
            result.put(key, functionItem);
        }
        if (showErrorMsg) {
            RoleExcel.FunctionItemSheet tempFunctionItem = new RoleExcel.FunctionItemSheet();
            tempFunctionItem.setRoleErrMsg(roleErrMap);
            result.put("", tempFunctionItem);
        }
        return new LinkedHashSet<RoleExcel.FunctionItemSheet>(result.values());
    }

    private static RoleExcel.DimSheet getRoleDim(DynamicObject initRecord, boolean showErrorMsg, Map<String, String> roleNameMap) {
        DynamicObjectCollection dimEntryColl = initRecord.getDynamicObjectCollection("roledimentry");
        Set collect = dimEntryColl.stream().map(it -> it.getLong("rdim_bucafunc.id")).collect(Collectors.toSet());
        PermRoleInitFinishValidateService service = new PermRoleInitFinishValidateService();
        Map hrFuncNameMap = service.getHrFuncNameMap(collect);
        List<Pair<Pair<String, String>, Triple<String, String, String>>> roleDimList = dimEntryColl.stream().map(it -> Pair.of((Object)Pair.of((Object)it.getString("rdim_dimension.number"), (Object)it.getString("rdim_dimension.name")), (Object)Triple.of((Object)it.getString("rdim_rolenumber"), roleNameMap.get(it.getString("rdim_rolenumber")), hrFuncNameMap.get(it.getLong("rdim_bucafunc.id"))))).sorted(Comparator.comparing(it -> (String)((Triple)it.getValue()).getLeft() + (String)((Triple)it.getValue()).getRight())).collect(Collectors.toList());
        RoleExcel.DimSheet dimSheet = new RoleExcel.DimSheet();
        dimSheet.setList(roleDimList);
        Map<String, String> roleDimErrMsgMap = dimEntryColl.stream().filter(it -> HRStringUtils.isNotEmpty((String)it.getString("rdim_errormsg"))).collect(Collectors.toMap(it -> it.getString("rdim_rolenumber") + "#" + it.getString("rdim_bucafunc.fname"), it -> it.getString("rdim_errormsg"), (newVal, oldVal) -> newVal));
        if (showErrorMsg) {
            List<Triple<String, String, String>> appendErrMsgMap = initRecord.getDynamicObjectCollection("roledimrowerrorentry").stream().map(it -> Triple.of((Object)it.getString("rdimrow_rolenumber"), (Object)it.getString("rdimrow_bucafunc.fname"), (Object)it.getString("rdimrow_errormsg"))).collect(Collectors.toList());
            dimSheet.setAppendErrMsgs(appendErrMsgMap);
        }
        dimSheet.setRoleDimErrMsgMap(roleDimErrMsgMap);
        return dimSheet;
    }

    private static Set<RoleExcel.DataRangeSheet> getRoleDataRange(DynamicObject initRecord, Map<String, String> roleNameMap) {
        DynamicObjectCollection dataRangeEntryColl = initRecord.getDynamicObjectCollection("roledataentry");
        Map<Long, Map<String, Pair<String, String>>> dimValueInfoMap = RoleRecordExcelWriter.queryRoleDimInfos(dataRangeEntryColl);
        HashMap<String, RoleExcel.DataRangeSheet> roleDataRangeMap = new HashMap<String, RoleExcel.DataRangeSheet>(16);
        Set roleNumbers = dataRangeEntryColl.stream().map(it -> it.getString("rdata_rolenumber")).collect(Collectors.toSet());
        Map roleDimGrpMap = PermInitServiceHelper.batchQueryRoleDimGrp(roleNumbers);
        for (DynamicObject dataRangeRow : dataRangeEntryColl) {
            String roleNumber = dataRangeRow.getString("rdata_rolenumber");
            RoleExcel.DataRangeSheet dataRangeSheet = (RoleExcel.DataRangeSheet)roleDataRangeMap.get(roleNumber);
            if (null == dataRangeSheet) {
                dataRangeSheet = new RoleExcel.DataRangeSheet();
                dataRangeSheet.setRoleNumber(roleNumber);
                dataRangeSheet.setRoleName(roleNameMap.get(roleNumber));
                roleDataRangeMap.put(roleNumber, dataRangeSheet);
            }
            List roleDimGrpList = roleDimGrpMap.getOrDefault(roleNumber, Lists.newArrayListWithExpectedSize((int)0));
            HashMap buFuncMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject roleDimGrp : roleDimGrpList) {
                long rangeRowBuId;
                DynamicObject buCaFunc = roleDimGrp.getDynamicObject("bucafunc");
                long buCaId = buCaFunc.getLong("id");
                if (buCaId != (rangeRowBuId = dataRangeRow.getLong("rdata_bucafunc.id"))) continue;
                MemberRoleSheet.FunctionType functionType = (MemberRoleSheet.FunctionType)buFuncMap.get(buCaId);
                if (null == functionType) {
                    functionType = new MemberRoleSheet.FunctionType(buCaId, buCaFunc.getString("fname"));
                    buFuncMap.put(buCaId, functionType);
                }
                DynamicObjectCollection dimValColl = roleDimGrp.getDynamicObjectCollection("entry");
                HashMap dimValMap = Maps.newHashMapWithExpectedSize((int)dimValColl.size());
                HashMap structProjectMap = Maps.newHashMapWithExpectedSize((int)dimValColl.size());
                for (DynamicObject dimValRow : dimValColl) {
                    boolean isAll;
                    DynamicObject dimension = dimValRow.getDynamicObject("dimension");
                    long dimId = dimension.getLong("id");
                    MemberRoleSheet.Dim dim = (MemberRoleSheet.Dim)dimValMap.get(dimId);
                    if (null == dim) {
                        dim = new MemberRoleSheet.Dim(roleDimGrp.getLong("id"), dimId, dimension.getString("name"), dimension.getString("number"), dimension.getInt("enable"), dimension.getString("datasource"), dimValRow.getBoolean("isall"));
                        dimValMap.put(dimId, dim);
                    }
                    if (isAll = dim.isAll()) continue;
                    DynamicObject structProject = dimValRow.getDynamicObject("structproject");
                    String dimVal = dimValRow.getString("dimval");
                    Pair<String, String> dimValInfoTemp = dimValueInfoMap.get(dimId).get(dimVal);
                    DimValueBean dimValInfo = new DimValueBean();
                    dimValInfo.setDimValName((String)dimValInfoTemp.getLeft());
                    dimValInfo.setDimValCode((String)dimValInfoTemp.getRight());
                    if (null != structProject) {
                        String spNumber = structProject.getString("number");
                        String spName = structProject.getString("name");
                        String spPKId = dimId + "|" + spNumber + "|" + spName;
                        List spValInfo = structProjectMap.computeIfAbsent(spPKId, key -> Lists.newArrayListWithCapacity((int)16));
                        spValInfo.add(dimValInfo);
                        continue;
                    }
                    dim.getDimValues().add(dimValInfo);
                }
                List<MemberRoleSheet.Dim> dims = functionType.getDims();
                for (Map.Entry entry : structProjectMap.entrySet()) {
                    String[] split = ((String)entry.getKey()).split("\\|");
                    MemberRoleSheet.Dim dim = (MemberRoleSheet.Dim)dimValMap.get(Long.valueOf(split[0]));
                    dim.getStructProject().add((Triple<String, String, List<DimValueBean>>)Triple.of((Object)split[1], (Object)split[2], entry.getValue()));
                }
                dims.addAll(dimValMap.values());
            }
            dataRangeSheet.getFuns().addAll(buFuncMap.values());
        }
        return new HashSet<RoleExcel.DataRangeSheet>(roleDataRangeMap.values());
    }

    private static Map<Long, Map<String, Pair<String, String>>> queryRoleDimInfos(DynamicObjectCollection dataRangeEntryColl) {
        HashMap allDimValList = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dataRangeRow : dataRangeEntryColl) {
            DynamicObjectCollection dataValColl = dataRangeRow.getDynamicObjectCollection("roledatavalentry");
            for (DynamicObject dimValRow : dataValColl) {
                List dimValList = allDimValList.computeIfAbsent(dimValRow.getLong("rdata_dimension.id"), key -> Lists.newArrayListWithExpectedSize((int)10));
                dimValList.add(dimValRow.getString("rdata_dimval"));
            }
        }
        return PermInitServiceHelper.structDimInfo((Map)allDimValList);
    }

    private static Set<RoleExcel.FieldPermSheet> getRoleFieldPerm(DynamicObject initRecord, Map<String, String> roleNameMap) {
        DynamicObjectCollection fieldPermColl = initRecord.getDynamicObjectCollection("rolefieldentry");
        HashMap entityFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        LinkedHashSet fieldPermSheets = Sets.newLinkedHashSetWithExpectedSize((int)fieldPermColl.size());
        for (DynamicObject fieldPerm : fieldPermColl) {
            DynamicObject entityType = fieldPerm.getDynamicObject("rfield_entitytype");
            String entityNum = entityType.getString("id");
            Map fieldMap = (Map)entityFieldMap.get(entityNum);
            if (MapUtils.isEmpty((Map)fieldMap)) {
                fieldMap = RoleServiceHelper.getEntityFieldMap((String)entityNum);
                entityFieldMap.put(entityNum, fieldMap);
            }
            String roleNumber = fieldPerm.getString("rfield_rolenumber");
            String propKey = fieldPerm.getString("rfield_propkey");
            fieldPermSheets.add(new RoleExcel.FieldPermSheet(roleNumber, roleNameMap.get(roleNumber), fieldPerm.getString("rfield_app.number"), fieldPerm.getString("rfield_app.name"), fieldPerm.getString("rfield_entitytype.id"), fieldPerm.getString("rfield_entitytype.name"), propKey, (String)fieldMap.get(propKey), !fieldPerm.getBoolean("rfield_canread"), !fieldPerm.getBoolean("rfield_canwrite"), fieldPerm.getString("rfield_errormsg")));
        }
        return fieldPermSheets;
    }

    private static Map<String, String> getRoleNameMap(DynamicObject initRecord) {
        DynamicObjectCollection roleBaseCol = initRecord.getDynamicObjectCollection("rolebaseentry");
        LinkedHashMap roleNameMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : roleBaseCol) {
            String rbaseName = dynamicObject.getString("rbase_name");
            String rbaseNumber = dynamicObject.getString("rbase_number");
            roleNameMap.put(rbaseNumber, rbaseName);
        }
        return roleNameMap;
    }

    private void addRoleSheet(String sheetName, DynamicObject recordDyna) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        sheet.setZoom(80);
        Map<String, Integer> colIndexMap = this.addRoleSheetHeader(sheet);
        this.addRoleBody(sheet, recordDyna, colIndexMap);
    }

    public Map<String, Integer> addRoleSheetHeader(XSSFSheet sheet) {
        LOGGER.info("Begin  addRoleHeader.");
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\uff1b4\u3001\u4e00\u6b21\u6700\u591a\u5bfc\u5165300\u4e2a\u89d2\u8272\uff1b5\u3001\u5f53\u8c03\u6574\u4e86\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u540e\uff0c\u8bf7\u68c0\u67e5\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e\u4e2d\u89d2\u8272\u5217\u52fe\u9009\u7684\u6743\u9650\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"RoleTemplateExcelWriter_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int startRow = 1;
        int startCol = 0;
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        if (this.showErrorMsg) {
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, mustCellStyle, ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            startCol = 1;
        }
        Map<String, Integer> colIndexMap = this.addRoleHeaderCol(sheet, startRow, startCol);
        if (this.showErrorMsg) {
            colIndexMap.put(ERROR_MSG, 0);
        }
        colIndexMap.put("roleNumber", startCol);
        return colIndexMap;
    }

    private void addRoleBody(XSSFSheet sheet, DynamicObject recordDyna, Map<String, Integer> colIndexMap) {
        DynamicObjectCollection roleEntryColl = recordDyna.getDynamicObjectCollection("rolebaseentry");
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        commonCellStyle1.setWrapText(true);
        int rowIndex = 5;
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"hrcs_role");
        for (DynamicObject role : roleEntryColl) {
            for (EnabledLang enabledLang : enabledLangList) {
                String number = enabledLang.getNumber();
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleName_" + number), commonCellStyle1, ((OrmLocaleValue)role.get("rbase_name")).get((Object)number));
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleRemark_" + number), commonCellStyle1, ((OrmLocaleValue)role.get("rbase_remark")).get((Object)number));
            }
            if (this.showErrorMsg) {
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get(ERROR_MSG), commonCellStyle1, role.getString("rbase_errormsg"));
            }
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleNumber"), commonCellStyle1, role.getString("rbase_number"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleGroupNumber"), commonCellStyle1, role.getString("rbase_group.number"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleGroupName"), commonCellStyle1, role.getString("rbase_group.name"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleProperty"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("property")).getItemByName(role.getString("rbase_property")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleCBisIntersection"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("isintersection")).getItemByName(role.getString("rbase_isintersection")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("useScope"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("usescope")).getItemByName(role.getString("rbase_usescope")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("createAdminGrpNumber"), commonCellStyle1, role.getString("rbase_createadmingrp.number"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("createAdminGrpName"), commonCellStyle1, role.getString("rbase_createadmingrp.name"));
            DynamicObjectCollection openScopeView = role.getDynamicObjectCollection("rbase_openscopeview");
            String openScopeViewInfo = openScopeView.stream().filter(it -> !ObjectUtils.isEmpty((Object)it.getDynamicObject("fbasedataid"))).map(it -> it.getString("fbasedataid.name")).collect(Collectors.joining(";"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("openRangeWithView"), commonCellStyle1, openScopeViewInfo);
            DynamicObjectCollection openScopeEdit = role.getDynamicObjectCollection("rbase_openscopeedit");
            String openScopeEditInfo = openScopeEdit.stream().filter(it -> !ObjectUtils.isEmpty((Object)it.getDynamicObject("fbasedataid"))).map(it -> it.getString("fbasedataid.name")).collect(Collectors.joining(";"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("openRangeWithEdit"), commonCellStyle1, openScopeEditInfo);
            ++rowIndex;
        }
    }

    private void writeDataRangeError(DynamicObject recordDyna, Map<String, String> roleNameMap, RoleTemplateExcelWriter writer, int lastCol, boolean showErrorMsg) {
        int structStart;
        List dataRangeModelList = this.service.getDataRangeModelList(recordDyna);
        HashSet dimIdSet = Sets.newHashSetWithExpectedSize((int)dataRangeModelList.size());
        HashSet structIdSet = Sets.newHashSetWithExpectedSize((int)dataRangeModelList.size());
        for (DataRangeInitModel dataRangeInitModel : dataRangeModelList) {
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            for (Map.Entry entry : structValueMap.entrySet()) {
                String key = (String)entry.getKey();
                String[] split = key.split("#");
                dimIdSet.add(Long.parseLong(split[0]));
                if (split.length <= 1) continue;
                structIdSet.add(Long.parseLong(split[1]));
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dims = serviceHelper.queryOriginalArray("id,number", new QFilter[]{new QFilter("id", "in", (Object)dimIdSet)});
        HRBaseServiceHelper serviceHelper2 = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] struct = serviceHelper2.queryOriginalArray("id,number", new QFilter[]{new QFilter("id", "in", (Object)structIdSet)});
        Map<Long, String> dimNumberMap = Arrays.stream(dims).collect(Collectors.toMap(dim -> dim.getLong("id"), dim -> dim.getString("number")));
        Map<Long, String> structNumberMap = Arrays.stream(struct).collect(Collectors.toMap(st -> st.getLong("id"), st -> st.getString("number")));
        SXSSFWorkbook workbook = writer.getWorkbook();
        XSSFSheet sheet = workbook.getXSSFWorkbook().getSheetAt(3);
        XSSFRow row = sheet.getRow(1);
        XSSFCell cell = row.getCell(structStart = 4);
        if (cell == null) {
            structStart = 5;
        }
        HashMap keyColNumMap = Maps.newHashMapWithExpectedSize((int)100);
        while (cell != null) {
            String stringCellValue = cell.getStringCellValue();
            keyColNumMap.put(stringCellValue, structStart);
            cell = row.getCell(++structStart);
        }
        int rowNum = 5;
        int startColIndex = 0;
        if (showErrorMsg) {
            sheet.shiftColumns(0, structStart - 1, 1);
            XSSFRow row1 = sheet.getRow(0);
            XSSFCell cellTop = row1.getCell(1);
            this.addCellRegion((Sheet)sheet, 0, 0, writer.styles.getTitleStyle(), cellTop.getStringCellValue());
            row1.removeCell((Cell)cellTop);
            String content = ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6", (String)"RoleTemplateExcelWriter_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String tip = ResManager.loadKDString((String)"\u6839\u636e\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\uff0c\u83b7\u53d6\u89d2\u8272\u5404\u804c\u80fd\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            if (lastCol > 5) {
                CellStyle mustCellStyle = writer.styles.getTitleStyle("header-center");
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, 5, lastCol, mustCellStyle, content, tip);
            }
            CellStyle header = writer.styles.getTitleStyle("header");
            content = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, header, content, "");
            sheet.setColumnWidth(0, content.getBytes().length * 400);
            ++startColIndex;
        }
        XSSFCellStyle commonCellStyle = workbook.getXSSFWorkbook().createCellStyle();
        commonCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        commonCellStyle.setDataFormat(workbook.getXSSFWorkbook().createDataFormat().getFormat("@"));
        commonCellStyle.setAlignment(HorizontalAlignment.GENERAL);
        XSSFCellStyle errorCellStyle = workbook.getXSSFWorkbook().createCellStyle();
        errorCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        errorCellStyle.setDataFormat(workbook.getXSSFWorkbook().createDataFormat().getFormat("@"));
        errorCellStyle.setAlignment(HorizontalAlignment.GENERAL);
        Font font = workbook.createFont();
        font.setBold(true);
        font.setColor(IndexedColors.RED.getIndex());
        errorCellStyle.setFont(font);
        HashMap roleNumIndexMap = Maps.newHashMapWithExpectedSize((int)dataRangeModelList.size());
        for (DataRangeInitModel dataRangeInitModel : dataRangeModelList) {
            roleNumIndexMap.put(dataRangeInitModel.getRoleNumber(), rowNum);
            this.addCellRegion((Sheet)sheet, rowNum, startColIndex, (CellStyle)commonCellStyle, dataRangeInitModel.getRoleNumber());
            this.addCellRegion((Sheet)sheet, rowNum, startColIndex + 1, (CellStyle)commonCellStyle, roleNameMap.get(dataRangeInitModel.getRoleNumber()));
            this.addCellRegion((Sheet)sheet, rowNum, startColIndex + 2, (CellStyle)commonCellStyle, dataRangeInitModel.getBuCaFuncName());
            this.addCellRegion((Sheet)sheet, rowNum, startColIndex + 3, (CellStyle)commonCellStyle, dataRangeInitModel.getOrgRange());
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            for (Map.Entry entry : structValueMap.entrySet()) {
                if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                String key = (String)entry.getKey();
                String[] split = key.split("#");
                String excelKey = dimNumberMap.get(Long.parseLong(split[0]));
                if (split.length > 1) {
                    excelKey = excelKey + "#" + structNumberMap.get(Long.parseLong(split[1]));
                }
                Integer colNum = (Integer)keyColNumMap.get(excelKey) + startColIndex;
                this.addCellRegion((Sheet)sheet, rowNum, (int)colNum, (CellStyle)commonCellStyle, (String)entry.getValue());
            }
            ++rowNum;
        }
        if (!showErrorMsg) {
            return;
        }
        DynamicObjectCollection dataRangeEntry = recordDyna.getDynamicObjectCollection("roledataentry");
        DynamicObjectCollection dataRangeErrorRowEntry = recordDyna.getDynamicObjectCollection("roledatarowerrorentry");
        rowNum = 5;
        CellStyle errorStyle = writer.styles.getTextStyle("body-errormsg");
        for (Object dim2 : dataRangeEntry) {
            String errMsg = dim2.getString("rdata_errormsg");
            if (!HRStringUtils.isEmpty((String)errMsg)) {
                this.addCellRegion((Sheet)sheet, rowNum, 0, errorStyle, errMsg);
            }
            ++rowNum;
        }
        HashSet bosFuncIdSet = Sets.newHashSetWithExpectedSize((int)dataRangeErrorRowEntry.size());
        for (DynamicObject dimError : dataRangeErrorRowEntry) {
            bosFuncIdSet.add(dimError.getLong("rdatarow_bucafunc.id"));
        }
        Map hrFuncNameMap = this.service.getHrFuncNameMap((Set)bosFuncIdSet);
        for (DynamicObject dimError : dataRangeErrorRowEntry) {
            int errRowNum;
            String roleNumber = dimError.getString("rdatarow_rolenumber");
            Long buCaFuncId = dimError.getLong("rdatarow_bucafunc.id");
            String buCaFuncName = (String)hrFuncNameMap.get(buCaFuncId);
            String errorMsg = dimError.getString("rdatarow_errormsg");
            Integer index = (Integer)roleNumIndexMap.get(roleNumber);
            if (index == null) {
                errRowNum = rowNum;
            } else {
                errRowNum = index + 1;
                sheet.shiftRows(errRowNum, dataRangeModelList.size() + 5, 1);
            }
            Cell cell1 = this.addCellRegion((Sheet)sheet, errRowNum, 1, (CellStyle)commonCellStyle, roleNumber);
            cell1.getCellStyle().setFillForegroundColor(IndexedColors.YELLOW.getIndex());
            Cell cell2 = this.addCellRegion((Sheet)sheet, errRowNum, 3, (CellStyle)commonCellStyle, buCaFuncName);
            cell2.getCellStyle().setFillForegroundColor(IndexedColors.YELLOW.getIndex());
            Cell cell3 = this.addCellRegion((Sheet)sheet, errRowNum, 0, (CellStyle)errorCellStyle, errorMsg);
            cell3.getCellStyle().setFillForegroundColor(IndexedColors.YELLOW.getIndex());
            ++rowNum;
        }
    }
}

