/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleExcel;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleTemplateExcelWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class RoleTemplateDemoExcelWriter
extends RoleTemplateExcelWriter {
    private static final Log LOGGER = LogFactory.getLog(RoleTemplateDemoExcelWriter.class);
    private static final int COL_WIDTH_NUM = 192;
    public static final String DROP_DOWN_SHEET_PREX = "DDM_";
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private Map<String, String> allFunMap;

    public RoleTemplateDemoExcelWriter(Map<String, String> allFunMap) {
        this.allFunMap = allFunMap;
    }

    public void addRoleSheet(String sheetName) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        Map<String, Integer> colIndexMap = this.addRoleHeaderWithIndex(sheet);
        this.addRoleListBody(sheet, colIndexMap);
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangList) {
            String number = enabledLang.getNumber();
            Integer nameIndex = colIndexMap.get("roleName_" + number);
            Integer remarkIndex = colIndexMap.get("roleRemark_" + number);
            if (!ObjectUtils.isEmpty((Object)nameIndex)) {
                sheet.setColumnWidth(nameIndex.intValue(), 3400);
            }
            if (!ObjectUtils.isEmpty((Object)remarkIndex)) {
                sheet.setColumnWidth(remarkIndex.intValue(), 3000);
            }
            if (!"zh_TW".equals(number)) continue;
            sheet.setColumnHidden(nameIndex.intValue(), true);
            sheet.setColumnHidden(remarkIndex.intValue(), true);
        }
        sheet.setColumnWidth(0, 2000);
        sheet.setColumnWidth(1, 7000);
        sheet.setColumnWidth(colIndexMap.get("roleProperty").intValue(), 3300);
        sheet.setColumnWidth(colIndexMap.get("roleCBisIntersection").intValue(), 6300);
        sheet.setColumnWidth(colIndexMap.get("useScope").intValue(), 1400);
        sheet.setColumnWidth(colIndexMap.get("createAdminGrpNumber").intValue(), 2000);
        sheet.setColumnWidth(colIndexMap.get("createAdminGrpName").intValue(), 2100);
        sheet.setColumnWidth(colIndexMap.get("openRangeWithView").intValue(), 5500);
        sheet.setColumnWidth(colIndexMap.get("openRangeWithEdit").intValue(), 5000);
        sheet.setZoom(80);
    }

    private Map<String, Integer> addRoleHeaderWithIndex(XSSFSheet sheet) {
        LOGGER.info("Begin  addRoleHeader.");
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u7070\u8272\u5217\u4e3a\u7cfb\u7edf\u81ea\u52a8\u52a0\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u8c03\u6574\uff1b4\u3001\u8bf7\u6309\u89d2\u8272\u52fe\u9009\u529f\u80fd\u6743\u9650\u9879\uff1b5\u3001\u5f53\u8c03\u6574\u4e86\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u540e\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u9875\u7b7e\u7684\u89d2\u8272\u4e0e\u5bf9\u5e94\u7684\u529f\u80fd\u6743\u9650\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"RoleTemplateExcelWriter_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 1, 1, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int startRow = 1;
        int startCol = 2;
        Map<String, Integer> colIndexMap = this.addRoleHeaderCol(sheet, startRow, startCol);
        colIndexMap.put("roleNumber", startCol);
        return colIndexMap;
    }

    private void addRoleListBody(XSSFSheet sheet, Map<String, Integer> colIndexMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_role");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,rolenumber,rolename,rolegroupnumber,rolegroupname,roleproperty,rolecbisintersection,admingroupnumber,admingroupname,usescope,publicscopeview,publicscopeedit,roleremark", new QFilter[0], "sceneid,index");
        this.scene(sheet, items, colIndexMap);
    }

    private void scene(XSSFSheet sheet, DynamicObject[] items, Map<String, Integer> colIndexMap) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        commonCellStyle1.setWrapText(true);
        int rowIndex = 5;
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"hrcs_role");
        String scenename = "";
        String scenedesc = "";
        for (DynamicObject item : items) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            if (rowIndex == 5) {
                scenename = item.getString("scenename");
                scenedesc = item.getString("scenedesc");
            }
            for (EnabledLang enabledLang : enabledLangList) {
                String number = enabledLang.getNumber();
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleName_" + number), commonCellStyle1, ((OrmLocaleValue)item.get("rolename")).get((Object)number));
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleRemark_" + number), commonCellStyle1, ((OrmLocaleValue)item.get("roleremark")).get((Object)number));
            }
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleNumber"), commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleGroupNumber"), commonCellStyle1, item.getString("rolegroupnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleGroupName"), commonCellStyle1, item.getString("rolegroupname"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleProperty"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("property")).getItemByName(item.getString("roleproperty")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleCBisIntersection"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("isintersection")).getItemByName(item.getString("rolecbisintersection")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("useScope"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("usescope")).getItemByName(item.getString("usescope")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("createAdminGrpNumber"), commonCellStyle1, item.getString("admingroupnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("createAdminGrpName"), commonCellStyle1, item.getString("admingroupname"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("openRangeWithView"), commonCellStyle1, item.getString("publicscopeview"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("openRangeWithEdit"), commonCellStyle1, item.getString("publicscopeedit"));
            ++rowIndex;
        }
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 5, 6, 0, 0, commonCellStyle1, scenename);
        Cell cell = this.addMergedRegionWithWhiteBorder((Sheet)sheet, 5, 6, 1, 1, commonCellStyle1, scenedesc);
        Row row = cell.getRow();
        row.setHeight((short)800);
    }

    public static void calcAndSetRowHeigt(Cell cell) {
        String cellContent = RoleTemplateDemoExcelWriter.getCellContentAsString(cell);
        if (null != cellContent && !"".equals(cellContent)) {
            double stringNeedsHeight;
            Row row = cell.getRow();
            double maxHeight = row.getHeight();
            Map<String, Object> cellInfoMap = RoleTemplateDemoExcelWriter.getCellInfo(cell);
            Integer cellWidth = (Integer)cellInfoMap.get("width");
            Integer cellHeight = (Integer)cellInfoMap.get("height");
            if ((double)cellHeight.intValue() > maxHeight) {
                maxHeight = cellHeight.intValue();
            }
            XSSFCellStyle cellstyle = (XSSFCellStyle)cell.getCellStyle();
            XSSFFont font = cellstyle.getFont();
            short fontHeight = font.getFontHeight();
            double cellContentWidth = cellContent.getBytes().length * 2 * 256;
            double stringNeedsRows = cellContentWidth / (double)cellWidth.intValue();
            if (stringNeedsRows < 1.0) {
                stringNeedsRows = 1.0;
            }
            if ((stringNeedsHeight = (double)fontHeight * stringNeedsRows) > maxHeight) {
                maxHeight = stringNeedsHeight / 2.25;
                maxHeight = Math.ceil(maxHeight);
                Boolean isPartOfRowsRegion = (Boolean)cellInfoMap.get("isPartOfRowsRegion");
                if (isPartOfRowsRegion.booleanValue()) {
                    Integer firstRow = (Integer)cellInfoMap.get("firstRow");
                    Integer lastRow = (Integer)cellInfoMap.get("lastRow");
                    double addHeight = (maxHeight - (double)cellHeight.intValue()) / (double)(lastRow - firstRow + 1);
                    for (int i = firstRow.intValue(); i <= lastRow; ++i) {
                        double rowsRegionHeight = (double)row.getSheet().getRow(i).getHeight() + addHeight;
                        row.getSheet().getRow(i).setHeight((short)rowsRegionHeight);
                    }
                } else if (maxHeight > (double)cell.getRow().getHeight()) {
                    row.setHeight((short)maxHeight);
                }
            } else {
                row.setHeight((short)stringNeedsHeight);
            }
        }
    }

    private static Map<String, Object> getCellInfo(Cell cell) {
        Sheet sheet = cell.getSheet();
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        boolean isPartOfRegion = false;
        int firstColumn = 0;
        int lastColumn = 0;
        int firstRow = 0;
        int lastRow = 0;
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            firstColumn = ca.getFirstColumn();
            lastColumn = ca.getLastColumn();
            firstRow = ca.getFirstRow();
            lastRow = ca.getLastRow();
            if (rowIndex < firstRow || rowIndex > lastRow || columnIndex < firstColumn || columnIndex > lastColumn) continue;
            isPartOfRegion = true;
            break;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer width = 0;
        Integer height = 0;
        boolean isPartOfRowsRegion = false;
        if (isPartOfRegion) {
            int i;
            for (i = firstColumn; i <= lastColumn; ++i) {
                width = width + sheet.getColumnWidth(i);
            }
            for (i = firstRow; i <= lastRow; ++i) {
                height = height + sheet.getRow(i).getHeight();
            }
            if (lastRow > firstRow) {
                isPartOfRowsRegion = true;
            }
        } else {
            width = sheet.getColumnWidth(columnIndex);
            height = height + cell.getRow().getHeight();
        }
        map.put("firstRow", firstRow);
        map.put("lastRow", lastRow);
        map.put("firstColumn", firstColumn);
        map.put("lastColumn", lastColumn);
        map.put("width", width);
        map.put("height", height);
        map.put("isPartOfRowsRegion", isPartOfRowsRegion);
        return map;
    }

    private static String getCellContentAsString(Cell cell) {
        if (null == cell) {
            return "";
        }
        String result = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                String s = String.valueOf(cell.getNumericCellValue());
                if (s != null && s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                result = s;
                break;
            }
            case STRING: {
                result = String.valueOf(cell.getStringCellValue());
                break;
            }
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                break;
            }
        }
        return result;
    }

    public void addFunctionItemSheet(String sheetName) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        this.addFunctionItemHeader(sheet);
        this.addFunctionItemBody(sheet);
        sheet.createFreezePane(11, 4);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(3, 3000);
        sheet.setColumnWidth(5, 3000);
        sheet.setColumnWidth(9, 4500);
        sheet.setColumnWidth(10, 10000);
        sheet.setColumnWidth(11, 3400);
        sheet.setColumnWidth(12, 3400);
        sheet.setColumnWidth(13, 3400);
        sheet.setColumnWidth(14, 3400);
        sheet.setZoom(80);
    }

    @Override
    public void addFunctionItemHeader(XSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u7070\u8272\u5217\u4e3a\u7cfb\u7edf\u81ea\u52a8\u52a0\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u8c03\u6574\uff1b4\u3001\u8bf7\u6309\u89d2\u8272\u52fe\u9009\u529f\u80fd\u6743\u9650\u9879\uff1b5\u3001\u5f53\u8c03\u6574\u4e86\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u540e\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u9875\u7b7e\u7684\u89d2\u8272\u4e0e\u5bf9\u5e94\u7684\u529f\u80fd\u6743\u9650\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"RoleTemplateExcelWriter_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 3, 0, 0, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 3, 1, 1, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int startRow = 1;
        int startCol = 2;
        this.addFunctionItemHeaderCol(sheet, startRow, startCol);
        String roleSheetName = ResManager.loadKDString((String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f", (String)"PermSheetHelper_91", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        for (int i = 8; i < 12; ++i) {
            Cell cell = this.addCellRegion((Sheet)sheet, 2, i + 3);
            cell.setCellStyle(centerCellStyle);
            cell.setCellType(CellType.STRING);
            String str = "IF(COUNTBLANK(" + roleSheetName + "!C" + (i - 2) + "),\"\",TRANSPOSE(" + roleSheetName + "!C" + (i - 2) + "))";
            cell.setCellFormula(str);
            Cell cell2 = this.addCellRegion((Sheet)sheet, 3, i + 3);
            cell2.setCellStyle(centerCellStyle);
            cell2.setCellType(CellType.STRING);
            String str2 = "IF(COUNTBLANK(" + roleSheetName + "!D" + (i - 2) + "),\"\",TRANSPOSE(" + roleSheetName + "!D" + (i - 2) + "))";
            cell2.setCellFormula(str2);
        }
    }

    public void addFunctionItemBody(XSSFSheet sheet) {
        CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_fc");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,entryentity.cloudnum,entryentity.cloudname,entryentity.appnum,entryentity.appname,entryentity.entitynum,entryentity.entityname,entryentity.bucafuncname,entryentity.dimname,entryentity.name,entryentity.payroll_01,entryentity.payroll_02,entryentity.payroll_03,entryentity.ch_020", new QFilter[0], "sceneid,index");
        int rowIndex = 4;
        for (DynamicObject item : items) {
            DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
            if (entryentity.isEmpty()) continue;
            int size = entryentity.size() + rowIndex - 1;
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 4, size, 0, 0, commonCellStyle, item.getString("scenename"));
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 4, size, 1, 1, commonCellStyle, item.getString("scenedesc").replaceAll("1\u3001", "\n1\u3001").replaceAll("2\u3001", "\n2\u3001"));
            XSSFFont redFont = sheet.getWorkbook().createFont();
            redFont.setColor(IndexedColors.RED.getIndex());
            redFont.setBold(false);
            for (DynamicObject dynamicObject : entryentity) {
                Cell cell;
                XSSFRichTextString xssfRichTextString;
                int colIndex = 2;
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("cloudnum"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("cloudname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("appnum"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("appname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("entitynum"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("entityname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("name"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, this.allFunMap.get(dynamicObject.getString("bucafuncname")));
                String dimname = dynamicObject.getString("dimname");
                if (rowIndex == 7 || rowIndex == 8 || rowIndex == 9 || rowIndex == 10 || rowIndex == 11) {
                    redFont.setFontHeightInPoints((short)12);
                    xssfRichTextString = new XSSFRichTextString(dimname);
                    xssfRichTextString.applyFont(8, 13, (Font)redFont);
                    xssfRichTextString.applyFont(14, 20, this.getOriginalFont());
                    cell = this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dimname);
                    cell.setCellValue((RichTextString)xssfRichTextString);
                } else if (rowIndex == 13 || rowIndex == 14 || rowIndex == 15 || rowIndex == 16 || rowIndex == 17) {
                    xssfRichTextString = new XSSFRichTextString(dimname);
                    xssfRichTextString.applyFont(0, 7, (Font)redFont);
                    xssfRichTextString.applyFont(8, 11, this.getOriginalFont());
                    cell = this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dimname);
                    cell.setCellValue((RichTextString)xssfRichTextString);
                } else {
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dimname);
                }
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("payroll_01"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("ch_020"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("payroll_02"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("payroll_03"));
                ++rowIndex;
            }
        }
    }

    public void addDimSheet(String sheetName) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        this.addDimHeader(sheet);
        this.addDimBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(3, 3500);
        sheet.setColumnWidth(4, 3500);
        sheet.setZoom(80);
    }

    public void addDimHeader(XSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1.\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2.\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3.\u4e0d\u5141\u8bb8\u8c03\u6574\u7ef4\u5ea6\u5217\uff1b4.\u52fe\u9009\u5f53\u524d\u89d2\u8272\u9700\u8981\u63a7\u6743\u7684\u7ef4\u5ea6\uff1b5.\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"RoleTemplateExcelWriter_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 3, 0, 0, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 3, 1, 1, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        centerCellStyle.setWrapText(true);
        int startRow = 1;
        int startCol = 2;
        this.addDimHeaderCol(sheet, startRow, startCol);
        String content = ResManager.loadKDString((String)"\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f", (String)"RoleDemoExcelWriter_43", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String orgTip = ResManager.loadKDString((String)"\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\norg2\u3010**\u516c\u53f8\u3011<\u5305\u542b\u4e0b\u7ea7>;\norg2<\u5305\u542b\u4e0b\u7ea7>\uff1b\n4\u3001\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u6570\u636e\u8303\u56f4\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\nDYNA_COND_10020\u3010\u4efb\u804c\u90e8\u95e8\u53ca\u4e0b\u7ea7\u90e8\u95e8\u3011\u3002", (String)"PermSheetHelper_50", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 3, 5, centerCellStyle, content, orgTip);
        sheet.setColumnWidth(5, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"RoleDemoExcelWriter_44", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 3, 6, centerCellStyle, content);
        sheet.setColumnWidth(6, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f", (String)"RoleDemoExcelWriter_45", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 3, 7, centerCellStyle, content);
        sheet.setColumnWidth(7, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"RoleDemoExcelWriter_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 3, 8, centerCellStyle, content);
        sheet.setColumnWidth(8, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6", (String)"RoleTemplateExcelWriter_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u6839\u636e\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\uff0c\u83b7\u53d6\u89d2\u8272\u5404\u804c\u80fd\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, 5, 8, centerCellStyle, content, tip);
    }

    private void addDimBody(XSSFSheet sheet) {
        int startIndex;
        CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_dim");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,entryentity.rolenumber,entryentity.rolename,entryentity.bucafuncname,entryentity.adminorg,entryentity.salarygroup,entryentity.servicetpl,entryentity.countryarea", new QFilter[0], "sceneid,index");
        int rowIndex = startIndex = 4;
        for (DynamicObject item : items) {
            DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
            if (entryentity.isEmpty()) continue;
            int size = entryentity.size() + rowIndex - 1;
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, rowIndex, size, 0, 0, commonCellStyle, item.getString("scenename"));
            Cell cell = this.addMergedRegionWithWhiteBorder((Sheet)sheet, rowIndex, size, 1, 1, commonCellStyle, item.getString("scenedesc"));
            Row row = cell.getRow();
            row.setHeight((short)1100);
            for (DynamicObject dynamicObject : entryentity) {
                int colIndex = 2;
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("rolenumber"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("rolename"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, this.allFunMap.get(dynamicObject.getString("bucafuncname")));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("adminorg"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("salarygroup"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("servicetpl"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("countryarea"));
                ++rowIndex;
            }
        }
    }

    public void addDataRangeSheet(String sheetName) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        this.addDataRangeHeader(sheet, null);
        this.addDataRangeBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(3, 3500);
        sheet.setColumnWidth(4, 3500);
        sheet.setColumnWidth(5, 5000);
        sheet.setColumnWidth(6, 4000);
        sheet.setColumnWidth(8, 5000);
        sheet.setZoom(80);
    }

    @Override
    public int addDataRangeHeader(XSSFSheet sheet, RoleExcel roleExcel) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"RoleTemplateExcelWriter_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        centerCellStyle.setWrapText(true);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 1, 1, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int startRow = 1;
        int startCol = 2;
        this.addDataRangeHeaderCol(sheet, startRow, startCol);
        String content = ResManager.loadKDString((String)"\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f", (String)"RoleDemoExcelWriter_43", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\norg2\u3010**\u516c\u53f8\u3011<\u5305\u542b\u4e0b\u7ea7>;\norg2<\u5305\u542b\u4e0b\u7ea7>\uff1b\n4\u3001\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u6570\u636e\u8303\u56f4\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\nDYNA_COND_10020\u3010\u4efb\u804c\u90e8\u95e8\u53ca\u4e0b\u7ea7\u90e8\u95e8\u3011\u3002", (String)"PermSheetHelper_50", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, 6, 7, centerCellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u884c\u653f\u67b6\u6784", (String)"RoleDemoExcelWriter_47", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 4, 6, centerCellStyle, content);
        sheet.setColumnWidth(6, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u9879\u76ee\u67b6\u6784", (String)"RoleDemoExcelWriter_48", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 4, 7, centerCellStyle, content);
        sheet.setColumnWidth(7, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"RoleDemoExcelWriter_44", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, 8, 8, centerCellStyle, content);
        sheet.setColumnWidth(8, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f", (String)"RoleDemoExcelWriter_45", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, 9, 9, centerCellStyle, content);
        sheet.setColumnWidth(9, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"RoleDemoExcelWriter_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, 10, 10, centerCellStyle, content);
        sheet.setColumnWidth(10, content.getBytes().length * 192);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, 6, 10, centerCellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6", (String)"RoleDemoExcelWriter_49", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0e\u201c\u89d2\u8272\u7ef4\u5ea6\u201d\u9875\u7b7e\u6807\u8bb0\u7684\u89d2\u8272\u7ef4\u5ea6\u4e00\u81f4\u3002", (String)"RoleDemoExcelWriter_51", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        return 0;
    }

    private void addDataRangeBody(XSSFSheet sheet) {
        CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_dr");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,rolenumber,rolename,bucafuncname,orgrange,adminorg,projectteam,salarygroup,servicetpl,countryarea,orgrangetip,adminorgtip", new QFilter[0], "sceneid,index");
        int rowIndex = 5;
        String sen3Name = "";
        String sen3Desc = "";
        String sen4Name = "";
        String sen4Desc = "";
        for (DynamicObject item : items) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle, item.getString("scenedesc").replaceAll("1\u3001", "\n1\u3001").replaceAll("2\u3001", "\n2\u3001"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle, this.allFunMap.get(item.getString("bucafuncname")));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle, item.getString("orgrange"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle, item.getString("adminorg"), item.getString("adminorgtip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n").replaceAll("\uff1a", "\uff1a\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle, item.getString("projectteam"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle, item.getString("salarygroup"));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle, item.getString("servicetpl"));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle, item.getString("countryarea"));
            if (rowIndex == 7) {
                sen3Name = item.getString("scenename");
                sen3Desc = item.getString("scenedesc").replaceAll("1\u3001", "\n1\u3001").replaceAll("2\u3001", "\n2\u3001");
            }
            if (rowIndex == 9) {
                sen4Name = item.getString("scenename");
                sen4Desc = item.getString("scenedesc").replaceAll("1\u3001", "\n1\u3001").replaceAll("2\u3001", "\n2\u3001");
            }
            ++rowIndex;
        }
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 7, 8, 0, 0, commonCellStyle, sen3Name);
        Cell cell = this.addMergedRegionWithWhiteBorder((Sheet)sheet, 7, 8, 1, 1, commonCellStyle, sen3Desc);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 9, 10, 0, 0, commonCellStyle, sen4Name);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 9, 10, 1, 1, commonCellStyle, sen4Desc);
        cell.getRow().setHeight((short)1200);
    }

    public void addFieldPermSheet(String sheetName) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        this.addFieldPermHeader(sheet);
        this.addFieldPermBody(sheet);
        sheet.setColumnWidth(1, 17300);
        sheet.setColumnWidth(3, 3500);
        sheet.setColumnWidth(10, 2000);
        sheet.setColumnWidth(11, 2000);
        sheet.setZoom(80);
    }

    private void addFieldPermBody(XSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        commonCellStyle1.setWrapText(true);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_fp");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,rolenumber,rolename,appnumber,appname,entitynumber,entityname,propkey,propname,canread,canwrite", new QFilter[0], "sceneid,index");
        int rowIndex = 3;
        XSSFFont redFont = sheet.getWorkbook().createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        for (DynamicObject item : items) {
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc").replaceAll("1\u3001", "\n1\u3001").replaceAll("2\u3001", "\n2\u3001"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, item.getString("propkey"));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, item.getString("propname"));
            Cell canread = this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle3, item.getString("canread"));
            Cell canwrite = this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle3, item.getString("canwrite"));
            canwrite.getCellStyle().setFont((Font)redFont);
            canread.getCellStyle().setFont((Font)redFont);
            ++rowIndex;
        }
    }

    private void addFieldPermHeader(XSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"RoleTemplateExcelWriter_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        centerCellStyle.setWrapText(true);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 2, 0, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 2, 1, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int startRow = 1;
        int startCol = 2;
        this.addFieldPermHeaderCol(sheet, startRow, startCol);
    }

    private void setDropDown(XSSFSheet sheet, XSSFSheet dropdownSheet, Map<String, Integer> colIndexMap) {
        ArrayList rolePropValuesList = Lists.newArrayListWithExpectedSize((int)2);
        rolePropValuesList.add(ResManager.loadKDString((String)"\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"RoleDemoExcelWriter_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        rolePropValuesList.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"RoleDemoExcelWriter_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.createDropDownSheet(sheet, dropdownSheet, rolePropValuesList, colIndexMap.get("roleProperty"));
        ArrayList cbisValuesList = Lists.newArrayListWithExpectedSize((int)4);
        cbisValuesList.add(ResManager.loadKDString((String)"\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd", (String)"RoleDemoExcelWriter_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        cbisValuesList.add(ResManager.loadKDString((String)"\u4e0d\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd", (String)"RoleDemoExcelWriter_37", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        cbisValuesList.add(ResManager.loadKDString((String)"\u4ec5\u53d7\u89d2\u8272\u6570\u636e\u8303\u56f4\u5f71\u54cd", (String)"RoleDemoExcelWriter_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        cbisValuesList.add(ResManager.loadKDString((String)"\u4ec5\u53d7\u89d2\u8272\u5b57\u6bb5\u6743\u9650\u5f71\u54cd", (String)"RoleDemoExcelWriter_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.createDropDownSheet(sheet, dropdownSheet, cbisValuesList, colIndexMap.get("roleCBisIntersection"));
        ArrayList useScopeValuesList = Lists.newArrayListWithExpectedSize((int)2);
        useScopeValuesList.add(ResManager.loadKDString((String)"\u516c\u5f00", (String)"RoleDemoExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        useScopeValuesList.add(ResManager.loadKDString((String)"\u79c1\u6709", (String)"RoleDemoExcelWriter_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        useScopeValuesList.add(ResManager.loadKDString((String)"\u5206\u914d", (String)"RoleDemoExcelWriter_42", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.createDropDownSheet(sheet, dropdownSheet, useScopeValuesList, colIndexMap.get("useScope"));
    }

    private void createDropDownSheet(XSSFSheet sheet, XSSFSheet dropdownSheet, List<String> inputValuesList, int offSet) {
        if (CollectionUtils.isEmpty(inputValuesList)) {
            return;
        }
        for (int k = 0; k < inputValuesList.size(); ++k) {
            RoleTemplateDemoExcelWriter.getRow(dropdownSheet, k).createCell(offSet).setCellValue(inputValuesList.get(k));
        }
        String formatString = dropdownSheet.getSheetName() + "!$%s$%d:$%s$%d";
        String currColLabel = RoleTemplateDemoExcelWriter.getColumnLabel(offSet + 1);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(1, 10000, offSet, offSet);
        String strFormula = String.format(formatString, currColLabel, 1, currColLabel, inputValuesList.size());
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static String getColumnLabel(int columnNo) {
        if (columnNo < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    private Map<String, Integer> addRoleListHeader(XSSFSheet sheet) {
        int i;
        HashMap<String, Integer> colIndexMap = new HashMap<String, Integer>(16);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u4e0d\u5141\u8bb8\u8c03\u6574\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6\u7684\u987a\u5e8f\uff1b4\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int roleNumberIndex = i = 2;
        this.addCellRegion((Sheet)sheet, 1, roleNumberIndex).setCellValue("roleNumber");
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Lang lang = RequestContext.get().getLang();
        enabledLangList.sort((x1, x2) -> {
            if (lang.name().equals(x2.getNumber())) {
                return 1;
            }
            if (lang.name().equals(x1.getNumber())) {
                return -1;
            }
            return 0;
        });
        for (EnabledLang enabledLang : enabledLangList) {
            int roleNameIndex = ++i;
            this.addCellRegion((Sheet)sheet, 1, roleNameIndex).setCellValue("roleName_" + enabledLang.getNumber());
            colIndexMap.put("roleName_" + enabledLang.getNumber(), roleNameIndex);
        }
        ++i;
        int roleGroupNumberIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, roleGroupNumberIndex).setCellValue("roleGroupNumber");
        int roleGroupNameIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, roleGroupNameIndex).setCellValue("roleGroupName");
        int rolePropertyIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, rolePropertyIndex).setCellValue("roleProperty");
        int roleCBisIntersectionIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, roleCBisIntersectionIndex).setCellValue("roleCBisIntersection");
        int useScopeIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, useScopeIndex).setCellValue("useScope");
        int createAdminGrpNumberIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, createAdminGrpNumberIndex).setCellValue("createAdminGrpNumber");
        int createAdminGrpNameIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, createAdminGrpNameIndex).setCellValue("createAdminGrpName");
        int openRangeWithViewIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, openRangeWithViewIndex).setCellValue("openRangeWithView");
        int openRangeWithEditIndex = i;
        this.addCellRegion((Sheet)sheet, 1, openRangeWithEditIndex).setCellValue("openRangeWithEdit");
        colIndexMap.put("roleNumber", roleNumberIndex);
        colIndexMap.put("roleGroupNumber", roleGroupNumberIndex);
        colIndexMap.put("roleGroupName", roleGroupNameIndex);
        colIndexMap.put("roleProperty", rolePropertyIndex);
        colIndexMap.put("roleCBisIntersection", roleCBisIntersectionIndex);
        colIndexMap.put("useScope", useScopeIndex);
        colIndexMap.put("createAdminGrpNumber", createAdminGrpNumberIndex);
        colIndexMap.put("createAdminGrpName", createAdminGrpNameIndex);
        colIndexMap.put("openRangeWithView", openRangeWithViewIndex);
        colIndexMap.put("openRangeWithEdit", openRangeWithEditIndex);
        for (EnabledLang enabledLang : enabledLangList) {
            int roleRemarkIndex = ++i;
            this.addCellRegion((Sheet)sheet, 1, roleRemarkIndex).setCellValue("roleRemark_" + enabledLang.getNumber());
            colIndexMap.put("roleRemark_" + enabledLang.getNumber(), roleRemarkIndex);
        }
        sheet.getRow(1).getCTRow().setHidden(true);
        LOGGER.info("Begin  addRoleHeader3.");
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        mustCellStyle.setWrapText(true);
        cellStyle.setWrapText(true);
        centerCellStyle.setWrapText(true);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 1, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"RoleTemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RoleTemplateExcelWriter_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 2, 2, mustCellStyle, content, tip);
        tip = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RoleTemplateExcelWriter_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        int j = 3;
        for (EnabledLang enabledLang : enabledLangList) {
            CellStyle style;
            if (lang.name().equals(enabledLang.getNumber())) {
                content = String.format(ResManager.loadKDString((String)"%1$s\u89d2\u8272\u540d\u79f0\uff08%2$s\uff09", (String)"RoleTemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), "*", enabledLang.getName());
                style = mustCellStyle;
            } else {
                content = String.format(ResManager.loadKDString((String)"%1$s\u89d2\u8272\u540d\u79f0\uff08%2$s\uff09", (String)"RoleTemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), "", enabledLang.getName());
                style = cellStyle;
            }
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, j, j, style, content, tip);
            ++j;
        }
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, j, j, cellStyle, content);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u540d\u79f0", (String)"RoleTemplateExcelWriter_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content);
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027", (String)"RoleTemplateExcelWriter_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u89d2\u8272\u4e0b\u7528\u6237\u81ea\u5b9a\u4e49\u8303\u56f4\u3002\n\u5f55\u5165\u503c\uff1a\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u3001\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u3002", (String)"RoleTemplateExcelWriter_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, mustCellStyle, content, tip);
        content = ResManager.loadKDString((String)"*\u81ea\u5b9a\u4e49\u8303\u56f4\u662f\u5426\u53d7\u9650\u4e8e\u89d2\u8272\u8303\u56f4", (String)"RoleTemplateExcelWriter_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u5982\u679c\u5141\u8bb8\u6210\u5458\u81ea\u5b9a\u4e49\u6570\u636e\u8303\u56f4\uff0c\u9700\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7684\u8303\u56f4\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u89d2\u8272\u9650\u5b9a\u7684\u8303\u56f4\n\u5f55\u5165\u503c\uff1a\n\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd\n\u4e0d\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd\n\u4ec5\u53d7\u89d2\u8272\u6570\u636e\u8303\u56f4\u5f71\u54cd\n\u4ec5\u53d7\u89d2\u8272\u5b57\u6bb5\u6743\u9650\u5f71\u54cd", (String)"RoleTemplateExcelWriter_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, mustCellStyle, content, tip);
        content = ResManager.loadKDString((String)"*\u516c\u5f00\u72b6\u6001", (String)"RoleTemplateExcelWriter_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u72b6\u6001\u503c\uff1a\u516c\u5f00\u3001\u79c1\u6709\u3001\u5206\u914d\n\u5206\u914d\u548c\u79c1\u6709\u72b6\u6001\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u3002", (String)"RoleTemplateExcelWriter_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, mustCellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u79c1\u6709\u3001\u5206\u914d\u72b6\u6001\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u6240\u5c5e\u7ba1\u7406\u5458", (String)"RoleTemplateExcelWriter_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u540d\u79f0", (String)"RoleTemplateExcelWriter_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u67e5\u770b\uff09", (String)"RoleTemplateExcelWriter_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u516c\u5f00\u3001\u79c1\u6709\u72b6\u6001\u65e0\u9700\u8bbe\u7f6e\uff1b\n\u5206\u914d\u72b6\u6001\u4e0b\uff0c\u53ef\u6dfb\u52a0\u7ba1\u7406\u5458\u7ec4\u3002", (String)"RoleTemplateExcelWriter_60", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u7f16\u8f91\uff09", (String)"RoleTemplateExcelWriter_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u516c\u5f00\u3001\u5206\u914d\u72b6\u6001\uff0c\u53ef\u6dfb\u52a0\u7ba1\u7406\u5458\u5206\u7ec4\u3002", (String)"RoleTemplateExcelWriter_61", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content, tip);
        ++j;
        for (EnabledLang enabledLang : enabledLangList) {
            content = ResManager.loadKDString((String)"\u89d2\u8272\u63cf\u8ff0\uff08%s\uff09", (String)"RoleTemplateExcelWriter_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{enabledLang.getName()});
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, j, j, cellStyle, content);
            ++j;
        }
        LOGGER.info("End  addRoleHeader.");
        return colIndexMap;
    }

    private static XSSFRow getRow(XSSFSheet sheet, int r) {
        if (r >= 0x100000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_3", (String)"bos-export", (Object[])new Object[0]), 0x100000));
        }
        XSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }
}

