/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DynamicControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.formplugin.web.perm.init.excel.AbstractWriter;
import kd.hr.hrcs.formplugin.web.perm.init.excel.MemberRoleSheet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class TemplateExcelWriter
extends AbstractWriter {
    private static final Log LOGGER = LogFactory.getLog(TemplateExcelWriter.class);
    protected ExportSheetStyle styles;
    protected final Font originalFont;
    protected Map<Integer, Integer> columnWidthMap;

    public TemplateExcelWriter() {
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.styles = new ExportSheetStyle(this.wb, null);
        this.originalFont = this.wb.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        XSSFCellStyle tipsCellStyle = (XSSFCellStyle)this.styles.getTitleStyle();
        XSSFFont tipsFont = tipsCellStyle.getFont();
        tipsFont.setBold(true);
        tipsFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header");
        headerCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCellStyle.setBorderTop(BorderStyle.THIN);
        headerCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerCellFont = headerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerMustInputCellStyle = (XSSFCellStyle)this.styles.getTitleMustInputStyle();
        headerMustInputCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerMustInputCellStyle.setBorderTop(BorderStyle.THIN);
        headerMustInputCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderRight(BorderStyle.THIN);
        headerMustInputCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderBottom(BorderStyle.THIN);
        headerMustInputCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderLeft(BorderStyle.THIN);
        headerMustInputCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerMustInputFont = headerMustInputCellStyle.getFont();
        headerMustInputFont.setBold(true);
        headerMustInputFont.setFontHeightInPoints((short)12);
        headerMustInputFont.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle headerCenterCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header-center");
        headerCenterCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCenterCellStyle.setBorderTop(BorderStyle.THIN);
        headerCenterCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderRight(BorderStyle.THIN);
        headerCenterCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCenterCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCenterCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCenterCellFont = headerCenterCellStyle.getFont();
        headerCenterCellFont.setBold(true);
        headerCenterCellFont.setFontHeightInPoints((short)12);
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        commonCellStyle1.setFont(this.originalFont);
        commonCellStyle1.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBorderTop(BorderStyle.THIN);
        commonCellStyle1.setBorderRight(BorderStyle.THIN);
        commonCellStyle1.setBorderBottom(BorderStyle.THIN);
        commonCellStyle1.setBorderLeft(BorderStyle.THIN);
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-errormsg");
        commonCellStyle2.setFont(this.originalFont);
        commonCellStyle2.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle2.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle2.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle2.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle2.setBorderTop(BorderStyle.THIN);
        commonCellStyle2.setBorderRight(BorderStyle.THIN);
        commonCellStyle2.setBorderBottom(BorderStyle.THIN);
        commonCellStyle2.setBorderLeft(BorderStyle.THIN);
        Font redFont = this.styles.getRedFont();
        commonCellStyle2.setFont(redFont);
    }

    /*
     * Exception decompiling
     */
    public String writeFile(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Font getOriginalFont() {
        return this.originalFont;
    }

    public void addMemberRoleSheet(String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress, boolean queryDimValue) {
        this.columnWidthMap = new HashMap<Integer, Integer>();
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        int lastColumnIndex = this.addMemberRoleHeader(sheet, memberRoleSheetList, enableValidateTime);
        this.addMemberRoleSheetBody(sheet, sheetName, memberRoleSheetList, feedbackProgress, enableValidateTime, lastColumnIndex, queryDimValue);
        this.columnWidthMap.forEach((key, value) -> sheet.setColumnWidth(key.intValue(), value * 256));
    }

    private int addMemberRoleHeader(SXSSFSheet sheet, List<MemberRoleSheet> memberRoleSheetList, boolean enableValidateTime) {
        LOGGER.info("Begin  addMemberRoleHeader.");
        int startColumnIndex = 6;
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u4e0d\u5141\u8bb8\u8c03\u6574\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6\u7684\u987a\u5e8f\uff1b4\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        LOGGER.info("Begin  addMemberRoleHeader 2.");
        int secondRowTemp = 0;
        this.addCellRegion((Sheet)sheet, 1, 0).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, 5).setCellValue("rolename");
        if (enableValidateTime) {
            this.addCellRegion((Sheet)sheet, 1, startColumnIndex).setCellValue("starttime");
            this.addCellRegion((Sheet)sheet, 1, startColumnIndex + 1).setCellValue("endtime");
            secondRowTemp += 2;
        }
        this.addCellRegion((Sheet)sheet, 1, startColumnIndex + secondRowTemp).setCellValue("datascope");
        this.addCellRegion((Sheet)sheet, 1, startColumnIndex + secondRowTemp + 1).setCellValue("butype");
        this.addCellRegion((Sheet)sheet, 1, startColumnIndex + secondRowTemp + 2).setCellValue("buorg");
        TemplateExcelWriter.getRow((SXSSFSheet)sheet, (int)1).setHidden(Boolean.valueOf(true));
        LOGGER.info("Begin  addMemberRoleHeader3.");
        int nextColTemp = 0;
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        mustCellStyle.setWrapText(true);
        cellStyle.setWrapText(true);
        centerCellStyle.setWrapText(true);
        String content = ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, mustCellStyle, content);
        this.cacheColumnWidth(0, content);
        content = ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 1, 1, cellStyle, content);
        this.cacheColumnWidth(1, content);
        content = ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 2, 2, mustCellStyle, content);
        this.cacheColumnWidth(2, content);
        content = ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 3, 3, cellStyle, content);
        this.cacheColumnWidth(3, content);
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 4, 4, mustCellStyle, content);
        this.cacheColumnWidth(4, content);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 5, 5, cellStyle, content);
        this.cacheColumnWidth(5, content);
        if (enableValidateTime) {
            content = ResManager.loadKDString((String)"*\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"PermSheetHelper_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, startColumnIndex, startColumnIndex, mustCellStyle, content, ResManager.loadKDString((String)"\u8bf7\u6309\u7167YYYY-MM-DD\u3001YYYY\u5e74MM\u6708DD\u65e5\u6216YYYY/MM/DD\u7684\u683c\u5f0f\u8f93\u5165\u6709\u6548\u671f\u3002", (String)"PermSheetHelper_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            this.cacheColumnWidth(startColumnIndex, content);
            content = ResManager.loadKDString((String)"*\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"PermSheetHelper_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, startColumnIndex + 1, startColumnIndex + 1, mustCellStyle, content, ResManager.loadKDString((String)"\u8bf7\u6309\u7167YYYY-MM-DD\u3001YYYY\u5e74MM\u6708DD\u65e5\u6216YYYY/MM/DD\u7684\u683c\u5f0f\u8f93\u5165\u6709\u6548\u671f\u3002", (String)"PermSheetHelper_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            this.cacheColumnWidth(startColumnIndex + 1, content);
            nextColTemp += 2;
        }
        content = ResManager.loadKDString((String)"*\u6570\u636e\u8303\u56f4\u5c5e\u6027", (String)"PermSheetHelper_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, startColumnIndex + nextColTemp, startColumnIndex + nextColTemp, mustCellStyle, content, ResManager.loadKDString((String)"\u5982\u679c\u4e0b\u8f7d\u7684\u6570\u636e\u81ea\u5e26\u503c\uff0c\u5219\u8868\u793a\u89d2\u8272\u53ea\u5141\u8bb8\u6309\u5f53\u524d\u503c\u5bfc\u5165\uff1b\n\u5982\u679c\u4e0b\u8f7d\u7684\u89d2\u8272\u65e0\u503c\uff0c\u5219\u53ef\u9009\uff1a\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4\u6216\u81ea\u5b9a\u4e49\u8303\u56f4\u3002", (String)"PermSheetHelper_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.cacheColumnWidth(startColumnIndex + nextColTemp, content);
        content = ResManager.loadKDString((String)"*\u804c\u80fd\u7c7b\u578b", (String)"PermSheetHelper_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, startColumnIndex + nextColTemp + 1, startColumnIndex + nextColTemp + 1, mustCellStyle, content, ResManager.loadKDString((String)"\u4e0b\u8f7d\u7684\u89d2\u8272\u81ea\u52a8\u8bc6\u522b\u804c\u80fd\u7c7b\u578b\u3002\n\u5982\u679c\u540c\u4e2a\u89d2\u8272\u67092\u884c\u8bb0\u5f55\uff0c\u5219\u8868\u793a\u89d2\u8272\u67092\u4e2a\u4e0d\u540c\u7684\u804c\u80fd\u7c7b\u578b\n\u6570\u636e\u5305\u62ec\uff1a", (String)"PermSheetHelper_97", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]) + "\n" + StringUtils.join((Object[])this.getFunctionTypeNames(), (String)"\n"));
        this.cacheColumnWidth(startColumnIndex + nextColTemp + 1, content);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"PermSheetHelper_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, startColumnIndex + nextColTemp + 2, startColumnIndex + nextColTemp + 2, cellStyle, content, ResManager.loadKDString((String)"\u5f53\u201c\u6570\u636e\u8303\u56f4\u5c5e\u6027\u201d\u4e3a\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\u65f6\uff0c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u5fc5\u987b\u586b\u5199\u3002\n\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002", (String)"PermSheetHelper_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.cacheColumnWidth(startColumnIndex + nextColTemp + 2, content);
        LOGGER.info("Begin  addMemberRoleHeader dims.");
        List dims = memberRoleSheetList.stream().map(MemberRoleSheet::getFuns).flatMap(funs -> funs.stream().flatMap(fun -> fun.getDims().stream())).distinct().filter(dim -> Objects.nonNull(dim.getNumber())).collect(Collectors.toMap(MemberRoleSheet.Dim::getId, Function.identity(), (dim1, dim2) -> {
            Set allDim1StructProjectIds = dim1.getStructProject().stream().map(Triple::getLeft).collect(Collectors.toSet());
            for (Triple<String, String, List<DimValueBean>> dim2StructProject : dim2.getStructProject()) {
                if (allDim1StructProjectIds.contains(dim2StructProject.getLeft())) continue;
                dim1.getStructProject().add(dim2StructProject);
            }
            return dim1;
        })).values().stream().sorted(this.getDimComparator()).collect(Collectors.toList());
        int nextColumnIndex = startColumnIndex = startColumnIndex + nextColTemp + 3;
        LOGGER.info("Begin  addMemberRoleHeader other dims: {}.", (Object)dims.size());
        Set dimIds = dims.stream().map(MemberRoleSheet.Dim::getId).collect(Collectors.toSet());
        Map<Long, Long> teamTypeIdMap = Arrays.stream(new HRBaseServiceHelper("hrcs_dimension").query("id,teamtype.id", new QFilter[]{new QFilter("id", "in", dimIds), new QFilter("datasource", "=", (Object)"orgteam")})).collect(Collectors.toMap(dimension -> dimension.getLong("id"), dimension -> dimension.getLong("teamtype.id"), (oldValue, newValue) -> oldValue));
        for (MemberRoleSheet.Dim dim3 : dims) {
            if (CollectionUtils.isNotEmpty(dim3.getStructProject())) {
                String dimNumber = dim3.getNumber();
                String dimName = dim3.getName();
                String kdString = ResManager.loadKDString((String)"\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f", (String)"PermSheetHelper_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String tip = ResManager.loadKDString((String)"\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\norg2\u3010**\u516c\u53f8\u3011<\u5305\u542b\u4e0b\u7ea7>;\norg2<\u5305\u542b\u4e0b\u7ea7>\uff1b\n4\u3001\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u6570\u636e\u8303\u56f4\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\nDYNA_COND_10020\u3010\u4efb\u804c\u90e8\u95e8\u53ca\u4e0b\u7ea7\u90e8\u95e8\u3011\u3002", (String)"PermSheetHelper_50", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                Long teamTypeId = teamTypeIdMap.get(dim3.getId());
                if (null == teamTypeId) {
                    LOGGER.info("Can not find team type with dim id: {}.", (Object)dim3.getId());
                    continue;
                }
                List projectStructInfo = dim3.getStructProject().stream().map(Triple::getLeft).distinct().map(sp -> Pair.of((Object)teamTypeId, (Object)sp)).collect(Collectors.toList());
                List items = DynamicControlHelper.sortStructProjectsByNumberAndTeamType(projectStructInfo);
                Map<String, Triple> projectStructMap = dim3.getStructProject().stream().collect(Collectors.toMap(Triple::getLeft, it -> it, (oldValue, newValue) -> oldValue));
                if (items.size() > 1) {
                    if (kdString.equals(dimName)) {
                        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, nextColumnIndex, nextColumnIndex + items.size() - 1, centerCellStyle, dimName, tip);
                    } else {
                        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, nextColumnIndex, nextColumnIndex + items.size() - 1, centerCellStyle, dimName);
                    }
                } else if (kdString.equals(dimName)) {
                    this.addCellRegionWithWhiteBorder((Sheet)sheet, 3, nextColumnIndex, cellStyle, dimName, tip);
                } else {
                    this.addCellRegionWithWhiteBorder((Sheet)sheet, 3, nextColumnIndex, cellStyle, dimName);
                }
                for (DynamicObject item : items) {
                    Triple structProject = projectStructMap.get(item.getString("number"));
                    this.addCellRegionWithWhiteBorder((Sheet)sheet, 4, nextColumnIndex, cellStyle, (String)structProject.getMiddle());
                    this.cacheColumnWidth(nextColumnIndex, (String)structProject.getMiddle());
                    this.addCellRegionWithWhiteBorder((Sheet)sheet, 1, nextColumnIndex).setCellValue(dimNumber + "#" + (String)structProject.getLeft());
                    ++nextColumnIndex;
                }
                continue;
            }
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, nextColumnIndex, nextColumnIndex, cellStyle, dim3.getName());
            this.cacheColumnWidth(nextColumnIndex, dim3.getName());
            this.addCellRegionWithWhiteBorder((Sheet)sheet, 1, nextColumnIndex).setCellValue(dim3.getNumber());
            ++nextColumnIndex;
        }
        if (dims.size() > 0) {
            if (nextColumnIndex - 1 > startColumnIndex) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, startColumnIndex, nextColumnIndex - 1, centerCellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u3010\u6570\u636e\u8303\u56f4\u5c5e\u6027=\u81ea\u5b9a\u4e49\u8303\u56f4\u3011\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6807\u8272\u533a\u57df\u7684\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_22", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            } else {
                this.addCellRegionWithWhiteBorder((Sheet)sheet, 2, startColumnIndex, centerCellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u3010\u6570\u636e\u8303\u56f4\u5c5e\u6027=\u81ea\u5b9a\u4e49\u8303\u56f4\u3011\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6807\u8272\u533a\u57df\u7684\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6", (String)"PermSheetHelper_22", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        LOGGER.info("End  addMemberRoleHeader.");
        return nextColumnIndex;
    }

    private void addMemberRoleSheetBody(SXSSFSheet sheet, String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress, boolean enableValidateTime, int lastColumnIndex, boolean queryDimValue) {
        LOGGER.info("Begin addMemberRoleSheetBody.");
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        int nextRowIndex = 5;
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        List qFilterStrList = memberRoleSheetList.stream().flatMap(memberRoleSheet -> memberRoleSheet.getFuns().stream().map(fun -> "(role='" + memberRoleSheet.getRoleId() + "' and hrbucafunc = " + fun.getId() + ")")).collect(Collectors.toList());
        LOGGER.info("Got addMemberRoleSheetBody qFilterStrList size: {}.", (Object)qFilterStrList.size());
        HashMap<String, Integer> buCountMap = new HashMap<String, Integer>();
        Lists.partition(qFilterStrList, (int)100).forEach(qFilterItem -> {
            String qFilterStr = qFilterItem.stream().reduce((acc, item) -> acc + " or " + item).orElse("1!=1");
            LOGGER.info("Got addMemberRoleSheetBody qFilterStr: {}.", (Object)qFilterStr);
            QFilter qFilter = QFilter.of((String)qFilterStr, (Object[])new Object[0]);
            buCountMap.putAll(Arrays.stream(roleBuHelper.query("id,role,hrbucafunc", new QFilter[]{qFilter})).collect(Collectors.toMap(it -> it.getString("role") + "#" + it.getString("hrbucafunc"), it -> 1, (oldValue, newValue) -> oldValue)));
        });
        LOGGER.info("Begin addMemberRoleSheetBody.");
        int rowCount = 0;
        for (MemberRoleSheet memberRoleSheet2 : memberRoleSheetList) {
            for (MemberRoleSheet.FunctionType fun : memberRoleSheet2.getFuns()) {
                Collection<List<MemberRoleSheet.Dim>> listGroupDims = fun.getDims().stream().filter(dim -> Objects.nonNull(dim) && Objects.nonNull(dim.getNumber())).collect(Collectors.groupingBy(MemberRoleSheet.Dim::getGroupId)).values();
                if (CollectionUtils.isNotEmpty(listGroupDims)) {
                    for (List<MemberRoleSheet.Dim> groupDims : listGroupDims) {
                        ++rowCount;
                        Pair<Boolean, Integer> pair = this.fillCommonData(sheet, memberRoleSheet2, fun, commonCellStyle1, buCountMap, enableValidateTime, nextRowIndex, queryDimValue);
                        boolean sameWithRole = (Boolean)pair.getKey();
                        int dimNextColumnIndex = (Integer)pair.getValue();
                        if (!sameWithRole) {
                            HashMap<String, MemberRoleSheet.Dim> allDimSet = new HashMap<String, MemberRoleSheet.Dim>();
                            List sortedDimList = groupDims.stream().sorted(this.getDimComparator()).collect(Collectors.toList());
                            for (MemberRoleSheet.Dim dim2 : sortedDimList) {
                                if (null != dim2.getStructProject() && !dim2.getStructProject().isEmpty()) {
                                    dim2.getStructProject().forEach(cf -> {
                                        ArrayList<DimValueBean> classifyDimValues = new ArrayList<DimValueBean>(dim2.getDimValues());
                                        classifyDimValues.addAll((Collection)cf.getRight());
                                        MemberRoleSheet.Dim classifyDim = new MemberRoleSheet.Dim(dim2.getGroupId(), dim2.getId(), dim2.getName(), dim2.getNumber(), dim2.getEnable(), dim2.getDataSource(), new HashSet<Triple<String, String, List<DimValueBean>>>(dim2.getStructProject()), dim2.isAll(), classifyDimValues);
                                        allDimSet.put(dim2.getNumber() + "#" + (String)cf.getLeft(), classifyDim);
                                    });
                                    continue;
                                }
                                allDimSet.put(dim2.getNumber(), dim2);
                            }
                            while (dimNextColumnIndex < lastColumnIndex) {
                                MemberRoleSheet.Dim dim3 = (MemberRoleSheet.Dim)allDimSet.get(sheet.getRow(1).getCell(dimNextColumnIndex).getStringCellValue());
                                if (Objects.nonNull(dim3)) {
                                    if (queryDimValue) {
                                        String cellValue = "ALL";
                                        if (!dim3.isAll()) {
                                            cellValue = dim3.getDimValues().stream().filter(Objects::nonNull).map(it -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), it.getDimValCode(), it.getDimValName(), it.isContainsSub() ? PermInitServiceHelper.getContainsSubText() : "")).reduce((acc, item) -> acc + "\n" + item).orElse("");
                                        }
                                        this.addCellRegion((Sheet)sheet, nextRowIndex, dimNextColumnIndex, commonCellStyle1, cellValue);
                                    }
                                    this.setPinkBackground(sheet, nextRowIndex, dimNextColumnIndex, commonCellStyle1);
                                }
                                ++dimNextColumnIndex;
                            }
                        }
                        ++nextRowIndex;
                    }
                    continue;
                }
                ++rowCount;
                this.fillCommonData(sheet, memberRoleSheet2, fun, commonCellStyle1, buCountMap, enableValidateTime, nextRowIndex, queryDimValue);
                ++nextRowIndex;
            }
        }
        if (rowCount > 0) {
            int dropDownIndex = enableValidateTime ? 8 : 6;
            DataValidationHelper helper = sheet.getDataValidationHelper();
            CellRangeAddressList dataScopeValueList = new CellRangeAddressList(5, 5 + rowCount, dropDownIndex, dropDownIndex);
            String[] dataScopeItems = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"PermSheetHelper_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermSheetHelper_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])};
            DataValidationConstraint dataScopeValueConstraint = helper.createExplicitListConstraint(dataScopeItems);
            DataValidation dataScopeDataValidation = helper.createValidation(dataScopeValueConstraint, dataScopeValueList);
            sheet.addValidationData(dataScopeDataValidation);
            CellRangeAddressList funValueList = new CellRangeAddressList(5, 5 + rowCount, dropDownIndex + 1, dropDownIndex + 1);
            String[] items = this.getFunctionTypeNames();
            SXSSFSheet hiddenSheet = this.wb.createSheet("hiddenSheet");
            for (int index = 0; index < items.length; ++index) {
                hiddenSheet.createRow(index).createCell(0).setCellValue(items[index]);
            }
            Name wbName = this.wb.createName();
            wbName.setNameName("hidden");
            wbName.setRefersToFormula("hiddenSheet!$A$1:$A$" + items.length);
            DataValidationConstraint funValueConstraint = helper.createFormulaListConstraint("hidden");
            DataValidation funDataValidation = helper.createValidation(funValueConstraint, funValueList);
            sheet.addValidationData(funDataValidation);
            this.wb.setSheetHidden(1, true);
        }
        LOGGER.info("End addMemberRoleSheetBody.");
    }

    private Pair<Boolean, Integer> fillCommonData(SXSSFSheet sheet, MemberRoleSheet memberRoleSheet, MemberRoleSheet.FunctionType fun, CellStyle commonCellStyle1, Map<String, Integer> buCountMap, boolean enableValidateTime, int nextRowIndex, boolean queryDimValue) {
        String dataScopeProperty = ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermSheetHelper_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.isNotEmpty((String)memberRoleSheet.getCustomEnable())) {
            dataScopeProperty = this.getCustomEnableStr(memberRoleSheet.getCustomEnable());
        } else if (HRStringUtils.equals((String)"1", (String)memberRoleSheet.getRoleProperty())) {
            int count = buCountMap.getOrDefault(memberRoleSheet.getRoleId() + "#" + fun.getId(), 0);
            dataScopeProperty = count > 0 ? "" : ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"PermSheetHelper_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        }
        boolean sameWithRole = HRStringUtils.equals((String)dataScopeProperty, (String)ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermSheetHelper_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(nextRowIndex).setRowStyle(commonCellStyle1);
        this.addCellRegion((Sheet)sheet, nextRowIndex, 0, commonCellStyle1, memberRoleSheet.getMemberNumber());
        this.addCellRegion((Sheet)sheet, nextRowIndex, 1, commonCellStyle1, memberRoleSheet.getMemberName());
        this.addCellRegion((Sheet)sheet, nextRowIndex, 2, commonCellStyle1, memberRoleSheet.getOrgNumber());
        this.addCellRegion((Sheet)sheet, nextRowIndex, 3, commonCellStyle1, memberRoleSheet.getOrgName());
        this.addCellRegion((Sheet)sheet, nextRowIndex, 4, commonCellStyle1, memberRoleSheet.getRoleNumber());
        this.addCellRegion((Sheet)sheet, nextRowIndex, 5, commonCellStyle1, memberRoleSheet.getRoleName());
        int dimNextColumnIndex = 11;
        if (enableValidateTime) {
            this.addCellRegion((Sheet)sheet, nextRowIndex, 6, commonCellStyle1, this.formatDate(memberRoleSheet.getValidStart()));
            this.addCellRegion((Sheet)sheet, nextRowIndex, 7, commonCellStyle1, this.formatDate(memberRoleSheet.getValidEnd()));
            this.addCellRegion((Sheet)sheet, nextRowIndex, 8, commonCellStyle1, dataScopeProperty);
            this.addCellRegion((Sheet)sheet, nextRowIndex, 9, commonCellStyle1, fun.getName());
            this.cacheColumnWidth(9, fun.getName());
            if (queryDimValue && !sameWithRole) {
                this.addCellRegion((Sheet)sheet, nextRowIndex, 10, commonCellStyle1, fun.getBuOrgs().stream().map(it -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), it.getLeft(), it.getMiddle(), (Boolean)it.getRight() != false ? PermInitServiceHelper.getContainsSubText() : "")).reduce((acc, item) -> acc + "\n" + item).orElse(""));
            }
        } else {
            this.addCellRegion((Sheet)sheet, nextRowIndex, 6, commonCellStyle1, dataScopeProperty);
            this.addCellRegion((Sheet)sheet, nextRowIndex, 7, commonCellStyle1, fun.getName());
            this.cacheColumnWidth(7, fun.getName());
            if (queryDimValue && !sameWithRole) {
                this.addCellRegion((Sheet)sheet, nextRowIndex, 8, commonCellStyle1, fun.getBuOrgs().stream().map(it -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), it.getLeft(), it.getMiddle(), (Boolean)it.getRight() != false ? PermInitServiceHelper.getContainsSubText() : "")).reduce((acc, item) -> acc + "\n" + item).orElse(""));
            }
            dimNextColumnIndex = 9;
        }
        return Pair.of((Object)sameWithRole, (Object)dimNextColumnIndex);
    }

    public void addCustomRoleDataRuleSheet(String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        this.addCustomRoleDataRuleHeader(sheet);
        sheet.setColumnWidth(2, 4900);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4700);
        sheet.setColumnWidth(5, 4700);
        sheet.setColumnWidth(6, 4700);
        sheet.setColumnWidth(7, 4700);
        sheet.setColumnWidth(8, 4700);
        sheet.setColumnWidth(9, 4900);
        sheet.setColumnWidth(10, 4700);
        sheet.setColumnWidth(11, 5000);
        sheet.setColumnWidth(12, 5300);
        this.addCustomRoleDataRuleBody(sheet, sheetName, memberRoleSheetList, feedbackProgress);
    }

    private void addCustomRoleDataRuleHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, 0).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, 5).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, 6).setCellValue("appnum");
        this.addCellRegion((Sheet)sheet, 1, 7).setCellValue("appname");
        this.addCellRegion((Sheet)sheet, 1, 8).setCellValue("entitynum");
        this.addCellRegion((Sheet)sheet, 1, 9).setCellValue("entityname");
        this.addCellRegion((Sheet)sheet, 1, 10).setCellValue("perm");
        this.addCellRegion((Sheet)sheet, 1, 11).setCellValue("rulenum");
        this.addCellRegion((Sheet)sheet, 1, 12).setCellValue("rulename");
        sheet.getRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, cellStyle, ResManager.loadKDString((String)"*\u6743\u9650\u9879", (String)"PermSheetHelper_30", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5141\u8bb8\u5f55\u5165\u591a\u4e2a\u503c\u3002\u503c\u4e3a\u7a7a\u65f6\uff0c\u9ed8\u8ba4\u89d2\u8272\u4e0b\u4e1a\u52a1\u5bf9\u8c61\u7684\u6240\u6709\u6743\u9650\u9879\u8303\u56f4\u90fd\u6309\u540c\u4e2a\u6570\u636e\u89c4\u5219\u65b9\u6848\u3002", (String)"PermSheetHelper_47", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRoleDataRuleBody(SXSSFSheet sheet, String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress) {
        int nextRowIndex = 3;
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        for (MemberRoleSheet memberRoleSheet : memberRoleSheetList) {
            for (MemberRoleSheet.DataRule dataRule : memberRoleSheet.getDataRules()) {
                this.addCellRegion((Sheet)sheet, nextRowIndex, 0, commonCellStyle1, memberRoleSheet.getMemberNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 1, commonCellStyle1, memberRoleSheet.getMemberName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 2, commonCellStyle1, memberRoleSheet.getOrgNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 3, commonCellStyle1, memberRoleSheet.getOrgName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 4, commonCellStyle1, memberRoleSheet.getRoleNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 5, commonCellStyle1, memberRoleSheet.getRoleName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 6, commonCellStyle1, dataRule.getAppNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 7, commonCellStyle1, dataRule.getAppName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 8, commonCellStyle1, dataRule.getEntityNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 9, commonCellStyle1, dataRule.getEntityName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 10, commonCellStyle1, dataRule.getPermItemName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 11, commonCellStyle1, dataRule.getDataRuleSchemeNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 12, commonCellStyle1, dataRule.getDataRuleSchemeName());
                ++nextRowIndex;
            }
        }
    }

    public void addCustomRoleBaseDataDataScopePropertySheet(String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        this.addCustomRoleBaseDataDataScopePropertyHeader(sheet);
        sheet.setColumnWidth(2, 4900);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4700);
        sheet.setColumnWidth(5, 4700);
        sheet.setColumnWidth(6, 4700);
        sheet.setColumnWidth(7, 4700);
        sheet.setColumnWidth(8, 4700);
        sheet.setColumnWidth(9, 4900);
        sheet.setColumnWidth(10, 4900);
        sheet.setColumnWidth(11, 4700);
        sheet.setColumnWidth(12, 5000);
        sheet.setColumnWidth(13, 5300);
        this.addCustomRoleBaseDataDataScopePropertyBody(sheet, sheetName, memberRoleSheetList, feedbackProgress);
    }

    private void addCustomRoleBaseDataDataScopePropertyHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, 0).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, 5).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, 6).setCellValue("appnum");
        this.addCellRegion((Sheet)sheet, 1, 7).setCellValue("appname");
        this.addCellRegion((Sheet)sheet, 1, 8).setCellValue("entitynum");
        this.addCellRegion((Sheet)sheet, 1, 9).setCellValue("entityname");
        this.addCellRegion((Sheet)sheet, 1, 10).setCellValue("basedataprop");
        this.addCellRegion((Sheet)sheet, 1, 11).setCellValue("basedataname");
        this.addCellRegion((Sheet)sheet, 1, 12).setCellValue("rulenum");
        this.addCellRegion((Sheet)sheet, 1, 13).setCellValue("rulename");
        sheet.getRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027", (String)"PermSheetHelper_33", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"PermSheetHelper_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRoleBaseDataDataScopePropertyBody(SXSSFSheet sheet, String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress) {
        int nextRowIndex = 3;
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        for (MemberRoleSheet memberRoleSheet : memberRoleSheetList) {
            for (MemberRoleSheet.BaseDataRule baseDataRule : memberRoleSheet.getBaseDataRules()) {
                this.addCellRegion((Sheet)sheet, nextRowIndex, 0, commonCellStyle1, memberRoleSheet.getMemberNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 1, commonCellStyle1, memberRoleSheet.getMemberName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 2, commonCellStyle1, memberRoleSheet.getOrgNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 3, commonCellStyle1, memberRoleSheet.getOrgName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 4, commonCellStyle1, memberRoleSheet.getRoleNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 5, commonCellStyle1, memberRoleSheet.getRoleName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 6, commonCellStyle1, baseDataRule.getAppNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 7, commonCellStyle1, baseDataRule.getAppName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 8, commonCellStyle1, baseDataRule.getEntityNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 9, commonCellStyle1, baseDataRule.getEntityName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 10, commonCellStyle1, baseDataRule.getPropKey());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 11, commonCellStyle1, baseDataRule.getPropEntityName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 12, commonCellStyle1, baseDataRule.getDataRuleSchemeNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 13, commonCellStyle1, baseDataRule.getDataRuleSchemeName());
                ++nextRowIndex;
            }
        }
    }

    public void addCustomRolePropertyPermSheet(String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        this.addCustomRolePropertyPermHeader(sheet);
        sheet.setColumnWidth(2, 4900);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4700);
        sheet.setColumnWidth(5, 4700);
        sheet.setColumnWidth(6, 4700);
        sheet.setColumnWidth(7, 4700);
        sheet.setColumnWidth(8, 4700);
        sheet.setColumnWidth(9, 4900);
        sheet.setColumnWidth(10, 4900);
        sheet.setColumnWidth(11, 4700);
        this.addCustomRolePropertyPermBody(sheet, sheetName, memberRoleSheetList, feedbackProgress);
    }

    private void addCustomRolePropertyPermHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 1, 0).setCellValue("usernum");
        this.addCellRegion((Sheet)sheet, 1, 1).setCellValue("username");
        this.addCellRegion((Sheet)sheet, 1, 2).setCellValue("orgnum");
        this.addCellRegion((Sheet)sheet, 1, 3).setCellValue("orgname");
        this.addCellRegion((Sheet)sheet, 1, 4).setCellValue("rolenum");
        this.addCellRegion((Sheet)sheet, 1, 5).setCellValue("rolename");
        this.addCellRegion((Sheet)sheet, 1, 6).setCellValue("appnum");
        this.addCellRegion((Sheet)sheet, 1, 7).setCellValue("appname");
        this.addCellRegion((Sheet)sheet, 1, 8).setCellValue("entitynum");
        this.addCellRegion((Sheet)sheet, 1, 9).setCellValue("entityname");
        this.addCellRegion((Sheet)sheet, 1, 10).setCellValue("fieldprop");
        this.addCellRegion((Sheet)sheet, 1, 11).setCellValue("fieldname");
        this.addCellRegion((Sheet)sheet, 1, 12).setCellValue("view");
        this.addCellRegion((Sheet)sheet, 1, 13).setCellValue("edit");
        TemplateExcelWriter.getRow((SXSSFSheet)sheet, (int)1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027", (String)"PermSheetHelper_37", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"PermSheetHelper_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u67e5\u770b", (String)"PermSheetHelper_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002", (String)"PermSheetHelper_48", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, mustCellStyle, ResManager.loadKDString((String)"*\u7f16\u8f91", (String)"PermSheetHelper_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f55\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002\n\u5f55\u5165\u8981\u6c42\uff1a\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PermSheetHelper_49", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRolePropertyPermBody(SXSSFSheet sheet, String sheetName, List<MemberRoleSheet> memberRoleSheetList, Consumer<Triple<String, Long, Long>> feedbackProgress) {
        int nextRowIndex = 3;
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        for (MemberRoleSheet memberRoleSheet : memberRoleSheetList) {
            for (MemberRoleSheet.FieldPerm fieldPerm : memberRoleSheet.getFieldPerms()) {
                this.addCellRegion((Sheet)sheet, nextRowIndex, 0, commonCellStyle1, memberRoleSheet.getMemberNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 1, commonCellStyle1, memberRoleSheet.getMemberName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 2, commonCellStyle1, memberRoleSheet.getOrgNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 3, commonCellStyle1, memberRoleSheet.getOrgName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 4, commonCellStyle1, memberRoleSheet.getRoleNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 5, commonCellStyle1, memberRoleSheet.getRoleName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 6, commonCellStyle1, fieldPerm.getAppNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 7, commonCellStyle1, fieldPerm.getAppName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 8, commonCellStyle1, fieldPerm.getEntityNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 9, commonCellStyle1, fieldPerm.getEntityName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 10, commonCellStyle1, fieldPerm.getFieldNumber());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 11, commonCellStyle1, fieldPerm.getFieldName());
                this.addCellRegion((Sheet)sheet, nextRowIndex, 12, commonCellStyle1, this.getFieldBanStr(fieldPerm.isNoView()));
                this.addCellRegion((Sheet)sheet, nextRowIndex, 13, commonCellStyle1, this.getFieldBanStr(fieldPerm.isNoEdit()));
                ++nextRowIndex;
            }
        }
    }

    protected void cacheColumnWidth(int columnIndex, String content) {
        this.columnWidthMap.put(columnIndex, Math.max(this.columnWidthMap.getOrDefault(columnIndex, 0), Optional.ofNullable(content).map(it -> it.getBytes().length).orElseGet(() -> 0)));
    }

    protected String getFieldBanStr(boolean isBan) {
        if (isBan) {
            return ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"PermSheetHelper_58", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5141\u8bb8", (String)"PermSheetHelper_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getCustomEnableStr(String customEnable) {
        if (HRStringUtils.equals((String)customEnable, (String)"1")) {
            return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4", (String)"PermSheetHelper_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u8303\u56f4\u4e00\u81f4", (String)"PermSheetHelper_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private Comparator<MemberRoleSheet.Dim> getDimComparator() {
        Comparator<MemberRoleSheet.Dim> comparator = (it1, it2) -> {
            if (CollectionUtils.isNotEmpty(it1.getStructProject()) && CollectionUtils.isNotEmpty(it2.getStructProject())) {
                return 0;
            }
            if (CollectionUtils.isNotEmpty(it1.getStructProject())) {
                return -1;
            }
            if (CollectionUtils.isNotEmpty(it2.getStructProject())) {
                return 1;
            }
            return 0;
        };
        comparator = comparator.thenComparing(MemberRoleSheet.Dim::getEnable, Comparator.reverseOrder()).thenComparing(it -> it.getDataSource().toLowerCase());
        return comparator;
    }
}

