/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.task;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.util.AttachmentUtil;
import kd.hr.hrcs.formplugin.web.perm.init.excel.PermRoleSheetHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.PermSheetHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleExcel;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleTemplateExcelWriter;
import kd.hr.hrcs.formplugin.web.perm.init.task.AbstractPermTask;
import org.apache.commons.lang3.tuple.Triple;

public class RoleExportTask
extends AbstractPermTask {
    private static final Log LOGGER = LogFactory.getLog(RoleExportTask.class);

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map, Consumer<Triple<String, Long, Long>> feedbackProgress) throws KDException {
        try {
            JSONArray jsonArray = (JSONArray)map.get("roleIds");
            String[] roleIds = null == jsonArray || jsonArray.isEmpty() ? this.getRoleIds() : (String[])jsonArray.stream().map(Object::toString).toArray(String[]::new);
            String clientFullContextPath = (String)map.get("clientFullContextPathFromContext");
            if (HRStringUtils.isNotEmpty((String)clientFullContextPath)) {
                requestContext.setClientFullContextPath(clientFullContextPath);
            }
            this.downloadTemplate(feedbackProgress, roleIds);
        }
        catch (Exception exception) {
            LOGGER.error("RoleExportTask error", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("hrmp-hrcs-formplugin.export-role", exception.getMessage()), new Object[]{exception.getMessage()});
        }
    }

    private void downloadTemplate(Consumer<Triple<String, Long, Long>> feedbackProgress, String[] roleIds) throws IOException {
        RoleExcel roleExcel = PermRoleSheetHelper.getRole(feedbackProgress, roleIds);
        RoleTemplateExcelWriter writer = PermSheetHelper.getRoleTemplateExcelWriter(feedbackProgress, roleExcel);
        String prefix = ResManager.loadKDString((String)"\u89d2\u8272\u6743\u9650", (String)"PermSheetHelper_96", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String excelUrl = writer.writeFile(prefix + "_" + HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        String fullUrl = AttachmentUtil.genFullUrl((String)excelUrl);
        String disposableUrl = AttachmentUtil.genDisposableUrl((String)fullUrl, (String)"hrcs_rolequery", (String)"3GH71VH39OLA");
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("exportUrl", disposableUrl);
        this.feedbackCustomdata(result);
    }

    private String[] getRoleIds() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_role");
        return (String[])serviceHelper.queryOriginalCollection("id", new QFilter[0]).stream().map(it -> it.getString("id")).toArray(String[]::new);
    }
}

