/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.task;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.extpoint.permission.role.IExportRolePermCusPlugin;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.util.AttachmentUtil;
import kd.hr.hrcs.formplugin.web.perm.init.excel.MemberRoleSheet;
import kd.hr.hrcs.formplugin.web.perm.init.excel.PermHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.PermSheetHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.TemplateExcelWriter;
import kd.hr.hrcs.formplugin.web.perm.init.task.AbstractPermTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Triple;

public class RoleUserExportTask
extends AbstractPermTask {
    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map, Consumer<Triple<String, Long, Long>> feedbackProgress) throws KDException {
        try {
            JSONArray roleIds = (JSONArray)map.get("roleIds");
            String clientFullContextPath = (String)map.get("clientFullContextPathFromContext");
            if (HRStringUtils.isNotEmpty((String)clientFullContextPath)) {
                requestContext.setClientFullContextPath(clientFullContextPath);
            }
            this.downloadTemplate(feedbackProgress, roleIds.toArray());
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void downloadTemplate(Consumer<Triple<String, Long, Long>> feedbackProgress, Object[] roleIds) throws IOException {
        QFilter[] finalFilterArr;
        HRPluginProxy proxy = new HRPluginProxy(null, IExportRolePermCusPlugin.class, "kd.hr.hrcs.formplugin.web.perm.init.task.RoleUserExportTask#downloadTemplate", null);
        List qFilters = proxy.callReplace(IExportRolePermCusPlugin::buildPermFileFilter);
        qFilters.removeIf(ObjectUtils::isEmpty);
        QFilter roleFilter = new QFilter("role.id", "in", (Object)roleIds);
        if (CollectionUtils.isNotEmpty((Collection)qFilters)) {
            qFilters.add(roleFilter);
            finalFilterArr = qFilters.toArray(new QFilter[0]);
        } else {
            finalFilterArr = new QFilter[]{roleFilter};
        }
        List<MemberRoleSheet> memberRoleSheetList = PermHelper.getRoleMemberByRoleIds(feedbackProgress, roleIds, finalFilterArr);
        TemplateExcelWriter writer = PermSheetHelper.getTemplateExcelWriter(feedbackProgress, memberRoleSheetList, true);
        String prefix = ResManager.loadKDString((String)"\u7528\u6237\u6743\u9650", (String)"PermSheetHelper_59", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String excelUrl = writer.writeFile(prefix + "_" + HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        String fullUrl = AttachmentUtil.genFullUrl((String)excelUrl);
        String disposableUrl = AttachmentUtil.genDisposableUrl((String)fullUrl, (String)"hrcs_rolequery", (String)"3728=2A7G7T2");
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("exportUrl", disposableUrl);
        this.feedbackCustomdata(result);
    }
}

