/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.util.PermLogUtil;
import kd.hr.hrcs.formplugin.common.ComPrompts;
import kd.hr.hrcs.formplugin.common.HrcsFormpluginRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

@ExcludeFromJacocoGeneratedReport
public class PermLogArchiveSetPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(PermLogArchiveSetPlugin.class);
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permlogtype");
    private static final String CONTROL_MYFID = "myfid";
    private static final String CONTROL_ARCHIVE_PERIOD_TYPE = "archiveperiodtype";
    private static final String CONTROL_ARCHIVE_PERIOD = "archiveperiod";
    private static final String CONTROL_BUSITYPESELECT = "busitypeselect";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object[] busiTypeDyns = this.queryAllBusiTypes();
        if (ArrayUtils.isEmpty((Object[])busiTypeDyns)) {
            return;
        }
        this.loadBusiTypeMulCombo((DynamicObject[])busiTypeDyns);
        this.loadEntry((DynamicObject[])busiTypeDyns);
        this.setControlEnable();
    }

    private void setControlEnable() {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntitys)) {
            for (int rowIndex = 0; rowIndex < entryEntitys.size(); ++rowIndex) {
                if (this.isCustom(((DynamicObject)entryEntitys.get(rowIndex)).getString(CONTROL_ARCHIVE_PERIOD_TYPE))) continue;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{CONTROL_ARCHIVE_PERIOD});
            }
        }
    }

    private DynamicObject[] queryAllBusiTypes() {
        return serviceHelper.query("id, number, name, archiveperiodtype, archiveperiod", new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])}, "number");
    }

    private DynamicObject[] queryBusiTypes(Set<String> busiTypes) {
        return serviceHelper.query("id, number, name, archiveperiodtype, archiveperiod", new QFilter[]{new QFilter("number", "in", busiTypes)}, "number");
    }

    private void loadBusiTypeMulCombo(DynamicObject[] busiTypeDyns) {
        MulComboEdit busiTypeSelect = (MulComboEdit)this.getControl(CONTROL_BUSITYPESELECT);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(busiTypeDyns.length);
        for (DynamicObject busiTypeDyn : busiTypeDyns) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(busiTypeDyn.getString("number"));
            comboItem.setCaption(new LocaleString(busiTypeDyn.getString("name")));
            propertyItems.add(comboItem);
        }
        busiTypeSelect.setComboItems(propertyItems);
    }

    private void loadEntry(DynamicObject[] busiTypeDyns) {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(CONTROL_MYFID, new Object[0]);
        vs.addField("busitype", new Object[0]);
        vs.addField("busitypedesc", new Object[0]);
        vs.addField(CONTROL_ARCHIVE_PERIOD_TYPE, new Object[0]);
        vs.addField(CONTROL_ARCHIVE_PERIOD, new Object[0]);
        for (DynamicObject busiTypeDyn : busiTypeDyns) {
            String archivePeriodType = busiTypeDyn.getString(CONTROL_ARCHIVE_PERIOD_TYPE);
            int archivePeriod = busiTypeDyn.getInt(CONTROL_ARCHIVE_PERIOD);
            vs.addRow(new Object[]{busiTypeDyn.getPkValue(), busiTypeDyn.getString("number"), busiTypeDyn.getLocaleString("name"), archivePeriodType, archivePeriod});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (null == changeSet || 0 == changeSet.length) {
            return;
        }
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        if (Objects.equals(newValue, oldValue = changeData.getOldValue())) {
            return;
        }
        DynamicObject dataEntity = changeData.getDataEntity();
        String propName = e.getProperty().getName();
        IFormView view = this.getView();
        if (CONTROL_ARCHIVE_PERIOD_TYPE.equals(propName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String archivePeriodType = (String)newValue;
            if (this.isCustom(archivePeriodType)) {
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{CONTROL_ARCHIVE_PERIOD});
            } else {
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{CONTROL_ARCHIVE_PERIOD});
                int archivePeriod = PermLogUtil.computeArchivePeriod((String)archivePeriodType);
                view.getModel().setValue(CONTROL_ARCHIVE_PERIOD_TYPE, (Object)archivePeriodType);
                view.getModel().setValue(CONTROL_ARCHIVE_PERIOD, (Object)archivePeriod);
            }
        } else if (CONTROL_ARCHIVE_PERIOD.equals(propName)) {
            long myfid = dataEntity.getLong(CONTROL_MYFID);
            int archivePeriod = (Integer)newValue;
            if (archivePeriod > 1000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8d85\u8fc71000\u5929\u3002", (String)HrcsFormpluginRes.PermLogArchiveSetPlugin_0.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (archivePeriod < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8f93\u5165\u8d1f\u6570\uff0c\u8bf7\u8f93\u51651\u52301000\u4e4b\u95f4\u7684\u6570\u5b57\u3002", (String)HrcsFormpluginRes.PermLogArchiveSetPlugin_1.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (archivePeriod == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8f93\u51650\uff0c\u8bf7\u8f93\u51651\u52301000\u4e4b\u95f4\u7684\u6570\u5b57\u3002", (String)HrcsFormpluginRes.PermLogArchiveSetPlugin_2.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject busiTypeDyn = serviceHelper.loadSingle((Object)myfid);
            busiTypeDyn.set(CONTROL_ARCHIVE_PERIOD_TYPE, view.getModel().getValue(CONTROL_ARCHIVE_PERIOD_TYPE));
            busiTypeDyn.set(CONTROL_ARCHIVE_PERIOD, (Object)archivePeriod);
            busiTypeDyn.set("archiveretaindays", (Object)(archivePeriod * 2));
            serviceHelper.updateOne(busiTypeDyn);
            OperateLogService.commonWriteLog((String)"15NPDX/GJFOO", (String)view.getEntityId(), (String)"save", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58", HrcsFormpluginRes.ComPrompts_12.resId(), "hrmp-hrcs-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", HrcsFormpluginRes.ComPrompts_13.resId(), "hrmp-hrcs-formplugin"), (String[])new String[0]);
            view.showSuccessNotification(ComPrompts.saveTitle(), Integer.valueOf(3000));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "query": {
                boolean isQueyAll = false;
                Object value = this.getModel().getValue(CONTROL_BUSITYPESELECT);
                if (null == value) {
                    isQueyAll = true;
                } else {
                    String[] split = String.valueOf(value).split(",");
                    if (0 == split.length) {
                        isQueyAll = true;
                    } else {
                        Set<String> busiTypes = Arrays.stream(split).filter(x -> StringUtils.isNotEmpty((String)x.trim())).collect(Collectors.toSet());
                        if (CollectionUtils.isEmpty(busiTypes)) {
                            isQueyAll = true;
                        } else {
                            Object[] busiTypeDyns = this.queryBusiTypes(busiTypes);
                            if (ArrayUtils.isEmpty((Object[])busiTypeDyns)) {
                                return;
                            }
                            this.loadEntry((DynamicObject[])busiTypeDyns);
                            this.setControlEnable();
                            break;
                        }
                    }
                }
                if (!isQueyAll) break;
                Object[] busiTypeDyns = this.queryAllBusiTypes();
                if (ArrayUtils.isEmpty((Object[])busiTypeDyns)) {
                    return;
                }
                this.loadEntry((DynamicObject[])busiTypeDyns);
                this.setControlEnable();
                break;
            }
        }
    }

    private boolean isCustom(String archivePeriodType) {
        return "custom".equals(archivePeriodType);
    }
}

