/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.ot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermCommonTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermCommonTreeSupplier;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermOTLazyTreeCommonHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeBean;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeServiceFactory;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class OTTreePreviewPlugin
extends HRDynamicFormBasePlugin
implements TreeNodeQueryListener {
    private static final Log LOGGER = LogFactory.getLog(OTTreePreviewPlugin.class);
    private static final String ROOT_NODE_ID = "nodeId";
    private static final String ROOT_NODE_NAME = "nodeName";
    private static final String ROOT_NODE_ICON = "nodeIcon";
    private static final String ROOT_NODE_OT_SUB = "otSub";
    private static final String ROOT_NODE_CROSS_OT_SUB = "crossOtSub";
    private static final String LEFT = "left";
    private static final String MIDDLE = "middle";
    private static final String RIGHT = "right";
    private static final String IDENTIFY = "identify";
    private static final String NODES = "nodes";
    private static final String IS_ALL = "isAll";
    private static final String FROM_STRUCT_PROJECT = "fromStructProject";
    private static final String FROM_STRUCT_PROJECT_RELY_ON = "fromStructProjectRelyOn";
    private static final String NODE_CACHE = "nodeCache";
    private static final String ORIGINAL_NODE_CACHE = "originalNodeCache";
    private static final String PARENT_NODES_STRUCT_LONG_NUMBER = "parentNodesStructLongNumber";
    private static final String NODE_SUB_RESULT_NONE = "none";
    private static final String NODE_SUB_RESULT_CROSS_OT = "crossOt";
    private static final String NODE_SUB_RESULT_OT = "ot";
    private static final String NODE_SUB_RESULT_BOTH = "both";
    private static final String NODE_SUB_RESULT_OTHER = "other";
    private static final String SPLIT_STRING_1 = "!";
    private static final String SPLIT_STRING_2 = "\\.";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        TreeView treeview = (TreeView)this.getControl("treeview");
        treeview.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        this.initRootNode();
        this.initTips();
    }

    private void initTips() {
        String fromStructProject = (String)this.getView().getFormShowParameter().getCustomParam(FROM_STRUCT_PROJECT);
        String tips = (String)this.getView().getFormShowParameter().getCustomParam("tips");
        String tipsText = "";
        if (HRStringUtils.isNotEmpty((String)tips)) {
            tipsText = tips;
        } else if (HRStringUtils.isNotEmpty((String)fromStructProject)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
            DynamicObject item = serviceHelper.queryOne("name,relyonstructproject.id", (Object)Long.parseLong(fromStructProject));
            tipsText = item.getString("name");
            this.getPageCache().put(FROM_STRUCT_PROJECT_RELY_ON, item.getString("relyonstructproject.id"));
        }
        String tipsContent = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c55\u793a\u6570\u636e\u4e3a\u5373\u65f6\u67e5\u8be2\u6570\u636e\uff0c\u5f53\u524d\u5206\u914d\u7684%1$s\u8be6\u60c5\u5982\u4e0b\uff1a", (String)"OTTreePreviewPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), tipsText);
    }

    private void initRootNode() {
        AtomicReference<String> nodeId = new AtomicReference<String>("");
        AtomicReference<String> nodeName = new AtomicReference<String>("");
        AtomicReference<String> nodeIcon = new AtomicReference<String>("");
        AtomicReference<String> nodeStructProject = new AtomicReference<String>("");
        AtomicReference<String> nodeStructProjectRelyOn = new AtomicReference<String>("");
        AtomicReference<String> nodeStructProjectFrom = new AtomicReference<String>("");
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        String identify = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam(IDENTIFY)).orElse("orgTeam");
        String isAll = (String)this.getView().getFormShowParameter().getCustomParam(IS_ALL);
        String nodes = (String)this.getView().getFormShowParameter().getCustomParam(NODES);
        List nodeList = SerializationUtils.fromJsonStringToList((String)nodes, Map.class);
        Map<Long, Map> entryNodeMap = nodeList.stream().collect(Collectors.toMap(it -> Long.parseLong((String)it.get(ROOT_NODE_ID)), it -> it, (oldValue, newValue) -> oldValue));
        Set<Long> nodeIds = entryNodeMap.keySet();
        this.getPageCache().put(ORIGINAL_NODE_CACHE, SerializationUtils.toJsonString(nodeList.stream().collect(Collectors.toMap(it -> (String)it.get(ROOT_NODE_ID), it -> it, (oldValue, newValue) -> oldValue))));
        if (nodeList.isEmpty()) {
            return;
        }
        if (HRStringUtils.equals((String)"1", (String)isAll)) {
            switch (identify) {
                case "bizOrg": {
                    this.initRootNodeForBizOrg(nodeId, nodeName, nodeIcon, nodeStructProject, nodeIds);
                    break;
                }
                case "funcDim": {
                    this.initRootNodeForFuncDim(nodeId, nodeName, nodeIcon, nodeStructProject, nodeIds);
                    break;
                }
                case "orgTeam": {
                    this.initRootNodeForOrgTeam(nodeId, nodeName, nodeIcon, nodeStructProject, nodeStructProjectRelyOn, nodeList);
                    break;
                }
                case "common": {
                    this.initRootNodeForCommon(nodeId, nodeName, nodeIcon, nodeStructProject, nodeIds);
                    break;
                }
            }
        } else {
            Map singleNodeMap = (Map)nodeList.get(0);
            nodeId.set((String)singleNodeMap.get(ROOT_NODE_ID));
            nodeName.set((String)singleNodeMap.get(ROOT_NODE_NAME));
            nodeIcon.set((String)singleNodeMap.get(ROOT_NODE_ICON));
        }
        HashMap<String, String> nodeData = new HashMap<String, String>();
        nodeData.put(LEFT, nodeStructProject.get());
        nodeData.put(MIDDLE, nodeStructProjectRelyOn.get());
        nodeData.put(RIGHT, nodeStructProjectFrom.get());
        this.doInitRootNode(nodeId.get(), nodeName.get(), nodeIcon.get(), nodeData, children);
    }

    private void initRootNodeForCommon(AtomicReference<String> nodeId, AtomicReference<String> nodeName, AtomicReference<String> nodeIcon, AtomicReference<String> nodeStructProject, Set<Long> nodeIds) {
        this.getView().getFormShowParameter().setCustomParam("filter", (Object)new QFilter("id", "in", nodeIds));
        DynamicObject[] items = PermCommonTreeHelper.getInstance().getDataInfo(this.getView(), null);
        String rootStructLongNumber = PermOTLazyTreeCommonHelper.getLongestCommonStructLongNumber((String)SPLIT_STRING_2, (DynamicObject[])items);
        this.getView().getFormShowParameter().setCustomParam("filter", null);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper((String)this.getView().getFormShowParameter().getCustomParam("entityNumber"));
        List qFilterList = PermCommonTreeSupplier.getInstance().getFilter(this.getView());
        qFilterList.add(new QFilter("longnumber", "=", (Object)rootStructLongNumber));
        DynamicObject rootItem = serviceHelper.queryOne("id,number,name,parent.id,longnumber structlongnumber", HRPermCommonUtil.listToQFilters((List)qFilterList));
        nodeId.set(rootItem.getString("id"));
        nodeName.set(rootItem.getString("name"));
        nodeIcon.set("kdfont kdfont-shitizuzhi");
        nodeStructProject.set((String)this.getView().getFormShowParameter().getCustomParam(FROM_STRUCT_PROJECT));
        this.getRootNodeStructLongNumber(SPLIT_STRING_2, items);
    }

    private void initRootNodeForFuncDim(AtomicReference<String> nodeId, AtomicReference<String> nodeName, AtomicReference<String> nodeIcon, AtomicReference<String> nodeStructProject, Set<Long> nodeIds) {
        this.initRootNodeForBizOrg(nodeId, nodeName, nodeIcon, nodeStructProject, nodeIds);
    }

    private void initRootNodeForBizOrg(AtomicReference<String> nodeId, AtomicReference<String> nodeName, AtomicReference<String> nodeIcon, AtomicReference<String> nodeStructProject, Set<Long> nodeIds) {
        this.getView().getFormShowParameter().setCustomParam("filter", (Object)new QFilter("org.id", "in", nodeIds));
        DynamicObject[] items = (DynamicObject[])Arrays.stream(PermCommonTreeHelper.getInstance().getDataInfo(this.getView(), null)).filter(it -> nodeIds.contains(it.getLong("org.id"))).toArray(DynamicObject[]::new);
        String rootStructLongNumber = PermOTLazyTreeCommonHelper.getLongestCommonStructLongNumber((String)SPLIT_STRING_1, (DynamicObject[])items);
        this.getView().getFormShowParameter().setCustomParam("filter", null);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        List list = PermCommonTreeSupplier.getInstance().getFilter(this.getView());
        list.add(new QFilter("longnumber", "=", (Object)rootStructLongNumber));
        DynamicObject rootItem = serviceHelper.queryOne("org.id,org.number,org.name,longnumber AS structlongnumber,parent.id", HRPermCommonUtil.listToQFilters((List)list));
        nodeId.set(rootItem.getString("org.id"));
        nodeName.set(rootItem.getString("org.name"));
        nodeIcon.set("kdfont kdfont-shitizuzhi");
        nodeStructProject.set((String)this.getView().getFormShowParameter().getCustomParam(FROM_STRUCT_PROJECT));
        this.getRootNodeStructLongNumber(SPLIT_STRING_1, items);
    }

    private void initRootNodeForOrgTeam(AtomicReference<String> nodeId, AtomicReference<String> nodeName, AtomicReference<String> nodeIcon, AtomicReference<String> nodeStructProject, AtomicReference<String> nodeStructProjectRelyOn, List<Map<String, String>> nodeList) {
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)((String)this.getView().getFormShowParameter().getCustomParam("customStructProject")));
        Map<Long, Map> entryNodeMap = nodeList.stream().collect(Collectors.toMap(it -> Long.parseLong((String)it.get(ROOT_NODE_ID)), it -> it, (oldValue, newValue) -> oldValue));
        Set<Long> nodeIds = entryNodeMap.keySet();
        Set allStructProject = nodeList.stream().map(it -> Arrays.asList((String)it.get("currentstructproject"), (String)it.get("currentstructprojectrelyon"))).flatMap(Collection::stream).filter(HRStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(isCustomProjectStruct ? "haos_customotstruct" : "haos_adminorgstructure");
        List qFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        qFilterList.add(new QFilter("orgteam", "in", nodeIds));
        qFilterList.add(new QFilter("structproject.id", "in", allStructProject));
        DynamicObject[] items = serviceHelper.queryOriginalArray("structlongnumber", HRPermCommonUtil.listToQFilters((List)qFilterList));
        String rootStructLongNumber = PermOTLazyTreeCommonHelper.getLongestCommonStructLongNumber((String)SPLIT_STRING_1, (DynamicObject[])items);
        List list = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        list.add(new QFilter("structlongnumber", "=", (Object)rootStructLongNumber));
        list.add(new QFilter("structproject.id", "in", allStructProject));
        DynamicObject rootItem = serviceHelper.queryOne("orgteam.id,orgteam.name,structlongnumber,structproject.id,structproject.relyonstructproject.id", HRPermCommonUtil.listToQFilters((List)list));
        nodeId.set(rootItem.getString("orgteam.id"));
        nodeName.set(rootItem.getString("orgteam.name"));
        nodeIcon.set(HRStringUtils.isNotEmpty((String)rootItem.getString("structproject.relyonstructproject.id")) ? "kdfont kdfont-xiangmuxingtuandui" : "kdfont kdfont-shitizuzhi");
        nodeStructProject.set(rootItem.getString("structproject.id"));
        nodeStructProjectRelyOn.set(rootItem.getString("structproject.relyonstructproject.id"));
        this.getRootNodeStructLongNumber(SPLIT_STRING_1, items);
    }

    private Set<String> getRootNodeStructLongNumber(String splitString, DynamicObject[] items) {
        String rootStructLongNumber = PermOTLazyTreeCommonHelper.getLongestCommonStructLongNumber((String)splitString, (DynamicObject[])items);
        Set<String> parentStructLongNumbers = Arrays.stream(items).map(it -> it.getString("structlongnumber")).map(it -> {
            ArrayList<String> parentStructLongNumber = new ArrayList<String>();
            String tempItem = it;
            if (tempItem.equals(rootStructLongNumber)) {
                parentStructLongNumber.add(tempItem);
            }
            while (!tempItem.equals(rootStructLongNumber) && tempItem.startsWith(rootStructLongNumber) && tempItem.lastIndexOf(StringEscapeUtils.unescapeJava((String)splitString)) > 0) {
                parentStructLongNumber.add(tempItem);
                tempItem = tempItem.substring(0, tempItem.lastIndexOf(StringEscapeUtils.unescapeJava((String)splitString)));
            }
            return parentStructLongNumber;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
        if (parentStructLongNumbers.isEmpty()) {
            parentStructLongNumbers.add(rootStructLongNumber);
        }
        this.getPageCache().put(PARENT_NODES_STRUCT_LONG_NUMBER, SerializationUtils.toJsonString(parentStructLongNumbers));
        return parentStructLongNumbers;
    }

    private void doInitRootNode(String nodeId, String nodeName, String nodeIcon, HashMap<String, String> nodeData, List<TreeNode> children) {
        TreeNode root = new TreeNode(null, nodeId, nodeName);
        root.setData(nodeData);
        root.setIcon(nodeIcon);
        root.setChildren(children);
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        treeview.addNode(root);
        treeview.expand(nodeId);
        HashMap<String, HashMap<String, String>> nodeMap = new HashMap<String, HashMap<String, String>>();
        nodeMap.put(nodeId, nodeData);
        children.forEach(it -> nodeMap.put(it.getId(), (HashMap)it.getData()));
        this.getPageCache().put(NODE_CACHE, SerializationUtils.toJsonString(nodeMap));
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        boolean isNotRelyOn = this.isNotRelyOn();
        boolean showCompanyName = HRStringUtils.equals((String)"1", (String)((String)this.getView().getFormShowParameter().getCustomParam("showCompanyName")));
        String fromStructProject = (String)this.getView().getFormShowParameter().getCustomParam(FROM_STRUCT_PROJECT);
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(NODE_CACHE), HashMap.class);
        String nodeId = (String)event.getNodeId();
        HashMap nodeData = (HashMap)nodeMap.get(nodeId);
        String nodeType = (String)nodeData.get(LEFT);
        String nodeStructProjectRelyOn = (String)nodeData.get(MIDDLE);
        if (HRStringUtils.equals((String)"0", (String)nodeId)) {
            return;
        }
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)((String)this.getView().getFormShowParameter().getCustomParam("customStructProject")));
        Long paramClassifier = Optional.ofNullable(fromStructProject).map(Long::parseLong).orElse(HRCSBaseConstants.LONG_MINUS_ONE);
        Long relyOnStruct = Optional.ofNullable(this.getPageCache().get(FROM_STRUCT_PROJECT_RELY_ON)).map(Long::parseLong).orElse(HRCSBaseConstants.LONG_MINUS_ONE);
        String isAll = (String)this.getView().getFormShowParameter().getCustomParam(IS_ALL);
        String nodeSubResult = this.getNodeSubResult(nodeId, Collections.singletonList(paramClassifier), relyOnStruct, isCustomProjectStruct);
        LOGGER.error("Got query children params: nodeSubResult:[{}], nodeType:[{}], paramClassifier:[{}], type:[{}].", new Object[]{nodeSubResult, nodeType, paramClassifier, isAll});
        switch (nodeSubResult) {
            case "none": {
                Map originalNodeMap;
                if (!HRStringUtils.isEmpty((String)nodeStructProjectRelyOn) || isNotRelyOn || !(originalNodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ORIGINAL_NODE_CACHE), Map.class)).containsKey(nodeId)) break;
                this.handleQueryTreeNodeChildren((Map<String, HashMap<String, String>>)nodeMap, nodeId, Collections.singletonList(paramClassifier), relyOnStruct, false, isCustomProjectStruct, showCompanyName);
                break;
            }
            case "crossOt": {
                if (HRStringUtils.isEmpty((String)nodeStructProjectRelyOn)) {
                    if (isNotRelyOn) {
                        paramClassifier = HRCSBaseConstants.LONG_MINUS_ONE;
                        this.handleQueryTreeNodeChildren(nodeMap, nodeId, Arrays.asList(Long.parseLong("1010"), paramClassifier), relyOnStruct, true, false, Collections.emptySet(), isCustomProjectStruct, showCompanyName);
                        break;
                    }
                    List<TreeNode> treeNodeList = this.handleTreeNodeForCascade(nodeMap, nodeId, Arrays.asList(relyOnStruct, paramClassifier), relyOnStruct, true, true, isCustomProjectStruct, false, showCompanyName);
                    TreeView treeView = (TreeView)this.getControl("treeview");
                    treeView.addNodes(treeNodeList);
                    treeView.updateNodes(treeNodeList);
                    break;
                }
                this.handleQueryTreeNodeChildren((Map<String, HashMap<String, String>>)nodeMap, nodeId, Collections.singletonList(paramClassifier), relyOnStruct, true, isCustomProjectStruct, showCompanyName);
                break;
            }
            case "ot": {
                this.handleQueryTreeNodeChildren((Map<String, HashMap<String, String>>)nodeMap, nodeId, Collections.singletonList(paramClassifier), relyOnStruct, true, isCustomProjectStruct, showCompanyName);
                break;
            }
            case "both": {
                if (HRStringUtils.isEmpty((String)nodeStructProjectRelyOn)) {
                    List<TreeNode> treeNodeList = this.handleTreeNodeForCascade(nodeMap, nodeId, Arrays.asList(relyOnStruct, paramClassifier), relyOnStruct, true, true, isCustomProjectStruct, true, showCompanyName);
                    TreeView treeView = (TreeView)this.getControl("treeview");
                    treeView.addNodes(treeNodeList);
                    treeView.updateNodes(treeNodeList);
                    break;
                }
                this.handleQueryTreeNodeChildren((Map<String, HashMap<String, String>>)nodeMap, nodeId, Collections.singletonList(paramClassifier), relyOnStruct, true, isCustomProjectStruct, showCompanyName);
                break;
            }
            case "other": {
                break;
            }
            default: {
                LOGGER.info("Ignore query tree children with node-id:[{}] node-type:[{}] node-sub-result:[{}] ", new Object[]{nodeId, nodeType, nodeSubResult});
            }
        }
        if (HRStringUtils.equals((String)"1", (String)isAll)) {
            Set parentNodesStructLongNumber = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PARENT_NODES_STRUCT_LONG_NUMBER), Set.class);
            Long originalParamClassifier = Optional.ofNullable(fromStructProject).map(Long::parseLong).orElse(HRCSBaseConstants.LONG_MINUS_ONE);
            this.handleQueryTreeNodeChildren((Map<String, HashMap<String, String>>)nodeMap, nodeId, Arrays.asList(originalParamClassifier, relyOnStruct), relyOnStruct, parentNodesStructLongNumber, isCustomProjectStruct, showCompanyName);
        }
        this.getPageCache().put(NODE_CACHE, SerializationUtils.toJsonString((Object)nodeMap));
    }

    private Map<String, String> getDefaultNodeMap(String nodeId, Map<Long, List<Pair<Long, String>>> parentMap, List<Map<String, String>> nodeMap) {
        List<Pair<Long, String>> parents = parentMap.get(Long.parseLong(nodeId));
        List sortedNodeMap = nodeMap.stream().sorted((item1, item2) -> Integer.parseInt((String)item2.get(ROOT_NODE_OT_SUB)) - Integer.parseInt((String)item1.get(ROOT_NODE_OT_SUB))).sorted((item1, item2) -> Integer.parseInt((String)item2.get(ROOT_NODE_CROSS_OT_SUB)) - Integer.parseInt((String)item1.get(ROOT_NODE_CROSS_OT_SUB))).collect(Collectors.toList());
        for (Map sortedNode : sortedNodeMap) {
            if (!parents.stream().anyMatch(parent -> (Long)parent.getKey() == Long.parseLong((String)sortedNode.get(ROOT_NODE_ID)))) continue;
            return sortedNode;
        }
        return Collections.emptyMap();
    }

    private String getNodeSubResult(String nodeId, List<Long> struct, Long relyOnStruct, boolean isCustomProjectStruct) {
        boolean subResult;
        String nodes = (String)this.getView().getFormShowParameter().getCustomParam(NODES);
        List nodeMap = SerializationUtils.fromJsonStringToList((String)nodes, Map.class);
        Long longNodeId = Long.parseLong(nodeId);
        String identify = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam(IDENTIFY)).orElse("orgTeam");
        Map parentMap = TreeNodeServiceFactory.getTreeNodeService((String)identify).getNodeAllParents(this.getView(), Collections.singletonList(longNodeId), struct, relyOnStruct, isCustomProjectStruct);
        Map<String, String> singleNodeMap = this.getDefaultNodeMap(nodeId, parentMap, nodeMap);
        String defaultOtSub = singleNodeMap.getOrDefault(ROOT_NODE_OT_SUB, "");
        String defaultCrossOtSub = singleNodeMap.getOrDefault(ROOT_NODE_CROSS_OT_SUB, "");
        Map originalNodeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ORIGINAL_NODE_CACHE), Map.class);
        Map currentNodeMap = originalNodeMap.getOrDefault(nodeId, Collections.emptyMap());
        String otSub = currentNodeMap.getOrDefault(ROOT_NODE_OT_SUB, defaultOtSub);
        String crossOtSub = currentNodeMap.getOrDefault(ROOT_NODE_CROSS_OT_SUB, defaultCrossOtSub);
        if (HRStringUtils.equals((String)"0", (String)otSub)) {
            otSub = defaultOtSub;
        }
        if (HRStringUtils.equals((String)"0", (String)crossOtSub)) {
            crossOtSub = defaultCrossOtSub;
        }
        String result = NODE_SUB_RESULT_OTHER;
        boolean bl = subResult = HRStringUtils.isNotEmpty((String)otSub) && HRStringUtils.isNotEmpty((String)crossOtSub);
        if (subResult && HRStringUtils.equals((String)"0", (String)otSub) && HRStringUtils.equals((String)"0", (String)crossOtSub)) {
            result = NODE_SUB_RESULT_NONE;
        } else if (subResult && HRStringUtils.equals((String)"0", (String)otSub) && HRStringUtils.equals((String)"1", (String)crossOtSub)) {
            result = NODE_SUB_RESULT_CROSS_OT;
        } else if (subResult && HRStringUtils.equals((String)"1", (String)otSub) && HRStringUtils.equals((String)"0", (String)crossOtSub)) {
            result = NODE_SUB_RESULT_OT;
        } else if (subResult && HRStringUtils.equals((String)"1", (String)otSub) && HRStringUtils.equals((String)"1", (String)crossOtSub)) {
            result = NODE_SUB_RESULT_BOTH;
        }
        return result;
    }

    private void handleQueryTreeNodeChildren(Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> classifies, Long relyOnStruct, boolean hasChildren, boolean isCustomProjectStruct, boolean showCompanyName) {
        this.handleQueryTreeNodeChildren(nodeMap, parentNodeId, classifies, relyOnStruct, hasChildren, true, Collections.emptySet(), isCustomProjectStruct, showCompanyName);
    }

    private void handleQueryTreeNodeChildren(Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> classifies, Long relyOnStruct, Set<String> structLongNumbers, boolean isCustomProjectStruct, boolean showCompanyName) {
        this.handleQueryTreeNodeChildren(nodeMap, parentNodeId, classifies, relyOnStruct, true, true, structLongNumbers, isCustomProjectStruct, showCompanyName);
    }

    private void handleQueryTreeNodeChildren(Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> classifies, Long relyOnStruct, boolean hasChildren, boolean hasProjectTeamAndWorkGroupChildren, Set<String> structLongNumbers, boolean isCustomProjectStruct, boolean showCompanyName) {
        List<TreeNode> treeNodeList = this.handleTreeNode(nodeMap, parentNodeId, classifies, relyOnStruct, hasChildren, hasProjectTeamAndWorkGroupChildren, structLongNumbers, isCustomProjectStruct, showCompanyName);
        if (!treeNodeList.isEmpty()) {
            TreeView treeView = (TreeView)this.getControl("treeview");
            treeView.addNodes(treeNodeList);
            treeView.updateNodes(treeNodeList);
        }
    }

    private List<TreeNode> handleTreeNode(Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> classifies, Long relyOnStruct, boolean hasChildren, boolean hasProjectTeamAndWorkGroupChildren, Set<String> structLongNumbers, boolean isCustomProjectStruct, boolean showCompanyName) {
        return this.handleTreeNode(nodeMap, parentNodeId, classifies, relyOnStruct, hasChildren, hasProjectTeamAndWorkGroupChildren, structLongNumbers, isCustomProjectStruct, null, showCompanyName);
    }

    private List<TreeNode> handleTreeNode(Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> classifies, Long relyOnStruct, boolean hasChildren, boolean hasProjectTeamAndWorkGroupChildren, Set<String> structLongNumbers, boolean isCustomProjectStruct, QFilter extendQFilter, boolean showCompanyName) {
        String identify = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam(IDENTIFY)).orElse("orgTeam");
        List treeNodeList = TreeNodeServiceFactory.getTreeNodeService((String)identify).getHasAdminPermTreeNodeList(this.getView(), Long.valueOf(Long.parseLong(parentNodeId)), classifies, relyOnStruct, structLongNumbers, isCustomProjectStruct, extendQFilter, showCompanyName);
        return this.assembleTreeNode(treeNodeList, nodeMap, parentNodeId, classifies, relyOnStruct, hasChildren, hasProjectTeamAndWorkGroupChildren, isCustomProjectStruct);
    }

    private List<TreeNode> handleTreeNodeForCascade(Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> classifies, Long relyOnStruct, boolean hasChildren, boolean hasProjectTeamAndWorkGroupChildren, boolean isCustomProjectStruct, boolean cascade, boolean showCompanyName) {
        String identify = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam(IDENTIFY)).orElse("orgTeam");
        List treeNodeList = TreeNodeServiceFactory.getTreeNodeService((String)identify).getHasAdminPermTreeNodeList(this.getView(), Long.valueOf(Long.parseLong(parentNodeId)), classifies, relyOnStruct, Collections.emptySet(), isCustomProjectStruct, cascade, showCompanyName);
        return this.assembleTreeNode(treeNodeList, nodeMap, parentNodeId, classifies, relyOnStruct, hasChildren, hasProjectTeamAndWorkGroupChildren, isCustomProjectStruct);
    }

    private List<TreeNode> assembleTreeNode(List<TreeNodeBean> treeNodeList, Map<String, HashMap<String, String>> nodeMap, String parentNodeId, List<Long> struct, Long relyOnStruct, boolean hasChildren, boolean hasProjectTeamAndWorkGroupChildren, boolean isCustomProjectStruct) {
        HashSet parentNodesStructLongNumber = new HashSet();
        String isAll = (String)this.getView().getFormShowParameter().getCustomParam(IS_ALL);
        if (HRStringUtils.equals((String)"1", (String)isAll)) {
            parentNodesStructLongNumber.addAll((Collection)SerializationUtils.fromJsonString((String)this.getPageCache().get(PARENT_NODES_STRUCT_LONG_NUMBER), Set.class));
        }
        String nodes = (String)this.getView().getFormShowParameter().getCustomParam(NODES);
        List nodeList = SerializationUtils.fromJsonStringToList((String)nodes, Map.class);
        String identify = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam(IDENTIFY)).orElse("orgTeam");
        List nodeIds = treeNodeList.stream().map(TreeNodeBean::getId).collect(Collectors.toList());
        Map parentMap = TreeNodeServiceFactory.getTreeNodeService((String)identify).getNodeAllParents(this.getView(), nodeIds, struct, relyOnStruct, isCustomProjectStruct);
        boolean isNotRelyOn = this.isNotRelyOn();
        ArrayList newTreeNodeList = Lists.newArrayListWithExpectedSize((int)treeNodeList.size());
        for (TreeNodeBean nodeBean : treeNodeList) {
            if (0L == nodeBean.getId()) continue;
            HashMap<String, String> nodeData = new HashMap<String, String>();
            nodeData.put(LEFT, String.valueOf(nodeBean.getCurrentStructProject()));
            nodeData.put(MIDDLE, null == nodeBean.getCurrentStructProjectRelyOn() || 0L == nodeBean.getCurrentStructProjectRelyOn() ? "" : String.valueOf(nodeBean.getCurrentStructProjectRelyOn()));
            nodeData.put(RIGHT, "");
            TreeNode node = new TreeNode(parentNodeId, nodeBean.getId().toString(), nodeBean.getName());
            if (hasChildren) {
                if (hasProjectTeamAndWorkGroupChildren) {
                    node.setLeaf(nodeBean.isLeaf());
                } else if (HRStringUtils.equals((String)"1010", (String)String.valueOf(nodeBean.getCurrentClassify()))) {
                    node.setLeaf(nodeBean.isLeaf());
                } else {
                    node.setLeaf(true);
                }
                if (isNotRelyOn) {
                    boolean entryHasChild;
                    Map<String, String> currentEntryNodeMap = this.getDefaultNodeMap(node.getId(), parentMap, nodeList);
                    boolean bl = entryHasChild = null == currentEntryNodeMap || HRStringUtils.equals((String)"1", (String)currentEntryNodeMap.get(ROOT_NODE_OT_SUB));
                    if (!node.isLeaf() && entryHasChild) {
                        node.setChildren((List)Lists.newArrayList());
                    } else {
                        boolean hasChild = parentNodesStructLongNumber.stream().anyMatch(it -> !it.equals(nodeBean.getStructLongNumber()) && it.startsWith(nodeBean.getStructLongNumber()));
                        if (!node.isLeaf() && hasChild) {
                            node.setChildren((List)Lists.newArrayList());
                        }
                    }
                } else if (!node.isLeaf()) {
                    node.setChildren(Collections.emptyList());
                }
            }
            node.setDisabled(!nodeBean.isHasPerm());
            node.setLongNumber(nodeBean.getStructLongNumber());
            node.setIcon(null != nodeBean.getCurrentStructProjectRelyOn() && 0L != nodeBean.getCurrentStructProjectRelyOn() ? "kdfont kdfont-xiangmuxingtuandui" : "kdfont kdfont-shitizuzhi");
            node.setType(String.valueOf(nodeBean.getCurrentClassify()));
            node.setData(nodeData);
            newTreeNodeList.add(node);
            nodeMap.putIfAbsent(node.getId(), (HashMap)node.getData());
        }
        return newTreeNodeList;
    }

    private boolean isNotRelyOn() {
        String fromStructProjectRelyOn = this.getPageCache().get(FROM_STRUCT_PROJECT_RELY_ON);
        String identify = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam(IDENTIFY)).orElse("orgTeam");
        return !HRStringUtils.equals((String)identify, (String)"orgTeam") || HRStringUtils.isEmpty((String)fromStructProjectRelyOn);
    }
}

