/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignSaveService;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.constants.perm.RoleMemberDetailModel;
import kd.hr.hrcs.common.constants.perm.RoleMemberModel;

public class BatchSetValidityEditPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(BatchSetValidityEditPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        super.addClickListeners(new String[]{"lblnumber"});
        Toolbar buToolBar = (Toolbar)this.getControl("advcontoolbarap");
        buToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setStatus(OperationStatus.EDIT);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("lblnumber".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_modifyrole");
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("roleId", this.getRoleId());
            String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_role");
            DynamicObject role = serviceHelper.queryOne((Object)roleId);
            showParameter.setCaption(role.getString("name"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isForbidden = (String)customParams.get("isforbidden");
        if (HRStringUtils.equals((String)"true", (String)isForbidden)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getPageCache().put("viewStatus", "1");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4ee5\u67e5\u770b\u72b6\u6001\u6253\u5f00", (String)"RoleMemberAssignEditPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("viewStatus", "0");
        }
        String roleId = (String)customParams.get("roleId");
        this.getModel().setValue("role", (Object)roleId);
        this.setLabel(roleId);
        RoleMemberAssignServiceHelper.roleAssignMembHandleLock((IFormView)this.getView());
        Map roleDataPermModels = RoleMemberAssignSaveService.assembleRoleDataPermModelList((String)this.getRoleId(), (boolean)true);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
        permPageCacheUtil.setDataPerm(roleDataPermModels);
        List permFileIds = (List)customParams.get("permFileIds");
        if (CollectionUtils.isEmpty((Collection)permFileIds)) {
            LOG.error("beforeBindData() permFileIds is empty");
            return;
        }
        this.setByNew(permFileIds);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (HRStringUtils.equals((String)itemKey, (String)"batchsetvalid")) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("hrcs_validdialog");
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.Modal);
            fsp.setOpenStyle(style);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "choosed_valid_range"));
            this.getView().showForm(fsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            if (collection.size() <= 0) {
                return;
            }
            boolean noValid = collection.stream().anyMatch(it -> null == it.getDate("validstart") || null == it.getDate("validend"));
            if (noValid) {
                return;
            }
            RoleMemberModel model = new RoleMemberModel();
            model.setRoleId(roleId);
            ArrayList details = Lists.newArrayListWithExpectedSize((int)collection.size());
            for (DynamicObject row : collection) {
                long permFileId = row.getLong("permfileid");
                details.add(new RoleMemberDetailModel(permFileId, row.getDate("validstart"), row.getDate("validend"), "0", 0L));
            }
            model.setDetails((List)details);
            RoleMemberAssignSaveService.saveRoleMember(Collections.singletonList(model), (String)"userRoleAdd", (Long)0L, (String)"hrcs_rolememassign");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (HRStringUtils.equals((String)"choosed_valid_range", (String)actionId)) {
            Map map = (Map)evt.getReturnData();
            if (null == map) {
                return;
            }
            Date start = (Date)SerializationUtils.fromJsonString((String)((String)map.get("validstart")), Date.class);
            Date end = (Date)SerializationUtils.fromJsonString((String)((String)map.get("validend")), Date.class);
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            this.getModel().beginInit();
            for (int index = 0; index < entryRowCount; ++index) {
                this.getModel().setValue("validstart", (Object)start, index);
                this.getModel().setValue("validend", (Object)end, index);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void setByNew(List<Long> permFileIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObject[] permFiles = serviceHelper.queryOriginalArray("id,user.name,user.number,org.name", new QFilter[]{new QFilter("id", "in", permFileIds)});
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("entryentity", permFileIds.size());
        Date startDate = new Date();
        Date endDate = PermRoleUtil.dateIncreaseByMonth((Date)startDate, (int)36);
        for (int index = 0; index < permFileIds.size(); ++index) {
            DynamicObject permFile = permFiles[index];
            this.getModel().setValue("usernumber", permFile.get("user.number"), index);
            this.getModel().setValue("username", permFile.get("user.name"), index);
            this.getModel().setValue("hrbu", permFile.get("org.name"), index);
            this.getModel().setValue("permfileid", (Object)permFile.getLong("id"), index);
            this.getModel().setValue("validstart", (Object)startDate, index);
            this.getModel().setValue("validend", (Object)endDate, index);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void setLabel(String roleId) {
        DynamicObject permRole = RoleMemberAssignServiceHelper.getPermRoleById((String)roleId);
        Label labName = (Label)this.getView().getControl("lblname");
        labName.setText(permRole.getString("name"));
        Label lblNumber = (Label)this.getView().getControl("lblnumber");
        lblNumber.setText(permRole.getString("number"));
        DynamicObject hrRole = RoleMemberAssignServiceHelper.getHRRoleById((String)roleId);
        if (Objects.nonNull(hrRole)) {
            this.getModel().setValue("property", (Object)hrRole.getString("property"));
            Label lblGroup = (Label)this.getView().getControl("lblgroup");
            if (Objects.nonNull(hrRole.get("rolegrp")) && HRStringUtils.isNotEmpty((String)hrRole.getString("rolegrp"))) {
                lblGroup.setText(hrRole.getString("rolegrp.name"));
            } else {
                lblGroup.setText("-");
            }
        }
        Label lblProperty = (Label)this.getView().getControl("lblproperty");
        lblProperty.setText(RoleServiceHelper.getComboValue((String)"property", (IFormView)this.getView()));
    }

    public String getRoleId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get("roleId");
    }
}

