/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermDataRuleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.formplugin.web.perm.role.DataRuleBeforeQuickAddListener;

@ExcludeFromJacocoGeneratedReport
public class HRDataRuleBatchSetting
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
Serializable {
    private static final long serialVersionUID = 2300617725642000836L;
    private static final String CONTROL_KEY_SUFFIX = "permitemcb";
    private static final String PERMITEM_PANEL = "permitempanel";
    private static final String CHECKALL = "checkall";
    private static final String UNCHECKALL = "uncheckall";
    private static final String CHECKALL_PERMITEM_CHECKBOX = "checkallpermitemcb";
    private static final String FILL_DATA_MARK = "fillData";
    private static final String DATARULE_SCHEME = "datarulescheme";
    private static final String CURRENT_PERM_ITEM = "currentPermItem";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit dataRule = (BasedataEdit)this.getControl(DATARULE_SCHEME);
        dataRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit dataruleField = (BasedataEdit)this.getControl(DATARULE_SCHEME);
        dataruleField.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)new DataRuleBeforeQuickAddListener(this.getEntityNum()));
    }

    public void afterCreateNewData(EventObject evt) {
        String currentHRbuFunc = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        List permItems = HRPermDataRuleServiceHelper.buildControlItem((IFormView)this.getView(), (String)this.getEntityNum(), (String)this.getAppId());
        this.createPermItemPanel(permItems);
    }

    private void createPermItemPanel(List<Map<String, String>> permItems) {
        if (CollectionUtils.isEmpty(permItems)) {
            return;
        }
        FlexPanelAp flexPanelAp = this.createRowFlexPanelAp(PERMITEM_PANEL, 0);
        flexPanelAp.getItems().clear();
        for (Map<String, String> permItem : permItems) {
            String key = permItem.get("key");
            String name = permItem.get("name");
            this.createPermItemPanel(flexPanelAp, key, name);
        }
        this.getView().updateControlMetadata(PERMITEM_PANEL, flexPanelAp.createControl());
    }

    private void createPermItemPanel(FlexPanelAp funcFlexPanelAp, String id, String name) {
        FieldAp fieldAp = this.createPermItemCheckBox(id + CONTROL_KEY_SUFFIX, name);
        funcFlexPanelAp.getItems().add(fieldAp);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs evt) {
        super.loadCustomControlMetas(evt);
        FlexPanelAp funcFlexPanelAp = this.createRowFlexPanelAp(PERMITEM_PANEL, 0);
        HashMap<String, String> funcDataMap = new HashMap<String, String>(3);
        funcDataMap.put("id", PERMITEM_PANEL);
        funcDataMap.put("items", (String)funcFlexPanelAp.createControl().get("items"));
        evt.getItems().add(funcDataMap);
    }

    public void getEntityType(GetEntityTypeEventArgs evt) {
        MainEntityType oldMainType = evt.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("HRDataRuleBatchSetting", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        evt.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String key = evt.getKey();
        if (key.contains(CONTROL_KEY_SUFFIX)) {
            FieldEdit fieldEdit = this.getFieldEdit(key, (AbstractFormPlugin)this);
            evt.setControl((Control)fieldEdit);
        }
    }

    private FieldEdit getFieldEdit(String key, AbstractFormPlugin plugin) {
        FieldEdit fieldEdit = new FieldEdit();
        fieldEdit.setKey(key);
        fieldEdit.setView(plugin.getView());
        return fieldEdit;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List permItems = HRPermDataRuleServiceHelper.buildControlItem((IFormView)this.getView(), (String)this.getEntityNum(), (String)this.getAppId());
        for (Map tempMap : permItems) {
            this.doRegister(newMainType, tempMap);
        }
    }

    private void doRegister(MainEntityType newMainType, Map<String, String> tempMap) {
        BooleanProp booleanProp = this.getBooleanProp(tempMap.get("name"), tempMap.get("key") + CONTROL_KEY_SUFFIX);
        newMainType.registerSimpleProperty((DynamicSimpleProperty)booleanProp);
    }

    private BooleanProp getBooleanProp(String displayName, String apKey) {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setName(apKey);
        booleanProp.setDisplayName(new LocaleString(displayName));
        booleanProp.setDbIgnore(true);
        return booleanProp;
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        IDataEntityProperty property = evt.getProperty();
        String propertyName = property.getName();
        if (propertyName.contains(CONTROL_KEY_SUFFIX)) {
            this.handleCheckBoxChanged(evt, propertyName);
        }
    }

    private void handleCheckBoxChanged(PropertyChangedArgs evt, String propertyName) {
        ChangeData changeData = evt.getChangeSet()[0];
        Object newValueObj = changeData.getNewValue();
        if (Objects.isNull(newValueObj)) {
            return;
        }
        Boolean newValue = (Boolean)newValueObj;
        if (HRStringUtils.equals((String)CHECKALL_PERMITEM_CHECKBOX, (String)propertyName) && this.isUncheckAllByUser()) {
            this.checkAll(newValue);
        } else {
            Set<String> permItems = this.getPermItemsCach();
            if (newValue.booleanValue()) {
                permItems.add(propertyName.replace(CONTROL_KEY_SUFFIX, ""));
            } else {
                permItems.remove(propertyName.replace(CONTROL_KEY_SUFFIX, ""));
            }
            this.getPageCache().put("permitem", SerializationUtils.toJsonString(permItems));
            if (!newValue.booleanValue() && !this.checkFillData()) {
                this.getPageCache().put(UNCHECKALL, "1");
                this.getPageCache().put(FILL_DATA_MARK, "1");
                this.getModel().setValue(CHECKALL_PERMITEM_CHECKBOX, (Object)Boolean.FALSE);
            }
        }
    }

    private boolean checkFillData() {
        boolean result = HRStringUtils.equals((String)this.getPageCache().get(FILL_DATA_MARK), (String)"1");
        return result;
    }

    private boolean isUncheckAllByUser() {
        boolean result = HRStringUtils.equals((String)this.getPageCache().get(UNCHECKALL), (String)"1");
        if (result) {
            this.getPageCache().remove(UNCHECKALL);
        }
        return !result;
    }

    private void checkAll(Boolean newValue) {
        this.getPageCache().put(FILL_DATA_MARK, "1");
        List permItemList = HRPermDataRuleServiceHelper.getPermItemMapInfoList((IFormView)this.getView(), (String)this.getEntityNum(), (String)this.getAppId(), (Boolean)Boolean.TRUE);
        Set<String> permItems = this.getPermItemsCach();
        for (Map tempMap : permItemList) {
            this.getModel().setValue((String)tempMap.get("key") + CONTROL_KEY_SUFFIX, (Object)newValue);
            permItems.add((String)tempMap.get("id"));
        }
        this.getPageCache().remove(FILL_DATA_MARK);
        this.getView().updateView(PERMITEM_PANEL);
    }

    private Set<String> getPermItemsCach() {
        String permItemStr = this.getPageCache().get("permitem");
        Set permItems = HRStringUtils.isEmpty((String)permItemStr) ? Sets.newHashSetWithExpectedSize((int)16) : (Set)SerializationUtils.fromJsonString((String)permItemStr, Set.class);
        return permItems;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (key = button.getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void returnData() {
        String isSuccess = this.checkDataEmpty();
        if (!"3".equals(isSuccess)) {
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        String permItemStr = this.getPageCache().get("permitem");
        Set permItemSet = (Set)SerializationUtils.fromJsonString((String)permItemStr, Set.class);
        DynamicObject dataRuleScheme = (DynamicObject)this.getModel().getValue(DATARULE_SCHEME);
        String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("entitytype");
        String app = (String)this.getView().getFormShowParameter().getCustomParam("parentid");
        returnData.put("entitynum", entityNum);
        returnData.put("app", app);
        returnData.put(DATARULE_SCHEME, dataRuleScheme.getLong("id"));
        returnData.put("permitem.id", permItemSet);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("entitytype");
        String property = evt.getProperty().getName();
        if (HRStringUtils.equals((String)DATARULE_SCHEME, (String)property)) {
            ArrayList qList = Lists.newArrayListWithCapacity((int)16);
            QFilter qFilter = new QFilter("entitynum", "=", (Object)entityNum);
            qList.add(qFilter);
            ((ListShowParameter)evt.getFormShowParameter()).setMultiSelect(false);
            evt.setCustomQFilters((List)qList);
        }
    }

    private List<ComboItem> getAppComboData() {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entitynum");
        String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
        String currentHRbuFunc = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        IFormView view = this.getView().getView(mainPageId);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view, false);
        Map assignedHrBuCaMap = permPageCacheUtil.getAssignedHrBuCaMap();
        ArrayList data = Lists.newArrayListWithCapacity((int)16);
        Map assignedAppEntity = permPageCacheUtil.getAssignedAppEntity();
        HashSet filterAppId = Sets.newHashSetWithExpectedSize((int)16);
        Optional.ofNullable(assignedHrBuCaMap.get(currentHRbuFunc)).ifPresent(currentHRbuFuncMap -> {
            Set appIds = (Set)currentHRbuFuncMap.get("appId");
            assignedAppEntity.forEach((assignedApp, assignAppBusiness) -> appIds.forEach(appId -> {
                if (HRStringUtils.equals((String)assignedApp, (String)appId) && assignAppBusiness.contains(entity.getString("number"))) {
                    filterAppId.add(appId);
                }
            }));
            DynamicObjectCollection appById = RoleMemberAssignServiceHelper.getAppById((Set)filterAppId);
            appById.forEach(app -> data.add(new ComboItem(new LocaleString(app.getString("name")), app.getString("id"))));
        });
        return data;
    }

    private String checkDataEmpty() {
        String permItemStr = this.getPageCache().get("permitem");
        DynamicObject datarulescheme = (DynamicObject)this.getModel().getValue(DATARULE_SCHEME);
        Set permItemSet = Sets.newHashSet();
        if (HRStringUtils.isNotEmpty((String)permItemStr)) {
            permItemSet = (Set)SerializationUtils.fromJsonString((String)permItemStr, Set.class);
        }
        if ((HRStringUtils.isEmpty((String)permItemStr) || CollectionUtils.isEmpty((Collection)permItemSet)) && Objects.isNull(datarulescheme)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e0e\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRDataRuleBatchSetting_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return "0";
        }
        if (HRStringUtils.isEmpty((String)permItemStr) || CollectionUtils.isEmpty((Collection)permItemSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRDataRuleBatchSetting_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return "1";
        }
        if (Objects.isNull(datarulescheme)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRDataRuleBatchSetting_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return "2";
        }
        return "3";
    }

    private FlexPanelAp createRowFlexPanelAp(String flexName, Integer grow) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(flexName);
        flexPanelAp.setWrap(true);
        flexPanelAp.setFontSize(12);
        flexPanelAp.setGrow(grow.intValue());
        return flexPanelAp;
    }

    private FieldAp createPermItemCheckBox(String key, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(key);
        fieldAp.setId(key);
        fieldAp.setHeight(new LocaleString("20px"));
        fieldAp.setFieldTextAlign("center");
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setKey(key);
        checkBoxField.setId(key);
        checkBoxField.setShowStyle(2);
        checkBoxField.setName(new LocaleString(name));
        checkBoxField.setDefValue(false);
        fieldAp.setField((Field)checkBoxField);
        fieldAp.setLabelDirection(ResManager.loadKDString((String)"\u6c34\u5e73", (String)"DynamicControlHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        fieldAp.setName(new LocaleString(name));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("22px");
        margin.setBottom("20px");
        margin.setTop("10px");
        style.setMargin(margin);
        fieldAp.setStyle(style);
        fieldAp.setFireUpdEvt(true);
        return fieldAp;
    }

    private String getEntityNum() {
        return (String)this.getView().getFormShowParameter().getCustomParam("entitytype");
    }

    private String getAppId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("parentid");
    }
}

