/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.extpoint.permission.role.IRoleDimF7CustomFilterPlugin;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermCommonTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermLazyOTSearchTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermLazyOTTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermOTLazyTreeCommonHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.PermDimTreeEntryModel;
import kd.hr.hrcs.common.model.OrgTeamTreeBean;

@ExcludeFromJacocoGeneratedReport
public class PermOTLazyTreePlugin
extends HRDynamicFormBasePlugin
implements IDataModelChangeListener,
TreeNodeQueryListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(PermOTLazyTreePlugin.class);
    private static final String KEY_STRUCT_IS_CUSTOM = "isCustomStructKey";
    private static final String KEY_STRUCT = "structKey";
    private static final String KEY_STRUCT_RELY_ON = "structRelyOnKey";
    private static final String KEY_STRUCT_RELY_ON_MAP = "structRelyOnKeyMap";
    private static final String PREVIEW_FORM = "hrcs_ottreepreview";
    private static final int THRESHOLD = 5000;

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Button btnOk = (Button)this.getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        TreeView treeview = (TreeView)this.getControl("treeview");
        treeview.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeview.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Label label = (Label)this.getControl("clearall");
        label.addClickListener((ClickListener)this);
        Label previewAll = (Label)this.getControl("previewall");
        previewAll.addClickListener((ClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Search entrySearch = (Search)this.getView().getControl("entrysearchap");
        entrySearch.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.initRelyOnStructProject();
        this.initTree();
        this.initEntry();
    }

    private void initRelyOnStructProject() {
        String controlKey = (String)this.getView().getFormShowParameter().getCustomParam("htmlControlKey");
        String struct = controlKey.substring(controlKey.lastIndexOf("#") + 1);
        HashMap<String, String> structRelyOnMap = new HashMap<String, String>();
        structRelyOnMap.put(struct, null);
        String isCustom = "0";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject item = serviceHelper.queryOne("relyonstructproject.id,otclassify.teamtype.id", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(struct))});
        Long relyOnStructProject = HRCSBaseConstants.LONG_MINUS_ONE;
        if (null != item) {
            long teamTypeId;
            HRBaseServiceHelper teamTypeServiceHelper;
            DynamicObject teamType;
            long relyOnId = item.getLong("relyonstructproject.id");
            if (relyOnId != 0L) {
                structRelyOnMap.put(struct, String.valueOf(item.getLong("relyonstructproject.id")));
                struct = struct + "," + item.getLong("relyonstructproject.id");
                relyOnStructProject = item.getLong("relyonstructproject.id");
            }
            if (null != (teamType = (teamTypeServiceHelper = new HRBaseServiceHelper("hbss_teamtype")).queryOne("iscustom", new QFilter[]{new QFilter("id", "=", (Object)(teamTypeId = item.getLong("otclassify.teamtype.id")))})) && HRStringUtils.isNotEmpty((String)teamType.getString("iscustom"))) {
                isCustom = teamType.getString("iscustom");
            } else {
                LOGGER.info("Can not get iscustom property with team type id: {}.", (Object)teamTypeId);
            }
        }
        this.getPageCache().put(KEY_STRUCT_IS_CUSTOM, isCustom);
        this.getPageCache().put(KEY_STRUCT, struct);
        this.getPageCache().put(KEY_STRUCT_RELY_ON, String.valueOf(relyOnStructProject));
        this.getPageCache().put(KEY_STRUCT_RELY_ON_MAP, SerializationUtils.toJsonString(structRelyOnMap));
    }

    private void initTree() {
        String controlKey = (String)this.getView().getFormShowParameter().getCustomParam("htmlControlKey");
        String structProjectId = controlKey.substring(controlKey.lastIndexOf("#") + 1);
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        TreeNode rootNode = PermOTLazyTreeCommonHelper.buildRootNode((List)Lists.newArrayList((Object[])new Long[]{Long.parseLong(structProjectId)}), (boolean)true, (boolean)isCustomProjectStruct, (IFormView)this.getView());
        if (HRStringUtils.isEmpty((String)rootNode.getId())) {
            return;
        }
        HashMap treeProMap = Maps.newHashMapWithExpectedSize((int)1);
        treeProMap.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata("treeview", (Map)treeProMap);
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        treeview.addNode(rootNode);
        treeview.expand(rootNode.getId());
        List selectedOrgIds = new ArrayList();
        boolean customCheckValue = HRStringUtils.equals((String)"1", (String)((String)this.getView().getFormShowParameter().getCustomParam("customCheckValue")));
        if (customCheckValue) {
            JSONObject jsonValue = (JSONObject)this.getView().getFormShowParameter().getCustomParam("checkValue");
            selectedOrgIds = PermOTLazyTreeCommonHelper.getSelectedOrgIds((IFormView)this.getView(), (JSONObject)jsonValue);
        } else {
            selectedOrgIds = PermOTLazyTreeCommonHelper.getSelectedOrgIds((IFormView)this.getView());
        }
        if (selectedOrgIds.contains(Long.parseLong(rootNode.getId()))) {
            treeview.checkNodesWithoutChild((List)Lists.newArrayList((Object[])new TreeNode[]{rootNode}));
        }
        String showCompanyName = "0";
        HRBaseServiceHelper structProject = new HRBaseServiceHelper("haos_structure");
        DynamicObject item = structProject.queryOne("id", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(structProjectId)), new QFilter("id", "!=", (Object)1010L), new QFilter("otclassify", "=", (Object)1010L)});
        if (null != item) {
            showCompanyName = "1";
        }
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)rootNode));
        this.getPageCache().put("showCompanyName", showCompanyName);
    }

    private void initEntry() {
        String suffix = ResManager.loadKDString((String)"\u4e0b\u7ea7", (String)"PermOTLazyTreePlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        List struct = Arrays.stream(this.getPageCache().get(KEY_STRUCT).split(",")).map(Long::parseLong).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
        final DynamicObject[] items = serviceHelper.query("id,name", new QFilter[]{new QFilter("id", "in", struct)}, "id desc");
        if (struct.size() > 1) {
            if (items.length > 1) {
                grid.setColumnProperty("includesub", "header", (Object)(items[0].getString("name") + suffix));
                grid.setColumnProperty("admincontainssub", "header", (Object)(items[1].getString("name") + suffix));
                grid.setColumnProperty("includesub", "tips", (Object)new Tips(){
                    private static final long serialVersionUID = -3196037191318674525L;
                    {
                        this.setType("text");
                        this.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u5f00\u542f\uff1a\u6839\u636e\u6240\u9009\u7ec4\u7ec7\uff0c\u83b7\u53d6\u4e0b\u7ea7\u201c%1$s\u201d\u7684\u6570\u636e\uff0c\u5f53\u65b0\u589e\u4e0b\u7ea7\u7ec4\u7ec7\u65f6\uff0c\u81ea\u52a8\u62e5\u6709\u65b0\u589e\u7ec4\u7ec7\u6743\u9650\uff1b\n\u5173\u95ed\uff1a\u4e0d\u5305\u542b\u4e0b\u7ea7\u201c%1$s\u201d\u3002", (String)"PermOTLazyTreePlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), items[0].getString("name"))));
                    }
                });
                grid.setColumnProperty("admincontainssub", "tips", (Object)new Tips(){
                    private static final long serialVersionUID = -7052414222862147254L;
                    {
                        this.setType("text");
                        this.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u5f00\u542f\uff1a\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u201c%1$s\u201d\u7684\u76f4\u5c5e\u201c%2$s\u201d\u6570\u636e\uff1b\n\u5173\u95ed\uff1a\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u76f4\u5c5e\u7684\u201c%2$s\u201d\u6570\u636e\u3002", (String)"PermOTLazyTreePlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), items[1].getString("name"), items[0].getString("name"))));
                    }
                });
            } else {
                grid.setColumnProperty("includesub", "header", (Object)(items[0].getString("name") + suffix));
                grid.setColumnProperty("admincontainssub", "visible", (Object)false);
                grid.setColumnProperty("includesub", "tips", (Object)new Tips(){
                    private static final long serialVersionUID = 5048570691430873480L;
                    {
                        this.setType("text");
                        this.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u5f00\u542f\uff1a\u6839\u636e\u6240\u9009\u7ec4\u7ec7\uff0c\u83b7\u53d6\u4e0b\u7ea7\u201c%1$s\u201d\u7684\u6570\u636e\uff0c\u5f53\u65b0\u589e\u4e0b\u7ea7\u7ec4\u7ec7\u65f6\uff0c\u81ea\u52a8\u62e5\u6709\u65b0\u589e\u7ec4\u7ec7\u6743\u9650\uff1b\n\u5173\u95ed\uff1a\u4e0d\u5305\u542b\u4e0b\u7ea7\u201c%1$s\u201d\u3002", (String)"PermOTLazyTreePlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), items[0].getString("name"))));
                    }
                });
            }
        } else {
            grid.setColumnProperty("includesub", "header", (Object)(items[0].getString("name") + suffix));
            grid.setColumnProperty("admincontainssub", "visible", (Object)false);
            grid.setColumnProperty("includesub", "tips", (Object)new Tips(){
                private static final long serialVersionUID = 8648282441790341334L;
                {
                    this.setType("text");
                    this.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u5f00\u542f\uff1a\u6839\u636e\u6240\u9009\u7ec4\u7ec7\uff0c\u83b7\u53d6\u4e0b\u7ea7\u201c%1$s\u201d\u7684\u6570\u636e\uff0c\u5f53\u65b0\u589e\u4e0b\u7ea7\u7ec4\u7ec7\u65f6\uff0c\u81ea\u52a8\u62e5\u6709\u65b0\u589e\u7ec4\u7ec7\u6743\u9650\uff1b\n\u5173\u95ed\uff1a\u4e0d\u5305\u542b\u4e0b\u7ea7\u201c%1$s\u201d\u3002", (String)"PermOTLazyTreePlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), items[0].getString("name"))));
                }
            });
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        this.handleQueryTreeNodeChildren((String)evt.getNodeId());
    }

    private void handleQueryTreeNodeChildren(String parentNodeId) {
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        Long adminOrgId = Long.parseLong(parentNodeId);
        Map structRelyOnMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_STRUCT_RELY_ON_MAP), Map.class);
        List struct = Arrays.stream(this.getPageCache().get(KEY_STRUCT).split(",")).map(Long::parseLong).collect(Collectors.toList());
        Long relyOnStruct = Long.parseLong(this.getPageCache().get(KEY_STRUCT_RELY_ON));
        boolean showCompanyName = HRStringUtils.equals((String)"1", (String)this.getPageCache().get("showCompanyName"));
        List orgBeanList = PermLazyOTTreeHelper.getHasAdminPermOrgList((Long)adminOrgId, struct, (Long)relyOnStruct, (boolean)isCustomProjectStruct, (boolean)showCompanyName);
        List<TreeNode> treeNodeList = Lists.newArrayListWithExpectedSize((int)orgBeanList.size());
        for (OrgTeamTreeBean orgBean : orgBeanList) {
            TreeNode node = new TreeNode(parentNodeId, orgBean.getId().toString(), orgBean.getName());
            node.setLeaf(orgBean.isLeaf());
            if (!orgBean.isLeaf()) {
                node.setChildren((List)Lists.newArrayList());
            }
            node.setDisabled(!orgBean.isHasPerm());
            node.setLongNumber(orgBean.getStructLongNumber());
            node.setIcon(HRStringUtils.isNotEmpty((String)((String)structRelyOnMap.get(String.valueOf(orgBean.getStructProject())))) ? "kdfont kdfont-xiangmuxingtuandui" : "kdfont kdfont-shitizuzhi");
            treeNodeList.add(node);
        }
        ArrayList tempFinalTreeNode = treeNodeList;
        HRPluginProxy proxy = new HRPluginProxy(null, IRoleDimF7CustomFilterPlugin.class, "kd.hr.hrcs.formplugin.web.perm.role.component.CustomCtrlPlugin#beforeF7Select", null);
        treeNodeList = proxy.callReplace(p -> p.postProcessTreeNode(tempFinalTreeNode, this.getView().getFormShowParameter().getCustomParams())).stream().filter(Objects::nonNull).findFirst().orElse(treeNodeList);
        LOGGER.info("Complete tree node post process.");
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.addNodes((List)treeNodeList);
        List selectedOrgIds = PermOTLazyTreeCommonHelper.getOrgIdsByEntry((IFormView)this.getView());
        ArrayList checkedNodes = Lists.newArrayListWithCapacity((int)16);
        for (TreeNode node : treeNodeList) {
            if (!selectedOrgIds.contains(Long.parseLong(node.getId()))) continue;
            checkedNodes.add(node);
        }
        treeView.checkNodesWithoutChild((List)checkedNodes);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        String controlKey = (String)this.getView().getFormShowParameter().getCustomParam("htmlControlKey");
        String structProjectId = controlKey.substring(controlKey.lastIndexOf("#") + 1);
        boolean showCompanyName = HRStringUtils.equals((String)"1", (String)this.getPageCache().get("showCompanyName"));
        List selectedOrgInfos = PermOTLazyTreeCommonHelper.buildEntryData((IFormView)this.getView(), (String)structProjectId, (boolean)isCustomProjectStruct, (boolean)showCompanyName);
        int size = selectedOrgInfos.size();
        if (size > 0) {
            int[] index;
            this.getModel().beginInit();
            for (int value : index = this.getModel().batchCreateNewEntryRow("entryentity", size)) {
                OrgTeamTreeBean orgBean = (OrgTeamTreeBean)selectedOrgInfos.get(value);
                this.getModel().setValue("id", (Object)orgBean.getId().toString(), value);
                this.getModel().setValue("name", (Object)orgBean.getName(), value);
                this.getModel().setValue("number", (Object)orgBean.getNumber(), value);
                this.getModel().setValue("currentotclassify", (Object)orgBean.getCurrentClassify(), value);
                this.getModel().setValue("currentotclassifyid", (Object)orgBean.getCurrentClassify(), value);
                this.getModel().setValue("currentstructproject", (Object)orgBean.getStructProject(), value);
                this.getModel().setValue("currentstructprojectid", (Object)orgBean.getStructProject(), value);
                this.getModel().setValue("haschildren", (Object)(!orgBean.isLeaf() ? 1 : 0), value);
                this.getModel().setValue("includesub", (Object)orgBean.isIncludesub(), value);
                this.getModel().setValue("admincontainssub", (Object)orgBean.isIncludeSubAdminOrg(), value);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata("entryentity", (Map)map);
    }

    private void flatTree(TreeNode rootNode, LinkedHashMap<String, TreeNode> result) {
        if (rootNode == null) {
            return;
        }
        result.put(rootNode.getId(), rootNode);
        List children = rootNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (TreeNode child : children) {
                this.flatTree(child, result);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        final Map structRelyOnMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_STRUCT_RELY_ON_MAP), Map.class);
        String operationKey = evt.getOperateKey();
        if (HRStringUtils.equals((String)"delete", (String)operationKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectedRows = entryGrid.getSelectRows();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            String id = (String)this.getModel().getValue("id", index);
            TreeView treeView = (TreeView)this.getControl("treeview");
            treeView.uncheckNode(id);
            this.getModel().deleteEntryRow("entryentity", index);
            entryGrid.selectRows(selectedRows, selectedRows[selectedRows.length - 1]);
            if (this.hasMemoryEntry()) {
                List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
                memoryEntry.removeIf(model -> HRStringUtils.equals((String)id, (String)model.getId()));
                this.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)memoryEntry));
            }
        } else if (HRStringUtils.equals((String)"preview", (String)operationKey)) {
            final int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(){
                private static final long serialVersionUID = -6941814541571532482L;
                {
                    this.add(new HashMap<String, String>(){
                        private static final long serialVersionUID = 359024026100926335L;
                        {
                            this.put("nodeId", (String)PermOTLazyTreePlugin.this.getModel().getValue("id", index));
                            this.put("nodeName", (String)PermOTLazyTreePlugin.this.getModel().getValue("name", index));
                            this.put("nodeType", String.valueOf(PermOTLazyTreePlugin.this.getModel().getValue("currentotclassifyid", index)));
                            this.put("nodeIcon", HRStringUtils.isNotEmpty((String)((String)structRelyOnMap.get(String.valueOf(PermOTLazyTreePlugin.this.getModel().getValue("currentstructprojectid", index))))) ? "kdfont kdfont-xiangmuxingtuandui" : "kdfont kdfont-shitizuzhi");
                            this.put("hasChildren", (Boolean)PermOTLazyTreePlugin.this.getModel().getValue("haschildren", index) != false ? "1" : "0");
                            this.put("otSub", (Boolean)PermOTLazyTreePlugin.this.getModel().getValue("includesub", index) != false ? "1" : "0");
                            this.put("crossOtSub", (Boolean)PermOTLazyTreePlugin.this.getModel().getValue("admincontainssub", index) != false ? "1" : "0");
                            this.put("currentstructproject", String.valueOf(PermOTLazyTreePlugin.this.getModel().getValue("currentstructprojectid", index)));
                            this.put("currentstructprojectrelyon", structRelyOnMap.get(String.valueOf(PermOTLazyTreePlugin.this.getModel().getValue("currentstructprojectid", index))));
                        }
                    });
                }
            };
            this.showPreviewForm(SerializationUtils.toJsonString((Object)list), null, "0");
        }
    }

    private void showPreviewForm(String nodes, String nodeType, String isAll) {
        String controlKey = (String)this.getView().getFormShowParameter().getCustomParam("htmlControlKey");
        String dimensionName = (String)this.getView().getFormShowParameter().getCustomParam("dimensionName");
        String structName = (String)this.getView().getFormShowParameter().getCustomParam("structName");
        String previewLabelName = ResManager.loadKDString((String)"\u9884\u89c8", (String)"PermOTLazyTreePlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String struct = controlKey.substring(controlKey.lastIndexOf("#") + 1);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(PREVIEW_FORM);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("identify", (Object)"orgTeam");
        parameter.setCustomParam("nodes", (Object)nodes);
        parameter.setCustomParam("type", (Object)nodeType);
        parameter.setCustomParam("isAll", (Object)isAll);
        parameter.setCustomParam("fromStructProject", (Object)struct);
        parameter.setCustomParam("showCompanyName", (Object)this.getPageCache().get("showCompanyName"));
        parameter.setCustomParam("customStructProject", (Object)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        parameter.setCaption(dimensionName + "_" + structName + previewLabelName);
        this.getView().showForm(parameter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control field = (Control)evt.getSource();
        switch (key = field.getKey()) {
            case "btnok": {
                if (this.hasMemoryEntry()) {
                    List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
                    this.getModel().beginInit();
                    this.getModel().deleteEntryData("entryentity");
                    this.insertEntryByModel(memoryEntry);
                    this.getModel().endInit();
                }
                PermCommonTreeHelper.handleOk((IFormView)this.getView());
                break;
            }
            case "clearall": {
                PermCommonTreeHelper.handleClearAll((IFormView)this.getView());
                break;
            }
            case "previewall": {
                DynamicObjectCollection items = this.getModel().getEntryEntity("entryentity");
                List nodes = items.stream().map(it -> {
                    String structProjectId = it.getString("currentstructprojectid");
                    String relyOnStructProjectId = it.getDynamicObject("currentstructproject").getString("relyonstructproject.id");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("nodeId", it.getString("id"));
                    map.put("nodeName", it.getString("name"));
                    map.put("nodeIcon", HRStringUtils.isNotEmpty((String)relyOnStructProjectId) ? "kdfont kdfont-xiangmuxingtuandui" : "kdfont kdfont-shitizuzhi");
                    map.put("hasChildren", it.getBoolean("haschildren") ? "1" : "0");
                    map.put("otSub", it.getBoolean("includesub") ? "1" : "0");
                    map.put("crossOtSub", it.getBoolean("admincontainssub") ? "1" : "0");
                    map.put("currentstructproject", structProjectId);
                    map.put("currentstructprojectrelyon", relyOnStructProjectId);
                    return map;
                }).collect(Collectors.toList());
                String controlKey = (String)this.getView().getFormShowParameter().getCustomParam("htmlControlKey");
                String ot = controlKey.substring(controlKey.lastIndexOf("#") + 1);
                this.showPreviewForm(SerializationUtils.toJsonString(nodes), ot, "1");
                break;
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        boolean nodeChecked = treeNodeCheckEvent.getChecked();
        if (nodeChecked) {
            this.checkTreeNodeHandle(treeNodeCheckEvent);
        } else {
            this.uncheckTreeNodeHandle(treeNodeCheckEvent);
        }
    }

    private void checkTreeNodeHandle(TreeNodeCheckEvent treeNodeCheckEvent) {
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        String controlKey = (String)this.getView().getFormShowParameter().getCustomParam("htmlControlKey");
        String structProjectId = controlKey.substring(controlKey.lastIndexOf("#") + 1);
        IDataModel model = this.getView().getModel();
        Long targetNodeId = Long.parseLong((String)treeNodeCheckEvent.getNodeId());
        boolean includeSub = (Boolean)model.getValue("cbincludesub");
        boolean showCompanyName = HRStringUtils.equals((String)"1", (String)this.getPageCache().get("showCompanyName"));
        List structList = Arrays.stream(this.getPageCache().get(KEY_STRUCT).split(",")).map(Long::parseLong).collect(Collectors.toList());
        if (includeSub && PermOTLazyTreeCommonHelper.getAllChildrenCountByParentId((Long)targetNodeId, structList, (boolean)isCustomProjectStruct) > 5000) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u6570\u636e\u91cf\u8d85\u8fc75000\u6761\u3002\u5efa\u8bae\u5206\u591a\u6b21\u6388\u6743\uff0c\u6216\u4f7f\u7528\u53f3\u4fa7\u7684\u201c\u5305\u542b\u4e0b\u7ea7\u201d\u529f\u80fd\uff0c\u4ec5\u9009\u62e9\u6839\u8282\u70b9\u5e76\u6253\u5f00\u5f00\u5173\u3002\u9ed8\u8ba4\u7528\u6237\u5177\u6709\u4e0b\u7ea7\u7ec4\u7ec7\u6743\u9650\u3002", (String)"PermOTLazyTreePlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Boolean> checkedNodeParentMap = ((TreeView)treeNodeCheckEvent.getSource()).getTreeState().getCheckedNodes().stream().collect(Collectors.toMap(it -> it.get("id").toString(), it -> (Boolean)it.get("isParent"), (oldValue, newValue) -> oldValue));
        DynamicObjectCollection collection = model.getEntryEntity("entryentity");
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        Set existedIds = collection.stream().map(dyno -> dyno.getLong("id")).collect(Collectors.toSet());
        int size = collection.size();
        PermDimTreeEntryModel entry = null;
        OrgTeamTreeBean targetOrgBean = PermOTLazyTreeCommonHelper.getAdminOrgInfoById((Long)targetNodeId, (String)structProjectId, (boolean)isCustomProjectStruct, (boolean)showCompanyName);
        ArrayList<PermDimTreeEntryModel> nodeList = new ArrayList<PermDimTreeEntryModel>();
        if (!existedIds.contains(targetNodeId)) {
            model.insertEntryRow("entryentity", size);
            model.setValue("id", (Object)targetNodeId, size);
            model.setValue("name", (Object)targetOrgBean.getName(), size);
            model.setValue("number", (Object)targetOrgBean.getNumber(), size);
            model.setValue("haschildren", (Object)checkedNodeParentMap.getOrDefault(targetOrgBean.getId().toString(), false), size);
            model.setValue("currentotclassify", (Object)targetOrgBean.getCurrentClassify(), size);
            model.setValue("currentotclassifyid", (Object)targetOrgBean.getCurrentClassify(), size);
            model.setValue("currentstructproject", (Object)targetOrgBean.getStructProject(), size);
            model.setValue("currentstructprojectid", (Object)targetOrgBean.getStructProject(), size);
            if (null != targetOrgBean.getStructProjectRelyOn() && 0L != targetOrgBean.getStructProjectRelyOn()) {
                model.setValue("admincontainssub", (Object)false, size);
            }
            ++size;
            entry = new PermDimTreeEntryModel();
            entry.setId(String.valueOf(targetNodeId));
            entry.setNumber(targetOrgBean.getNumber());
            entry.setName(targetOrgBean.getName());
            entry.setHaschildren(checkedNodeParentMap.getOrDefault(targetOrgBean.getId().toString(), false).booleanValue());
            entry.setSeq(size);
            entry.setCurrentotclassifyid(targetOrgBean.getCurrentClassify());
            entry.setCurrentstructprojectid(targetOrgBean.getStructProject());
            if (null != targetOrgBean.getStructProjectRelyOn() && 0L != targetOrgBean.getStructProjectRelyOn()) {
                entry.setAdmincontainssub(false);
            }
        }
        if (includeSub) {
            ArrayList treeNodes = Lists.newArrayListWithExpectedSize((int)16);
            List children = PermOTLazyTreeCommonHelper.getAllChildrenByParentId((Long)targetNodeId, structList, (boolean)isCustomProjectStruct, (boolean)showCompanyName);
            for (OrgTeamTreeBean orgBean : children) {
                treeNodes.add(new TreeNode("", orgBean.getId().toString(), ""));
                if (existedIds.contains(orgBean.getId())) continue;
                model.insertEntryRow("entryentity", size);
                model.setValue("id", (Object)orgBean.getId(), size);
                model.setValue("name", (Object)orgBean.getName(), size);
                model.setValue("number", (Object)orgBean.getNumber(), size);
                model.setValue("haschildren", (Object)checkedNodeParentMap.getOrDefault(orgBean.getId().toString(), false), size);
                model.setValue("currentotclassify", (Object)orgBean.getCurrentClassify(), size);
                model.setValue("currentotclassifyid", (Object)orgBean.getCurrentClassify(), size);
                model.setValue("currentstructproject", (Object)orgBean.getStructProject(), size);
                model.setValue("currentstructprojectid", (Object)orgBean.getStructProject(), size);
                if (null != orgBean.getStructProjectRelyOn() && 0L != orgBean.getStructProjectRelyOn()) {
                    model.setValue("admincontainssub", (Object)false, size);
                }
                PermDimTreeEntryModel item = new PermDimTreeEntryModel();
                item.setId(String.valueOf(orgBean.getId()));
                item.setNumber(orgBean.getNumber());
                item.setName(orgBean.getName());
                item.setHaschildren(checkedNodeParentMap.getOrDefault(orgBean.getId().toString(), false).booleanValue());
                item.setSeq(size);
                item.setCurrentotclassifyid(orgBean.getCurrentClassify());
                item.setCurrentstructprojectid(orgBean.getStructProject());
                if (null != orgBean.getStructProjectRelyOn() && 0L != orgBean.getStructProjectRelyOn()) {
                    item.setAdmincontainssub(false);
                }
                nodeList.add(item);
                ++size;
            }
            treeView.checkNodesWithoutChild((List)treeNodes);
        }
        this.updateMemoryEntry(this.getView(), entry, includeSub, nodeList);
    }

    private void uncheckTreeNodeHandle(TreeNodeCheckEvent treeNodeCheckEvent) {
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection collection = model.getEntryEntity("entryentity");
        Long targetNodeId = Long.parseLong((String)treeNodeCheckEvent.getNodeId());
        boolean includeSub = (Boolean)model.getValue("cbincludesub");
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        boolean showCompanyName = HRStringUtils.equals((String)"1", (String)this.getPageCache().get("showCompanyName"));
        HashMap idIndexMap = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (int index = 0; index < collection.size(); ++index) {
            idIndexMap.put(((DynamicObject)collection.get(index)).getLong("id"), index);
        }
        HashSet toDeletes = Sets.newHashSetWithExpectedSize((int)16);
        Integer index = (Integer)idIndexMap.get(targetNodeId);
        if (index != null) {
            toDeletes.add(index);
        }
        if (includeSub) {
            List classifies = Arrays.stream(this.getPageCache().get(KEY_STRUCT).split(",")).map(Long::parseLong).collect(Collectors.toList());
            List children = PermOTLazyTreeCommonHelper.getAllChildrenByParentId((Long)targetNodeId, classifies, (boolean)isCustomProjectStruct, (boolean)showCompanyName);
            for (OrgTeamTreeBean orgBean2 : children) {
                Integer index2 = (Integer)idIndexMap.get(orgBean2.getId());
                if (index2 == null) continue;
                toDeletes.add(index2);
            }
            List uncheckIds = children.stream().map(orgBean -> orgBean.getId().toString()).collect(Collectors.toList());
            treeView.unCheckNodesWithoutChild(uncheckIds);
        }
        model.deleteEntryRows("entryentity", toDeletes.stream().mapToInt(i -> i).toArray());
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        String key = source.getKey();
        String searchText = evt.getText();
        List structProjects = Arrays.stream(this.getPageCache().get(KEY_STRUCT).split(",")).map(Long::parseLong).collect(Collectors.toList());
        Map structRelyOnMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_STRUCT_RELY_ON_MAP), Map.class);
        boolean showCompanyName = HRStringUtils.equals((String)"1", (String)this.getPageCache().get("showCompanyName"));
        boolean isCustomProjectStruct = HRStringUtils.equals((String)"1", (String)this.getPageCache().get(KEY_STRUCT_IS_CUSTOM));
        if (HRStringUtils.equals((String)key, (String)"searchap")) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            HashMap treeProMap = Maps.newHashMapWithExpectedSize((int)1);
            treeProMap.put("cpn", Boolean.FALSE);
            this.getView().updateControlMetadata("treeview", (Map)treeProMap);
            List selectedOrgIds = PermOTLazyTreeCommonHelper.getOrgIdsByEntry((IFormView)this.getView());
            if (HRStringUtils.isEmpty((String)searchText)) {
                treeView.deleteAllNodes();
                TreeNode rootNode = PermOTLazyTreeCommonHelper.buildRootNode(structProjects, (boolean)false, (boolean)isCustomProjectStruct, (IFormView)this.getView());
                treeView.addNode(rootNode);
                treeView.focusNode(rootNode);
                treeView.expand(rootNode.getId());
                treeView.treeNodeClick("", rootNode.getId());
                this.handleQueryTreeNodeChildren(rootNode.getId());
                if (selectedOrgIds.contains(Long.parseLong(rootNode.getId()))) {
                    treeView.checkNodesWithoutChild((List)Lists.newArrayList((Object[])new TreeNode[]{rootNode}));
                }
            } else {
                treeView.deleteAllNodes();
                TreeNode rootNode = PermLazyOTSearchTreeHelper.buildSearchedOrgTreeNode((String)searchText, structProjects, (Map)structRelyOnMap, (boolean)isCustomProjectStruct, (boolean)showCompanyName);
                List<TreeNode> tempFinalTreeNode = Collections.singletonList(rootNode);
                HRPluginProxy proxy = new HRPluginProxy(null, IRoleDimF7CustomFilterPlugin.class, "kd.hr.hrcs.formplugin.web.perm.role.component.CustomCtrlPlugin#beforeF7Select", null);
                List<TreeNode> treeNodeList = proxy.callReplace(p -> p.postProcessTreeNode(tempFinalTreeNode, this.getView().getFormShowParameter().getCustomParams())).stream().filter(Objects::nonNull).findFirst().orElse(tempFinalTreeNode);
                rootNode = treeNodeList.stream().filter(Objects::nonNull).findFirst().orElse(rootNode);
                LOGGER.info("Complete tree node post process.");
                if (rootNode != null) {
                    treeView.addNode(rootNode);
                }
                LinkedHashMap treeNodes = Maps.newLinkedHashMapWithExpectedSize((int)16);
                this.flatTree(rootNode, treeNodes);
                ArrayList nodes = new ArrayList(treeNodes.values());
                List selectedNodes = nodes.stream().filter(node -> selectedOrgIds.contains(Long.parseLong(node.getId()))).collect(Collectors.toList());
                treeView.checkNodesWithoutChild(selectedNodes);
            }
            this.getView().updateView("treeview");
        } else {
            List memoryEntry;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (!this.hasMemoryEntry()) {
                this.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)entryEntity));
            }
            if (CollectionUtils.isEmpty((Collection)(memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView()))) && !CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)entryEntity));
                memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
            }
            if (CollectionUtils.isEmpty((Collection)memoryEntry)) {
                return;
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity");
            ArrayList newValue = Lists.newArrayListWithExpectedSize((int)16);
            for (PermDimTreeEntryModel model : memoryEntry) {
                String name = model.getName();
                String number = model.getNumber();
                if (HRStringUtils.isEmpty((String)searchText) || !name.contains(searchText) && !number.contains(searchText)) continue;
                newValue.add(model);
            }
            if (HRStringUtils.isEmpty((String)searchText)) {
                newValue.addAll(memoryEntry);
            }
            this.insertEntryByModel(newValue);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("includesub".equals(name) && this.hasMemoryEntry()) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            String id = (String)this.getModel().getValue("id", index);
            List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
            memoryEntry.forEach(entry -> {
                if (HRStringUtils.equals((String)id, (String)entry.getId())) {
                    entry.setIncludesub(((Boolean)this.getModel().getValue("includesub", index)).booleanValue());
                }
            });
            this.getView().getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)memoryEntry));
        } else if ("admincontainssub".equals(name) && this.hasMemoryEntry()) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            String id = (String)this.getModel().getValue("id", index);
            List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
            memoryEntry.forEach(entry -> {
                if (HRStringUtils.equals((String)id, (String)entry.getId())) {
                    entry.setAdmincontainssub(((Boolean)this.getModel().getValue("admincontainssub", index)).booleanValue());
                }
            });
            this.getView().getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)memoryEntry));
        }
    }

    private void insertEntryByModel(List<PermDimTreeEntryModel> memoryEntry) {
        for (int index = 0; index < memoryEntry.size(); ++index) {
            PermDimTreeEntryModel model = memoryEntry.get(index);
            this.getModel().insertEntryRow("entryentity", index);
            this.getModel().setValue("id", (Object)model.getId(), index);
            this.getModel().setValue("name", (Object)model.getName(), index);
            this.getModel().setValue("number", (Object)model.getNumber(), index);
            this.getModel().setValue("currentotclassify", (Object)model.getCurrentotclassifyid(), index);
            this.getModel().setValue("currentotclassifyid", (Object)model.getCurrentotclassifyid(), index);
            this.getModel().setValue("currentstructproject", (Object)model.getCurrentstructprojectid(), index);
            this.getModel().setValue("currentstructprojectid", (Object)model.getCurrentstructprojectid(), index);
            this.getModel().setValue("haschildren", (Object)model.isHaschildren(), index);
            this.getModel().setValue("includesub", (Object)model.isIncludesub(), index);
            this.getModel().setValue("admincontainssub", (Object)model.isAdmincontainssub(), index);
        }
    }

    private boolean hasMemoryEntry() {
        return !HRStringUtils.isEmpty((String)this.getView().getPageCache().get("originalEntryValue"));
    }

    private void updateMemoryEntry(IFormView formView, PermDimTreeEntryModel entry, boolean includeSub, List<PermDimTreeEntryModel> entries) {
        String originalEntryValue = formView.getPageCache().get("originalEntryValue");
        if (HRStringUtils.isEmpty((String)originalEntryValue) || null == entry) {
            return;
        }
        List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
        memoryEntry.add(entry);
        if (includeSub) {
            memoryEntry.addAll(entries);
        }
        formView.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)memoryEntry));
    }
}

