/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.service.perm.DimChangeCheckService;
import kd.hr.hrcs.bussiness.service.perm.PermNotifyService;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRRoleFunctionPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HrbuCaControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.NewRoleWizardHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleDataPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DimensionHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.role.HRRolePermHelper;
import kd.hr.hrcs.bussiness.util.FieldPermInfoJsonUtil;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.formplugin.web.perm.role.AllFuncPermTreeUtil;
import kd.hr.hrcs.formplugin.web.perm.role.UserFuncPermTreeUtil;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class RoleFuntionAssignEdit
extends HRDynamicFormBasePlugin
implements UploadListener,
RowClickEventListener,
TabSelectListener,
BeforeF7SelectListener,
ClickListener {
    private static final Log LOGGER = LogFactory.getLog(RoleFuntionAssignEdit.class);
    private static final String HRCS_MODIFYROLEINFO = "hrcs_modifyroleinfo";
    private static final String ROLE_ID = "roleId";
    private static final String TREE_FIELD = "tree_fieldperm";
    private AllFuncPermTreeUtil allFuncPermTreeUtil = null;
    private UserFuncPermTreeUtil userFuncPermTreeUtil = null;
    private TreeView allFuncPermTreeView = null;
    private TreeView funcPermTreeView = null;
    private PermPageCacheUtil permPageCacheUtil = null;
    private static final String ENTITY_PERM_ROLE = "perm_role";
    private static final String VALIDATE_STATUS = "validateStatus";
    private static final String REVERT = "revert";
    private static final String ROLE_PROPERTY_OLD_VALUE = "propertyOldValue";

    private String getRoleNumberEmptyMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u89d2\u8272\u7f16\u7801\u3002", (String)"RoleModifyEdit_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getRoleNameEmptyMsg() {
        return ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleModifyEdit_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        Object roleIdObj = evt.getFormShowParameter().getCustomParams().get(ROLE_ID);
        if (Objects.isNull(roleIdObj)) {
            evt.setCancel(true);
            evt.setCancelMessage(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728", (String)"RoleFuntionAssignEdit_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Toolbar buToolBar = (Toolbar)this.getControl("toolbarap");
        buToolBar.addItemClickListener((ItemClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("rolegroup");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminGrpEdit = (BasedataEdit)this.getView().getControl("createadmingrp");
        adminGrpEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button checkRelate = (Button)this.getView().getControl("checkrelate");
        checkRelate.addClickListener((ClickListener)this);
        BasedataEdit openAdminGrp = (BasedataEdit)this.getView().getControl("admingroup");
        openAdminGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit assignAdminGrp = (BasedataEdit)this.getView().getControl("admingroup1");
        assignAdminGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (HRCS_MODIFYROLEINFO.equals(actionId)) {
            String roleId = RoleServiceHelper.getRoleId((IFormView)this.getView());
            this.updateRoleBaseInfo(roleId, true);
            RoleServiceHelper.showMember((IFormView)this.getView());
        }
    }

    public void initialize() {
        super.initialize();
        this.allFuncPermTreeView = (TreeView)this.getControl("tree_allfunctionperm");
        this.funcPermTreeView = (TreeView)this.getControl("tree_funcperm");
        this.allFuncPermTreeUtil = new AllFuncPermTreeUtil(this.allFuncPermTreeView, null, null);
        TreeView fieldPermTreeView = (TreeView)this.getControl(TREE_FIELD);
        this.userFuncPermTreeUtil = new UserFuncPermTreeUtil(this.allFuncPermTreeView, new TreeView[]{this.funcPermTreeView, fieldPermTreeView}, null, null, null, -1L);
        this.permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
        this.addListener();
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("modify".equals(itemKey)) {
            DynamicObject[] dynamicObjects;
            if (!SaveRoleServiceHelper.checkUpdatePermission((IFormView)this.getView())) {
                evt.setCancel(true);
                return;
            }
            if (this.checkRoleForBidden()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u89d2\u8272\u3002", (String)"RoleFuntionAssignEdit_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (!this.checkCanModify()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u89d2\u8272\u7684\u4fee\u6539\u6743\u9650\u3002", (String)"RoleFuntionAssignEdit_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject roleName = RoleMemberAssignServiceHelper.getRoleName((String)RoleServiceHelper.getRoleId((IFormView)this.getView()));
            ILocaleString nameLocal = roleName.getLocaleString("name");
            String name = nameLocal.getLocaleValue();
            boolean roleNewAssignDataLock = RoleMemberAssignServiceHelper.isMutexDataLock((String)name, (String)"hrcs_role", (String)"assign");
            boolean lockFlag = false;
            for (DynamicObject dynamicObject : dynamicObjects = SaveRoleServiceHelper.queryUserRoleRelate((String)RoleServiceHelper.getRoleId((IFormView)this.getView()))) {
                boolean roleAssignDataLock = RoleMemberAssignServiceHelper.isMutexDataLock((String)dynamicObject.get("id").toString(), (String)"hrcs_role", (String)"assign");
                if (!roleAssignDataLock) continue;
                lockFlag = true;
            }
            if (roleNewAssignDataLock || lockFlag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u6b63\u5728\u4fee\u6539\u4e2d\u6216\u8005\u6b63\u5728\u5206\u914d\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u89d2\u8272\u3002", (String)"RoleFuntionAssignEdit_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (!RoleServiceHelper.handleLock((String)RoleServiceHelper.getRoleId((IFormView)this.getView()), (String)ENTITY_PERM_ROLE, (IFormView)this.getView(), (String)"modify", (String)ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u6b63\u5728\u4fee\u6539\u4e2d\u6216\u8005\u6b63\u5728\u5206\u914d\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u89d2\u8272\u3002", (String)"RoleFuntionAssignEdit_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]))) {
                evt.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)itemKey, (String)"btnsave")) {
            String validateStatus;
            boolean isCopy = HRStringUtils.equals((String)"1", (String)this.getView().getPageCache().get("copy"));
            if (isCopy) {
                if (!SaveRoleServiceHelper.checkCopyPermission((IFormView)this.getView())) {
                    evt.setCancel(true);
                    return;
                }
            } else if (!SaveRoleServiceHelper.checkUpdatePermission((IFormView)this.getView())) {
                evt.setCancel(true);
                return;
            }
            if (!this.checkCanModify()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u89d2\u8272\u7684\u4fee\u6539\u6743\u9650\u3002", (String)"RoleFuntionAssignEdit_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean numberValidate = true;
            boolean nameValidate = true;
            Pair<Boolean, FieldTip> pair = this.getNumberCheckResult();
            if (!((Boolean)pair.getKey()).booleanValue()) {
                numberValidate = false;
                this.getView().showFieldTip((FieldTip)pair.getRight());
            }
            if (!((Boolean)(pair = this.getNameCheckResult()).getKey()).booleanValue()) {
                nameValidate = false;
                this.getView().showFieldTip((FieldTip)pair.getRight());
            }
            if (HRStringUtils.equals((String)"true", (String)this.getPageCache().get("needValidateUseScope")) && NewRoleWizardHelper.validateCreateAdminGrp((IFormView)this.getView())) {
                evt.setCancel(true);
            }
            if (!(HRStringUtils.equals((String)(validateStatus = this.getPageCache().get(VALIDATE_STATUS)), (String)"1") && numberValidate && nameValidate)) {
                evt.setCancel(true);
            }
            if (HRStringUtils.equals((String)itemKey, (String)"btnsave") && !this.validateBeforeSave()) {
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (HRStringUtils.equals((String)this.getPageCache().get("originCreateAdminGrp"), (String)"1")) {
            return;
        }
        int openRows = (int)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().filter(it -> it.getDynamicObject("admingroup") != null).count();
        int assignRows = (int)this.getModel().getDataEntity(true).getDynamicObjectCollection("assignentryentity").stream().filter(it -> it.getDynamicObject("admingroup1") != null).count();
        if (HRStringUtils.equals((String)"deleteentry", (String)operateKey) || HRStringUtils.equals((String)"newentry", (String)operateKey)) {
            this.getView().setEnable(Boolean.valueOf(openRows <= 0), new String[]{"createadmingrp"});
        } else if (HRStringUtils.equals((String)"deleteassignentry", (String)operateKey) || HRStringUtils.equals((String)"newassignentry", (String)operateKey)) {
            this.getView().setEnable(Boolean.valueOf(assignRows <= 0), new String[]{"createadmingrp"});
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        if (HRStringUtils.equals((String)"btnsave", (String)itemKey)) {
            this.doSaveRole();
            String roleId = RoleServiceHelper.getRoleId((IFormView)this.getView());
            this.updateRoleBaseInfo(roleId, false);
            String tabKey = this.permPageCacheUtil.get("tabKey");
            if (HRStringUtils.isNotEmpty((String)tabKey)) {
                Tab tabAp = (Tab)this.getView().getControl("tabap");
                tabAp.activeTab(tabKey);
            }
        } else if (HRStringUtils.equals((String)"modify", (String)itemKey) && RoleServiceHelper.handleRoleModifyLock((String)RoleServiceHelper.getRoleId((IFormView)this.getView()), (String)ENTITY_PERM_ROLE, (IFormView)this.getView())) {
            this.setViewStatus(Boolean.FALSE);
            this.getModel().setValue("viewstatus", (Object)"1");
        } else if (HRStringUtils.equals((String)"btnsave1", (String)itemKey)) {
            this.setViewStatus(Boolean.TRUE);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        String operateKey = source.getKey();
        if (HRStringUtils.equals((String)operateKey, (String)"checkrelate")) {
            this.userFuncPermTreeUtil.checkRelatePerms();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void doSaveRole() {
        boolean success = SaveRoleServiceHelper.modifyRole((IFormView)this.getView(), (IFormPlugin)this);
        if (success) {
            this.notifyUser();
            SaveRoleServiceHelper.updatePermCache((IFormView)this.getView());
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"modify"});
            Map dataPermModelMap = RoleDataPermHelper.loadDimData((IFormView)this.getView(), (PermPageCacheUtil)this.permPageCacheUtil);
            if (CollectionUtils.isEmpty((Map)dataPermModelMap)) {
                Map dataPermMap = this.permPageCacheUtil.getDataPermMap();
                for (RoleDataPermModel oldModel : dataPermMap.values()) {
                    if (null == oldModel) continue;
                    oldModel.setDimGroupMap(new HashMap());
                }
                this.permPageCacheUtil.setDataPerm(dataPermMap);
            }
            this.setViewStatus(Boolean.TRUE);
            this.getModel().setValue("viewstatus", (Object)"0");
            this.getPageCache().put("copy", "0");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabpageap4"});
            this.getView().setFormTitle(new LocaleString(((OrmLocaleValue)this.getModel().getValue("rolename")).getLocaleValue()));
        }
    }

    private void setViewStatus(Boolean isViewStatus) {
        this.getView().setStatus(isViewStatus != false ? OperationStatus.VIEW : OperationStatus.EDIT);
        this.getModel().setValue("fieldshowsetup", (Object)isViewStatus);
        this.getModel().setValue("fieldshowrelated", (Object)isViewStatus);
        this.getView().setVisible(Boolean.valueOf(isViewStatus == false), new String[]{"btnsave", "btnpanel", "fieldpermbar"});
        long currUserId = RequestContext.get().getCurrUserId();
        Map adminGroupInfos = HRRolePermHelper.queryUserAdminGroupInfos((long)currUserId);
        Set<Long> groupIds = adminGroupInfos.keySet();
        HashSet longNumbers = Sets.newHashSet(adminGroupInfos.values());
        String longNumber = this.getModel().getDataEntity().getString("createadmingrp.longnumber");
        boolean topAdminGroupModify = HRRolePermHelper.isTopAdminGroupModify((String)longNumber, (Set)longNumbers);
        DynamicObject createAdminGroup = this.getModel().getDataEntity().getDynamicObject("createadmingrp");
        boolean noCreateAdminGroup = null == createAdminGroup;
        long createAdminGroupId = noCreateAdminGroup ? 0L : createAdminGroup.getLong("id");
        boolean masterGroup = groupIds.contains(createAdminGroupId);
        boolean isSystem = HRStringUtils.equals((String)this.getPageCache().get("issystem"), (String)"1");
        this.getPageCache().put("needValidateUseScope", String.valueOf(topAdminGroupModify || noCreateAdminGroup || masterGroup));
        boolean hasModifyPerm = noCreateAdminGroup || masterGroup || this.checkHasModifyPerm(groupIds) || topAdminGroupModify;
        this.getView().setVisible(Boolean.valueOf(isViewStatus != false && !isSystem && hasModifyPerm), new String[]{"modify"});
        this.getPageCache().put("hasModifyPerm", hasModifyPerm ? "1" : "0");
        if (isViewStatus.booleanValue()) {
            RoleServiceHelper.removeEditStatus((IPageCache)this.getPageCache());
        }
        String viewStatus = isViewStatus != false ? "1" : "0";
        this.getPageCache().put("viewStatus", viewStatus);
        this.getView().setEnable(Boolean.valueOf(isViewStatus == false && noCreateAdminGroup), new String[]{"createadmingrp"});
        this.getView().setEnable(Boolean.valueOf(isViewStatus == false && (noCreateAdminGroup || masterGroup || topAdminGroupModify)), new String[]{"usescope"});
        this.getView().setVisible(Boolean.valueOf(noCreateAdminGroup || masterGroup || topAdminGroupModify), new String[]{"tabpageap5"});
        NewRoleWizardHelper.showDimEntryCard((IFormView)this.getView(), (boolean)false, (PermPageCacheUtil)this.permPageCacheUtil);
        RoleServiceHelper.reloadDataPermContainer((IFormView)this.getView());
        this.getView().setEnable(Boolean.valueOf(isViewStatus == false), new String[]{"list_fieldperm"});
        RoleServiceHelper.showMember((IFormView)this.getView());
    }

    private boolean checkCanModify() {
        long currUserId = RequestContext.get().getCurrUserId();
        Map adminGroupInfos = HRRolePermHelper.queryUserAdminGroupInfos((long)currUserId);
        Set<Long> groupIds = adminGroupInfos.keySet();
        HashSet longNumbers = Sets.newHashSet(adminGroupInfos.values());
        String longNumber = this.getModel().getDataEntity().getString("createadmingrp.longnumber");
        boolean topAdminGroupModify = HRRolePermHelper.isTopAdminGroupModify((String)longNumber, (Set)longNumbers);
        DynamicObject createAdminGroup = this.getModel().getDataEntity().getDynamicObject("createadmingrp");
        boolean noCreateAdminGroup = null == createAdminGroup;
        long createAdminGroupId = noCreateAdminGroup ? 0L : createAdminGroup.getLong("id");
        boolean masterGroup = groupIds.contains(createAdminGroupId);
        return noCreateAdminGroup || masterGroup || topAdminGroupModify || this.checkHasModifyPerm(groupIds);
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean checkHasModifyPerm(Set<Long> groupIds) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject createAdminGrp = dataEntity.getDynamicObject("createadmingrp");
        if (null == createAdminGrp) {
            return true;
        }
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        HRBaseServiceHelper openServiceHelper = new HRBaseServiceHelper("hrcs_roleopenscope");
        boolean openExists = openServiceHelper.isExists(new QFilter[]{new QFilter("roleid.id", "=", (Object)roleId).and("admingroup", "in", groupIds)});
        if (openExists) {
            return true;
        }
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("hrcs_role");
        boolean privateExists = roleHelper.isExists(new QFilter[]{new QFilter("id", "=", (Object)roleId).and("usescope", "=", (Object)"0").and("createadmingrp", "in", groupIds)});
        if (privateExists) {
            return true;
        }
        HRBaseServiceHelper assignHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
        boolean assignExists = assignHelper.isExists(new QFilter[]{new QFilter("roleid.id", "=", (Object)roleId).and("admingroup", "in", groupIds).and("ismodifiable", "=", (Object)"1")});
        return assignExists;
    }

    @ExcludeFromJacocoGeneratedReport
    private void notifyUser() {
        Set dimIds;
        boolean isCopy = HRStringUtils.equals((String)"1", (String)this.getView().getPageCache().get("copy"));
        if (isCopy) {
            return;
        }
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        Set originalDimIds = this.permPageCacheUtil.getOriginalHrBuCaDim().values().stream().flatMap(it -> it.keySet().stream()).collect(Collectors.toSet());
        if (!Sets.symmetricDifference(originalDimIds, dimIds = this.permPageCacheUtil.getAssignedHrBuCaDim().values().stream().flatMap(it -> it.keySet().stream()).collect(Collectors.toSet())).isEmpty()) {
            LOGGER.info("Dim id is different.");
            PermNotifyService.notifyAll((String)roleId);
            return;
        }
        LOGGER.info("Dim id is same.");
        Map roleInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("roleInfo"), Map.class);
        String originalRoleIntersection = (String)roleInfo.get("originalRoleIntersection");
        String roleIntersection = (String)this.getModel().getValue("rolecbisintersection");
        if (!originalRoleIntersection.equals(roleIntersection)) {
            PermNotifyService.notifyByDataProperty((String)roleId, (String)"1");
            return;
        }
        LOGGER.info("Dim data property is same.");
        int changeResult = DimChangeCheckService.checkDimDiff((IFormView)this.getView());
        LOGGER.info("Dim data originalRoleIntersection:[{}], changeResult:[{}]", (Object)originalRoleIntersection, (Object)changeResult);
        if ("1".equals(roleIntersection)) {
            if (changeResult != 0) {
                PermNotifyService.notifyAll((String)roleId);
            }
        } else if (changeResult != 0) {
            PermNotifyService.notifyByDataProperty((String)roleId, (String)"0");
        }
    }

    private void addListener() {
        this.allFuncPermTreeUtil.initListener();
        this.userFuncPermTreeUtil.initListener();
        Button btnAddNode = (Button)this.getControl("btn_addnode");
        btnAddNode.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                RoleFuntionAssignEdit.this.userFuncPermTreeUtil.addFuncPermNode(null);
                RoleFuntionAssignEdit.this.cacheAssignedData();
                RoleFuntionAssignEdit.this.updateFuncPermData();
                RoleFuntionAssignEdit.this.showCloudEntryCard();
                NewRoleWizardHelper.showDimEntryCard((IFormView)RoleFuntionAssignEdit.this.getView(), (boolean)true, (PermPageCacheUtil)RoleFuntionAssignEdit.this.permPageCacheUtil);
                RoleServiceHelper.reloadDataPermContainer((IFormView)RoleFuntionAssignEdit.this.getView());
                RoleServiceHelper.setEditStatus((IPageCache)RoleFuntionAssignEdit.this.getPageCache());
            }
        });
        Button btnDelNode = (Button)this.getControl("btn_delnode");
        btnDelNode.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                List ids = RoleFuntionAssignEdit.this.funcPermTreeView.getTreeState().getCheckedNodes();
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    return;
                }
                RoleFuntionAssignEdit.this.clearSelectedFieldCache(ids);
                RoleFuntionAssignEdit.this.userFuncPermTreeUtil.removeFuncPermNode(RoleFuntionAssignEdit.this.permPageCacheUtil, ids);
                RoleFuntionAssignEdit.this.cacheAssignedData();
                RoleFuntionAssignEdit.this.updateFuncPermData();
                RoleFuntionAssignEdit.this.showCloudEntryCard();
                NewRoleWizardHelper.showDimEntryCard((IFormView)RoleFuntionAssignEdit.this.getView(), (boolean)true, (PermPageCacheUtil)RoleFuntionAssignEdit.this.permPageCacheUtil);
                RoleServiceHelper.reloadDataPermContainer((IFormView)RoleFuntionAssignEdit.this.getView());
                RoleServiceHelper.setEditStatus((IPageCache)RoleFuntionAssignEdit.this.getPageCache());
            }
        });
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (HRStringUtils.isEmpty((String)searchText)) {
                this.refreshAllFuncTreeView();
                this.permPageCacheUtil.remove("isSearchMode");
                this.getView().updateView("tree_allfunctionperm");
                return;
            }
            this.permPageCacheUtil.put("isSearchMode", "true");
            List<String> cloudIds = Arrays.asList(HRCloudServiceHelper.getAllHRCloudId().toArray(new String[0]));
            this.allFuncPermTreeUtil.searchAllFuncPermTreeByText(searchText, "", cloudIds);
        });
        this.userFuncPermTreeUtil.initTreeViewCtrl(this.getView(), this.permPageCacheUtil, this.funcPermTreeView);
    }

    private void clearSelectedFieldCache(List<Map<String, Object>> removeIds) {
        if (CollectionUtils.isEmpty(removeIds)) {
            return;
        }
        String jsonStr = this.getPageCache().get("fieldPermCache");
        if (StringUtils.isEmpty((String)jsonStr)) {
            return;
        }
        Map fieldPermInfoMap = FieldPermInfoJsonUtil.fromJsonStr((String)jsonStr);
        boolean isClearAll = false;
        HashSet toRemoveApps = Sets.newHashSetWithExpectedSize((int)16);
        HashSet toRemoveEntitys = Sets.newHashSetWithExpectedSize((int)16);
        for (Map<String, Object> map : removeIds) {
            String nodeId = (String)map.get("id");
            String[] nodeIdArr = nodeId.split("#");
            String nodeType = nodeIdArr[nodeIdArr.length - 1];
            if (HRStringUtils.equals((String)nodeType, (String)"FIRST")) {
                isClearAll = true;
                break;
            }
            if (HRStringUtils.equals((String)nodeType, (String)"cloud")) {
                Map<String, Map<String, String>> nodeMap = this.userFuncPermTreeUtil.getNodeMap();
                Map<String, String> subAppMap = nodeMap.get(nodeId);
                for (String appKey : subAppMap.keySet()) {
                    toRemoveApps.add(appKey.split("#")[0]);
                }
                continue;
            }
            if (HRStringUtils.equals((String)nodeType, (String)"app")) {
                toRemoveApps.add(nodeIdArr[0]);
                continue;
            }
            if (!HRStringUtils.equals((String)nodeType, (String)"entity")) continue;
            String entityNumber = nodeId.substring(nodeId.indexOf(124) + 1, nodeId.indexOf(64));
            toRemoveEntitys.add(entityNumber);
        }
        HashSet toRemoveFieldPermKeys = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry entry : fieldPermInfoMap.entrySet()) {
            String fieldPermKey = (String)entry.getKey();
            String[] fieldPermKeys = fieldPermKey.split("@");
            if (!isClearAll && !toRemoveApps.contains(fieldPermKeys[0]) && !toRemoveEntitys.contains(fieldPermKeys[1])) continue;
            toRemoveFieldPermKeys.add(fieldPermKey);
        }
        for (String removeKey : toRemoveFieldPermKeys) {
            ((UserRoleFieldPermInfo)fieldPermInfoMap.get(removeKey)).setEmptyFlag(true);
            ((UserRoleFieldPermInfo)fieldPermInfoMap.get(removeKey)).setFieldPermModelList((List)Lists.newLinkedList());
        }
        this.getPageCache().put("fieldPermCache", SerializationUtils.toJsonString((Object)fieldPermInfoMap));
    }

    private void showCloudEntryCard() {
        HashMap<String, Map<String, String>> nodeMap = new HashMap<String, Map<String, String>>(this.userFuncPermTreeUtil.getNodeMap());
        HashMap<String, Map<String, String>> parentMap = new HashMap<String, Map<String, String>>(this.userFuncPermTreeUtil.getParentMap());
        NewRoleWizardHelper.addRelatedNodeMap(nodeMap, parentMap, (List)this.permPageCacheUtil.getFuncPermDataList());
        Map assignedCloudBuCaFunc = HRRoleFunctionPermHelper.reloadAssignedBuCaFunc(nodeMap, parentMap, (PermPageCacheUtil)this.permPageCacheUtil);
        LOGGER.info("Reload assigned with nodeMap:\u3010{}\u3011 and assignedCloudBuCaFunc: \u3010{}\u3011.", nodeMap, (Object)assignedCloudBuCaFunc);
        RoleServiceHelper.fillCloudEntryCard((IFormView)this.getView(), (Map)assignedCloudBuCaFunc, (PermPageCacheUtil)this.permPageCacheUtil, parentMap);
        this.permPageCacheUtil.updateAssignedBuCaFunc(assignedCloudBuCaFunc);
    }

    public void afterCreateNewData(EventObject evt) {
        String notShowModifyButton;
        Set userAdminGroups;
        boolean isCopy = HRStringUtils.equals((String)"1", (String)((String)this.getView().getFormShowParameter().getCustomParam("copy")));
        this.getPageCache().put("copy", (String)this.getView().getFormShowParameter().getCustomParam("copy"));
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        long userAdminGroupId = (userAdminGroups = HRRolePermHelper.queryUserAdminGroups((long)RequestContext.get().getCurrUserId())).isEmpty() ? 0L : (Long)userAdminGroups.iterator().next();
        this.getPageCache().put(VALIDATE_STATUS, "1");
        RoleServiceHelper.initRoleTypeMulCombo((IFormView)this.getView());
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        this.updateRoleBaseInfo(roleId, true);
        this.refreshAllFuncTreeView();
        this.loadPermInfo();
        this.cacheAssignedData();
        HrbuCaControlHelper.getBusinessFunction((String)roleId, (IFormView)this.getView(), (boolean)true);
        this.updateFuncPermDataForRoleInit();
        this.permPageCacheUtil.setOriginalFuncPermDataList(this.userFuncPermTreeUtil.getRolePerms());
        this.showCloudEntryCard();
        DimensionHelper.loadRoleDimData((IFormView)this.getView(), (String)roleId, (PermPageCacheUtil)this.permPageCacheUtil);
        RoleDataPermHelper.loadPermData((IFormView)this.getView(), (PermPageCacheUtil)this.permPageCacheUtil);
        if (isCopy) {
            this.setViewStatus(Boolean.FALSE);
            this.userFuncPermTreeUtil.fieldTreeShowSetUp(this.getView());
        } else {
            this.setViewStatus(Boolean.TRUE);
        }
        this.paintUseScopeTab(userAdminGroupId);
        RoleServiceHelper.setAssignedAppEntity(this.getAppIds(), this.userFuncPermTreeUtil.getNodeMap(), (PermPageCacheUtil)this.permPageCacheUtil);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        DynamicObject role = helper.queryOne("issystem", (Object)roleId);
        boolean isSystem = role.getBoolean("issystem");
        if (!isCopy && isSystem) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify", "btnsave"});
            this.getPageCache().put("issystem", "1");
        }
        if (isCopy) {
            String copyNameSuffix = ResManager.loadKDString((String)"\u590d\u5236", (String)"RoleFuntionAssignEdit_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("viewstatus", (Object)"1");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"modify"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnsave"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"createadmingrp"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"rolenumber"});
            this.getModel().setValue("rolename", (Object)(this.getModel().getValue("rolename") + copyNameSuffix));
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"usescope"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabpageap5"});
            Pair<Boolean, String> numberPair = this.generateNumber();
            if (HRStringUtils.isNotEmpty((String)((String)numberPair.getValue()))) {
                this.getModel().setValue("rolenumber", numberPair.getValue());
                this.getView().setEnable((Boolean)numberPair.getKey(), new String[]{"rolenumber"});
            } else {
                this.getModel().setValue("rolenumber", (Object)"");
                this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            }
            if (0L != userAdminGroupId) {
                this.getModel().setValue("createadmingrp", (Object)userAdminGroupId);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap4"});
        }
        if (HRStringUtils.isNotEmpty((String)(notShowModifyButton = (String)this.getView().getFormShowParameter().getCustomParam("notShowModifyButton")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Pair<Boolean, String> generateNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        DynamicObject permRoleDy = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ENTITY_PERM_ROLE, (DynamicObject)permRoleDy, null);
        return Pair.of((Object)Optional.ofNullable(codeRule).map(CodeRuleInfo::getIsModifiable).orElse(Boolean.FALSE), (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)permRoleDy));
    }

    @ExcludeFromJacocoGeneratedReport
    private void setUseScopeTab() {
        String tabKey = this.getPageCache().get("tabKey");
        if (HRStringUtils.isNotEmpty((String)tabKey)) {
            Tab tab = (Tab)this.getControl("tabap");
            if (HRStringUtils.equals((String)"tabpageap6", (String)tabKey)) {
                tab.activeTab("tabpageap5");
            } else if (HRStringUtils.equals((String)"tabpageap5", (String)tabKey)) {
                tab.activeTab("tabpageap6");
            } else {
                tab.activeTab(tabKey);
            }
        }
    }

    private List<Map<String, String>> updateFuncPermData() {
        Map allRelatedPerms = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get("allRelatedPerms"), Map.class);
        LOGGER.info("Prepare update func perm data. Got selected node map: {}, allRelatedPerms: {}.", this.userFuncPermTreeUtil.getNodeMap(), (Object)allRelatedPerms);
        List<Map<String, String>> curPermData = this.userFuncPermTreeUtil.getCurPermDataAll();
        LOGGER.info("Update func perm data: {}.", curPermData);
        this.permPageCacheUtil.updateFuncPermDataList(curPermData);
        return curPermData;
    }

    private List<Map<String, String>> updateFuncPermDataForRoleInit() {
        Map allRelatedPerms = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get("allRelatedPerms"), Map.class);
        LOGGER.info("Prepare update func perm data. Got selected node map: {}, allRelatedPerms: {}.", this.userFuncPermTreeUtil.getNodeMap(), (Object)allRelatedPerms);
        List curPermData = this.permPageCacheUtil.getRoleFuncPermDataList();
        LOGGER.info("Update func perm data: {}.", (Object)curPermData);
        this.permPageCacheUtil.updateFuncPermDataList(curPermData);
        return curPermData;
    }

    private void updateRoleBaseInfo(String roleId, boolean reloadNumberAndName) {
        HRBaseServiceHelper hrRoleHelper = new HRBaseServiceHelper("hrcs_role");
        HRBaseServiceHelper bosRoleHelper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        DynamicObject hrRoleObj = hrRoleHelper.queryOne((Object)roleId);
        DynamicObject bosRole = bosRoleHelper.queryOne((Object)roleId);
        if (reloadNumberAndName) {
            this.getModel().setValue("rolenumber", (Object)bosRole.getString("number"));
            this.getModel().setValue("rolename", bosRole.get("name"));
        }
        this.getModel().setValue("roletype", (Object)bosRole.getString("roletype"));
        DynamicObject group = bosRole.getDynamicObject("group");
        if (group != null) {
            this.getModel().setValue("rolegroup", group.get("id"));
        }
        this.getModel().setValue("roleproperty", (Object)hrRoleObj.getString("property"));
        this.getModel().setValue("rolecbisintersection", (Object)hrRoleObj.getString("isintersection"));
        this.getModel().setValue("roleremark", bosRole.get("remark"));
        this.getModel().setValue("rolemodifier", (Object)bosRole.getDynamicObject("modifier"));
        this.getModel().setValue("rolemodifytime", (Object)bosRole.getDate("modifytime"));
        this.getModel().setValue("usescope", (Object)hrRoleObj.getString("usescope"));
        long createAdminGrpId = hrRoleObj.getLong("createadmingrp.id");
        this.getModel().setValue("createadmingrp", (Object)createAdminGrpId);
        this.getPageCache().put("originCreateAdminGrp", createAdminGrpId > 0L ? "1" : "0");
        if (HRStringUtils.equals((String)hrRoleObj.getString("property"), (String)"0")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rolecbisintersection"});
        }
        HashMap<String, String> roleInfo = new HashMap<String, String>(16);
        Optional.ofNullable(bosRole.getDynamicObject("modifier")).ifPresent(modifyItem -> {
            roleInfo.put("originalRoleModifier", String.valueOf(modifyItem.getLong("id")));
            roleInfo.put("originalRoleModifyTime", String.valueOf(bosRole.getDate("modifytime").toInstant().toEpochMilli()));
        });
        roleInfo.put("originalRoleNumber", bosRole.getString("number"));
        roleInfo.put("originalRoleName", bosRole.getString("name"));
        roleInfo.put("createadmingrp", String.valueOf(createAdminGrpId));
        roleInfo.put("originalRoleType", bosRole.getString("roletype"));
        roleInfo.put("originalRoleProperty", hrRoleObj.getString("property"));
        roleInfo.put("originalRoleUseScope", hrRoleObj.getString("usescope"));
        roleInfo.put("originalRoleGroup", null == group ? null : group.getString("id"));
        roleInfo.put("originalRoleRemark", bosRole.getString("remark"));
        roleInfo.put("originalRoleIntersection", String.valueOf(hrRoleObj.getString("isintersection")));
        this.getPageCache().put("roleInfo", SerializationUtils.toJsonString(roleInfo));
    }

    private void cacheAssignedData() {
        Set<String> appIds = this.getAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return;
        }
        this.permPageCacheUtil.setAssignedAppSet(appIds);
        RoleServiceHelper.setAssignedAppEntity(appIds, this.userFuncPermTreeUtil.getNodeMap(), (PermPageCacheUtil)this.permPageCacheUtil);
    }

    private void loadPermInfo() {
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        this.userFuncPermTreeUtil.loadRolePermFromDB(roleId);
    }

    private void refreshAllFuncTreeView() {
        this.allFuncPermTreeView.deleteAllNodes();
        this.allFuncPermTreeUtil.initTree(true);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "fieldshowsetup": {
                this.userFuncPermTreeUtil.fieldTreeShowSetUp(this.getView());
                break;
            }
            case "fieldshowrelated": {
                this.userFuncPermTreeUtil.fieldTreeShowSetUp(this.getView());
                break;
            }
            case "roleproperty": {
                this.rolePropertyChanged(evt);
                break;
            }
            case "rolenumber": {
                this.handleNumberChanged(evt);
                break;
            }
            case "rolename": {
                this.nameChanged(evt);
                break;
            }
            case "usescope": {
                this.useScopeChanged();
                break;
            }
            case "admingroup": {
                this.adminGroupChanged(evt);
                break;
            }
            case "admingroup1": {
                this.adminGroupChanged(evt);
                break;
            }
            case "createadmingrp": {
                this.createAdminGroupChanged(evt);
                break;
            }
        }
    }

    private void createAdminGroupChanged(PropertyChangedArgs evt) {
        this.setUseScopeTab();
    }

    private void useScopeChanged() {
        String useScope = (String)this.getModel().getValue("usescope");
        String tabKey = this.getPageCache().get("tabKey");
        if (HRStringUtils.equals((String)"0", (String)useScope) && (HRStringUtils.equals((String)"tabpageap5", (String)tabKey) || HRStringUtils.equals((String)"tabpageap6", (String)tabKey))) {
            Tab tabAp = (Tab)this.getView().getControl("tabap");
            tabAp.activeTab("tabpageap");
        }
        String hasModifyPerm = this.getPageCache().get("hasModifyPerm");
        String originCreateAdminGrp = this.getPageCache().get("originCreateAdminGrp");
        if (HRStringUtils.equals((String)hasModifyPerm, (String)"1") && HRStringUtils.equals((String)originCreateAdminGrp, (String)"0")) {
            if (HRStringUtils.equals((String)hasModifyPerm, (String)"0")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"createadmingrp"});
            } else if (HRStringUtils.equals((String)hasModifyPerm, (String)"1")) {
                int assignRows = (int)this.getModel().getDataEntity(true).getDynamicObjectCollection("assignentryentity").stream().filter(it -> it.getDynamicObject("admingroup1") != null).count();
                this.getView().setEnable(Boolean.valueOf(assignRows <= 0), new String[]{"createadmingrp"});
            } else {
                int openRows = (int)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().filter(it -> it.getDynamicObject("admingroup") != null).count();
                this.getView().setEnable(Boolean.valueOf(openRows <= 0), new String[]{"createadmingrp"});
            }
        }
    }

    private void adminGroupChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        ChangeData changeData = evt.getChangeSet()[0];
        DynamicObject adminGroup = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (null == adminGroup) {
            if (HRStringUtils.equals((String)name, (String)"admingroup")) {
                this.getModel().setValue("users", (Object)"", rowIndex);
            } else {
                this.getModel().setValue("users1", (Object)"", rowIndex);
                this.getModel().setValue("ismodifiable", (Object)"0", rowIndex);
            }
            return;
        }
        long adminGroupId = adminGroup.getLong("id");
        boolean noCreateAdminGrp = HRStringUtils.equals((String)this.getPageCache().get("originCreateAdminGrp"), (String)"0");
        int openRows = (int)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().filter(it -> it.getDynamicObject("admingroup") != null).count();
        int assignRows = (int)this.getModel().getDataEntity(true).getDynamicObjectCollection("assignentryentity").stream().filter(it -> it.getDynamicObject("admingroup1") != null).count();
        if (HRStringUtils.equals((String)name, (String)"admingroup")) {
            this.getModel().setValue("users", (Object)HRRolePermHelper.queryAdminGrpUsers((long)adminGroupId), rowIndex);
            this.getView().setEnable(Boolean.valueOf(openRows <= 0 && noCreateAdminGrp), new String[]{"createadmingrp"});
        } else {
            this.getModel().setValue("users1", (Object)HRRolePermHelper.queryAdminGrpUsers((long)adminGroupId), rowIndex);
            this.getView().setEnable(Boolean.valueOf(assignRows <= 0 && noCreateAdminGrp), new String[]{"createadmingrp"});
        }
    }

    private Set<String> getAppIds() {
        List<Map<String, String>> dataLists = this.userFuncPermTreeUtil.getCurPermDataAll();
        return dataLists.stream().map(data -> (String)data.get("appId")).collect(Collectors.toSet());
    }

    @ExcludeFromJacocoGeneratedReport
    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        MutexHelper.release((IFormView)this.getView());
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeClosed(BeforeClosedEvent evt) {
        String editStatus = this.getPageCache().get("editStatus");
        if (!HRStringUtils.isEmpty((String)editStatus)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"RoleFuntionAssignEdit_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            evt.setCancel(true);
        }
        SessionManager.getCurrent().remove(this.getView().getPageId());
    }

    @ExcludeFromJacocoGeneratedReport
    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        int result = event.getResult().getValue();
        IFormView view = this.getView();
        switch (callBackId) {
            case "continue_close": {
                if (MessageBoxResult.Yes.getValue() != result) break;
                SessionManager.getCurrent().remove(this.getView().getPageId());
                PermFormCommonUtil.closeClientForm((IFormView)view);
                break;
            }
            case "doNotSave": {
                if (MessageBoxResult.Yes.getValue() != result) break;
                this.permPageCacheUtil.setDoNotSaveDimGrp();
                SaveRoleServiceHelper.clearDataPermMap((PermPageCacheUtil)this.permPageCacheUtil);
                this.doSaveRole();
                String tabKey = this.permPageCacheUtil.get("tabKey");
                if (!HRStringUtils.isNotEmpty((String)tabKey)) break;
                Tab tabAp = (Tab)this.getView().getControl("tabap");
                tabAp.activeTab(tabKey);
                break;
            }
            case "callBackPropertyChange": {
                this.handlePropertyChange(result);
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateBeforeSave() {
        Object value = this.getModel().getValue("roletype");
        if (value == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u79cd\u201c\u89d2\u8272\u7c7b\u578b\u201d\u3002", (String)"RoleFuntionAssignEdit_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        String[] types = value.toString().split(",");
        int size = (int)Arrays.stream(types).filter(HRStringUtils::isNotEmpty).count();
        if (size > 5) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u89d2\u8272\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"RoleFuntionAssignEdit_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Map originalHrBuCaDim;
        Map assignedHrBuCaDim;
        MapDifference assignDiff;
        String tabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put("tabKey", tabKey);
        if (HRStringUtils.equals((String)"tabpageap2", (String)tabKey) && !(assignDiff = Maps.difference((Map)(assignedHrBuCaDim = this.permPageCacheUtil.getAssignedHrBuCaDim()), (Map)(originalHrBuCaDim = this.permPageCacheUtil.getOriginalHrBuCaDim()))).areEqual()) {
            RoleServiceHelper.reloadDataPermContainer((IFormView)this.getView());
            this.permPageCacheUtil.setOriginalHrBuCaDim(this.permPageCacheUtil.getAssignedHrBuCaDim());
        }
    }

    private void paintUseScopeTab(long defaultCreateAdminGroupId) {
        String useScopeLoaded;
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        if (HRStringUtils.isNotEmpty((String)(useScopeLoaded = this.permPageCacheUtil.get("useScopeLoaded")))) {
            return;
        }
        String useScope = (String)this.getModel().getValue("usescope");
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        if (HRStringUtils.equals((String)"1", (String)useScope)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
            DynamicObject[] dynamicObjects = serviceHelper.query("admingroup,ismodifiable", new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
            this.getModel().beginInit();
            int rowIndex = -1;
            for (int index = 0; index < dynamicObjects.length; ++index) {
                long adminGroupId = dynamicObjects[index].getLong("admingroup.id");
                if (defaultCreateAdminGroupId == 0L || defaultCreateAdminGroupId == adminGroupId) continue;
                this.getModel().createNewEntryRow("assignentryentity");
                this.getModel().setValue("admingroup1", (Object)adminGroupId, ++rowIndex);
                this.getModel().setValue("users1", (Object)HRRolePermHelper.queryAdminGrpUsers((long)adminGroupId), rowIndex);
                this.getModel().setValue("ismodifiable", (Object)dynamicObjects[index].getString("ismodifiable"), rowIndex);
            }
            this.getView().updateView("assignentryentity");
            this.getModel().endInit();
        } else if (HRStringUtils.equals((String)"2", (String)useScope)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleopenscope");
            DynamicObject[] dynamicObjects = serviceHelper.query("admingroup", new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
            this.getModel().beginInit();
            int rowIndex = -1;
            for (int index = 0; index < dynamicObjects.length; ++index) {
                long adminGroupId = dynamicObjects[index].getLong("admingroup.id");
                if (defaultCreateAdminGroupId == 0L || defaultCreateAdminGroupId == adminGroupId) continue;
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("admingroup", (Object)adminGroupId, ++rowIndex);
                this.getModel().setValue("users", (Object)HRRolePermHelper.queryAdminGrpUsers((long)adminGroupId), rowIndex);
            }
            this.getView().updateView("entryentity");
            this.getModel().endInit();
        }
        this.permPageCacheUtil.put("useScopeLoaded", "1");
    }

    private void handlePropertyChange(int result) {
        HRPageCache cache = new HRPageCache(this.getView());
        if (result == MessageBoxResult.Cancel.getValue()) {
            String property = (String)cache.get(ROLE_PROPERTY_OLD_VALUE, String.class);
            cache.put(REVERT, (Object)"true");
            this.getModel().setValue("roleproperty", (Object)property);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void rolePropertyChanged(PropertyChangedArgs e) {
        Object editFlag = this.getView().getFormShowParameter().getCustomParam("editFlag");
        if (Objects.nonNull(editFlag)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        String oldValueTmp = changeData.getOldValue().toString();
        String newValueTmp = changeData.getNewValue().toString();
        HRPageCache cache = new HRPageCache(this.getView());
        String oldValue = (String)cache.get(ROLE_PROPERTY_OLD_VALUE, String.class);
        String revert = (String)cache.get(REVERT, String.class);
        if (HRStringUtils.equals((String)newValueTmp, (String)oldValue) && HRStringUtils.isNotEmpty((String)revert)) {
            cache.remove(ROLE_PROPERTY_OLD_VALUE);
            cache.remove(REVERT);
            return;
        }
        cache.put(ROLE_PROPERTY_OLD_VALUE, (Object)oldValueTmp);
        if (HRStringUtils.equals((String)newValueTmp, (String)"0")) {
            boolean isCopy = HRStringUtils.equals((String)"1", (String)this.getView().getPageCache().get("copy"));
            if (!isCopy) {
                ArrayList qFilters;
                String roleId;
                int customEnableCount;
                String newRoleId = this.getPageCache().get(ROLE_ID);
                if (HRStringUtils.isNotEmpty((String)newRoleId)) {
                    this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
                }
                if ((customEnableCount = RoleMemberAssignServiceHelper.getUserCountByRole((String)(roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID)), (List)(qFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("customenable", "=", (Object)"1")})))) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u89d2\u8272\u5b58\u5728\u81ea\u5b9a\u4e49\u6570\u636e\u8303\u56f4\u7684\u6210\u5458\u6570\u636e\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"RoleModifyEdit_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    formShowParameter.setCustomParam("editFlag", (Object)Boolean.FALSE);
                    this.getModel().setValue("roleproperty", (Object)"1");
                    return;
                }
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"rolecbisintersection"});
            this.getModel().setValue("rolecbisintersection", (Object)"0");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rolecbisintersection"});
            this.getModel().setValue("rolecbisintersection", (Object)"0");
        }
    }

    private void nameChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String local = RequestContext.get().getLang().name();
        LocaleDynamicObjectCollection oldValuesTmp = (LocaleDynamicObjectCollection)changeData.getOldValue();
        LocaleDynamicObjectCollection newValuesTmp = (LocaleDynamicObjectCollection)changeData.getNewValue();
        String oldValue = null;
        String newValue = null;
        for (int i = 0; i < oldValuesTmp.size(); ++i) {
            DynamicObject tempOld = (DynamicObject)oldValuesTmp.get(i);
            if (!HRStringUtils.equals((String)tempOld.getString("localeid"), (String)local)) continue;
            DynamicObject tempNew = (DynamicObject)newValuesTmp.get(i);
            oldValue = tempOld.getString("rolename");
            newValue = tempNew.getString("rolename");
            break;
        }
        if (HRStringUtils.equals(oldValue, newValue)) {
            return;
        }
        this.getModel().setValue("rolename", (Object)this.getModel().getValue("rolename").toString().trim());
        this.handleNameChanged();
    }

    private void handleNameChanged() {
        Pair<Boolean, FieldTip> pair = this.getNameCheckResult();
        if (((Boolean)pair.getKey()).booleanValue()) {
            this.getView().showFieldTip((FieldTip)pair.getRight());
        }
    }

    private Pair<Boolean, FieldTip> getNameCheckResult() {
        FieldTip tip;
        boolean result = true;
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("rolename");
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        String msg = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728", (String)"RoleModifyEdit_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.isEmpty((String)name.getLocaleValue())) {
            msg = this.getRoleNameEmptyMsg();
            tip = this.showValidateTip(false, msg, "rolename");
            this.getPageCache().put(VALIDATE_STATUS, "0");
            result = false;
        } else {
            boolean isCopy = HRStringUtils.equals((String)"1", (String)this.getView().getPageCache().get("copy"));
            if (isCopy) {
                roleId = "0";
            }
            if (RoleServiceHelper.checkNameExist((String)roleId, (String)name.getLocaleValue())) {
                tip = this.showValidateTip(true, null, "rolename");
                this.getPageCache().put(VALIDATE_STATUS, "1");
            } else {
                tip = this.showValidateTip(false, msg, "rolename");
                this.getPageCache().put(VALIDATE_STATUS, "0");
                result = false;
            }
        }
        return Pair.of((Object)result, (Object)tip);
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleNumberChanged(PropertyChangedArgs args) {
        Pair<Boolean, FieldTip> pair = this.getNumberCheckResult();
        if (((Boolean)pair.getKey()).booleanValue()) {
            this.getView().showFieldTip((FieldTip)pair.getRight());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Pair<Boolean, FieldTip> getNumberCheckResult() {
        FieldTip tip;
        boolean result = true;
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        String number = (String)this.getModel().getValue("rolenumber");
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        boolean isCopy = HRStringUtils.equals((String)"1", (String)this.getView().getPageCache().get("copy"));
        if (isCopy) {
            roleId = "0";
        }
        String msg = ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728", (String)"RoleModifyEdit_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.isEmpty((String)number)) {
            msg = this.getRoleNumberEmptyMsg();
            tip = this.showValidateTip(false, msg, "rolenumber");
            this.getPageCache().put(VALIDATE_STATUS, "0");
            result = false;
        } else if (RoleServiceHelper.checkNumberExist((String)roleId, (String)number)) {
            tip = this.showValidateTip(false, msg, "rolenumber");
            this.getPageCache().put(VALIDATE_STATUS, "0");
            result = false;
        } else {
            tip = this.showValidateTip(true, null, "rolenumber");
            this.getPageCache().put(VALIDATE_STATUS, "1");
        }
        return Pair.of((Object)result, (Object)tip);
    }

    private FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
            this.getView().showTipNotification(msg);
        }
        return fieldTip;
    }

    private void getTip(List<FieldTip> list, String msg, String fieldName) {
        FieldTip fieldTip = this.showValidateTip(false, msg, fieldName);
        list.add(fieldTip);
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (HRStringUtils.equals((String)fieldKey, (String)"rolegroup")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_rolegrp");
            QFilter[] filters = new QFilter[]{QFilter.isNotNull((String)"id")};
            DynamicObject[] roleGroups = helper.queryOriginalArray("id", filters);
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)roleGroups.length);
            for (DynamicObject roleGroup : roleGroups) {
                idList.add(roleGroup.getString("id"));
            }
            QFilter idFilter = new QFilter("id", "in", (Object)idList);
            showParameter.getListFilterParameter().getQFilters().add(idFilter);
        } else if (HRStringUtils.equals((String)fieldKey, (String)"createadmingrp")) {
            Set userAdminGroups = HRRolePermHelper.queryUserAdminGroups((long)RequestContext.get().getCurrUserId());
            QFilter filter = new QFilter("id", "in", (Object)userAdminGroups);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (HRStringUtils.equals((String)"admingroup", (String)fieldKey)) {
            QFilter filter = HRRolePermHelper.buildAdminGroupFilter((DynamicObject)dataEntity);
            Set selectedIds = dataEntity.getDynamicObjectCollection("entryentity").stream().filter(it -> it.getDynamicObject("admingroup") != null).map(it -> it.getLong("admingroup.id")).collect(Collectors.toSet());
            if (selectedIds.size() > 0) {
                filter.and("id", "not in", selectedIds);
            }
            showParameter.getListFilterParameter().setFilter(filter);
        } else if (HRStringUtils.equals((String)"admingroup1", (String)fieldKey)) {
            QFilter filter = HRRolePermHelper.buildAdminGroupFilter((DynamicObject)dataEntity);
            Set selectedIds = dataEntity.getDynamicObjectCollection("assignentryentity").stream().filter(it -> it.getDynamicObject("admingroup1") != null).map(it -> it.getLong("admingroup1.id")).collect(Collectors.toSet());
            if (selectedIds.size() > 0) {
                filter.and("id", "not in", selectedIds);
            }
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    private boolean checkRoleForBidden() {
        String newRoleId = this.getPageCache().get(ROLE_ID);
        if (HRStringUtils.isNotEmpty((String)newRoleId)) {
            this.getView().getFormShowParameter().setCustomParam(ROLE_ID, (Object)newRoleId);
        }
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam(ROLE_ID);
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        return roleHelper.isExists(new QFilter("id", "=", (Object)roleId).and("enable", "=", (Object)"0"));
    }
}

