/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.service.perm.DimChangeCheckService;
import kd.hr.hrcs.bussiness.service.perm.PermNotifyService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRListFieldPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRRoleFunctionPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignSaveService;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DimensionHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;

@ExcludeFromJacocoGeneratedReport
public class RoleMemberAssignEditPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(RoleMemberAssignEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{"copy"});
        super.addClickListeners(new String[]{"lblnumber"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setStatus(OperationStatus.EDIT);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("copy".equals(key)) {
            String roleId = this.getRoleId();
            Map roleDataPermModels = RoleMemberAssignSaveService.assembleRoleDataPermModelList((String)roleId, (boolean)false);
            Map roleFieldPermInfoFromDatabase = HRListFieldPermServiceHelper.getRoleFieldPermInfoFromDatabase(null, null, (String)roleId);
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
            permPageCacheUtil.setDataPerm(roleDataPermModels);
            permPageCacheUtil.put("fieldPermCache", SerializationUtils.toJsonString((Object)roleFieldPermInfoFromDatabase));
            RoleServiceHelper.reloadDataPermContainer((IFormView)this.getView());
        } else if ("lblnumber".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_modifyrole");
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("roleId", this.getRoleId());
            String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_role");
            DynamicObject role = serviceHelper.queryOne((Object)roleId);
            showParameter.setCaption(role.getString("name"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isForbidden = (String)customParams.get("isforbidden");
        String setupMyself = (String)customParams.get("setupMyself");
        if (HRStringUtils.equals((String)"true", (String)setupMyself)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getPageCache().put("viewStatus", "1");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8c03\u6574\u81ea\u5df1\u7684\u8bb0\u5f55\uff0c\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"RoleMemberAssignEditPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)"true", (String)isForbidden)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getPageCache().put("viewStatus", "1");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4ee5\u67e5\u770b\u72b6\u6001\u6253\u5f00", (String)"RoleMemberAssignEditPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("viewStatus", "0");
        }
        if (customParams.get("isUpdate") != null) {
            boolean roleModifyDataLock = RoleMemberAssignServiceHelper.isMutexDataLock((String)RoleServiceHelper.getRoleId((IFormView)this.getView()), (String)"perm_role", (String)"modify");
            boolean roleAssignDataLock = RoleMemberAssignServiceHelper.isMutexDataLock((String)customParams.get("relationId").toString(), (String)"hrcs_role", (String)"assign");
            if (roleModifyDataLock) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
                this.getPageCache().put("viewStatus", "1");
                RoleMemberAssignServiceHelper.showRoleEditTips((IFormView)this.getView());
            } else if (roleAssignDataLock) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
                this.getPageCache().put("viewStatus", "1");
                RoleMemberAssignServiceHelper.showRoleAssignEditTips((IFormView)this.getView(), (String)customParams.get("relationId").toString());
            }
        }
        String roleId = (String)customParams.get("roleId");
        this.getModel().setValue("role", (Object)roleId);
        this.getModel().deleteEntryData("entryentity");
        boolean existRange = RoleMemberAssignServiceHelper.roleExistDataRange((String)roleId);
        this.setLabel(roleId);
        HRRoleFunctionPermHelper.setAssignedAppEntity((IFormView)this.getView(), (String)roleId);
        if (customParams.get("isUpdate") != null) {
            this.setByUpdate(existRange);
            DynamicObject relation = RoleMemberAssignServiceHelper.getRelationInfoById((Long)((Long)customParams.get("relationId")));
            this.getView().getFormShowParameter().setCustomParam("userRoleRelateId", (Object)((Long)customParams.get("relationId")));
            if (relation.getString("customenable").equals("1")) {
                List roleDataPermModelList = RoleMemberAssignSaveService.getRoleMemberInfoCustom((Long)((Long)customParams.get("relationId")));
                HashMap roleDataPermModelMap = Maps.newHashMapWithExpectedSize((int)roleDataPermModelList.size());
                roleDataPermModelList.forEach(roleDataPermModel -> roleDataPermModelMap.put(String.valueOf(roleDataPermModel.getHrBuCaFunc()), roleDataPermModel));
                PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
                permPageCacheUtil.setDataPerm((Map)roleDataPermModelMap);
                RoleServiceHelper.reloadDataPermContainer((IFormView)this.getView());
            }
        } else {
            RoleMemberAssignServiceHelper.roleAssignMembHandleLock((IFormView)this.getView());
            Map roleDataPermModels = RoleMemberAssignSaveService.assembleRoleDataPermModelList((String)this.getRoleId(), (boolean)true);
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
            permPageCacheUtil.setDataPerm(roleDataPermModels);
            String roleProperty = (String)customParams.get("roleProperty");
            List permFileIds = (List)customParams.get("permFileIds");
            if (CollectionUtils.isEmpty((Collection)permFileIds)) {
                LOG.error("beforeBindData() permFileIds is empty");
                return;
            }
            this.setByNew(permFileIds, existRange, roleProperty);
        }
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
        permPageCacheUtil.setAssignedDimIntoCache(roleId);
        DimensionHelper.loadRoleDimData((IFormView)this.getView(), (String)roleId, (PermPageCacheUtil)permPageCacheUtil);
        permPageCacheUtil.setOriginalDataPerm(permPageCacheUtil.getDataPermMap());
        Map assignedEntityBuCaFuncMap = (Map)this.getView().getFormShowParameter().getCustomParam("assignedEntityBuCaFuncMap");
        if (null != assignedEntityBuCaFuncMap && !assignedEntityBuCaFuncMap.isEmpty()) {
            permPageCacheUtil.setEntityBuCaFuncMap(assignedEntityBuCaFuncMap);
        }
        this.getPageCache().put("userId", ((DynamicObject)this.getModel().getValue("permfile")).getString("user.id"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate fo = (FormOperate)args.getSource();
        if ("save".equalsIgnoreCase(fo.getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String roleId = (String)customParams.get("roleId");
            String isUpdate = (String)customParams.get("isUpdate");
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(this.getPageCache());
            Map permDataMap = permPageCacheUtil.getDataPermMap();
            ArrayList modelList = new ArrayList(permDataMap.values());
            LOG.info("modelList:{}", modelList);
            String roleProperty = (String)customParams.get("roleProperty");
            Date startDate = (Date)this.getModel().getValue("validstart");
            Date endDate = (Date)this.getModel().getValue("validend");
            if (Objects.isNull(startDate)) {
                startDate = new Date();
            }
            if (Objects.isNull(endDate)) {
                endDate = PermRoleUtil.dateIncreaseByMonth((Date)startDate, (int)36);
            }
            DynamicObject permFileDy = (DynamicObject)this.getModel().getValue("permfile");
            if (startDate.compareTo(endDate) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"RoleMemberAssignEditPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long permFileId = permFileDy.getLong("id");
            String dataProperty = (String)this.getModel().getValue("dataproperty");
            if ("1".equals(isUpdate)) {
                HashSet permFileIds = Sets.newHashSetWithExpectedSize((int)16);
                permFileIds.add(permFileId);
                HashMap relationAndCustom = Maps.newHashMapWithExpectedSize((int)16);
                long relationId = (Long)this.getView().getFormShowParameter().getCustomParam("relationId");
                relationAndCustom.put(relationId, dataProperty);
                if ("1".equals(roleProperty) && HRStringUtils.equals((String)"1", (String)dataProperty)) {
                    StringBuilder processInfo = new StringBuilder();
                    if (RoleMemberAssignSaveService.checkSaveRoleMember((IFormView)this.getView(), (StringBuilder)processInfo, modelList)) {
                        if (HRStringUtils.isNotEmpty((String)processInfo.toString())) {
                            this.getView().showErrorNotification(processInfo.toString());
                        }
                        args.setCancel(true);
                        return;
                    }
                    RoleMemberAssignSaveService.saveRoleMemCustom((IFormView)this.getView(), (String)roleId, (long)permFileId, (Date)startDate, (Date)endDate, modelList, (String)"userRoleModify", (Long)relationId, (String)"hrcs_rolememassign");
                } else {
                    Long[] permFileIdArr = new Long[]{permFileId};
                    RoleMemberAssignSaveService.saveRoleMember((Long[])permFileIdArr, (String)roleId, (Date)startDate, (Date)endDate, (String)"userRoleModify", (Long)relationId, (String)"hrcs_rolememassign");
                }
                RoleMemberAssignSaveService.deleteRoleMember((String)roleId, (Set)permFileIds, (Map)relationAndCustom);
            } else if ("1".equals(roleProperty) && HRStringUtils.equals((String)"1", (String)dataProperty)) {
                StringBuilder processInfo = new StringBuilder();
                if (RoleMemberAssignSaveService.checkSaveRoleMember((IFormView)this.getView(), (StringBuilder)processInfo, modelList)) {
                    if (HRStringUtils.isNotEmpty((String)processInfo.toString())) {
                        this.getView().showErrorNotification(processInfo.toString());
                    }
                    args.setCancel(true);
                    return;
                }
                RoleMemberAssignSaveService.saveRoleMemCustom((IFormView)this.getView(), (String)roleId, (long)permFileId, (Date)startDate, (Date)endDate, modelList, (String)"userRoleAdd", (Long)0L, (String)"hrcs_rolememassign");
            } else {
                List permFileIds = (List)customParams.get("permFileIds");
                RoleMemberAssignSaveService.saveRoleMember((Long[])permFileIds.toArray(new Long[permFileIds.size()]), (String)roleId, (Date)startDate, (Date)endDate, (String)"userRoleAdd", (Long)0L, (String)"hrcs_rolememassign");
            }
        }
    }

    private void setLabel(String roleId) {
        DynamicObject permRole = RoleMemberAssignServiceHelper.getPermRoleById((String)roleId);
        Label labName = (Label)this.getView().getControl("lblname");
        labName.setText(permRole.getString("name"));
        Label lblNumber = (Label)this.getView().getControl("lblnumber");
        lblNumber.setText(permRole.getString("number"));
        DynamicObject hrRole = RoleMemberAssignServiceHelper.getHRRoleById((String)roleId);
        if (Objects.nonNull(hrRole)) {
            this.getModel().setValue("property", (Object)hrRole.getString("property"));
            if (Objects.nonNull(hrRole.get("rolegrp"))) {
                Label lblGroup = (Label)this.getView().getControl("lblgroup");
                LOG.info("rolegrp.name is " + hrRole.getString("rolegrp.name"));
                lblGroup.setText(hrRole.getString("rolegrp.name"));
            }
        }
        Label lblProperty = (Label)this.getView().getControl("lblproperty");
        lblProperty.setText(RoleServiceHelper.getComboValue((String)"property", (IFormView)this.getView()));
    }

    private void setByUpdate(boolean existRange) {
        long relationId = (Long)this.getView().getFormShowParameter().getCustomParam("relationId");
        DynamicObject relation = RoleMemberAssignServiceHelper.getRelationInfoById((Long)relationId);
        if (ObjectUtils.isEmpty((Object)relation)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"RoleMemberAssignEditPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", 1);
        this.getModel().setValue("permfile", relation.get("permfile.id"), 0);
        boolean enableValidateTime = RoleMemberAssignServiceHelper.enablePermValidateTime();
        if (enableValidateTime) {
            Date date = new Date();
            if (Objects.nonNull(relation.getDate("validstart"))) {
                this.getModel().setValue("validstart", (Object)PermRoleUtil.formatStartDate((Date)relation.getDate("validstart")), 0);
            } else {
                this.getModel().setValue("validstart", (Object)PermRoleUtil.formatStartDate((Date)date), 0);
            }
            if (Objects.nonNull(relation.getDate("validend"))) {
                this.getModel().setValue("validend", (Object)PermRoleUtil.formatStartDate((Date)relation.getDate("validend")), 0);
            } else {
                this.getModel().setValue("validend", (Object)PermRoleUtil.formatStartDate((Date)PermRoleUtil.dateIncreaseByMonth((Date)date, (int)36)), 0);
            }
        } else {
            CardEntry control = (CardEntry)this.getView().getControl("entryentity");
            control.setChildVisible(false, 0, new String[]{"effectivedaterange"});
        }
        this.getModel().setValue("dataproperty", (Object)relation.getString("customenable"), 0);
        if (!existRange) {
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"dataproperty"});
        }
        this.getView().updateView("entryentity");
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"permfile"});
        boolean roleModifyDataLock = RoleMemberAssignServiceHelper.isMutexDataLock((String)RoleServiceHelper.getRoleId((IFormView)this.getView()), (String)"perm_role", (String)"modify");
        if (roleModifyDataLock) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void setByNew(List<Long> permFileIds, boolean existRange, String roleProperty) {
        Date date = new Date();
        this.getModel().batchCreateNewEntryRow("entryentity", permFileIds.size());
        boolean enableValidateTime = RoleMemberAssignServiceHelper.enablePermValidateTime();
        for (int index = 0; index < permFileIds.size(); ++index) {
            this.getModel().setValue("permfile", (Object)permFileIds.get(index), index);
            if (enableValidateTime) {
                this.getModel().setValue("validstart", (Object)PermRoleUtil.formatStartDate((Date)date), index);
                this.getModel().setValue("validend", (Object)PermRoleUtil.formatStartDate((Date)PermRoleUtil.dateIncreaseByMonth((Date)date, (int)36)), index);
            } else {
                CardEntry control = (CardEntry)this.getView().getControl("entryentity");
                control.setChildVisible(false, 0, new String[]{"effectivedaterange"});
            }
            if (existRange && "1".equals(roleProperty)) {
                this.getModel().setValue("dataproperty", (Object)"0", index);
            }
            if (existRange) continue;
            this.getModel().setValue("dataproperty", (Object)"1", index);
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"dataproperty"});
        }
        if (!existRange) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"dataproperty"});
        }
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.notifyUser();
        }
    }

    public String getRoleId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String roleId = (String)customParams.get("roleId");
        return roleId;
    }

    private void notifyUser() {
        Long newUserId;
        Long userId = Long.parseLong(this.getPageCache().get("userId"));
        if (!userId.equals(newUserId = Long.valueOf(((DynamicObject)this.getModel().getValue("permfile")).getLong("user.id")))) {
            this.doNotifyUser();
            return;
        }
        Date endDate = (Date)this.getModel().getValue("validend");
        if (null != endDate) {
            LocalDate endLocaleDate = ZonedDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault()).toLocalDate();
            if (LocalDate.now().isAfter(endLocaleDate) || this.checkDiff()) {
                this.doNotifyUser();
            }
        }
    }

    private boolean checkDiff() {
        if (!HRStringUtils.equals((String)"1", (String)((String)this.getModel().getValue("dataproperty")))) {
            return false;
        }
        return 0 != DimChangeCheckService.checkDimDiff((IFormView)this.getView());
    }

    private void doNotifyUser() {
        Long userId = Long.parseLong(this.getPageCache().get("userId"));
        PermNotifyService.notifyUser((Long)userId);
    }
}

