/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;

public class RoleNewEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CB_PROPERTY = "property";
    private static final String LBL_ROLETYPE = "lblroletype";
    private static final String ROLETYPE = "roletype";
    private static final String GROUP = "group";
    private static final String LBL_SEPARATOR = "lbl_separator";
    public static final String LBL_GROUP = "lblgroup";
    public static final String ROLE_PROPERTY = "roleProperty";
    public static final String ROLE_TYPE_EMPLOYEE = ",1,";

    public void initialize() {
        RoleServiceHelper.initRoleTypeMulCombo((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "group": {
                this.setGroup();
                break;
            }
            case "name": {
                this.handleNameChanged();
                SaveRoleServiceHelper.setNameLabel((IFormView)this.getView(), (PropertyChangedArgs)args);
                break;
            }
            case "number": {
                this.handleNumberChanged();
                SaveRoleServiceHelper.setNumberLabel((IFormView)this.getView(), (PropertyChangedArgs)args);
                break;
            }
        }
        this.getModel().setDataChanged(true);
    }

    private void handleNumberChanged() {
        String number = (String)this.getModel().getValue("number");
        if (HRStringUtils.isEmpty((String)number)) {
            this.getModel().setValue("number", null);
            return;
        }
        String msg = ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728", (String)"RoleNewEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        FieldTip tip = !RoleServiceHelper.checkNumberExist(null, (String)number) ? RoleServiceHelper.showValidatTip((IFormView)this.getView(), (boolean)true, null, (String)"number") : RoleServiceHelper.showValidatTip((IFormView)this.getView(), (boolean)false, (String)msg, (String)"number");
        this.getView().showFieldTip(tip);
    }

    private void handleNameChanged() {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (HRStringUtils.isEmpty((String)name.getLocaleValue())) {
            this.getModel().setValue("name", null);
            return;
        }
        String msg = this.getRoleNameExistMsg();
        FieldTip tip = RoleServiceHelper.checkNameExist(null, (String)name.getLocaleValue()) ? RoleServiceHelper.showValidatTip((IFormView)this.getView(), (boolean)true, null, (String)"name") : RoleServiceHelper.showValidatTip((IFormView)this.getView(), (boolean)false, (String)msg, (String)"name");
        this.getView().showFieldTip(tip);
    }

    private String getRoleNameExistMsg() {
        return ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728", (String)"RoleNewEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private void setGroup() {
        DynamicObject group = this.getModel().getDataEntity().getDynamicObject(GROUP);
        if (Objects.nonNull(group)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{LBL_SEPARATOR});
            this.getModel().setValue(LBL_GROUP, group.get("id"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_SEPARATOR});
            this.getModel().setValue(LBL_GROUP, null);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Object roleType = this.getModel().getValue(ROLETYPE);
        if (Objects.isNull(roleType) || HRStringUtils.isEmpty((String)roleType.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_ROLETYPE});
        }
        this.getPageCache().put(ROLE_PROPERTY, this.getModel().getValue(CB_PROPERTY).toString());
    }

    public void afterCreateNewData(EventObject evt) {
        this.getModel().setValue(ROLETYPE, (Object)ROLE_TYPE_EMPLOYEE);
        String number = this.readNumber();
        if (HRStringUtils.isNotEmpty((String)number)) {
            this.getModel().setValue("number", (Object)number);
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
        String groupId = (String)this.getView().getFormShowParameter().getCustomParam("groupId");
        if (HRStringUtils.isNotEmpty((String)groupId) && !HRStringUtils.equals((String)"0", (String)groupId)) {
            this.getModel().setValue(GROUP, (Object)groupId);
            this.setGroup();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_SEPARATOR});
        }
        this.getModel().setValue("name", (Object)"");
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(GROUP);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private String generateNumber(boolean isGetMode) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_role");
        DynamicObject permRoleDy = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"perm_role", (DynamicObject)permRoleDy, null);
        if (isGetMode) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)permRoleDy);
        }
        return CodeRuleServiceHelper.readNumber((CodeRuleInfo)codeRule, (DynamicObject)permRoleDy);
    }

    private String readNumber() {
        return this.generateNumber(true);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)GROUP)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_rolegrp");
            QFilter[] filters = new QFilter[]{new QFilter("id", "is not null", null)};
            DynamicObject[] roleGrps = helper.query(filters);
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)roleGrps.length);
            for (DynamicObject roleGrp : roleGrps) {
                ids.add(roleGrp.getString("id"));
            }
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(idFilter);
        }
    }
}

