/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role.component;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.EntityCtrlViewHelper;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;

@ExcludeFromJacocoGeneratedReport
public class HRDimCardEntryPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(HRDimCardEntryPlugin.class);
    public static final String MUST_INPUT = "mustinput";
    private static final String SELF_PROPERTY_CHANGED = "selfPropertyChanged";
    private static final String FRAMEWORK_PROPERTY_CHANGED = "frameworkPropertyChanged";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"lbldetail"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (HRStringUtils.equals((String)"lbldetail", (String)controlKey)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension", index);
            Long dimensionId = dimension.getLong("id");
            String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
            String hrBuCaFuncId = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
            String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
            FormShowParameter fsp = new FormShowParameter();
            IFormView mainPageView = this.getView().getView(mainPageId);
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainPageView, false);
            Map dataPermMap = permPageCacheUtil.getDataPermMap();
            RoleDataPermModel roleDataPermModel = (RoleDataPermModel)dataPermMap.get(hrBuCaFuncId);
            Set disableEntitySet = new HashSet(16);
            if (Objects.nonNull(roleDataPermModel)) {
                Map roleDimRelatMap = roleDataPermModel.getRoleDimRelatDisableMap();
                disableEntitySet = roleDimRelatMap.getOrDefault(dimensionId.toString(), new HashSet(16));
            }
            fsp.setFormId("hrcs_entityctrlview");
            fsp.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5173\u8054\u4e1a\u52a1\u5bf9\u8c61", (String)"HRDimCardEntryPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            fsp.setStatus(OperationStatus.EDIT);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            OpenStyle style = new OpenStyle();
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("1000px");
            cssValue.setHeight("600px");
            style.setInlineStyleCss(cssValue);
            style.setShowType(ShowType.Modal);
            fsp.setOpenStyle(style);
            fsp.setHasRight(true);
            fsp.setCustomParam("dimId", (Object)dimensionId);
            fsp.setCustomParam("mainPageId", (Object)mainPageId);
            fsp.setCustomParam("roleId", (Object)roleId);
            fsp.setCustomParam("currentHRbuCaFunc", (Object)hrBuCaFuncId);
            boolean viewStatus = (Boolean)this.getModel().getValue("viewstatus");
            fsp.setCustomParam("viewstatus", (Object)(viewStatus ? "1" : "0"));
            fsp.setCustomParam("roleDimRelat", (Object)SerializationUtils.toJsonString(disableEntitySet));
            fsp.setCustomParam("rowIndex", (Object)index);
            fsp.setCustomParam("parentCard", this.getModel().getValue("enable"));
            fsp.setParentPageId(this.getView().getPageId());
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hrcs_entityctrlview"));
            this.getView().showForm(fsp);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        IFormView parentView = this.getView().getParentView();
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(parentView, false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hrBuCaFuncId = (String)formShowParameter.getCustomParam("currentHRbuCaFunc");
        Map assignedHrBuCaDim = pageCacheUtil.getAssignedHrBuCaDim();
        Map realTimeBuCaFuncDim = pageCacheUtil.getRealTimeBuCaFuncDim();
        LOGGER.info("Got assignedHrBuCaDim: {} , realTimeBuCaFuncDim: {}, hrBuCaFuncId: {}.", new Object[]{assignedHrBuCaDim, realTimeBuCaFuncDim, hrBuCaFuncId});
        Map hrBuCaFuncMap = assignedHrBuCaDim.computeIfAbsent(hrBuCaFuncId, item -> Maps.newHashMapWithExpectedSize((int)16));
        Map roleDimData = pageCacheUtil.getRoleDimData();
        Object coll = roleDimData.get(hrBuCaFuncId);
        Set<String> dimIds = this.buildDimIds(hrBuCaFuncId, roleDimData, coll);
        this.fillDimEntryCard(hrBuCaFuncId, realTimeBuCaFuncDim, hrBuCaFuncMap, dimIds);
        this.getModel().setValue("hrbucafunc", (Object)hrBuCaFuncId);
        this.getModel().setValue("bosbucafunc", (Object)hrBuCaFuncId);
    }

    private Set<String> buildDimIds(String hrBuCaFuncId, Map<String, Set<String>> roleDimData, Object coll) {
        Set<String> dimIds = coll instanceof List ? new HashSet<String>((List)coll) : roleDimData.get(hrBuCaFuncId);
        return dimIds;
    }

    private void fillDimEntryCard(String hrBuCaFuncId, Map<String, Map<String, Map<String, Object>>> realTimeBuCaFuncDim, Map<String, Map<String, Object>> hrBuCaFuncMap, Set<String> dimIds) {
        this.getModel().beginInit();
        int index = 0;
        Map currentBuCaDimMap = realTimeBuCaFuncDim.getOrDefault(hrBuCaFuncId, new HashMap());
        for (Map.Entry dim : currentBuCaDimMap.entrySet()) {
            String dimId = (String)dim.getKey();
            Map dimInfo = (Map)dim.getValue();
            String isMust = (String)((Map)dim.getValue()).get("ismust");
            boolean ctrlEnable = HRStringUtils.equals((String)"1", (String)isMust);
            this.getModel().insertEntryRow("entryentity", index);
            this.getModel().setValue("dimension", (Object)dimId, index);
            this.getModel().setValue("enable", (Object)ctrlEnable, index);
            this.getModel().setValue(MUST_INPUT, (Object)ctrlEnable, index);
            if (HRStringUtils.equals((String)"1", (String)isMust)) {
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)2);
                tempMap.put("dimensionNumber", dimInfo.get("dimensionNumber"));
                tempMap.put("dimId", dimId);
                hrBuCaFuncMap.put(dimId, tempMap);
            }
            ++index;
        }
        this.getModel().endInit();
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        boolean customEntityDim = PermCheckUtil.getSysParamCustomEntityDim();
        IFormView parentView = this.getView().getParentView();
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(parentView, false);
        Map assignedHrBuCaDim = pageCacheUtil.getAssignedHrBuCaDim();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hrBuCaFuncId = (String)formShowParameter.getCustomParam("currentHRbuCaFunc");
        String viewStatus = (String)formShowParameter.getCustomParam("viewStatus");
        String roleId = (String)formShowParameter.getCustomParam("roleId");
        Boolean isEnable = HRStringUtils.equals((String)"1", (String)viewStatus);
        this.getModel().setValue("viewstatus", (Object)isEnable);
        Map dataPermMap = pageCacheUtil.getDataPermMap();
        RoleDataPermModel roleDataPermModel = dataPermMap.computeIfAbsent(hrBuCaFuncId, key -> new RoleDataPermModel());
        Map roleDimRelatMap = roleDataPermModel.getRoleDimRelatDisableMap();
        LOGGER.info("BeforeBindData.Got assignedHrBuCaDim: {} ,dataPermMap: {}, hrBuCaFuncId: {}.", new Object[]{assignedHrBuCaDim, dataPermMap, hrBuCaFuncId});
        Map dimMap = (Map)assignedHrBuCaDim.get(hrBuCaFuncId);
        if (CollectionUtils.isEmpty((Map)dimMap)) {
            dimMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int rowIndex = 0;
        this.getModel().beginInit();
        for (DynamicObject entry : entryEntity) {
            String dimId = entry.getString("dimension.id");
            Map dimInfo = (Map)dimMap.get(dimId);
            Set disableEntitySet = roleDimRelatMap.getOrDefault(dimId, new HashSet(16));
            HashMap entityCtrlMap = Maps.newHashMapWithExpectedSize((int)16);
            EntityCtrlViewHelper.prepareDataForJudgement((String)hrBuCaFuncId, (Long)Long.parseLong(dimId), (Map)entityCtrlMap, (PermPageCacheUtil)pageCacheUtil, (String)roleId);
            Set items = entityCtrlMap.entrySet().stream().map(item -> (String)((Map)item.getValue()).get("app") + ((String)item.getKey()).split("#")[0] + ((String)item.getKey()).split("#")[1]).collect(Collectors.toSet());
            this.getModel().setValue("enable", (Object)(Objects.nonNull(dimInfo) && !disableEntitySet.containsAll(items) ? 1 : 0), rowIndex);
            if (((Boolean)this.getModel().getValue(MUST_INPUT, rowIndex)).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"enable"});
            }
            if (customEntityDim && !isEnable.booleanValue()) {
                Label labName = (Label)this.getView().getControl("lbldetail");
                labName.setText(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7ef4\u5ea6\u5173\u8054\u4e1a\u52a1\u5bf9\u8c61", (String)"HRDimCardEntryPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void beforePropertyChanged(PropertyChangedArgs evt) {
        ChangeData changeData = evt.getChangeSet()[0];
        if (changeData.getOldValue() == changeData.getNewValue()) {
            return;
        }
        if ("1".equals(this.getPageCache().get(SELF_PROPERTY_CHANGED))) {
            this.getPageCache().remove(SELF_PROPERTY_CHANGED);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String property = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"enable", (String)property)) {
            String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
            LOGGER.info("HRDimCardEntryPlugin.PropertyChanged start. Thread id:[{}]", (Object)Thread.currentThread().getId());
            try (DLock lock = DLock.createReentrant((String)("changeRoleDataLockKey" + mainPageId));){
                boolean locked;
                LOGGER.info("HRDimCardEntryPlugin.PropertyChanged try get lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
                boolean hrRoleLockless = HRStringUtils.equals((String)"1", (String)System.getProperty("hr.role.lockless"));
                boolean bl = locked = hrRoleLockless || lock.tryLock(10000L);
                if (locked) {
                    LOGGER.info("HRDimCardEntryPlugin.PropertyChanged got lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
                    this.doPropertyChanged(evt);
                } else {
                    LOGGER.info("HRDimCardEntryPlugin.PropertyChanged can not got lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
                }
            }
            LOGGER.info("HRDimCardEntryPlugin.PropertyChanged release lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
        }
    }

    private void doPropertyChanged(PropertyChangedArgs evt) {
        ChangeData changeData = evt.getChangeSet()[0];
        Boolean newValue = (Boolean)changeData.getNewValue();
        if ("1".equals(this.getPageCache().get(SELF_PROPERTY_CHANGED))) {
            return;
        }
        if ("1".equals(this.getPageCache().get(FRAMEWORK_PROPERTY_CHANGED))) {
            this.getPageCache().remove(FRAMEWORK_PROPERTY_CHANGED);
            changeData.getDataEntity().set("enable", (Object)true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u5fc5\u987b\u6309\u7ef4\u5ea6\u63a7\u6743\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"HRDimCardEntryPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (changeData.getDataEntity().getBoolean(MUST_INPUT)) {
            if (!newValue.booleanValue()) {
                this.getPageCache().put(SELF_PROPERTY_CHANGED, "1");
                this.getPageCache().put(FRAMEWORK_PROPERTY_CHANGED, "1");
                changeData.getDataEntity().set("enable", (Object)true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u5fc5\u987b\u6309\u7ef4\u5ea6\u63a7\u6743\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"HRDimCardEntryPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (null != newValue) {
            int rowIndex = changeData.getRowIndex();
            Boolean oldValue = Optional.ofNullable((Boolean)changeData.getOldValue()).orElse(newValue == false);
            boolean cascade = HRStringUtils.isEmpty((String)this.getPageCache().get("fromCallback"));
            this.handleEnableChanged(rowIndex, newValue, oldValue, cascade);
        } else {
            LOGGER.info("Got null value with changeData:{}.", (Object)changeData);
        }
    }

    private void handleEnableChanged(int rowIndex, Boolean newValue, Boolean oldValue, boolean cascade) {
        Boolean mustInput = (Boolean)this.getModel().getValue(MUST_INPUT, rowIndex);
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension", rowIndex);
        String dimNumber = dimension.getString("number");
        String dimId = dimension.getString("id");
        String hrBuCaFuncId = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
        if (this.checkMustInput(rowIndex, newValue, oldValue, mustInput)) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(parentView, false);
        this.updateBuCaFuncDim(newValue, dimNumber, dimId, hrBuCaFuncId, pageCacheUtil);
        this.updatePermData(newValue, dimNumber, dimId, hrBuCaFuncId, pageCacheUtil);
        if (cascade) {
            this.updatePermDataForCardDetail(newValue, dimNumber, dimId, hrBuCaFuncId, pageCacheUtil, roleId);
        }
    }

    private void updateBuCaFuncDim(Boolean newValue, String dimNumber, String dimId, String hrBuCaFuncId, PermPageCacheUtil pageCacheUtil) {
        Map assignedHrBuCaDim = pageCacheUtil.getAssignedHrBuCaDim();
        Map hrBuCaFuncMap = assignedHrBuCaDim.computeIfAbsent(hrBuCaFuncId, item -> Maps.newHashMapWithExpectedSize((int)16));
        if (newValue.booleanValue()) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)1);
            tempMap.put("dimensionNumber", dimNumber);
            tempMap.put("dimId", dimId);
            hrBuCaFuncMap.put(dimId, tempMap);
        } else {
            hrBuCaFuncMap.remove(dimId);
        }
        pageCacheUtil.setAssignedHrBuCaDim(assignedHrBuCaDim);
    }

    private void updatePermData(Boolean newValue, String dimNumber, String dimId, String hrBuCaFuncId, PermPageCacheUtil pageCacheUtil) {
        Map permDataMap = pageCacheUtil.getDataPermMap();
        RoleDataPermModel roleDataPermModel = (RoleDataPermModel)permDataMap.get(hrBuCaFuncId);
        if (roleDataPermModel == null) {
            return;
        }
        Map dimGroupMap = roleDataPermModel.getDimGroupMap();
        for (Map.Entry dimGrpModelEntry : dimGroupMap.entrySet()) {
            TreeMap dimMap;
            DimGrpModel dimGrpModel = (DimGrpModel)dimGrpModelEntry.getValue();
            if (dimGrpModel == null || CollectionUtils.isEmpty((Map)(dimMap = dimGrpModel.getDimMap()))) continue;
            if (newValue.booleanValue()) {
                DimModel dimModel = new DimModel();
                dimModel.setDimId(dimId);
                dimModel.setDimNumber(dimNumber);
                dimMap.put(dimNumber, dimModel);
                continue;
            }
            dimMap.remove(dimNumber);
        }
        pageCacheUtil.setDataPerm(permDataMap);
    }

    private void updatePermDataForCardDetail(Boolean newValue, String dimNumber, String dimId, String hrBuCaFuncId, PermPageCacheUtil pageCacheUtil, String roleId) {
        Map permDataMap = pageCacheUtil.getDataPermMap();
        RoleDataPermModel roleDataPermModel = (RoleDataPermModel)permDataMap.get(hrBuCaFuncId);
        if (roleDataPermModel == null) {
            return;
        }
        Map roleDimRelatDisableMap = roleDataPermModel.getRoleDimRelatDisableMap();
        Set disableEntitySet = roleDimRelatDisableMap.computeIfAbsent(dimId, key -> new HashSet(16));
        if (newValue.booleanValue()) {
            disableEntitySet.clear();
        } else {
            HashMap entityCtrlMap = Maps.newHashMapWithExpectedSize((int)16);
            EntityCtrlViewHelper.prepareDataForJudgement((String)hrBuCaFuncId, (Long)Long.parseLong(dimId), (Map)entityCtrlMap, (PermPageCacheUtil)pageCacheUtil, (String)roleId);
            Set items = entityCtrlMap.entrySet().stream().map(item -> (String)((Map)item.getValue()).get("app") + ((String)item.getKey()).split("#")[0] + ((String)item.getKey()).split("#")[1]).collect(Collectors.toSet());
            disableEntitySet.addAll(items);
            roleDataPermModel.setRoleDimRelatDisableMap(roleDimRelatDisableMap);
        }
        pageCacheUtil.setDataPerm(permDataMap);
    }

    private boolean checkMustInput(int rowIndex, Boolean newValue, Boolean oldValue, Boolean mustInput) {
        if (Objects.nonNull(newValue) && Objects.nonNull(oldValue) && Objects.nonNull(mustInput) && !newValue.booleanValue() && oldValue.booleanValue() && mustInput.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue("enable", (Object)"1", rowIndex);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("hrcs_entityctrlview".equals(actionId)) {
            Map resultMap = (Map)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty((Map)resultMap) || !HRStringUtils.equals((String)"1", (String)((String)resultMap.get("actionId")))) {
                return;
            }
            Set roleDimEntityDisableSet = (Set)resultMap.get("resultSet");
            String dimId = (String)resultMap.get("dimId");
            IFormView parentView = this.getView().getParentView();
            PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(parentView, false);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String hrBuCaFuncId = (String)formShowParameter.getCustomParam("currentHRbuCaFunc");
            Map dataPermMap = pageCacheUtil.getDataPermMap();
            RoleDataPermModel roleDataPermModel = (RoleDataPermModel)dataPermMap.get(hrBuCaFuncId);
            if (Objects.isNull(roleDataPermModel)) {
                roleDataPermModel = new RoleDataPermModel();
                dataPermMap.put(hrBuCaFuncId, roleDataPermModel);
            }
            if (CollectionUtils.isEmpty((Collection)roleDimEntityDisableSet)) {
                roleDataPermModel.resetRoleDimEntityDisableSet();
            } else {
                Map roleDimRelatDisableMap = roleDataPermModel.getRoleDimRelatDisableMap();
                if (CollectionUtils.isEmpty((Map)roleDimRelatDisableMap)) {
                    roleDataPermModel.setRoleDimRelatDisableMap(roleDimRelatDisableMap);
                }
                roleDimRelatDisableMap.put(dimId, roleDimEntityDisableSet);
            }
            pageCacheUtil.setDataPerm(dataPermMap);
            boolean enableCard = (Boolean)resultMap.get("enableCard");
            int rowIndex = (Integer)resultMap.get("rowIndex");
            boolean originEnable = (Boolean)this.getModel().getValue("enable", rowIndex);
            if (enableCard != originEnable) {
                this.getPageCache().put("fromCallback", "true");
                this.getModel().setValue("enable", (Object)enableCard, rowIndex);
                this.getPageCache().remove("fromCallback");
            }
        }
    }
}

