/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.privacy;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class DataSortEntryEditPlugin
extends HRDataBaseEdit {
    private static final String CONDITION_PANEL = "filtergridap";
    private static final String DESCRIPTION = "description";
    private static final String ADD = "add";

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List<Object> entry = this.fromString((String)formShowParameter.getCustomParam("entryentity"));
        String rowIndex = (String)formShowParameter.getCustomParam("index");
        if (!entry.isEmpty() && !StringUtils.isEmpty((Object)rowIndex)) {
            DynamicObject row = (DynamicObject)entry.get(Integer.parseInt(rowIndex));
            this.getModel().setValue("name", row.get("entryname"));
            this.getModel().setValue(DESCRIPTION, row.get("entrydescription"));
            formShowParameter.setCustomParam("condition", (Object)row.getString("condition"));
        }
        this.getModel().setValue("index", (Object)rowIndex);
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNum = (String)formShowParameter.getCustomParam("entityNum");
        String condition = (String)formShowParameter.getCustomParam("condition");
        this.refreshFilterGrid(entityNum, condition);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        EntityOperate entityOperate = (EntityOperate)args.getSource();
        if (ADD.equals(entityOperate.getOperateKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List<Object> entry = this.fromString((String)formShowParameter.getCustomParam("entryentity"));
            String rowIndex = (String)formShowParameter.getCustomParam("index");
            FilterGrid filterGrid = (FilterGrid)this.getControl(CONDITION_PANEL);
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            boolean isFcEmpty = fc == null || CollectionUtils.isEmpty((Collection)fc.getFilterRow());
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                boolean isCurrent = Objects.equals(String.valueOf(i), rowIndex);
                ILocaleString value = (ILocaleString)this.getModel().getValue("name");
                if (Objects.equals(row.getString("entryname").trim(), value.getLocaleValue().trim()) && !isCurrent) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u5206\u7c7b\u540d\u79f0\u3002", (String)"DataSortEntryEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String condition = row.getString("condition");
                if (!StringUtils.isEmpty((Object)condition)) {
                    FilterCondition oldFc = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
                    if (isFcEmpty || !this.isEquals(oldFc, fc) || isCurrent) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u5206\u7c7b\u6761\u4ef6\u4e0e\u201c%s\u201d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataSortEntryEditPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{row.getString("entryname")}));
                    args.setCancel(true);
                    return;
                }
                if (!StringUtils.isEmpty((Object)condition) || !isFcEmpty || isCurrent) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u5206\u7c7b\u6761\u4ef6\u4e0e\u201c%s\u201d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataSortEntryEditPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{row.getString("entryname")}));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (ADD.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("name", this.getModel().getValue("name"));
            returnData.put(DESCRIPTION, this.getModel().getValue(DESCRIPTION));
            returnData.put("index", this.getModel().getValue("index"));
            FilterGrid filterGrid = (FilterGrid)this.getControl(CONDITION_PANEL);
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
                String condition = SerializationUtils.toJsonString((Object)fc);
                returnData.put("condition", condition);
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)this.getView().getFormShowParameter().getCustomParam("entityNum")));
            FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
            try {
                filterBuilder.buildFilter();
            }
            catch (Exception e) {
                return;
            }
            QFilter filter = filterBuilder.getQFilter();
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    private void refreshFilterGrid(String entityNum, String condition) {
        if (HRStringUtils.isEmpty((String)entityNum)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        List filterColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
        HRPermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONDITION_PANEL);
        filterGrid.setEntityNumber(entityNum);
        filterGrid.setFilterColumns(filterColumns);
        if (HRStringUtils.isNotEmpty((String)condition)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
            filterGrid.SetValue(fc);
        }
        this.getView().updateView(CONDITION_PANEL);
    }

    private List<Object> fromString(String content) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dataroleconfig");
        DynamicObject dynamicObject = serviceHelper.generateEmptyEntryDynamicObject("entryentity");
        return Arrays.asList(DynamicObjectSerializeUtil.deserialize((String)content, (DynamicObjectType)dynamicObject.getDynamicObjectType()));
    }

    private boolean isEquals(FilterCondition oldFc, FilterCondition newFc) {
        List oldFilterRow = oldFc.getFilterRow();
        List newFilterRow = newFc.getFilterRow();
        int sampleCount = 0;
        if (oldFilterRow.size() == newFilterRow.size()) {
            for (SimpleFilterRow oldRow : oldFilterRow) {
                List oldFilterValueList = oldRow.getValue();
                List oldValueList = oldFilterValueList.stream().map(FilterValue::getValue).collect(Collectors.toList());
                for (SimpleFilterRow newRow : newFilterRow) {
                    if (!this.isAllFieldEquals(oldRow, newRow)) continue;
                    List newValueList = newRow.getValue().stream().map(FilterValue::getValue).collect(Collectors.toList());
                    if (oldValueList.size() != newValueList.size() || !oldValueList.containsAll(newValueList)) continue;
                    ++sampleCount;
                }
            }
        }
        return sampleCount == newFilterRow.size();
    }

    private boolean isAllFieldEquals(SimpleFilterRow oldRow, SimpleFilterRow newRow) {
        return Objects.equals(oldRow.getFieldName(), newRow.getFieldName()) && Objects.equals(oldRow.getCompareType(), newRow.getCompareType()) && Objects.equals(oldRow.getLogic(), newRow.getLogic()) && Objects.equals(oldRow.getLeftBracket(), newRow.getLeftBracket()) && Objects.equals(oldRow.getRightBracket(), newRow.getRightBracket());
    }
}

