/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.privacy.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonList;
import kd.hr.hrcs.common.constants.PrivacyConstants;

public class BaseDataFieldListPlugin
extends HRBaseDataCommonList
implements PrivacyConstants {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                List fieldList = BaseDataFieldListPlugin.this.getFieldList(entityNumber, this.getQFilters());
                DynamicObjectCollection resultColls = start >= fieldList.size() ? new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hrcs_basedatafield"), null) : BaseDataFieldListPlugin.this.getDynamicObjectCollection(fieldList, start, limit);
                this.getQueryResult().setDataCount(fieldList.size());
                this.getQueryResult().setBillDataCount(fieldList.size());
                this.getQueryResult().setCollection(resultColls);
                return resultColls;
            }
        });
    }

    private List<Map<String, String>> getFieldList(String entityNumber, List<QFilter> qFilters) {
        List fieldList;
        String fieldListStr = this.getPageCache().get(entityNumber);
        if (qFilters.isEmpty() && StringUtils.isNotEmpty((CharSequence)fieldListStr)) {
            fieldList = SerializationUtils.fromJsonStringToList((String)fieldListStr, Map.class);
        } else {
            String value = "";
            if (!qFilters.isEmpty()) {
                value = qFilters.get(0).getValue().toString();
                value = value.substring(value.indexOf("#") + 1);
            }
            fieldList = Lists.newArrayListWithExpectedSize((int)32);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection propertyCollection = mainEntityType.getProperties();
            for (IDataEntityProperty property : propertyCollection) {
                HashMap fieldMap;
                if (StringUtils.isNotEmpty((CharSequence)value) && !property.getName().contains(value) && (property.getDisplayName() == null || !property.getDisplayName().getLocaleValue().contains(value))) continue;
                if (property.getDisplayName() != null) {
                    fieldMap = Maps.newHashMapWithExpectedSize((int)4);
                    fieldMap.put("name", property.getDisplayName().getLocaleValue());
                    fieldMap.put("number", property.getName());
                    fieldList.add(fieldMap);
                    continue;
                }
                if (!"id".equals(property.getName())) continue;
                fieldMap = Maps.newHashMapWithExpectedSize((int)4);
                fieldMap.put("name", "");
                fieldMap.put("number", property.getName());
                fieldList.add(fieldMap);
            }
            this.getPageCache().put(entityNumber, SerializationUtils.toJsonString((Object)fieldList));
        }
        return fieldList;
    }

    private DynamicObjectCollection getDynamicObjectCollection(List<Map<String, String>> fieldList, int start, int limit) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_basedatafield");
        DynamicObjectCollection basedataFieldColls = new DynamicObjectCollection();
        for (int i = start; i < fieldList.size() && i < start + limit; ++i) {
            DynamicObject basedataFieldDy = helper.generateEmptyDynamicObject();
            basedataFieldDy.set("name", (Object)fieldList.get(i).get("name"));
            basedataFieldDy.set("number", (Object)fieldList.get(i).get("number"));
            basedataFieldColls.add((Object)basedataFieldDy);
        }
        return basedataFieldColls;
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
    }
}

