/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.prompt.PromptServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class PromptAddRulePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit prompt = (BasedataEdit)this.getView().getControl("prompt");
        prompt.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter showFSP = this.getView().getFormShowParameter();
        String entity = (String)showFSP.getCustomParam("entity");
        if (HRStringUtils.isNotEmpty((String)entity)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.setEntityNumber(entity);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            List filterColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
            HRPermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
            filterGrid.setFilterColumns(filterColumns);
        }
        Object promptId = showFSP.getCustomParam("promptId");
        Optional.ofNullable(promptId).ifPresent(id -> this.getModel().setValue("prompt", id));
        Optional.ofNullable(showFSP.getCustomParam("entryDescription")).ifPresent(desc -> this.getModel().setValue("description", SerializationUtils.fromJsonString((String)((String)desc), Map.class)));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showFSP = this.getView().getFormShowParameter();
        String entity = (String)showFSP.getCustomParam("entity");
        if (HRStringUtils.isNotEmpty((String)entity)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            String entryRule = (String)showFSP.getCustomParam("entryRule");
            if (HRStringUtils.isNotEmpty((String)entryRule)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)entryRule, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setFormId("bos_treelistf7");
        showParameter.setBillFormId("hrcs_promptlist");
        if ("prompt".equals(evt.getProperty().getName())) {
            this.buildPromptF7Filter(showParameter);
        }
    }

    private void buildPromptF7Filter(ListShowParameter showParameter) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (Objects.nonNull(formId)) {
            DynamicObject[] extForms;
            DynamicObject appDy = BizAppServiceHelp.getBizAppByFormID((String)formId);
            DynamicObject cloudDy = BizCloudServiceHelp.getBizCloudByAppID((String)appDy.getString("id"));
            QFilter formFilter = new QFilter("businessobject", "=", (Object)MetadataDao.getNumberById((String)formId));
            String originId = appDy.getString("masterid");
            HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)64);
            if (StringUtils.isEmpty((CharSequence)originId)) {
                originId = appDy.getString("id");
            }
            for (DynamicObject extForm : extForms = PromptServiceHelper.getExtApps((String)originId)) {
                appIdSet.add(extForm.getString("id"));
            }
            appIdSet.add(originId);
            QFilter nullFormFilter = new QFilter("businessobject", "=", (Object)"");
            QFilter appFilter = new QFilter("app", "in", (Object)appIdSet);
            appFilter.and(nullFormFilter);
            QFilter nullAppFilter = new QFilter("app", "=", (Object)"");
            QFilter cloudFilter = new QFilter("cloud", "=", (Object)cloudDy.getString("id"));
            cloudFilter.and(nullAppFilter);
            QFilter totalQFilter = new QFilter("cloud", "=", (Object)"");
            showParameter.getListFilterParameter().setFilter(formFilter.or(appFilter).or(cloudFilter).or(totalQFilter));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"save")) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("prompt");
            if (Objects.isNull(value)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d0\u793a\u8bed\u3002", (String)"PromptAddRulePlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
            returnData.put("prompt", value);
            returnData.put("description", this.getModel().getValue("description"));
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            if (HRStringUtils.isNotEmpty((String)entity)) {
                FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
                FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
                returnData.put("rule", SerializationUtils.toJsonString((Object)filterCondition));
            }
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("rowIndex")).ifPresent(index -> returnData.put("rowIndex", index));
            this.getView().returnDataToParent((Object)returnData);
        }
    }
}

