/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.queryf7;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.DisplayPropsEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.util.QueryEntityUtil;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class HRDisplayPropsEdit
extends DisplayPropsEdit {
    private static final Log LOGGER = LogFactory.getLog(HRDisplayPropsEdit.class);
    private static final String CONTEXT = "context";
    private static final String ENTITY_ID = "entityId";
    private static final String DISPLAY_FIELD = "displayField";

    public void initialize() {
        super.initialize();
        this.initComboItems();
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
    }

    private void initComboItems() {
        try {
            String displayFieldStr = this.getPageCache(DISPLAY_FIELD);
            if (StringUtils.isEmpty((CharSequence)displayFieldStr)) {
                QueryEntityType queryEntityType = this.getBaseEntityType();
                List displayFieldList = QueryEntityUtil.getDisplayFieldNames((String)queryEntityType.getName());
                displayFieldStr = SerializationUtils.toJsonString((Object)displayFieldList);
                this.putPageCache(DISPLAY_FIELD, displayFieldStr);
            }
            ComboEdit paramComboControl = (ComboEdit)this.getView().getControl("displayfield");
            paramComboControl.setComboItems(this.getDisplayItem(this.getCurDisplayField(displayFieldStr)));
        }
        catch (Exception e1) {
            LOGGER.error("HRDisplayPropsEdit initComboItems error:%s", (Object)e1.getMessage());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (value != null) {
            String displayProp;
            List<QuerySelectField> displayFieldList = this.getCurDisplayField();
            String connector = displayProp = value.toString();
            List fieldList = displayFieldList.stream().map(QuerySelectField::getAlias).sorted((o1, o2) -> o2.length() - o1.length()).collect(Collectors.toList());
            for (String querySelectField : fieldList) {
                connector = connector.replace(querySelectField, "");
            }
            String displayField = displayProp;
            if (!"".equals(connector)) {
                displayField = "()".equals(connector) ? displayProp.replaceAll("[( )]", ",").substring(0, displayProp.length() - 1) : displayProp.replace(connector, ",");
                if (" ".equals(connector)) {
                    connector = "space";
                }
            } else {
                connector = null;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.set("displayfield", (Object)displayField);
            dataEntity.set("connector", (Object)connector);
            Label tipLab = (Label)this.getControl("tip");
            tipLab.setText(this.getCurTip(displayProp));
            if (connector == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"connector"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tipflexpanelap"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        ChangeData changeData = evt.getChangeSet()[0];
        Object newData = changeData.getNewValue();
        String field = evt.getProperty().getName();
        if (newData == null) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Label tipLab = (Label)this.getControl("tip");
        if (StringUtils.equals((CharSequence)"displayfield", (CharSequence)field)) {
            if (StringUtils.contains((CharSequence)newData.toString(), (CharSequence)",")) {
                if (dataEntity.get("connector") == null) {
                    dataEntity.set("connector", (Object)",");
                }
                tipLab.setText(this.getCurTip(this.getCurDisplayField(newData.toString(), dataEntity.get("connector"))));
                this.getView().setVisible(Boolean.TRUE, new String[]{"connector"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"tipflexpanelap"});
                this.getView().updateView();
            } else {
                this.getModel().getDataEntity().set("connector", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"connector"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tipflexpanelap"});
            }
        }
        if (StringUtils.equals((CharSequence)"connector", (CharSequence)field)) {
            String displayProp = dataEntity.get("displayfield") == null ? "name" : dataEntity.get("displayfield").toString();
            tipLab.setText(this.getCurTip(this.getCurDisplayField(displayProp, newData)));
        }
    }

    private String getCurDisplayField(String displayProp, Object connector) {
        if (connector != null && !",".equals(connector)) {
            if ("space".equals(connector)) {
                connector = " ";
            } else if ("()".equals(connector)) {
                connector = "(";
                displayProp = displayProp + ")";
            }
            displayProp = displayProp.replace(",", connector.toString());
        }
        return displayProp;
    }

    private List<ComboItem> getDisplayItem(List<QuerySelectField> displayFieldList) {
        ArrayList items = Lists.newArrayListWithCapacity((int)displayFieldList.size());
        Map<String, String> displayMap = displayFieldList.stream().collect(Collectors.toMap(QuerySelectField::getAlias, QuerySelectField::getDisplayName));
        for (QuerySelectField field : displayFieldList) {
            String nameField;
            ComboItem stringItem = new ComboItem();
            stringItem.setCaption(new LocaleString(field.getDisplayName()));
            stringItem.setValue(field.getAlias());
            items.add(stringItem);
            if ("number".equals(field.getAlias())) {
                nameField = field.getAlias().replace("number", "name");
                this.addItem(displayMap, items, nameField, field);
                continue;
            }
            if (!field.getAlias().endsWith(".number")) continue;
            nameField = field.getAlias().replace(".number", ".name");
            this.addItem(displayMap, items, nameField, field);
        }
        return items;
    }

    private void addItem(Map<String, String> displayMap, List<ComboItem> items, String nameField, QuerySelectField field) {
        String nameDisplayVal = displayMap.get(nameField);
        if (nameDisplayVal != null) {
            ComboItem name_numberItem = new ComboItem();
            name_numberItem.setCaption(new LocaleString(nameDisplayVal + "+" + field.getDisplayName()));
            name_numberItem.setValue(nameField + "," + field.getAlias());
            items.add(name_numberItem);
            ComboItem number_nameItem = new ComboItem();
            number_nameItem.setCaption(new LocaleString(field.getDisplayName() + "+" + nameDisplayVal));
            number_nameItem.setValue(field.getAlias() + "," + nameField);
            items.add(number_nameItem);
        }
    }

    private String getBaseEntityId() {
        JSONArray contextList = (JSONArray)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        JSONObject jsonObject = (JSONObject)contextList.get(0);
        if (null != jsonObject.getString("BaseEntityId")) {
            return jsonObject.getString("BaseEntityId");
        }
        if (null != jsonObject.getString("personEntityName")) {
            return jsonObject.getString("personEntityName");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u67e5\u8be2\u5b9e\u4f53\u3002", (String)"HRDisplayPropsEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private QueryEntityType getBaseEntityType() {
        String entityId = this.getPageCache(ENTITY_ID);
        if (entityId == null) {
            entityId = this.getBaseEntityId();
            this.putPageCache(ENTITY_ID, entityId);
        }
        return (QueryEntityType)EntityMetadataCache.getDataEntityTypeById((String)entityId);
    }

    private String getCurTip(String displayProp) {
        List<QuerySelectField> displayFieldList = this.getCurDisplayField();
        String tips = displayProp;
        for (QuerySelectField querySelectField : displayFieldList) {
            tips = tips.replace(querySelectField.getAlias(), querySelectField.getDisplayName());
        }
        return tips;
    }

    private String getPageCache(String key) {
        return this.getView().getParentView().getPageCache().get(this.formatKey(key));
    }

    private void putPageCache(String key, String value) {
        this.getView().getParentView().getPageCache().put(this.formatKey(key), value);
    }

    private String formatKey(String key) {
        return String.format("%s_%s_%s", this.getBaseEntityId(), this.getView().getFormShowParameter().getCustomParams().get("propertyName"), key);
    }

    private List<QuerySelectField> getCurDisplayField() {
        return SerializationUtils.fromJsonStringToList((String)this.getPageCache(DISPLAY_FIELD), QuerySelectField.class);
    }

    private List<QuerySelectField> getCurDisplayField(String displayField) {
        return SerializationUtils.fromJsonStringToList((String)displayField, QuerySelectField.class);
    }
}

