/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.queryf7;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.RefDisplayPropEditPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.hr.metadata.field.QueryField;
import kd.bos.ext.hr.util.QueryEntityUtil;
import kd.bos.ext.hr.util.QueryRefUtils;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;

public class HRRefDisplayPropEditPlugin
extends RefDisplayPropEditPlugin {
    private static final String ENTRY_KEY = "ftargetprops";
    private static final String FTNAME = "ftname";
    private static final String FT_DISPLAY_NAME = "ftdisplayname";

    public void afterCreateNewData(EventObject e) {
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (item == null || item.isEmpty()) {
            return;
        }
        List refFields = (List)item.get(0);
        if (refFields == null || refFields.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"HRRefDisplayPropEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map refFieldData = (Map)refFields.get(0);
        String refBaseFieldId = (String)refFieldData.get("RefBaseFieldId");
        List fieldsData = (List)item.get(1);
        Map baseField = null;
        for (Map field : fieldsData) {
            if (!field.get("Id").equals(refBaseFieldId)) continue;
            baseField = field;
            break;
        }
        if (baseField == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"HRRefDisplayPropEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        QueryField fld = (QueryField)EntityMetadataUtil.getEntityItem(baseField);
        String entityId = fld.getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed1\u5b9a\u7684\u67e5\u8be2\u7c7b\u578b\u65e0\u6548\u3002", (String)"HRRefDisplayPropEditPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)fld.getDisplayProp())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed1\u5b9a\u7684\u67e5\u8be2\u6ca1\u6709\u914d\u7f6e\u663e\u793a\u5c5e\u6027\u3002", (String)"HRRefDisplayPropEditPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)fld.getEditSearchProp())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed1\u5b9a\u7684\u67e5\u8be2\u6ca1\u6709\u914d\u7f6e\u7f16\u8f91\u663e\u793a\u5c5e\u6027\u3002", (String)"HRRefDisplayPropEditPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet defRefProps = Sets.newHashSetWithExpectedSize((int)16);
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_KEY);
        String entityNumber = MetadataDao.getEntityNumberById((String)entityId);
        List displayFieldNames = QueryEntityUtil.getDisplayFieldNames((String)entityNumber);
        Map<String, String> querySelectFieldMap = displayFieldNames.stream().collect(Collectors.toMap(QuerySelectField::getAlias, QuerySelectField::getDisplayName, (x, y) -> y));
        Set<String> fieldSet = this.getFieldSet(fld, displayFieldNames);
        int[] defRows = model.batchCreateNewEntryRow(ENTRY_KEY, fieldSet.size());
        int i = 0;
        for (String field : fieldSet) {
            model.setValue(FTNAME, (Object)field, defRows[i]);
            model.setValue(FT_DISPLAY_NAME, (Object)querySelectFieldMap.get(field), defRows[i]);
            ++i;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeAllMasterProps(true);
        option.setOnlyBillHead(true);
        TreeNode root = QueryEntityUtil.buildBillTreeNodes((EntityMetadata)entityMetadata, (boolean)true);
        List refProps = (List)baseField.get("RefProps");
        if (refProps != null) {
            for (Map refProp : refProps) {
                String name = (String)refProp.get("Name");
                TreeNode node = root.getTreeNode(name, 16);
                if (node == null || defRefProps.contains(node.getId()) || fieldSet.contains(node.getId())) continue;
                int rowindex = model.createNewEntryRow(ENTRY_KEY);
                model.setValue(FTNAME, (Object)node.getId(), rowindex);
                model.setValue(FT_DISPLAY_NAME, (Object)node.getText(), rowindex);
            }
        }
    }

    private Set<String> getFieldSet(QueryField fld, List<QuerySelectField> displayFieldNames) {
        String displayProp = QueryRefUtils.removeConnector((String)fld.getDisplayProp(), displayFieldNames);
        String editSearchProp = QueryRefUtils.removeConnector((String)fld.getEditSearchProp(), displayFieldNames);
        HashSet fieldSet = Sets.newHashSetWithExpectedSize((int)8);
        fieldSet.addAll(Arrays.asList(displayProp.split(",")));
        fieldSet.addAll(Arrays.asList(editSearchProp.split(",")));
        return fieldSet;
    }
}

