/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRPermChargeTreeSearchServiceHelper {
    public static void reBuildTreeBySearchKey(TreeView treeView, String searchText) {
        treeView.deleteAllNodes();
        List<Map<String, String>> apps = HRPermChargeTreeSearchServiceHelper.getAppsBySearchKey(searchText);
        Set<String> cloudIds = apps.stream().map(app -> (String)app.get("cloudId")).collect(Collectors.toSet());
        List<Map<String, String>> clouds = HRPermChargeTreeSearchServiceHelper.getCloudsByIds(cloudIds);
        HRPermChargeTreeSearchServiceHelper.addTreeNodeByLists(treeView, clouds, apps);
    }

    private static void addTreeNodeByLists(TreeView treeView, List<Map<String, String>> clouds, List<Map<String, String>> apps) {
        String id;
        TreeNode rootNode = HRPermChargeTreeSearchServiceHelper.buildRootNode();
        treeView.addNode(rootNode);
        if (CollectionUtils.isEmpty(clouds)) {
            return;
        }
        Set cloudIdSet = clouds.stream().map(cloud -> (String)cloud.get("id")).collect(Collectors.toSet());
        apps = apps.stream().filter(app -> cloudIdSet.contains(app.get("cloudId"))).collect(Collectors.toList());
        ArrayList childNodeList = Lists.newArrayListWithExpectedSize((int)clouds.size());
        for (Map<String, String> cloud2 : clouds) {
            id = "1_split_" + cloud2.get("id");
            TreeNode node = new TreeNode("1010", id, cloud2.get("name"), true);
            node.setIsOpened(true);
            childNodeList.add(node);
        }
        for (Map<String, String> app2 : apps) {
            id = "2_split_" + app2.get("id");
            String parentId = "1_split_" + app2.get("cloudId");
            TreeNode node = new TreeNode(parentId, id, app2.get("name"), false);
            childNodeList.add(node);
        }
        treeView.addNodes((List)childNodeList);
    }

    public static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"HREntityTreeListPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private static List<Map<String, String>> getAppsBySearchKey(String searchText) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter deployStatusFilter = new QFilter("deploystatus", "=", (Object)"2");
        QFilter nameFilter = QFilter.likeUnEscape((String)"name", (String)HRPermChargeTreeSearchServiceHelper.replaceSpecialChar(searchText));
        QFilter isExtendsFilter = new QFilter("masterid", "=", (Object)" ");
        QFilter[] appIdBlacklistFilters = RunModeServiceHelper.getAppIdBlacklistFilters(null, (String)"id");
        DataSet rows = serviceHelper.queryDataSet("kd.hr.hrcs.formplugin.web.utils.HRPermChargeTreeSearchServiceHelper.getAppsBySearchKey", "id,name,bizcloud.id", new QFilter[]{deployStatusFilter, nameFilter, isExtendsFilter, appIdBlacklistFilters[0]});
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        while (rows.hasNext()) {
            HashMap appMap = Maps.newHashMapWithExpectedSize((int)3);
            Row rs = rows.next();
            String appId = rs.getString("id");
            appMap.put("id", appId);
            appMap.put("name", AppMetadataCache.getAppInfo((String)appId).getName().getLocaleValue());
            appMap.put("cloudId", rs.getString("bizcloud.id"));
            result.add(appMap);
        }
        return result;
    }

    private static String replaceSpecialChar(String searchText) {
        return searchText.replaceAll("_", "\\\\_").replaceAll("%", "\\\\%");
    }

    private static List<Map<String, String>> getCloudsByIds(Set<String> cloudIds) {
        String cloudIdStr = HRPermChargeTreeSearchServiceHelper.list2JoinStr(cloudIds);
        String sql = "select a.fid,b.fname from t_meta_bizcloud a  left join t_meta_bizcloud_l b on (a.fid=b.fid and b.flocaleid=?)  where a.fid in (" + cloudIdStr + ")  and a.fvisible='1' ";
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (HRStringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql = sql + " and a.fid not in (" + cloudBlacklist + ")";
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_hrcloud");
        DynamicObject[] hrClouds = serviceHelper.query("id", null);
        Set idSet = Arrays.stream(hrClouds).map(it -> it.getString("id")).collect(Collectors.toSet());
        String langStr = RequestContext.get().getLang().name();
        Object[] params = new String[]{langStr};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            ArrayList<HashMap> result = new ArrayList<HashMap>(16);
            while (rs.next()) {
                if (!idSet.contains(rs.getString("fid"))) continue;
                HashMap cloudMap = Maps.newHashMapWithExpectedSize((int)3);
                cloudMap.put("id", rs.getString("fid"));
                cloudMap.put("name", rs.getString("fname"));
                result.add(cloudMap);
            }
            return result;
        });
    }

    private static String list2JoinStr(Collection<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "''";
        }
        return list.stream().map(str -> "'" + str + "'").collect(Collectors.joining(", "));
    }
}

