/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hrcs.bussiness.strategy.InitStrategyServiceHelper;

public class ManageStrategyServiceHelper {
    private static final Log LOG = LogFactory.getLog(ManageStrategyServiceHelper.class);

    public static Map<String, DynamicObject> getCanInheritedOrgWithSelf(Long orgId) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        DynamicObject company = StrategyServiceHelper.getOnlyCompanyByAdminOrgId((long)orgId, (boolean)true);
        DynamicObject group = StrategyServiceHelper.getCompanyByAdminOrgId((long)orgId, (boolean)true);
        LOG.info("getCanInheritedOrgWithSelf() orgId:{}, company:{},group:{}", new Object[]{orgId, company == null ? null : Long.valueOf(company.getLong("id")), group == null ? null : Long.valueOf(group.getLong("id"))});
        result.put("2", company);
        result.put("1", group);
        return result;
    }

    public static List<String> getProjStrategyTypes() {
        ArrayList strategyTypes = Lists.newArrayListWithCapacity((int)3);
        strategyTypes.add("3");
        strategyTypes.add("1");
        strategyTypes.add("2");
        strategyTypes.add("4");
        return strategyTypes;
    }

    public static List<String> getStrategyTypes(DynamicObject org, Long orgForm, Long businessObjectId, Long businessTypeId) {
        boolean flag;
        DynamicObject parent;
        ArrayList<String> strategyTypes = new ArrayList<String>();
        strategyTypes.add("3");
        strategyTypes.add("7");
        Long orgId = org.getLong("id");
        if (orgId.longValue() != HRBUExtServiceHelper.getRootHROrg().getLong("id")) {
            strategyTypes.add("0");
            strategyTypes.add("5");
        }
        if ((parent = (DynamicObject)org.get("parent")) != null) {
            Map<String, DynamicObject> map = ManageStrategyServiceHelper.getCanInheritedOrgWithSelf(parent.getLong("id"));
            LOG.info("======= getStrategyTypes() map:{},org:{},orgTypeNumber:{}", map, (Object)orgId);
            if (map.get("1") != null) {
                strategyTypes.add("1");
            }
            if (map.get("2") != null) {
                strategyTypes.add("2");
            }
        }
        Map bussType2HROrgMap = HRBUExtServiceHelper.getHROrgByIds((List)Lists.newArrayList((Object[])new Object[]{org.getLong("id")}));
        LOG.info("ManageStrategyServiceHelper.getStrategyTypes(),bussType2HROrgMap-key:{}", bussType2HROrgMap.keySet());
        if (0L != businessTypeId) {
            flag = bussType2HROrgMap.containsKey(businessTypeId);
        } else {
            DynamicObject[] allBusinessTypeReals = InitStrategyServiceHelper.getAllBusinessTypeReal((Long)orgForm, (Long[])new Long[]{businessObjectId});
            flag = Arrays.stream(allBusinessTypeReals).allMatch(dy -> bussType2HROrgMap.containsKey(dy.getLong("bussinesstype.id")));
        }
        if (flag) {
            strategyTypes.add("4");
        }
        LOG.info("getStrategyTypes() result:{}", strategyTypes);
        return strategyTypes;
    }
}

